/*
 * Decompiled with CFR 0.152.
 */
package ASAP.NRP.Core.Constraints.ANROM;

import ASAP.NRP.Core.Constraints.SoftConstraint;
import ASAP.NRP.Core.Constraints.SoftConstraints;
import ASAP.NRP.Core.Employee;
import ASAP.NRP.Core.EmployeeDescription;
import ASAP.NRP.Core.SchedulingPeriod;

public class IdenticalShiftTypesDuringWeekend
implements SoftConstraint {
    public String Title = "Identical shift types during weekend";
    public String LongTitle = "";
    public int Weight = 0;
    public String ID = "";

    public IdenticalShiftTypesDuringWeekend(int Weight) {
        this.Weight = Weight;
    }

    @Override
    public String getTitle() {
        return this.Title;
    }

    @Override
    public int getWeight() {
        return this.Weight;
    }

    @Override
    public void Delete(EmployeeDescription employee) {
    }

    @Override
    public String ToXml(EmployeeDescription employee) {
        return "";
    }

    @Override
    public String GetDescription(Employee employee) {
        return "";
    }

    @Override
    public int Calculate(Employee employee, int startDay, int endDay) {
        return this.Calculate(employee);
    }

    public int Calculate(Employee employee, int maxPenalty, int startDay, int endDay) {
        return this.Calculate(employee);
    }

    @Override
    public int Calculate(Employee employee, int startDay, int endDay, boolean updateStructure) {
        return this.Calculate(employee);
    }

    @Override
    public int Calculate(Employee employee) {
        if (this.Weight == 0) {
            return 0;
        }
        SchedulingPeriod schedulingPeriod = employee.Roster.SchedulingPeriod;
        int penalty = 0;
        int saturdayIndex = schedulingPeriod.FirstSaturday;
        int shiftTypeCount = schedulingPeriod.ShiftTypesCount;
        if (employee.EmployeeDescription.SchedulingHistory.Exists && schedulingPeriod.FirstSunday == 0) {
            int i = 0;
            while (i < shiftTypeCount) {
                if (employee.EmployeeDescription.SchedulingHistory.LastDayAssignments[i] != employee.ShiftAssignments[i] && employee.EmployeeDescription.SchedulingHistory.LastDayType != 2 && employee.DayType[0] != 2) {
                    penalty += this.Weight;
                    employee.ConstraintViolationPenalties[0] = employee.ConstraintViolationPenalties[0] + this.Weight;
                    if (SoftConstraints.UpdateViolationDescriptions) {
                        employee.ViolationDescriptions[0] = String.valueOf(employee.ViolationDescriptions[0]) + "Identical shift types required on both days of the weekend. " + System.getProperty("line.separator");
                    }
                }
                ++i;
            }
        }
        if (saturdayIndex < 0) {
            return penalty;
        }
        int numDaysInPeriod = schedulingPeriod.NumDaysInPeriod;
        while (saturdayIndex < numDaysInPeriod) {
            if (saturdayIndex + 1 < numDaysInPeriod) {
                int i = 0;
                while (i < shiftTypeCount) {
                    int j = saturdayIndex * shiftTypeCount;
                    if (employee.ShiftAssignments[j + i] != employee.ShiftAssignments[j + i + shiftTypeCount] && employee.DayType[saturdayIndex] != 2 && employee.DayType[saturdayIndex + 1] != 2) {
                        penalty += this.Weight;
                        int n = saturdayIndex;
                        employee.ConstraintViolationPenalties[n] = employee.ConstraintViolationPenalties[n] + this.Weight;
                        int n2 = saturdayIndex + 1;
                        employee.ConstraintViolationPenalties[n2] = employee.ConstraintViolationPenalties[n2] + this.Weight;
                        if (SoftConstraints.UpdateViolationDescriptions) {
                            int n3 = saturdayIndex;
                            employee.ViolationDescriptions[n3] = String.valueOf(employee.ViolationDescriptions[n3]) + "Identical shift types required on both days of the weekend. " + System.getProperty("line.separator");
                            int n4 = saturdayIndex + 1;
                            employee.ViolationDescriptions[n4] = String.valueOf(employee.ViolationDescriptions[n4]) + "Identical shift types required on both days of the weekend. " + System.getProperty("line.separator");
                        }
                    }
                    ++i;
                }
            }
            saturdayIndex += 7;
        }
        return penalty;
    }
}

