/*
 * Decompiled with CFR 0.152.
 */
package ASAP.NRP.Core.Constraints.ANROM;

import ASAP.NRP.Core.Constraints.SoftConstraint;
import ASAP.NRP.Core.Constraints.SoftConstraints;
import ASAP.NRP.Core.Employee;
import ASAP.NRP.Core.EmployeeDescription;
import ASAP.NRP.Core.SchedulingPeriod;

public class MaxConsecutiveWorkingDays
implements SoftConstraint {
    public String Title = "Max consecutive working days";
    public String LongTitle = "Maximum number of consecutive working days";
    public int Weight = 0;
    public String ID = "ANROM.MaxConsecutiveWorkingDays";

    public MaxConsecutiveWorkingDays(int Weight) {
        this.Weight = Weight;
    }

    @Override
    public String getTitle() {
        return this.Title;
    }

    @Override
    public int getWeight() {
        return this.Weight;
    }

    @Override
    public void Delete(EmployeeDescription employee) {
        employee.Contract.MaxConsecutiveWorkingDaysIsOn = false;
    }

    @Override
    public String ToXml(EmployeeDescription employee) {
        return "<MaxConsecutiveWorkingDays Weight=\"" + this.Weight + "\">" + employee.Contract.MaxConsecutiveWorkingDays + "</MaxConsecutiveWorkingDays>" + System.getProperty("line.separator");
    }

    @Override
    public String GetDescription(Employee employee) {
        return "Requests max " + employee.EmployeeDescription.Contract.MaxConsecutiveWorkingDays + " consecutive working days.";
    }

    @Override
    public int Calculate(Employee employee, int startDay, int endDay) {
        return this.Calculate(employee);
    }

    public int Calculate(Employee employee, int maxPenalty, int startDay, int endDay) {
        return this.Calculate(employee);
    }

    @Override
    public int Calculate(Employee employee, int startDay, int endDay, boolean updateStructure) {
        return this.Calculate(employee);
    }

    @Override
    public int Calculate(Employee employee) {
        if (this.Weight == 0) {
            return 0;
        }
        SchedulingPeriod schedulingPeriod = employee.Roster.SchedulingPeriod;
        int penalty = 0;
        int maxConsecutiveWorkingDays = employee.EmployeeDescription.Contract.MaxConsecutiveWorkingDays;
        int consecutiveWorkingDays = employee.EmployeeDescription.SchedulingHistory.PreviousConsecutiveWorkingDays;
        int numDaysInPeriod = schedulingPeriod.NumDaysInPeriod;
        int i = 0;
        while (i < numDaysInPeriod) {
            if (employee.DayType[i] == 1 || employee.EmployeeDescription.DayOffRequestIsWork[i]) {
                ++consecutiveWorkingDays;
            }
            if (employee.DayType[i] != 1 && !employee.EmployeeDescription.DayOffRequestIsWork[i] || i + 1 == numDaysInPeriod) {
                if (consecutiveWorkingDays > maxConsecutiveWorkingDays) {
                    int pen = this.Weight * (consecutiveWorkingDays - maxConsecutiveWorkingDays);
                    penalty += pen;
                    int end = i - 1;
                    if (employee.DayType[i] == 1) {
                        end = i;
                    }
                    int j = end;
                    while (j >= 0 && j > end - consecutiveWorkingDays) {
                        int n = j;
                        employee.ConstraintViolationPenalties[n] = employee.ConstraintViolationPenalties[n] + pen;
                        if (SoftConstraints.UpdateViolationDescriptions) {
                            int n2 = j;
                            employee.ViolationDescriptions[n2] = String.valueOf(employee.ViolationDescriptions[n2]) + "Too many consecutive working days (max " + maxConsecutiveWorkingDays + "). " + System.getProperty("line.separator");
                        }
                        --j;
                    }
                }
                consecutiveWorkingDays = 0;
            }
            ++i;
        }
        return penalty;
    }
}

