/*
 * Decompiled with CFR 0.152.
 */
package ASAP.NRP.Core.Constraints.ANROM;

import ASAP.NRP.Core.Constraints.SoftConstraint;
import ASAP.NRP.Core.Constraints.SoftConstraints;
import ASAP.NRP.Core.Employee;
import ASAP.NRP.Core.EmployeeDescription;
import ASAP.NRP.Core.SchedulingPeriod;

public class MaxConsecutiveWorkingWeekends
implements SoftConstraint {
    public String Title = "Max consecutive working weekends";
    public String LongTitle = "Maximum number of consecutive working weekends";
    public int Weight = 0;
    public String ID = "ANROM.MaxConsecutiveWorkingWeekends";

    public MaxConsecutiveWorkingWeekends(int weight) {
        this.Weight = weight;
    }

    @Override
    public void Delete(EmployeeDescription employee) {
        employee.Contract.MaxConsecutiveWorkingWeekendsIsOn = false;
    }

    @Override
    public String getTitle() {
        return this.Title;
    }

    @Override
    public int getWeight() {
        return this.Weight;
    }

    @Override
    public String ToXml(EmployeeDescription employee) {
        return "<MaxConsecutiveWorkingWeekends weight=\"" + this.Weight + "\">" + employee.Contract.MaxConsecutiveWorkingWeekends + "</MaxConsecutiveWorkingWeekends>" + System.getProperty("line.separator");
    }

    @Override
    public String GetDescription(Employee employee) {
        return "Requests max " + employee.EmployeeDescription.Contract.MaxConsecutiveWorkingWeekends + " consecutive working weekends.";
    }

    @Override
    public int Calculate(Employee employee, int startDay, int endDay) {
        return this.Calculate(employee);
    }

    public int Calculate(Employee employee, int maxPenalty, int startDay, int endDay) {
        return this.Calculate(employee);
    }

    @Override
    public int Calculate(Employee employee, int startDay, int endDay, boolean updateStructure) {
        return this.Calculate(employee);
    }

    @Override
    public int Calculate(Employee employee) {
        if (this.Weight == 0) {
            return 0;
        }
        SchedulingPeriod schedulingPeriod = employee.Roster.SchedulingPeriod;
        int penalty = 0;
        int maxConsecutiveWorkingWeekends = employee.EmployeeDescription.Contract.MaxConsecutiveWorkingWeekends;
        int consecutiveWorkingWeekends = employee.EmployeeDescription.SchedulingHistory.PreviousConsecutiveWorkingWeekends;
        int saturdayIndex = schedulingPeriod.FirstSaturday;
        if (saturdayIndex == 6) {
            if (consecutiveWorkingWeekends == 0 && employee.DayType[0] == 1) {
                consecutiveWorkingWeekends = 1;
            }
        } else if (saturdayIndex < 0) {
            if (consecutiveWorkingWeekends > maxConsecutiveWorkingWeekends) {
                penalty += this.Weight * (consecutiveWorkingWeekends - maxConsecutiveWorkingWeekends);
            }
            return penalty;
        }
        int numDaysInPeriod = schedulingPeriod.NumDaysInPeriod;
        while (saturdayIndex < numDaysInPeriod) {
            boolean workingWeekend = false;
            if (employee.DayType[saturdayIndex] == 1) {
                ++consecutiveWorkingWeekends;
                workingWeekend = true;
            } else if (saturdayIndex + 1 < employee.DayType.length && employee.DayType[saturdayIndex + 1] == 1) {
                ++consecutiveWorkingWeekends;
                workingWeekend = true;
            }
            if (!workingWeekend || saturdayIndex + 7 >= numDaysInPeriod) {
                if (consecutiveWorkingWeekends > maxConsecutiveWorkingWeekends) {
                    int pen = this.Weight * (consecutiveWorkingWeekends - maxConsecutiveWorkingWeekends);
                    penalty += pen;
                    int lastSat = workingWeekend ? saturdayIndex : saturdayIndex - 7;
                    int i = consecutiveWorkingWeekends;
                    while (i > 0) {
                        if (lastSat >= 0 && employee.DayType[lastSat] == 1) {
                            int n = lastSat;
                            employee.ConstraintViolationPenalties[n] = employee.ConstraintViolationPenalties[n] + pen;
                            if (SoftConstraints.UpdateViolationDescriptions) {
                                int n2 = lastSat;
                                employee.ViolationDescriptions[n2] = String.valueOf(employee.ViolationDescriptions[n2]) + "Too many consecutive working weekends. " + System.getProperty("line.separator");
                            }
                        }
                        if (lastSat + 1 >= 0 && lastSat + 1 < numDaysInPeriod && employee.DayType[lastSat + 1] == 1) {
                            int n = lastSat + 1;
                            employee.ConstraintViolationPenalties[n] = employee.ConstraintViolationPenalties[n] + pen;
                            if (SoftConstraints.UpdateViolationDescriptions) {
                                int n3 = lastSat + 1;
                                employee.ViolationDescriptions[n3] = String.valueOf(employee.ViolationDescriptions[n3]) + "Too many consecutive working weekends. " + System.getProperty("line.separator");
                            }
                        }
                        if ((lastSat -= 7) + 1 < 0) break;
                        --i;
                    }
                }
                consecutiveWorkingWeekends = 0;
            }
            saturdayIndex += 7;
        }
        return penalty;
    }
}

