/*
 * Decompiled with CFR 0.152.
 */
package ASAP.NRP.Core.Constraints.ANROM;

import ASAP.NRP.Core.Constraints.SoftConstraint;
import ASAP.NRP.Core.Constraints.SoftConstraints;
import ASAP.NRP.Core.Employee;
import ASAP.NRP.Core.EmployeeDescription;
import ASAP.NRP.Core.SchedulingPeriod;

public class MaxHoursWorked
implements SoftConstraint {
    public String Title = "Max hours worked";
    public String LongTitle = "Maximum number of hours the employee can work";
    public int Weight = 0;
    public String ID = "ANROM.MaxHoursWorked";

    public MaxHoursWorked(int Weight) {
        this.Weight = Weight;
    }

    @Override
    public String getTitle() {
        return this.Title;
    }

    @Override
    public int getWeight() {
        return this.Weight;
    }

    @Override
    public void Delete(EmployeeDescription employee) {
        employee.Contract.MaxHoursWorkedIsOn = false;
    }

    @Override
    public String ToXml(EmployeeDescription employee) {
        return "";
    }

    @Override
    public String GetDescription(Employee employee) {
        return "Requests max " + employee.EmployeeDescription.Contract.MaxHoursWorked + " hours.";
    }

    @Override
    public int Calculate(Employee employee, int startDay, int endDay) {
        return this.Calculate(employee);
    }

    public int Calculate(Employee employee, int maxPenalty, int startDay, int endDay) {
        return this.Calculate(employee);
    }

    @Override
    public int Calculate(Employee employee, int startDay, int endDay, boolean updateStructure) {
        return this.Calculate(employee);
    }

    @Override
    public int Calculate(Employee employee) {
        if (this.Weight == 0) {
            return 0;
        }
        SchedulingPeriod schedulingPeriod = employee.Roster.SchedulingPeriod;
        int penalty = 0;
        double standardPeformance = employee.EmployeeDescription.Contract.StandardPerformance;
        int numDaysOff = employee.HolidayDaysOffGranted;
        double previousHoursWorked = employee.EmployeeDescription.SchedulingHistory.PreviousOvertime;
        double x = employee.EmployeeDescription.Contract.MaxHoursWorked - standardPeformance * (double)numDaysOff;
        double y = previousHoursWorked + employee.HoursWorked;
        double diff = y - x;
        if ((diff = MaxHoursWorked.roundDouble(diff, 4)) > employee.EmployeeDescription.Contract.MaxHoursWorkedThreshold && (penalty = this.Weight * (int)Math.floor(diff)) > 0) {
            int day = 0;
            while (day < schedulingPeriod.NumDaysInPeriod) {
                if (employee.ShiftCountPerDay[day] > 0) {
                    int n = day;
                    employee.ConstraintViolationPenalties[n] = employee.ConstraintViolationPenalties[n] + penalty;
                    if (SoftConstraints.UpdateViolationDescriptions) {
                        int n2 = day;
                        employee.ViolationDescriptions[n2] = String.valueOf(employee.ViolationDescriptions[n2]) + "Too many hours worked (max " + employee.EmployeeDescription.Contract.MaxHoursWorked + "). " + System.getProperty("line.separator");
                    }
                }
                ++day;
            }
        }
        return penalty;
    }

    public static final double roundDouble(double d, int places) {
        return (double)Math.round(d * Math.pow(10.0, places)) / Math.pow(10.0, places);
    }
}

