/*
 * Decompiled with CFR 0.152.
 */
package ASAP.NRP.Core.Constraints.ANROM;

import ASAP.NRP.Core.Constraints.SoftConstraint;
import ASAP.NRP.Core.Constraints.SoftConstraints;
import ASAP.NRP.Core.Employee;
import ASAP.NRP.Core.EmployeeDescription;
import ASAP.NRP.Core.SchedulingPeriod;
import ASAP.NRP.Core.ShiftType;
import ASAP.NRP.Core.ShiftTypeAndValue;

public class MaxShiftTypes
implements SoftConstraint {
    public String Title = "Max shift types";
    public String LongTitle = "Maximum number of shifts of a particular type";
    public int Weight = 0;
    public String ID = "ANROM.MaxShiftTypes";

    public MaxShiftTypes(int Weight) {
        this.Weight = Weight;
    }

    @Override
    public String getTitle() {
        return this.Title;
    }

    @Override
    public int getWeight() {
        return this.Weight;
    }

    @Override
    public void Delete(EmployeeDescription employee) {
        int i = 0;
        while (i < employee.Contract.MaxShiftTypes.length) {
            employee.Contract.MaxShiftTypes[i] = -1;
            ++i;
        }
        employee.Contract.MaxShiftTypesAL.clear();
        employee.Contract.MaxShiftTypesUsed = false;
        employee.Contract.MaxShiftTypesIsOn = false;
    }

    @Override
    public String ToXml(EmployeeDescription employee) {
        String str = "<MaxShiftTypes Weight=\"" + this.Weight + "\">" + System.getProperty("line.separator");
        for (ShiftTypeAndValue stv : employee.Contract.MaxShiftTypesAL) {
            if (stv.Value < 0) continue;
            str = String.valueOf(str) + " <MaxShiftType><ShiftType>" + stv.ShiftType.ID + "</ShiftType><Value>" + stv.Value + "</Value></MaxShiftType>" + System.getProperty("line.separator");
        }
        str = String.valueOf(str) + "</MaxShiftTypes>" + System.getProperty("line.separator");
        return str;
    }

    @Override
    public String GetDescription(Employee employee) {
        String info = "";
        SchedulingPeriod schedulingPeriod = employee.Roster.SchedulingPeriod;
        int x = 0;
        while (x < schedulingPeriod.ShiftTypesCount) {
            ShiftType shiftType = schedulingPeriod.GetShiftType(x);
            String label = shiftType.Label;
            int i = shiftType.Index;
            info = employee.EmployeeDescription.Contract.MaxShiftTypes[i] < 0 ? String.valueOf(info) + "No limit on '" + label + "' shifts, receives " + employee.ShiftTypeCount[i] : String.valueOf(info) + "Requests max " + employee.EmployeeDescription.Contract.MaxShiftTypes[i] + " '" + label + "' shifts, receives " + employee.ShiftTypeCount[i];
            if (x + 1 < schedulingPeriod.ShiftTypesCount) {
                info = String.valueOf(info) + "<br/>";
            }
            ++x;
        }
        return info;
    }

    @Override
    public int Calculate(Employee employee, int startDay, int endDay) {
        return this.Calculate(employee);
    }

    public int Calculate(Employee employee, int maxPenalty, int startDay, int endDay) {
        return this.Calculate(employee);
    }

    @Override
    public int Calculate(Employee employee, int startDay, int endDay, boolean updateStructure) {
        return this.Calculate(employee);
    }

    @Override
    public int Calculate(Employee employee) {
        if (this.Weight == 0) {
            return 0;
        }
        SchedulingPeriod schedulingPeriod = employee.Roster.SchedulingPeriod;
        int penalty = 0;
        int shiftCount = schedulingPeriod.ShiftTypesCount;
        int i = 0;
        while (i < shiftCount) {
            int max = employee.EmployeeDescription.Contract.MaxShiftTypes[i];
            int count = employee.ShiftTypeCount[i];
            if (max >= 0 && count > max) {
                int pen = this.Weight * (count - max);
                penalty += pen;
                int day = 0;
                while (day < schedulingPeriod.NumDaysInPeriod) {
                    int index = shiftCount * day + i;
                    if (employee.ShiftAssignments[index]) {
                        int n = day;
                        employee.ConstraintViolationPenalties[n] = employee.ConstraintViolationPenalties[n] + pen;
                        if (SoftConstraints.UpdateViolationDescriptions) {
                            int n2 = day;
                            employee.ViolationDescriptions[n2] = String.valueOf(employee.ViolationDescriptions[n2]) + "Requests max " + max + " '" + schedulingPeriod.GetShiftType((int)i).Label + "' shifts. " + System.getProperty("line.separator");
                        }
                    }
                    ++day;
                }
            }
            ++i;
        }
        return penalty;
    }
}

