/*
 * Decompiled with CFR 0.152.
 */
package ASAP.NRP.Core.Constraints.ANROM;

import ASAP.NRP.Core.Constraints.SoftConstraint;
import ASAP.NRP.Core.Constraints.SoftConstraints;
import ASAP.NRP.Core.Employee;
import ASAP.NRP.Core.EmployeeDescription;
import ASAP.NRP.Core.SchedulingPeriod;

public class MaxWorkingBankHolidays
implements SoftConstraint {
    public String Title = "Max working bank holidays";
    public String LongTitle = "";
    public int Weight = 0;
    public String ID = "";

    public MaxWorkingBankHolidays(int Weight) {
        this.Weight = Weight;
    }

    @Override
    public String getTitle() {
        return this.Title;
    }

    @Override
    public int getWeight() {
        return this.Weight;
    }

    @Override
    public void Delete(EmployeeDescription employee) {
    }

    @Override
    public String ToXml(EmployeeDescription employee) {
        return "";
    }

    @Override
    public String GetDescription(Employee employee) {
        return "Requests max " + employee.EmployeeDescription.Contract.MaxWorkingBankHolidays + " working bank holidays.";
    }

    @Override
    public int Calculate(Employee employee, int startDay, int endDay) {
        return this.Calculate(employee);
    }

    public int Calculate(Employee employee, int maxPenalty, int startDay, int endDay) {
        return this.Calculate(employee);
    }

    @Override
    public int Calculate(Employee employee, int startDay, int endDay, boolean updateStructure) {
        return this.Calculate(employee);
    }

    @Override
    public int Calculate(Employee employee) {
        if (this.Weight == 0) {
            return 0;
        }
        SchedulingPeriod schedulingPeriod = employee.Roster.SchedulingPeriod;
        if (schedulingPeriod.getBankHolidayCount() == 0) {
            return 0;
        }
        int penalty = 0;
        int maxWorkingBankHolidays = employee.EmployeeDescription.Contract.MaxWorkingBankHolidays;
        int workingBankHolidays = employee.EmployeeDescription.SchedulingHistory.PreviousWorkingBankHolidays;
        int i = 0;
        while (i < schedulingPeriod.BankHolidayArray.length) {
            if (schedulingPeriod.BankHolidayArray[i] && employee.DayType[i] == 1) {
                ++workingBankHolidays;
            }
            ++i;
        }
        if (workingBankHolidays > maxWorkingBankHolidays) {
            penalty = this.Weight * (workingBankHolidays - maxWorkingBankHolidays);
            i = 0;
            while (i < schedulingPeriod.BankHolidayArray.length) {
                if (schedulingPeriod.BankHolidayArray[i] && employee.DayType[i] == 1) {
                    int n = i;
                    employee.ConstraintViolationPenalties[n] = employee.ConstraintViolationPenalties[n] + penalty;
                    if (SoftConstraints.UpdateViolationDescriptions) {
                        int n2 = i;
                        employee.ViolationDescriptions[n2] = String.valueOf(employee.ViolationDescriptions[n2]) + "Too many working bank holidays (max " + maxWorkingBankHolidays + ", works " + workingBankHolidays + " this year). " + System.getProperty("line.separator");
                    }
                }
                ++i;
            }
        }
        return penalty;
    }
}

