/*
 * Decompiled with CFR 0.152.
 */
package ASAP.NRP.Core.Constraints.ANROM;

import ASAP.NRP.Core.Constraints.SoftConstraint;
import ASAP.NRP.Core.Constraints.SoftConstraints;
import ASAP.NRP.Core.Employee;
import ASAP.NRP.Core.EmployeeDescription;
import ASAP.NRP.Core.SchedulingPeriod;

public class ShiftTypeSuccessions
implements SoftConstraint {
    public String Title = "Shift type successions";
    public String LongTitle = "";
    public int Weight = 0;
    public String ID = "";

    public ShiftTypeSuccessions(int Weight) {
        this.Weight = Weight;
    }

    @Override
    public String getTitle() {
        return this.Title;
    }

    @Override
    public int getWeight() {
        return this.Weight;
    }

    @Override
    public void Delete(EmployeeDescription employee) {
    }

    @Override
    public String ToXml(EmployeeDescription employee) {
        return "";
    }

    @Override
    public String GetDescription(Employee employee) {
        String info = "Which shifts may follow a shift the next day. (\"_\" = empty day).</br>" + System.getProperty("line.separator");
        SchedulingPeriod schedulingPeriod = employee.Roster.SchedulingPeriod;
        int shiftTypeCount = schedulingPeriod.ShiftTypesCount;
        int i = -1;
        while (i < shiftTypeCount) {
            String shift1Label = "_";
            if (i >= 0) {
                shift1Label = schedulingPeriod.GetShiftType((int)i).Label;
            }
            info = String.valueOf(info) + shift1Label + " : ";
            int j = -1;
            while (j < shiftTypeCount) {
                if (employee.EmployeeDescription.Contract.IsPermissibleSuccession(i, j)) {
                    String shift2Label = "_";
                    if (j >= 0) {
                        shift2Label = schedulingPeriod.GetShiftType((int)j).Label;
                    }
                    info = String.valueOf(info) + shift2Label + ",";
                }
                ++j;
            }
            info = String.valueOf(info) + "</br>" + System.getProperty("line.separator");
            ++i;
        }
        return info;
    }

    @Override
    public int Calculate(Employee employee, int startDay, int endDay) {
        return this.Calculate(employee);
    }

    public int Calculate(Employee employee, int maxPenalty, int startDay, int endDay) {
        return this.Calculate(employee);
    }

    @Override
    public int Calculate(Employee employee, int startDay, int endDay, boolean updateStructure) {
        return this.Calculate(employee);
    }

    @Override
    public int Calculate(Employee employee) {
        if (this.Weight == 0) {
            return 0;
        }
        SchedulingPeriod schedulingPeriod = employee.Roster.SchedulingPeriod;
        int penalty = 0;
        int shiftTypeCount = schedulingPeriod.ShiftTypesCount;
        int numDaysInPeriod = schedulingPeriod.NumDaysInPeriod;
        if (employee.EmployeeDescription.SchedulingHistory.Exists) {
            int j;
            if (employee.DayType[0] != 1) {
                if (employee.EmployeeDescription.SchedulingHistory.LastDayType != 1) {
                    if (!employee.EmployeeDescription.Contract.IsPermissibleSuccession(-1, -1)) {
                        penalty += this.Weight;
                        employee.ConstraintViolationPenalties[0] = employee.ConstraintViolationPenalties[0] + this.Weight;
                        if (SoftConstraints.UpdateViolationDescriptions) {
                            employee.ViolationDescriptions[0] = String.valueOf(employee.ViolationDescriptions[0]) + "No shift followed by no shift is not permitted, penalty=" + this.Weight + ". " + System.getProperty("line.separator");
                        }
                    }
                } else {
                    j = 0;
                    while (j < shiftTypeCount) {
                        if (employee.EmployeeDescription.SchedulingHistory.LastDayAssignments[j] && !employee.EmployeeDescription.Contract.IsPermissibleSuccession(j, -1)) {
                            penalty += this.Weight;
                            employee.ConstraintViolationPenalties[0] = employee.ConstraintViolationPenalties[0] + this.Weight;
                            if (SoftConstraints.UpdateViolationDescriptions) {
                                employee.ViolationDescriptions[0] = String.valueOf(employee.ViolationDescriptions[0]) + "'" + schedulingPeriod.GetShiftType((int)j).Label + "' followed by no shift is not permitted, penalty=" + this.Weight + ". " + System.getProperty("line.separator");
                            }
                        }
                        ++j;
                    }
                }
            } else if (employee.EmployeeDescription.SchedulingHistory.LastDayType != 1) {
                j = 0;
                while (j < shiftTypeCount) {
                    if (employee.ShiftAssignments[j] && !employee.EmployeeDescription.Contract.IsPermissibleSuccession(-1, j)) {
                        penalty += this.Weight;
                        employee.ConstraintViolationPenalties[0] = employee.ConstraintViolationPenalties[0] + this.Weight;
                        if (SoftConstraints.UpdateViolationDescriptions) {
                            employee.ViolationDescriptions[0] = String.valueOf(employee.ViolationDescriptions[0]) + "No shift followed by '" + schedulingPeriod.GetShiftType((int)j).Label + "' is not permitted, penalty=" + this.Weight + ". " + System.getProperty("line.separator");
                        }
                    }
                    ++j;
                }
            } else {
                j = 0;
                while (j < shiftTypeCount) {
                    if (employee.ShiftAssignments[j]) {
                        int k = 0;
                        while (k < shiftTypeCount) {
                            if (employee.EmployeeDescription.SchedulingHistory.LastDayAssignments[k] && !employee.EmployeeDescription.Contract.IsPermissibleSuccession(k, j)) {
                                penalty += this.Weight;
                                employee.ConstraintViolationPenalties[0] = employee.ConstraintViolationPenalties[0] + this.Weight;
                                if (SoftConstraints.UpdateViolationDescriptions) {
                                    employee.ViolationDescriptions[0] = String.valueOf(employee.ViolationDescriptions[0]) + "'" + schedulingPeriod.GetShiftType((int)k).Label + "' followed by '" + schedulingPeriod.GetShiftType((int)j).Label + "' is not permitted, penalty=" + this.Weight + ". " + System.getProperty("line.separator");
                                }
                            }
                            ++k;
                        }
                    }
                    ++j;
                }
            }
        }
        int i = 1;
        while (i < numDaysInPeriod) {
            int j;
            if (employee.DayType[i] != 1) {
                if (employee.DayType[i - 1] != 1) {
                    if (!employee.EmployeeDescription.Contract.IsPermissibleSuccession(-1, -1)) {
                        penalty += this.Weight;
                        int n = i - 1;
                        employee.ConstraintViolationPenalties[n] = employee.ConstraintViolationPenalties[n] + this.Weight;
                        int n2 = i;
                        employee.ConstraintViolationPenalties[n2] = employee.ConstraintViolationPenalties[n2] + this.Weight;
                        if (SoftConstraints.UpdateViolationDescriptions) {
                            int n3 = i - 1;
                            employee.ViolationDescriptions[n3] = String.valueOf(employee.ViolationDescriptions[n3]) + "No shift followed by no shift is not permitted, penalty=" + this.Weight + ". " + System.getProperty("line.separator");
                            int n4 = i;
                            employee.ViolationDescriptions[n4] = String.valueOf(employee.ViolationDescriptions[n4]) + "No shift followed by no shift is not permitted, penalty=" + this.Weight + ". " + System.getProperty("line.separator");
                        }
                    }
                } else {
                    j = 0;
                    while (j < shiftTypeCount) {
                        if (employee.ShiftAssignments[(i - 1) * shiftTypeCount + j] && !employee.EmployeeDescription.Contract.IsPermissibleSuccession(j, -1)) {
                            penalty += this.Weight;
                            int n = i - 1;
                            employee.ConstraintViolationPenalties[n] = employee.ConstraintViolationPenalties[n] + this.Weight;
                            int n5 = i;
                            employee.ConstraintViolationPenalties[n5] = employee.ConstraintViolationPenalties[n5] + this.Weight;
                            if (SoftConstraints.UpdateViolationDescriptions) {
                                int n6 = i - 1;
                                employee.ViolationDescriptions[n6] = String.valueOf(employee.ViolationDescriptions[n6]) + "'" + schedulingPeriod.GetShiftType((int)j).Label + "' followed by no shift is not permitted, penalty=" + this.Weight + ". " + System.getProperty("line.separator");
                                int n7 = i;
                                employee.ViolationDescriptions[n7] = String.valueOf(employee.ViolationDescriptions[n7]) + "'" + schedulingPeriod.GetShiftType((int)j).Label + "' followed by no shift is not permitted, penalty=" + this.Weight + ". " + System.getProperty("line.separator");
                            }
                        }
                        ++j;
                    }
                }
            } else if (employee.DayType[i - 1] != 1) {
                j = 0;
                while (j < shiftTypeCount) {
                    if (employee.ShiftAssignments[i * shiftTypeCount + j] && !employee.EmployeeDescription.Contract.IsPermissibleSuccession(-1, j)) {
                        penalty += this.Weight;
                        int n = i - 1;
                        employee.ConstraintViolationPenalties[n] = employee.ConstraintViolationPenalties[n] + this.Weight;
                        int n8 = i;
                        employee.ConstraintViolationPenalties[n8] = employee.ConstraintViolationPenalties[n8] + this.Weight;
                        if (SoftConstraints.UpdateViolationDescriptions) {
                            int n9 = i - 1;
                            employee.ViolationDescriptions[n9] = String.valueOf(employee.ViolationDescriptions[n9]) + "No shift followed by '" + schedulingPeriod.GetShiftType((int)j).Label + "' is not permitted, penalty=" + this.Weight + ". " + System.getProperty("line.separator");
                            int n10 = i;
                            employee.ViolationDescriptions[n10] = String.valueOf(employee.ViolationDescriptions[n10]) + "No shift followed by '" + schedulingPeriod.GetShiftType((int)j).Label + "' is not permitted, penalty=" + this.Weight + ". " + System.getProperty("line.separator");
                        }
                    }
                    ++j;
                }
            } else {
                j = 0;
                while (j < shiftTypeCount) {
                    if (employee.ShiftAssignments[i * shiftTypeCount + j]) {
                        int k = 0;
                        while (k < shiftTypeCount) {
                            if (employee.ShiftAssignments[(i - 1) * shiftTypeCount + k] && !employee.EmployeeDescription.Contract.IsPermissibleSuccession(k, j)) {
                                penalty += this.Weight;
                                int n = i - 1;
                                employee.ConstraintViolationPenalties[n] = employee.ConstraintViolationPenalties[n] + this.Weight;
                                int n11 = i;
                                employee.ConstraintViolationPenalties[n11] = employee.ConstraintViolationPenalties[n11] + this.Weight;
                                if (SoftConstraints.UpdateViolationDescriptions) {
                                    int n12 = i - 1;
                                    employee.ViolationDescriptions[n12] = String.valueOf(employee.ViolationDescriptions[n12]) + "'" + schedulingPeriod.GetShiftType((int)k).Label + "' followed by '" + schedulingPeriod.GetShiftType((int)j).Label + "' is not permitted, penalty=" + this.Weight + ". " + System.getProperty("line.separator");
                                    int n13 = i;
                                    employee.ViolationDescriptions[n13] = String.valueOf(employee.ViolationDescriptions[n13]) + "'" + schedulingPeriod.GetShiftType((int)k).Label + "' followed by '" + schedulingPeriod.GetShiftType((int)j).Label + "' is not permitted, penalty=" + this.Weight + ". " + System.getProperty("line.separator");
                                }
                            }
                            ++k;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        return penalty;
    }
}

