/*
 * Decompiled with CFR 0.152.
 */
package ASAP.NRP.Core.Constraints.ANROM;

import ASAP.NRP.Core.Constraints.SoftConstraint;
import ASAP.NRP.Core.Constraints.SoftConstraints;
import ASAP.NRP.Core.Employee;
import ASAP.NRP.Core.EmployeeDescription;
import ASAP.NRP.Core.SchedulingPeriod;

public class TwoFreeDaysAfterNightShifts
implements SoftConstraint {
    public String Title = "Two free days after night shifts";
    public String LongTitle = "";
    public int Weight = 0;
    public String ID = "";

    public TwoFreeDaysAfterNightShifts(int Weight) {
        this.Weight = Weight;
    }

    @Override
    public void Delete(EmployeeDescription employee) {
    }

    @Override
    public String getTitle() {
        return this.Title;
    }

    @Override
    public int getWeight() {
        return this.Weight;
    }

    @Override
    public String ToXml(EmployeeDescription employee) {
        return "";
    }

    @Override
    public String GetDescription(Employee employee) {
        return "";
    }

    @Override
    public int Calculate(Employee employee, int startDay, int endDay) {
        return this.Calculate(employee);
    }

    public int Calculate(Employee employee, int maxPenalty, int startDay, int endDay) {
        return this.Calculate(employee);
    }

    @Override
    public int Calculate(Employee employee, int startDay, int endDay, boolean updateStructure) {
        return this.Calculate(employee);
    }

    @Override
    public int Calculate(Employee employee) {
        if (this.Weight == 0) {
            return 0;
        }
        SchedulingPeriod schedulingPeriod = employee.Roster.SchedulingPeriod;
        int penalty = 0;
        boolean previousNightShiftFound = employee.EmployeeDescription.SchedulingHistory.PreviousNightShift;
        int previousFreeDays = employee.EmployeeDescription.SchedulingHistory.PreviousFreeDaysAfterNightShift;
        if (!previousNightShiftFound) {
            previousFreeDays = 0;
        }
        boolean nightShiftFound = previousNightShiftFound;
        int freeDays = previousFreeDays;
        int numDaysInPeriod = schedulingPeriod.NumDaysInPeriod;
        int i = 0;
        while (i < numDaysInPeriod) {
            boolean nightShift = false;
            if (employee.NightShifts[i]) {
                nightShift = true;
            }
            if (nightShiftFound) {
                if (employee.DayType[i] != 1) {
                    ++freeDays;
                } else if (!nightShift || freeDays != 0) {
                    if (freeDays < 2) {
                        int pen = this.Weight * (2 - freeDays);
                        penalty += pen;
                        int lastNightshift = i - freeDays - 1;
                        int day = lastNightshift + 2;
                        while (day >= 0 && day < numDaysInPeriod && day >= lastNightshift) {
                            int n = day;
                            employee.ConstraintViolationPenalties[n] = employee.ConstraintViolationPenalties[n] + pen;
                            if (SoftConstraints.UpdateViolationDescriptions) {
                                int n2 = day;
                                employee.ViolationDescriptions[n2] = String.valueOf(employee.ViolationDescriptions[n2]) + "Minimum two free days required after night shifts. " + System.getProperty("line.separator");
                            }
                            --day;
                        }
                    }
                    freeDays = 0;
                    if (!nightShift) {
                        nightShiftFound = false;
                    }
                }
            } else if (nightShift) {
                nightShiftFound = true;
                freeDays = 0;
            }
            ++i;
        }
        return penalty;
    }
}

