/*
 * Decompiled with CFR 0.152.
 */
package ASAP.NRP.Core.Constraints.Ikegami;

import ASAP.NRP.Core.Constraints.SoftConstraint;
import ASAP.NRP.Core.Constraints.SoftConstraints;
import ASAP.NRP.Core.Employee;
import ASAP.NRP.Core.EmployeeDescription;
import ASAP.NRP.Core.SchedulingPeriod;

public class MaxDaysOff
implements SoftConstraint {
    public String Title = "Max non-working days";
    public String LongTitle = "Maximum number of non-working days in the scheduling period";
    public int Weight = 0;
    public String ID = "Ikegami.MaxDaysOff";

    public MaxDaysOff(int Weight) {
        this.Weight = Weight;
    }

    @Override
    public void Delete(EmployeeDescription employee) {
        employee.Contract.MaxDaysOffIsOn = false;
    }

    @Override
    public String getTitle() {
        return this.Title;
    }

    @Override
    public int getWeight() {
        return this.Weight;
    }

    @Override
    public String ToXml(EmployeeDescription employee) {
        return "<MaxDaysOff Weight=\"" + this.Weight + "\">" + employee.Contract.MaxDaysOff + "</MaxDaysOff>" + System.getProperty("line.separator");
    }

    @Override
    public String GetDescription(Employee employee) {
        return "Requests max. " + employee.EmployeeDescription.Contract.MaxDaysOff + " days off, receives " + employee.DaysOffCount;
    }

    @Override
    public int Calculate(Employee employee, int startDay, int endDay) {
        return this.Calculate(employee);
    }

    public int Calculate(Employee employee, int maxPenalty, int startDay, int endDay) {
        return this.Calculate(employee);
    }

    @Override
    public int Calculate(Employee employee, int startDay, int endDay, boolean updateStructure) {
        return this.Calculate(employee);
    }

    @Override
    public int Calculate(Employee employee) {
        if (this.Weight == 0) {
            return 0;
        }
        int penalty = 0;
        int max = employee.EmployeeDescription.Contract.MaxDaysOff;
        if (employee.DaysOffCount > max) {
            penalty = (employee.DaysOffCount - max) * this.Weight;
            SchedulingPeriod schedulingPeriod = employee.Roster.SchedulingPeriod;
            int day = 0;
            while (day < schedulingPeriod.NumDaysInPeriod) {
                if (employee.DayType[day] != 1 && !employee.EmployeeDescription.DayOffRequestIsWork[day]) {
                    int n = day;
                    employee.ConstraintViolationPenalties[n] = employee.ConstraintViolationPenalties[n] + penalty;
                    if (SoftConstraints.UpdateViolationDescriptions) {
                        int n2 = day;
                        employee.ViolationDescriptions[n2] = String.valueOf(employee.ViolationDescriptions[n2]) + "Requests max " + employee.EmployeeDescription.Contract.MaxDaysOff + " days off. " + System.getProperty("line.separator");
                    }
                }
                ++day;
            }
        }
        return penalty;
    }
}

