/*
 * Decompiled with CFR 0.152.
 */
package ASAP.NRP.Core.Constraints.Ikegami;

import ASAP.NRP.Core.Constraints.SoftConstraint;
import ASAP.NRP.Core.Constraints.SoftConstraints;
import ASAP.NRP.Core.Employee;
import ASAP.NRP.Core.EmployeeDescription;
import ASAP.NRP.Core.SchedulingPeriod;
import ASAP.NRP.Core.ShiftType;

public class MinDaysBetweenShiftSeries
implements SoftConstraint {
    public String Title = "Min days between shift series";
    public String LongTitle = "";
    public int Weight = 0;
    public String ID = "";

    public MinDaysBetweenShiftSeries(int Weight) {
        this.Weight = Weight;
    }

    @Override
    public String getTitle() {
        return this.Title;
    }

    @Override
    public int getWeight() {
        return this.Weight;
    }

    @Override
    public void Delete(EmployeeDescription employee) {
    }

    @Override
    public String ToXml(EmployeeDescription employee) {
        return "";
    }

    @Override
    public String GetDescription(Employee employee) {
        String info = "Min days between series of shifts";
        SchedulingPeriod schedulingPeriod = employee.Roster.SchedulingPeriod;
        int x = 0;
        while (x < schedulingPeriod.ShiftTypesCount) {
            ShiftType shiftType = schedulingPeriod.GetShiftType(x);
            String ID = shiftType.ID;
            int i = shiftType.Index;
            int min = employee.EmployeeDescription.Contract.MinDaysBetweenShiftSeries[i];
            if (min > 1) {
                info = String.valueOf(info) + "<br/>Requests min " + min + " days between two series of '" + ID + "' shifts";
            }
            ++x;
        }
        return info;
    }

    @Override
    public int Calculate(Employee employee, int startDay, int endDay) {
        return this.Calculate(employee);
    }

    public int Calculate(Employee employee, int maxPenalty, int startDay, int endDay) {
        return this.Calculate(employee);
    }

    @Override
    public int Calculate(Employee employee, int startDay, int endDay, boolean updateStructure) {
        return this.Calculate(employee);
    }

    @Override
    public int Calculate(Employee employee) {
        if (this.Weight == 0) {
            return 0;
        }
        SchedulingPeriod schedulingPeriod = employee.Roster.SchedulingPeriod;
        int penalty = 0;
        int shiftTypeCount = schedulingPeriod.ShiftTypesCount;
        int numDaysInPeriod = schedulingPeriod.NumDaysInPeriod;
        int shiftIndex = 0;
        while (shiftIndex < shiftTypeCount) {
            int min = employee.EmployeeDescription.Contract.MinDaysBetweenShiftSeries[shiftIndex];
            if (min > 1) {
                int gap = employee.EmployeeDescription.SchedulingHistory.DaysSinceShiftType[shiftIndex];
                boolean firstFound = false;
                if (gap >= 0) {
                    firstFound = true;
                }
                int startDay = -1;
                int i = 0;
                while (i < numDaysInPeriod) {
                    if (employee.ShiftAssignments[i * shiftTypeCount + shiftIndex]) {
                        firstFound = true;
                        if (gap > 0 && gap < min) {
                            String label;
                            int pen = (min - gap) * this.Weight;
                            penalty += pen;
                            if (startDay >= 0) {
                                int n = startDay;
                                employee.ConstraintViolationPenalties[n] = employee.ConstraintViolationPenalties[n] + pen;
                                if (SoftConstraints.UpdateViolationDescriptions) {
                                    label = schedulingPeriod.GetShiftType((int)shiftIndex).Label;
                                    int n2 = startDay;
                                    employee.ViolationDescriptions[n2] = String.valueOf(employee.ViolationDescriptions[n2]) + "Min " + min + " days between '" + label + "' shifts required." + System.getProperty("line.separator");
                                }
                            }
                            int n = i;
                            employee.ConstraintViolationPenalties[n] = employee.ConstraintViolationPenalties[n] + pen;
                            if (SoftConstraints.UpdateViolationDescriptions) {
                                label = schedulingPeriod.GetShiftType((int)shiftIndex).Label;
                                int n3 = i;
                                employee.ViolationDescriptions[n3] = String.valueOf(employee.ViolationDescriptions[n3]) + "Min " + min + " days between '" + label + "' shifts required." + System.getProperty("line.separator");
                            }
                        }
                        gap = 0;
                        startDay = i;
                    } else if (firstFound) {
                        ++gap;
                    }
                    ++i;
                }
            }
            ++shiftIndex;
        }
        return penalty;
    }
}

