/*
 * Decompiled with CFR 0.152.
 */
package ASAP.NRP.Core.Constraints.QMC;

import ASAP.NRP.Core.Constraints.SoftConstraint;
import ASAP.NRP.Core.Constraints.SoftConstraints;
import ASAP.NRP.Core.Employee;
import ASAP.NRP.Core.EmployeeDescription;
import ASAP.NRP.Core.SchedulingPeriod;
import ASAP.NRP.Core.ShiftGroup;

public class RequestedShiftGroupsOn
implements SoftConstraint {
    public String Title = "Requested shift group on";
    public String LongTitle = "";
    public int Weight = 0;
    public String ID = "";

    @Override
    public void Delete(EmployeeDescription employee) {
    }

    @Override
    public String getTitle() {
        return this.Title;
    }

    @Override
    public int getWeight() {
        return this.Weight;
    }

    @Override
    public String ToXml(EmployeeDescription employee) {
        return "";
    }

    @Override
    public String GetDescription(Employee employee) {
        return "";
    }

    @Override
    public int Calculate(Employee employee, int startDay, int endDay) {
        return this.Calculate(employee);
    }

    public int Calculate(Employee employee, int maxPenalty, int startDay, int endDay) {
        return this.Calculate(employee);
    }

    @Override
    public int Calculate(Employee employee, int startDay, int endDay, boolean updateStructure) {
        return this.Calculate(employee);
    }

    @Override
    public int Calculate(Employee employee) {
        SchedulingPeriod schedulingPeriod = employee.Roster.SchedulingPeriod;
        int penalty = 0;
        if (employee.EmployeeDescription.ShiftGroupOnRequests == null) {
            return 0;
        }
        int i = 0;
        while (i < employee.EmployeeDescription.ShiftGroupOnRequests.length) {
            boolean matched = false;
            ShiftGroup group = employee.EmployeeDescription.ShiftGroupOnRequests[i].ShiftGroup;
            int day = employee.EmployeeDescription.ShiftGroupOnRequests[i].Day;
            int j = 0;
            while (j < group.Group.length) {
                int shift = group.Group[j].Index;
                int shiftIndex = day * schedulingPeriod.ShiftTypesCount + shift;
                if (employee.ShiftAssignments[shiftIndex]) {
                    matched = true;
                    break;
                }
                ++j;
            }
            if (!matched) {
                int Weight = employee.EmployeeDescription.ShiftGroupOnRequests[i].Weight;
                penalty += Weight;
                int n = day;
                employee.ConstraintViolationPenalties[n] = employee.ConstraintViolationPenalties[n] + Weight;
                if (SoftConstraints.UpdateViolationDescriptions) {
                    int n2 = day;
                    employee.ViolationDescriptions[n2] = String.valueOf(employee.ViolationDescriptions[n2]) + "Requested shift group (" + group.Label + ") on not satisfied (penalty=" + Weight + "). " + System.getProperty("line.separator");
                }
            }
            ++i;
        }
        return penalty;
    }
}

