/*
 * Decompiled with CFR 0.152.
 */
package ASAP.NRP.Core.Constraints.TEC;

import ASAP.NRP.Core.CSharpConversionHelper;
import ASAP.NRP.Core.Constraints.SoftConstraint;
import ASAP.NRP.Core.Constraints.SoftConstraints;
import ASAP.NRP.Core.Constraints.TEC.Edge;
import ASAP.NRP.Core.Constraints.TEC.Pattern;
import ASAP.NRP.Core.Employee;
import ASAP.NRP.Core.EmployeeDescription;
import ASAP.NRP.Core.SchedulingPeriod;
import ASAP.NRP.Core.ShiftGroup;
import java.util.Random;

public class BadPatterns
implements SoftConstraint {
    Node node0;
    int nodesCount = 0;
    int penalty = 0;
    int[] dayPens;
    int numDaysInPeriod;
    int shiftTypeCount;
    Stack[] stacks;
    int[] hashNodesRandVals;
    Stack tempStack1;
    Stack tempStack2;
    boolean temp1 = true;
    EmployeeDescription employeeDescription;
    boolean datePatternsExist = false;
    public String Title = "Sequences to avoid";
    public String LongTitle = "Sequences which are not allowed";
    public int Weight = 0;
    public String ID = "TEC.BadPatterns";
    public boolean IncludeDateSpecificXML = true;
    boolean VIOLATION_FLAGGING = true;

    @Override
    public String getTitle() {
        return this.Title;
    }

    @Override
    public int getWeight() {
        return this.Weight;
    }

    @Override
    public void Delete(EmployeeDescription employee) {
        employee.Contract.BadPatternsIsOn = false;
        employee.Contract.BadPatterns = new Pattern[0];
        employee.Contract.WeekDayBadPatterns = new Pattern[0];
        employee.Contract.DateBadPatterns = new Pattern[0];
    }

    @Override
    public String ToXml(EmployeeDescription employee) {
        return "";
    }

    public String GetDescription(EmployeeDescription employeeDescription) {
        if (employeeDescription.Contract.BadPatterns == null || employeeDescription.Contract.BadPatterns.length == 0) {
            return "";
        }
        int maxLength = 0;
        int i = 0;
        while (i < employeeDescription.Contract.BadPatterns.length) {
            Pattern pattern = employeeDescription.Contract.BadPatterns[i];
            if (pattern.Length > maxLength) {
                maxLength = pattern.Length;
            }
            ++i;
        }
        String str = "<table cellpadding=\"2\" cellspacing=\"0\" style=\"font-family: arial, sans-serif; font-size: x-small; border: 0px solid #E0E0E0; border-collapse: collapse;\" border=\"1\"><tr style=\"background-color: #F8F8F8\"><td style=\"border-width: 0px\">Start day</td>";
        int i2 = 1;
        while (i2 <= maxLength) {
            str = String.valueOf(str) + "<td style=\"width:24px; text-align: center; border-width: 0px\">" + i2 + "</td>";
            ++i2;
        }
        str = String.valueOf(str) + "<td style=\"border-width: 0px\">Weight</td></tr>";
        i2 = 0;
        while (i2 < employeeDescription.Contract.BadPatterns.length) {
            Pattern pattern = employeeDescription.Contract.BadPatterns[i2];
            str = String.valueOf(str) + "<tr>";
            str = pattern.StartDayType == Pattern.StartType.Day ? String.valueOf(str) + "<td class=\"ptrnTblCell\" valign=\"top\">" + pattern.getStartDayOrDate() + "s</td>" : (pattern.StartDayType == Pattern.StartType.Date ? String.valueOf(str) + "<td class=\"ptrnTblCell\" valign=\"top\">" + pattern.getStartDayOrDate() + "</td>" : String.valueOf(str) + "<td class=\"ptrnTblCell\" valign=\"top\">All days</td>");
            str = String.valueOf(str) + pattern.ToHtmlTableRow();
            int j = 1;
            while (j <= maxLength - pattern.Length) {
                str = String.valueOf(str) + "<td class=\"ptrnTblCell\">&nbsp;</td>";
                ++j;
            }
            str = String.valueOf(str) + "<td class=\"ptrnTblCell\" valign=\"top\" style=\"text-align: right\">" + pattern.Weight + "</td></tr>";
            ++i2;
        }
        str = String.valueOf(str) + "</table>";
        return str;
    }

    @Override
    public String GetDescription(Employee employee) {
        return this.GetDescription(employee.EmployeeDescription);
    }

    public BadPatterns(EmployeeDescription employeeDescription) {
        this.employeeDescription = employeeDescription;
        this.ConstructGraph();
    }

    public void ConstructGraph() {
        this.penalty = 0;
        this.node0 = new Node(0);
        this.nodesCount = 1;
        this.numDaysInPeriod = this.employeeDescription.SchedulingPeriod.NumDaysInPeriod;
        this.shiftTypeCount = this.employeeDescription.SchedulingPeriod.ShiftTypesCount;
        this.dayPens = new int[this.numDaysInPeriod];
        this.datePatternsExist = false;
        int patternIndex = 0;
        while (patternIndex < this.employeeDescription.Contract.BadPatterns.length) {
            Pattern pattern = this.employeeDescription.Contract.BadPatterns[patternIndex];
            this.AddPattern(pattern);
            ++patternIndex;
        }
        Random rand = new Random(1L);
        this.hashNodesRandVals = new int[this.nodesCount];
        int i = 0;
        while (i < this.nodesCount) {
            this.hashNodesRandVals[i] = rand.nextInt(Integer.MAX_VALUE);
            ++i;
        }
        this.stacks = new Stack[this.numDaysInPeriod + 1];
        i = 0;
        while (i < this.stacks.length) {
            Stack stack = new Stack(this.nodesCount);
            stack.items[0] = this.node0;
            stack.size = 1;
            stack.hash = this.hashNodesRandVals[0];
            this.stacks[i] = stack;
            ++i;
        }
        this.tempStack1 = new Stack(this.nodesCount);
        this.tempStack1.items[0] = this.node0;
        this.tempStack1.size = 1;
        this.tempStack1.hash = this.hashNodesRandVals[0];
        this.tempStack2 = new Stack(this.nodesCount);
        this.tempStack2.items[0] = this.node0;
        this.tempStack2.size = 1;
        this.tempStack2.hash = this.hashNodesRandVals[0];
        this.ProcessHistory();
    }

    private void ProcessHistory() {
        if (!this.employeeDescription.SchedulingHistory.Exists) {
            return;
        }
        int daysCount = this.employeeDescription.SchedulingHistory.PreviousDayType.length;
        Stack nextStack = new Stack(this.nodesCount);
        nextStack.items[0] = this.node0;
        nextStack.size = 1;
        nextStack.hash = this.hashNodesRandVals[0];
        Stack tStack1 = new Stack(this.nodesCount);
        tStack1.items[0] = this.node0;
        tStack1.size = 1;
        tStack1.hash = this.hashNodesRandVals[0];
        Stack tStack2 = new Stack(this.nodesCount);
        tStack2.items[0] = this.node0;
        tStack2.size = 1;
        tStack2.hash = this.hashNodesRandVals[0];
        boolean t1 = true;
        int day = 0;
        while (day < daysCount) {
            Stack stack = nextStack;
            nextStack = t1 ? tStack1 : tStack2;
            t1 = !t1;
            nextStack.size = 1;
            nextStack.hash = this.hashNodesRandVals[0];
            int i = stack.size - 1;
            while (i >= 0) {
                Node node = stack.items[i];
                int j = 0;
                while (j < node.Edges.length) {
                    Edge edge = node.Edges[j];
                    boolean match = false;
                    if (edge.type == Pattern.DayType.Off) {
                        if (this.employeeDescription.SchedulingHistory.PreviousDayType[day] != 1 && !this.employeeDescription.SchedulingHistory.PreviousDayOffRequestWasWork[day]) {
                            match = true;
                        }
                    } else if (edge.type == Pattern.DayType.OtherWork) {
                        if (this.employeeDescription.SchedulingHistory.PreviousDayOffRequestWasWork[day]) {
                            match = true;
                        }
                    } else if (edge.type == Pattern.DayType.WorkingDay) {
                        if (this.employeeDescription.SchedulingHistory.PreviousDayType[day] == 1 || this.employeeDescription.SchedulingHistory.PreviousDayOffRequestWasWork[day]) {
                            match = true;
                        }
                    } else if (edge.type == Pattern.DayType.Any) {
                        match = true;
                    } else if (edge.type == Pattern.DayType.Shift) {
                        if (this.employeeDescription.SchedulingHistory.PreviousShiftAssignments[day * this.shiftTypeCount + edge.value]) {
                            match = true;
                        }
                    } else if (edge.type == Pattern.DayType.NotShift) {
                        if (!this.employeeDescription.SchedulingHistory.PreviousShiftAssignments[day * this.shiftTypeCount + edge.value]) {
                            match = true;
                        }
                    } else if (edge.type == Pattern.DayType.ShiftGroup) {
                        ShiftGroup grp = this.employeeDescription.SchedulingPeriod.GetShiftGroup(edge.value);
                        int x = 0;
                        while (x < grp.Group.length) {
                            if (this.employeeDescription.SchedulingHistory.PreviousShiftAssignments[day * this.shiftTypeCount + grp.Group[x].Index]) {
                                match = true;
                                break;
                            }
                            ++x;
                        }
                    } else {
                        System.out.println("Uknown edge type!");
                    }
                    if (match) {
                        Node nextNode = edge.nextNode;
                        if (!nextNode.terminal) {
                            nextStack.items[nextStack.size] = nextNode;
                            ++nextStack.size;
                            nextStack.hash ^= this.hashNodesRandVals[nextNode.index];
                        }
                    }
                    ++j;
                }
                --i;
            }
            ++day;
        }
        this.stacks[0] = nextStack;
    }

    private void AddPattern(Pattern pattern) {
        if (pattern.StartDayType == Pattern.StartType.Day || pattern.StartDayType == Pattern.StartType.Date) {
            this.datePatternsExist = true;
            return;
        }
        Node currentNode = this.node0;
        int k = 0;
        while (k < pattern.ShiftIndices.length) {
            int index = pattern.ShiftIndices[k];
            boolean match = false;
            int j = 0;
            while (j < currentNode.Edges.length) {
                Edge edge = currentNode.Edges[j];
                if (edge.type == pattern.DayTypes[k]) {
                    if (edge.type == Pattern.DayType.Shift || edge.type == Pattern.DayType.NotShift || edge.type == Pattern.DayType.ShiftGroup) {
                        if (edge.value == index) {
                            currentNode = edge.nextNode;
                            match = true;
                            break;
                        }
                    } else {
                        currentNode = edge.nextNode;
                        match = true;
                        break;
                    }
                }
                ++j;
            }
            if (!match) {
                Node newNode = new Node(this.nodesCount);
                ++this.nodesCount;
                Edge e = new Edge();
                e.nextNode = newNode;
                e.type = pattern.DayTypes[k];
                e.value = index;
                currentNode.AddEdge(e);
                currentNode = newNode;
            }
            ++k;
        }
        currentNode.accepting = true;
        currentNode.acceptingPattern = pattern;
    }

    @Override
    public int Calculate(Employee employee, int startDay, int endDay, boolean updateStructure) {
        Stack nextStack = this.stacks[startDay];
        int newPenalty = this.penalty;
        int day = startDay;
        while (day < this.numDaysInPeriod) {
            Stack stack = nextStack;
            int originalHash = this.stacks[day + 1].hash;
            newPenalty -= this.dayPens[day];
            if (updateStructure) {
                nextStack = this.stacks[day + 1];
                this.dayPens[day] = 0;
            } else {
                nextStack = this.temp1 ? this.tempStack1 : this.tempStack2;
                this.temp1 = !this.temp1;
            }
            nextStack.size = 1;
            nextStack.hash = this.hashNodesRandVals[0];
            int i = stack.size - 1;
            while (i >= 0) {
                Node node = stack.items[i];
                int j = 0;
                while (j < node.Edges.length) {
                    Edge edge = node.Edges[j];
                    boolean match = false;
                    if (edge.type == Pattern.DayType.Off) {
                        if (employee.DayType[day] != 1 && !employee.EmployeeDescription.DayOffRequestIsWork[day]) {
                            match = true;
                        }
                    } else if (edge.type == Pattern.DayType.OtherWork) {
                        if (employee.EmployeeDescription.DayOffRequestIsWork[day]) {
                            match = true;
                        }
                    } else if (edge.type == Pattern.DayType.WorkingDay) {
                        if (employee.DayType[day] == 1 || employee.EmployeeDescription.DayOffRequestIsWork[day]) {
                            match = true;
                        }
                    } else if (edge.type == Pattern.DayType.Any) {
                        match = true;
                    } else if (edge.type == Pattern.DayType.Shift) {
                        if (employee.ShiftsOnDay[day][edge.value] != null) {
                            match = true;
                        }
                    } else if (edge.type == Pattern.DayType.NotShift) {
                        if (employee.ShiftsOnDay[day][edge.value] == null) {
                            match = true;
                        }
                    } else if (edge.type == Pattern.DayType.ShiftGroup) {
                        if (employee.ShiftGroupPerDayCount[day][edge.value] > 0) {
                            match = true;
                        }
                    } else {
                        System.out.println("Uknown edge type!");
                    }
                    if (match) {
                        Node nextNode = edge.nextNode;
                        if (nextNode.accepting) {
                            newPenalty += nextNode.acceptingPattern.Weight;
                            if (updateStructure) {
                                int n = day;
                                this.dayPens[n] = this.dayPens[n] + nextNode.acceptingPattern.Weight;
                                if (this.VIOLATION_FLAGGING) {
                                    int start = day - nextNode.acceptingPattern.Length + 1;
                                    if (start < 0) {
                                        start = 0;
                                    }
                                    int x = start;
                                    while (x <= day) {
                                        int n2 = x++;
                                        employee.ConstraintViolationPenalties[n2] = employee.ConstraintViolationPenalties[n2] + nextNode.acceptingPattern.Weight;
                                    }
                                    if (SoftConstraints.UpdateViolationDescriptions) {
                                        x = start;
                                        while (x <= day) {
                                            if (day - nextNode.acceptingPattern.Length < -1) {
                                                int n3 = x;
                                                employee.ViolationDescriptions[n3] = String.valueOf(employee.ViolationDescriptions[n3]) + "Undesirable sequence (includes previous schedule): " + nextNode.acceptingPattern.toString() + System.getProperty("line.separator");
                                            } else {
                                                int n4 = x;
                                                employee.ViolationDescriptions[n4] = String.valueOf(employee.ViolationDescriptions[n4]) + "Undesirable sequence: " + nextNode.acceptingPattern.toString() + System.getProperty("line.separator");
                                            }
                                            ++x;
                                        }
                                    }
                                }
                            }
                        }
                        if (!nextNode.terminal) {
                            nextStack.items[nextStack.size] = nextNode;
                            ++nextStack.size;
                            nextStack.hash ^= this.hashNodesRandVals[nextNode.index];
                        }
                    }
                    ++j;
                }
                --i;
            }
            if (day + 1 > endDay && originalHash == nextStack.hash) break;
            ++day;
        }
        if (updateStructure) {
            this.penalty = newPenalty;
        }
        if (this.datePatternsExist) {
            newPenalty += this.TestDatePatterns(employee, startDay, endDay);
        }
        return newPenalty;
    }

    @Override
    public int Calculate(Employee employee, int startDay, int endDay) {
        return this.Calculate(employee, startDay, endDay, true);
    }

    public int Calculate(Employee employee, int maxPenalty, int startDay, int endDay) {
        return this.Calculate(employee, startDay, endDay, true);
    }

    @Override
    public int Calculate(Employee employee) {
        return this.Calculate(employee, 0, this.numDaysInPeriod - 1, true);
    }

    private int TestDatePatterns(Employee employee, int startDay, int endDay) {
        Pattern pattern;
        int penalty = 0;
        int patternIndex = 0;
        while (patternIndex < this.employeeDescription.Contract.WeekDayBadPatterns.length) {
            pattern = this.employeeDescription.Contract.WeekDayBadPatterns[patternIndex];
            int newStart = pattern.StartDay;
            while ((newStart - 7) * -1 <= this.employeeDescription.SchedulingHistory.PreviousDayType.length && newStart - 7 + pattern.ShiftIndices.length > 0) {
                penalty += this.TestPattern(employee, pattern, newStart -= 7);
            }
            int i = 0;
            while (i <= this.numDaysInPeriod - pattern.ShiftIndices.length) {
                penalty += this.TestPattern(employee, pattern, i + pattern.StartDay);
                i += 7;
            }
            ++patternIndex;
        }
        patternIndex = 0;
        while (patternIndex < this.employeeDescription.Contract.DateBadPatterns.length) {
            pattern = this.employeeDescription.Contract.DateBadPatterns[patternIndex];
            if (pattern.StartDay + pattern.ShiftIndices.length <= this.numDaysInPeriod && pattern.StartDay + pattern.ShiftIndices.length > 0 && (pattern.StartDay >= 0 || this.employeeDescription.SchedulingHistory.PreviousDayType.length + pattern.StartDay >= 0)) {
                penalty += this.TestPattern(employee, pattern, pattern.StartDay);
            }
            ++patternIndex;
        }
        return penalty;
    }

    private int TestPattern(Employee employee, Pattern pattern, int startDay) {
        int day;
        SchedulingPeriod schedulingPeriod = employee.Roster.SchedulingPeriod;
        boolean patternMatched = true;
        int penalty = 0;
        int k = 0;
        while (k < pattern.ShiftIndices.length) {
            int index = pattern.ShiftIndices[k];
            day = startDay + k;
            if (day < 0) {
                day = this.employeeDescription.SchedulingHistory.PreviousDayType.length + day;
                if (pattern.DayTypes[k] != Pattern.DayType.Any) {
                    if (pattern.DayTypes[k] == Pattern.DayType.WorkingDay) {
                        if (this.employeeDescription.SchedulingHistory.PreviousDayType[day] != 1) {
                            patternMatched = false;
                            break;
                        }
                    } else if (pattern.DayTypes[k] == Pattern.DayType.Off) {
                        if (this.employeeDescription.SchedulingHistory.PreviousDayType[day] == 1) {
                            patternMatched = false;
                            break;
                        }
                    } else if (pattern.DayTypes[k] == Pattern.DayType.Shift) {
                        if (!this.employeeDescription.SchedulingHistory.PreviousShiftAssignments[day * this.shiftTypeCount + index]) {
                            patternMatched = false;
                            break;
                        }
                    } else if (pattern.DayTypes[k] == Pattern.DayType.NotShift) {
                        if (this.employeeDescription.SchedulingHistory.PreviousShiftAssignments[day * this.shiftTypeCount + index]) {
                            patternMatched = false;
                            break;
                        }
                    } else if (pattern.DayTypes[k] == Pattern.DayType.ShiftGroup) {
                        ShiftGroup grp = schedulingPeriod.GetShiftGroup(index);
                        boolean grpMatched = false;
                        int x = 0;
                        while (x < grp.Group.length) {
                            if (this.employeeDescription.SchedulingHistory.PreviousShiftAssignments[day * this.shiftTypeCount + grp.Group[x].Index]) {
                                grpMatched = true;
                                break;
                            }
                            ++x;
                        }
                        if (!grpMatched) {
                            patternMatched = false;
                            break;
                        }
                    } else if (pattern.DayTypes[k] == Pattern.DayType.OtherWork && this.employeeDescription.SchedulingHistory.PreviousDayType[day] != 1) {
                        patternMatched = false;
                        break;
                    }
                }
            } else {
                if (day >= schedulingPeriod.NumDaysInPeriod) {
                    patternMatched = false;
                    break;
                }
                if (pattern.DayTypes[k] != Pattern.DayType.Any) {
                    if (pattern.DayTypes[k] == Pattern.DayType.WorkingDay) {
                        if (employee.DayType[day] != 1) {
                            patternMatched = false;
                            break;
                        }
                    } else if (pattern.DayTypes[k] == Pattern.DayType.Off) {
                        if (employee.DayType[day] == 1 || this.employeeDescription.DayOffRequestIsWork[day]) {
                            patternMatched = false;
                            break;
                        }
                    } else if (pattern.DayTypes[k] == Pattern.DayType.Shift) {
                        if (employee.ShiftsOnDay[day][index] == null) {
                            patternMatched = false;
                            break;
                        }
                    } else if (pattern.DayTypes[k] == Pattern.DayType.NotShift) {
                        if (employee.ShiftsOnDay[day][index] != null) {
                            patternMatched = false;
                            break;
                        }
                    } else if (pattern.DayTypes[k] == Pattern.DayType.ShiftGroup) {
                        if (employee.ShiftGroupPerDayCount[day][index] <= 0) {
                            patternMatched = false;
                            break;
                        }
                    } else if (pattern.DayTypes[k] == Pattern.DayType.OtherWork && !this.employeeDescription.DayOffRequestIsWork[day]) {
                        patternMatched = false;
                        break;
                    }
                }
            }
            ++k;
        }
        if (patternMatched) {
            penalty += pattern.Weight;
            k = 0;
            while (k < pattern.ShiftIndices.length) {
                int day2 = startDay + k;
                if (day2 >= schedulingPeriod.NumDaysInPeriod) break;
                if (day2 >= 0) {
                    int n = day2;
                    employee.ConstraintViolationPenalties[n] = employee.ConstraintViolationPenalties[n] + pattern.Weight;
                }
                ++k;
            }
            if (SoftConstraints.UpdateViolationDescriptions) {
                boolean includesPreviousSchedule = false;
                if (startDay < 0) {
                    includesPreviousSchedule = true;
                }
                int k2 = 0;
                while (k2 < pattern.ShiftIndices.length) {
                    day = startDay + k2;
                    if (day >= schedulingPeriod.NumDaysInPeriod) break;
                    if (day >= 0) {
                        if (includesPreviousSchedule) {
                            int n = day;
                            employee.ViolationDescriptions[n] = String.valueOf(employee.ViolationDescriptions[n]) + "Undesirable sequence: " + pattern.toString() + " (includes previous schedule)" + System.getProperty("line.separator");
                        } else {
                            int n = day;
                            employee.ViolationDescriptions[n] = String.valueOf(employee.ViolationDescriptions[n]) + "Undesirable sequence: " + pattern.toString() + System.getProperty("line.separator");
                        }
                    }
                    ++k2;
                }
            }
        }
        return penalty;
    }

    class Node {
        public boolean accepting = false;
        public Pattern acceptingPattern;
        public Edge[] Edges = new Edge[0];
        public int index;
        public boolean terminal = true;

        public Node(int index) {
            this.index = index;
        }

        public void AddEdge(Edge edge) {
            this.terminal = false;
            this.Edges = CSharpConversionHelper.ArrayResize(this.Edges, this.Edges.length + 1);
            this.Edges[this.Edges.length - 1] = edge;
        }
    }

    class Stack {
        public Node[] items;
        public int size = 0;
        public int hash = 0;

        public Stack(int maxSize) {
            this.items = new Node[maxSize];
        }
    }
}

