/*
 * Decompiled with CFR 0.152.
 */
package ASAP.NRP.Core.Constraints.TEC;

import ASAP.NRP.Core.Constraints.SoftConstraint;
import ASAP.NRP.Core.Constraints.SoftConstraints;
import ASAP.NRP.Core.Constraints.TEC.Pattern;
import ASAP.NRP.Core.Constraints.TEC.PatternGroup;
import ASAP.NRP.Core.Employee;
import ASAP.NRP.Core.EmployeeDescription;
import ASAP.NRP.Core.SchedulingPeriod;
import ASAP.NRP.Core.ShiftGroup;

public class GoodPatterns
implements SoftConstraint {
    public String Title = "Good Patterns";
    public String LongTitle = "";
    public int Weight = 0;
    public String ID = "";

    @Override
    public String getTitle() {
        return this.Title;
    }

    @Override
    public int getWeight() {
        return this.Weight;
    }

    @Override
    public void Delete(EmployeeDescription employee) {
    }

    @Override
    public String ToXml(EmployeeDescription employee) {
        return "";
    }

    @Override
    public String GetDescription(Employee employee) {
        String str = "<p>";
        int i = 0;
        while (i < employee.EmployeeDescription.Contract.GoodPatterns.length) {
            PatternGroup grp = employee.EmployeeDescription.Contract.GoodPatterns[i];
            str = String.valueOf(str) + "At least one pattern required (Weight=" + grp.Weight + ") from :<br/>";
            int j = 0;
            while (j < grp.Patterns.length) {
                Pattern pattern = grp.Patterns[j];
                str = pattern.StartDayType == Pattern.StartType.Day ? String.valueOf(str) + "Starting on " + pattern.getStartDayOrDate() + "s : " : (pattern.StartDayType == Pattern.StartType.Date ? String.valueOf(str) + "Starting on " + pattern.getStartDayOrDate() + " : " : String.valueOf(str) + "Starting on any day : ");
                str = String.valueOf(str) + pattern.toString();
                str = String.valueOf(str) + ". Penalty=" + pattern.Weight + "<br/>";
                ++j;
            }
            ++i;
        }
        return String.valueOf(str) + "</p>";
    }

    @Override
    public int Calculate(Employee employee, int startDay, int endDay) {
        return this.Calculate(employee);
    }

    public int Calculate(Employee employee, int maxPenalty, int startDay, int endDay) {
        return this.Calculate(employee);
    }

    @Override
    public int Calculate(Employee employee, int startDay, int endDay, boolean updateStructure) {
        return this.Calculate(employee);
    }

    @Override
    public int Calculate(Employee employee) {
        SchedulingPeriod schedulingPeriod = employee.Roster.SchedulingPeriod;
        int shiftTypeCount = schedulingPeriod.ShiftTypesCount;
        int penalty = 0;
        int grpIndex = 0;
        while (grpIndex < employee.EmployeeDescription.Contract.GoodPatterns.length) {
            PatternGroup patternGrp = employee.EmployeeDescription.Contract.GoodPatterns[grpIndex];
            if (patternGrp.Weight > 0) {
                Pattern pattern;
                boolean patternFound = false;
                int j = 0;
                while (j < patternGrp.Patterns.length) {
                    pattern = patternGrp.Patterns[j];
                    if (pattern.StartDay >= 0 || employee.EmployeeDescription.SchedulingHistory.PreviousDayType.length + pattern.StartDay >= 0) {
                        boolean patternMatched = true;
                        int k = 0;
                        while (k < pattern.ShiftIndices.length) {
                            int x;
                            boolean grpMatched;
                            ShiftGroup grp;
                            int index = pattern.ShiftIndices[k];
                            int day = pattern.StartDay + k;
                            if (day < 0) {
                                day = employee.EmployeeDescription.SchedulingHistory.PreviousDayType.length + day;
                                if (pattern.DayTypes[k] != Pattern.DayType.Any) {
                                    if (pattern.DayTypes[k] == Pattern.DayType.Off) {
                                        if (employee.EmployeeDescription.SchedulingHistory.PreviousDayType[day] == 1) {
                                            patternMatched = false;
                                            break;
                                        }
                                    } else if (pattern.DayTypes[k] == Pattern.DayType.WorkingDay) {
                                        if (employee.EmployeeDescription.SchedulingHistory.PreviousDayType[day] != 1) {
                                            patternMatched = false;
                                            break;
                                        }
                                    } else if (pattern.DayTypes[k] == Pattern.DayType.Shift) {
                                        if (!employee.EmployeeDescription.SchedulingHistory.PreviousShiftAssignments[day * shiftTypeCount + index]) {
                                            patternMatched = false;
                                            break;
                                        }
                                    } else if (pattern.DayTypes[k] == Pattern.DayType.NotShift) {
                                        if (employee.EmployeeDescription.SchedulingHistory.PreviousShiftAssignments[day * shiftTypeCount + index]) {
                                            patternMatched = false;
                                            break;
                                        }
                                    } else if (pattern.DayTypes[k] == Pattern.DayType.ShiftGroup) {
                                        grp = schedulingPeriod.GetShiftGroup(index);
                                        grpMatched = false;
                                        x = 0;
                                        while (x < grp.Group.length) {
                                            if (employee.EmployeeDescription.SchedulingHistory.PreviousShiftAssignments[day * shiftTypeCount + grp.Group[x].Index]) {
                                                grpMatched = true;
                                                break;
                                            }
                                            ++x;
                                        }
                                        if (!grpMatched) {
                                            patternMatched = false;
                                            break;
                                        }
                                    } else if (pattern.DayTypes[k] == Pattern.DayType.OtherWork && employee.EmployeeDescription.SchedulingHistory.PreviousDayType[day] != 1) {
                                        patternMatched = false;
                                        break;
                                    }
                                }
                            } else {
                                if (day >= schedulingPeriod.NumDaysInPeriod) break;
                                if (pattern.DayTypes[k] != Pattern.DayType.Any) {
                                    if (pattern.DayTypes[k] == Pattern.DayType.Off) {
                                        if (employee.DayType[day] == 1 || employee.EmployeeDescription.DayOffRequestIsWork[day]) {
                                            patternMatched = false;
                                            break;
                                        }
                                    } else if (pattern.DayTypes[k] == Pattern.DayType.WorkingDay) {
                                        if (employee.DayType[day] != 1 && !employee.EmployeeDescription.DayOffRequestIsWork[day]) {
                                            patternMatched = false;
                                            break;
                                        }
                                    } else if (pattern.DayTypes[k] == Pattern.DayType.Shift) {
                                        if (!employee.ShiftAssignments[day * shiftTypeCount + index]) {
                                            patternMatched = false;
                                            break;
                                        }
                                    } else if (pattern.DayTypes[k] == Pattern.DayType.NotShift) {
                                        if (employee.ShiftAssignments[day * shiftTypeCount + index]) {
                                            patternMatched = false;
                                            break;
                                        }
                                    } else if (pattern.DayTypes[k] == Pattern.DayType.ShiftGroup) {
                                        grp = schedulingPeriod.GetShiftGroup(index);
                                        grpMatched = false;
                                        x = 0;
                                        while (x < grp.Group.length) {
                                            if (employee.ShiftAssignments[day * shiftTypeCount + grp.Group[x].Index]) {
                                                grpMatched = true;
                                                break;
                                            }
                                            ++x;
                                        }
                                        if (!grpMatched) {
                                            patternMatched = false;
                                            break;
                                        }
                                    } else if (pattern.DayTypes[k] == Pattern.DayType.OtherWork && !employee.EmployeeDescription.DayOffRequestIsWork[day]) {
                                        patternMatched = false;
                                        break;
                                    }
                                }
                            }
                            ++k;
                        }
                        if (patternMatched) {
                            penalty += pattern.Weight;
                            patternFound = true;
                            break;
                        }
                    }
                    ++j;
                }
                if (!patternFound) {
                    penalty += patternGrp.Weight;
                    j = 0;
                    while (j < patternGrp.Patterns.length) {
                        pattern = patternGrp.Patterns[j];
                        int k = 0;
                        while (k < pattern.ShiftIndices.length) {
                            int index = pattern.ShiftIndices[k];
                            int day = pattern.StartDay + k;
                            if (day >= 0) {
                                if (day >= schedulingPeriod.NumDaysInPeriod) break;
                                if (pattern.DayTypes[k] != Pattern.DayType.Any) {
                                    if (pattern.DayTypes[k] == Pattern.DayType.Off) {
                                        if (employee.DayType[day] == 1 || employee.EmployeeDescription.DayOffRequestIsWork[day]) {
                                            int n = day;
                                            employee.ConstraintViolationPenalties[n] = employee.ConstraintViolationPenalties[n] + patternGrp.Weight;
                                            if (SoftConstraints.UpdateViolationDescriptions) {
                                                int n2 = day;
                                                employee.ViolationDescriptions[n2] = String.valueOf(employee.ViolationDescriptions[n2]) + "Pattern not matched (wants a day off)" + System.getProperty("line.separator");
                                            }
                                        }
                                    } else if (pattern.DayTypes[k] == Pattern.DayType.WorkingDay) {
                                        if (employee.DayType[day] != 1 && !employee.EmployeeDescription.DayOffRequestIsWork[day]) {
                                            int n = day;
                                            employee.ConstraintViolationPenalties[n] = employee.ConstraintViolationPenalties[n] + patternGrp.Weight;
                                            if (SoftConstraints.UpdateViolationDescriptions) {
                                                int n3 = day;
                                                employee.ViolationDescriptions[n3] = String.valueOf(employee.ViolationDescriptions[n3]) + "Pattern not matched (wants a day on)" + System.getProperty("line.separator");
                                            }
                                        }
                                    } else if (pattern.DayTypes[k] == Pattern.DayType.Shift) {
                                        if (!employee.ShiftAssignments[day * shiftTypeCount + index]) {
                                            int n = day;
                                            employee.ConstraintViolationPenalties[n] = employee.ConstraintViolationPenalties[n] + patternGrp.Weight;
                                            if (SoftConstraints.UpdateViolationDescriptions) {
                                                int n4 = day;
                                                employee.ViolationDescriptions[n4] = String.valueOf(employee.ViolationDescriptions[n4]) + "Pattern not matched (" + schedulingPeriod.GetShiftType((int)index).Label + " shift required)" + System.getProperty("line.separator");
                                            }
                                        }
                                    } else if (pattern.DayTypes[k] == Pattern.DayType.NotShift) {
                                        if (employee.ShiftAssignments[day * shiftTypeCount + index]) {
                                            int n = day;
                                            employee.ConstraintViolationPenalties[n] = employee.ConstraintViolationPenalties[n] + patternGrp.Weight;
                                            if (SoftConstraints.UpdateViolationDescriptions) {
                                                int n5 = day;
                                                employee.ViolationDescriptions[n5] = String.valueOf(employee.ViolationDescriptions[n5]) + "Pattern not matched (Not " + schedulingPeriod.GetShiftType((int)index).Label + " shift required)" + System.getProperty("line.separator");
                                            }
                                        }
                                    } else if (pattern.DayTypes[k] == Pattern.DayType.ShiftGroup) {
                                        ShiftGroup grp = schedulingPeriod.GetShiftGroup(index);
                                        boolean grpMatched = false;
                                        int x = 0;
                                        while (x < grp.Group.length) {
                                            if (employee.ShiftAssignments[day * shiftTypeCount + grp.Group[x].Index]) {
                                                grpMatched = true;
                                                break;
                                            }
                                            ++x;
                                        }
                                        if (!grpMatched) {
                                            int n = day;
                                            employee.ConstraintViolationPenalties[n] = employee.ConstraintViolationPenalties[n] + patternGrp.Weight;
                                            if (SoftConstraints.UpdateViolationDescriptions) {
                                                int n6 = day;
                                                employee.ViolationDescriptions[n6] = String.valueOf(employee.ViolationDescriptions[n6]) + "Pattern not matched (wants a shift from group [" + grp.Label + "])" + System.getProperty("line.separator");
                                            }
                                        }
                                    } else if (pattern.DayTypes[k] == Pattern.DayType.OtherWork && !employee.EmployeeDescription.DayOffRequestIsWork[day]) {
                                        int n = day;
                                        employee.ConstraintViolationPenalties[n] = employee.ConstraintViolationPenalties[n] + patternGrp.Weight;
                                        if (SoftConstraints.UpdateViolationDescriptions) {
                                            int n7 = day;
                                            employee.ViolationDescriptions[n7] = String.valueOf(employee.ViolationDescriptions[n7]) + "Pattern not matched (wants other work)" + System.getProperty("line.separator");
                                        }
                                    }
                                }
                            }
                            ++k;
                        }
                        ++j;
                    }
                }
            }
            ++grpIndex;
        }
        return penalty;
    }
}

