/*
 * Decompiled with CFR 0.152.
 */
package ASAP.NRP.Core.Constraints.TEC;

import ASAP.NRP.Core.Constraints.SoftConstraint;
import ASAP.NRP.Core.Employee;
import ASAP.NRP.Core.EmployeeDescription;
import ASAP.NRP.Core.SchedulingPeriod;
import ASAP.NRP.Core.ShiftGroup;

public class MinShiftGroups
implements SoftConstraint {
    public String Title = "Min shift groups";
    public String LongTitle = "";
    public int Weight = 0;
    public String ID = "";

    public MinShiftGroups(int Weight) {
        this.Weight = Weight;
    }

    @Override
    public String getTitle() {
        return this.Title;
    }

    @Override
    public int getWeight() {
        return this.Weight;
    }

    @Override
    public void Delete(EmployeeDescription employee) {
    }

    @Override
    public String ToXml(EmployeeDescription employee) {
        return "";
    }

    @Override
    public String GetDescription(Employee employee) {
        String info = "Min shift roups";
        SchedulingPeriod schedulingPeriod = employee.Roster.SchedulingPeriod;
        int x = 0;
        while (x < schedulingPeriod.ShiftGroupsCount) {
            ShiftGroup shiftGroup = schedulingPeriod.GetShiftGroup(x);
            String ID = shiftGroup.ID;
            int i = shiftGroup.Index;
            info = employee.EmployeeDescription.Contract.MinShiftGroups[i] <= 0 ? String.valueOf(info) + "<br/>No minimum number of shifts from group '" + ID + "' (" + shiftGroup.Label + "), receives " + employee.ShiftGroupCount[i] : String.valueOf(info) + "<br/>Requests min " + employee.EmployeeDescription.Contract.MinShiftGroups[i] + " shifts from group '" + ID + "' (" + shiftGroup.Label + "), receives " + employee.ShiftGroupCount[i];
            ++x;
        }
        return info;
    }

    @Override
    public int Calculate(Employee employee, int startDay, int endDay) {
        return this.Calculate(employee);
    }

    public int Calculate(Employee employee, int maxPenalty, int startDay, int endDay) {
        return this.Calculate(employee);
    }

    @Override
    public int Calculate(Employee employee, int startDay, int endDay, boolean updateStructure) {
        return this.Calculate(employee);
    }

    @Override
    public int Calculate(Employee employee) {
        if (this.Weight == 0) {
            return 0;
        }
        SchedulingPeriod schedulingPeriod = employee.Roster.SchedulingPeriod;
        int penalty = 0;
        int shiftCount = schedulingPeriod.ShiftGroupsCount;
        int i = 0;
        while (i < shiftCount) {
            int min = employee.EmployeeDescription.Contract.MinShiftGroups[i];
            int count = employee.ShiftGroupCount[i];
            if (min > 0 && count < min) {
                int pen = this.Weight * (min - count);
                penalty += pen;
            }
            ++i;
        }
        return penalty;
    }
}

