/*
 * Decompiled with CFR 0.152.
 */
package ASAP.NRP.Core.Constraints.TEC;

import ASAP.NRP.Core.DateTime;
import ASAP.NRP.Core.ShiftGroup;
import ASAP.NRP.Core.ShiftType;

public class Pattern
implements Cloneable {
    public int StartDay;
    public int[] ShiftIndices;
    public DayType[] DayTypes;
    public ShiftType[] Shifts;
    public ShiftGroup[] ShiftGroups;
    public StartType StartDayType;
    public int Weight;
    public int Length;
    public int WeekdayIndex;
    public DateTime StartDate;

    public Pattern(int startDay, StartType startType, int[] shiftIndices, DayType[] dayTypes, int weight, int weekdayIndex, DateTime startDate, ShiftType[] Shifts, ShiftGroup[] ShiftGroups) {
        this.StartDay = startDay;
        this.ShiftIndices = shiftIndices;
        this.DayTypes = dayTypes;
        this.Shifts = Shifts;
        this.ShiftGroups = ShiftGroups;
        this.StartDayType = startType;
        this.Weight = weight;
        this.Length = dayTypes.length;
        this.WeekdayIndex = weekdayIndex;
        this.StartDate = startDate;
    }

    public String getStartDayOrDate() {
        if (this.StartDayType == StartType.All) {
            return "";
        }
        if (this.StartDayType == StartType.Date) {
            return this.StartDate.ToShortDateString();
        }
        if (this.StartDayType == StartType.Day) {
            if (this.WeekdayIndex == 0) {
                return "Monday";
            }
            if (this.WeekdayIndex == 1) {
                return "Tuesday";
            }
            if (this.WeekdayIndex == 2) {
                return "Wednesday";
            }
            if (this.WeekdayIndex == 3) {
                return "Thursday";
            }
            if (this.WeekdayIndex == 4) {
                return "Friday";
            }
            if (this.WeekdayIndex == 5) {
                return "Saturday";
            }
            if (this.WeekdayIndex == 6) {
                return "Sunday";
            }
        }
        return "";
    }

    public String toString() {
        String str = "";
        int k = 0;
        while (k < this.ShiftIndices.length) {
            Object sh;
            DayType dayType = this.DayTypes[k];
            if (dayType == DayType.Off) {
                str = String.valueOf(str) + "Off";
            } else if (dayType == DayType.OtherWork) {
                str = String.valueOf(str) + "OtherWork";
            } else if (dayType == DayType.Any) {
                str = String.valueOf(str) + "Off or On";
            } else if (dayType == DayType.WorkingDay) {
                str = String.valueOf(str) + "On";
            } else if (dayType == DayType.Shift) {
                sh = this.Shifts[k];
                str = String.valueOf(str) + ((ShiftType)sh).Label;
            } else if (dayType == DayType.NotShift) {
                sh = this.Shifts[k];
                str = String.valueOf(str) + "Not " + ((ShiftType)sh).Label;
            } else if (dayType == DayType.ShiftGroup) {
                sh = this.ShiftGroups[k];
                str = String.valueOf(str) + "[" + ((ShiftGroup)sh).Label + "]";
            }
            if (k != this.ShiftIndices.length - 1) {
                str = String.valueOf(str) + ", ";
            }
            ++k;
        }
        return str;
    }

    public String ToHtmlTableRow() {
        String str = "";
        int k = 0;
        while (k < this.ShiftIndices.length) {
            Object sh;
            DayType dayType = this.DayTypes[k];
            str = String.valueOf(str) + "<td class=\"ptrnTblCell\" valign=\"top\" style=\"text-align: center\">";
            if (dayType == DayType.Off) {
                str = String.valueOf(str) + "Off";
            } else if (dayType == DayType.OtherWork) {
                str = String.valueOf(str) + "OtherWork";
            } else if (dayType == DayType.Any) {
                str = String.valueOf(str) + "Off<br/><i>or</i><br/>On";
            } else if (dayType == DayType.WorkingDay) {
                str = String.valueOf(str) + "On";
            } else if (dayType == DayType.Shift) {
                sh = this.Shifts[k];
                str = String.valueOf(str) + ((ShiftType)sh).Label;
            } else if (dayType == DayType.NotShift) {
                sh = this.Shifts[k];
                str = String.valueOf(str) + "<nobr><i>Not</i> " + ((ShiftType)sh).Label + "</nobr>";
            } else if (dayType == DayType.ShiftGroup) {
                sh = this.ShiftGroups[k];
                str = String.valueOf(str) + ((ShiftGroup)sh).Group[0].Label;
                int i = 1;
                while (i < ((ShiftGroup)sh).Group.length) {
                    str = String.valueOf(str) + " <i>or</i><br/>" + ((ShiftGroup)sh).Group[i].Label;
                    ++i;
                }
            }
            str = String.valueOf(str) + "</td>";
            ++k;
        }
        return str;
    }

    public static enum DayType {
        Any,
        Off,
        OtherWork,
        Shift,
        NotShift,
        ShiftGroup,
        WorkingDay;

    }

    public static enum StartType {
        All,
        Day,
        Date;

    }
}

