/*
 * Decompiled with CFR 0.152.
 */
package ASAP.NRP.Core;

import ASAP.NRP.Core.Constraints.SoftConstraints;
import ASAP.NRP.Core.CoverProvided;
import ASAP.NRP.Core.CoverRequirement;
import ASAP.NRP.Core.DateTime;
import ASAP.NRP.Core.Employee;
import ASAP.NRP.Core.EmployeeDescription;
import ASAP.NRP.Core.SchedulingPeriod;
import ASAP.NRP.Core.Shift;
import ASAP.NRP.Core.ShiftGroup;
import ASAP.NRP.Core.ShiftType;
import ASAP.NRP.Core.Tools.RosterPrinter;
import java.io.StringWriter;
import java.util.Hashtable;

public class Roster
implements Cloneable,
Comparable<Object> {
    public static final int NON_WORKING_DAY = 0;
    public static final int WORKING_DAY = 1;
    public static final int HOLIDAY_DAY_OFF = 2;
    public CoverProvided[] CoverProvided;
    private Hashtable<String, Employee> EmployeeHash = new Hashtable();
    public Employee[] Employees;
    public int[] CoverPenOnDay;
    public final int CacheSize = 500;
    private int[] EmployeesPenaltyCache = new int[500];
    public SchedulingPeriod SchedulingPeriod;
    public int EmployeesPenalty;
    public int CoverPenalty;

    public Roster(SchedulingPeriod schedulingPeriod) {
        this.SchedulingPeriod = schedulingPeriod;
        this.CoverPenOnDay = new int[schedulingPeriod.NumDaysInPeriod];
        this.CoverProvided = new CoverProvided[schedulingPeriod.CoverRequirements.Requirements.length];
        int k = 0;
        while (k < this.CoverProvided.length) {
            this.CoverProvided[k] = new CoverProvided(schedulingPeriod);
            this.CoverProvided[k].Index = k;
            ++k;
        }
        int employeesCount = 0;
        int i = 0;
        while (i < schedulingPeriod.EmployeesCount) {
            if (schedulingPeriod.GetEmployeeDescription((int)i).InRoster) {
                ++employeesCount;
            }
            ++i;
        }
        this.Employees = new Employee[employeesCount];
        int ind = 0;
        int i2 = 0;
        while (i2 < schedulingPeriod.EmployeesCount) {
            EmployeeDescription employeeDescription = schedulingPeriod.GetEmployeeDescription(i2);
            if (employeeDescription.InRoster) {
                Employee employee = new Employee(this, employeeDescription);
                this.EmployeeHash.put(employeeDescription.ID, employee);
                this.Employees[ind] = employee;
                employee.Index = ind++;
            }
            ++i2;
        }
        this.MakeInitialAssignments();
        this.RecalculateAllPenalties();
    }

    public Object Clone() {
        Roster roster = new Roster(this.SchedulingPeriod);
        int i = 0;
        while (i < this.Employees.length) {
            Employee newEmployee = roster.GetEmployee(this.Employees[i].EmployeeDescription.ID);
            int day = 0;
            while (day < this.SchedulingPeriod.NumDaysInPeriod) {
                int j = 0;
                while (j < this.SchedulingPeriod.ShiftTypesCount) {
                    Shift newShift;
                    int violationCount;
                    if (this.Employees[i].ShiftsOnDay[day][j] != null && (violationCount = newEmployee.ViolationsForAssigningShift(newShift = (Shift)this.Employees[i].ShiftsOnDay[day][j].Clone())) != -1) {
                        roster.AssignShift(newEmployee, newShift);
                    }
                    ++j;
                }
                ++day;
            }
            ++i;
        }
        roster.RecalculateAllPenalties();
        return roster;
    }

    @Override
    public int compareTo(Object obj) {
        int p2;
        int p1 = this.getTotalPenalty();
        int diff = p1 - (p2 = ((Roster)obj).getTotalPenalty());
        if (diff > 0) {
            return 1;
        }
        if (diff < 0) {
            return -1;
        }
        return 0;
    }

    public int getTotalPenalty() {
        return this.CoverPenalty + this.EmployeesPenalty;
    }

    public boolean AssignShift(Employee employee, Shift shift) {
        if (shift == null) {
            return false;
        }
        if (shift.isAssigned()) {
            return false;
        }
        if (employee == null) {
            return false;
        }
        shift.Employee = employee;
        int rosterDay = shift.RosterDay;
        int shiftIndex = shift.ShiftType.Index;
        ++employee.ShiftsCount;
        employee.ShiftsOnDay[rosterDay][shiftIndex] = shift;
        if (employee.DayType[rosterDay] == 2) {
            --employee.HolidayDaysOffGranted;
        }
        employee.DayType[rosterDay] = 1;
        int shiftAssignmentIndex = rosterDay * this.SchedulingPeriod.ShiftTypesCount + shift.ShiftType.Index;
        employee.ShiftAssignments[shiftAssignmentIndex] = true;
        if (shift.ShiftType.getSpansMidnight()) {
            employee.NightShifts[rosterDay] = true;
        }
        if (employee.ShiftCountPerDay[rosterDay] == 0 && !employee.EmployeeDescription.DayOffRequestIsWork[rosterDay]) {
            --employee.DaysOffCount;
        }
        int n = rosterDay;
        employee.ShiftCountPerDay[n] = employee.ShiftCountPerDay[n] + 1;
        int n2 = shiftIndex;
        employee.ShiftTypeCount[n2] = employee.ShiftTypeCount[n2] + 1;
        int i = 0;
        while (i < shift.ShiftType.ShiftGroupCount) {
            ShiftGroup grp = shift.ShiftType.ShiftGroups[i];
            int n3 = grp.Index;
            employee.ShiftGroupCount[n3] = employee.ShiftGroupCount[n3] + 1;
            int[] nArray = employee.ShiftGroupPerDayCount[rosterDay];
            int n4 = grp.Index;
            nArray[n4] = nArray[n4] + 1;
            ++i;
        }
        int week = shift.WeekNumber;
        int[] nArray = employee.ShiftTypePerWeekCount[week - 1];
        int n5 = shiftIndex;
        nArray[n5] = nArray[n5] + 1;
        employee.HoursWorked += shift.ShiftType.HoursWorked;
        int n6 = week - 1;
        employee.HoursWorkedPerWeek[n6] = employee.HoursWorkedPerWeek[n6] + shift.ShiftType.HoursWorked;
        int i2 = 0;
        while (i2 < this.SchedulingPeriod.CoverRequirements.Requirements.length) {
            CoverRequirement req = this.SchedulingPeriod.CoverRequirements.Requirements[i2];
            CoverProvided prov = this.CoverProvided[i2];
            if (this.SchedulingPeriod.EmployeeHasSkillForCover(employee.EmployeeDescription, req)) {
                if (req.CoverPerShiftUsed) {
                    int[] nArray2 = prov.ProvidedCoverPerShift[shiftIndex];
                    int n7 = rosterDay;
                    nArray2[n7] = nArray2[n7] + 1;
                }
                if (req.CoverPerShiftGroupUsed) {
                    int[] groups = this.SchedulingPeriod.GetShiftGroupsContainingShift(shiftIndex);
                    int j = 0;
                    while (j < groups.length) {
                        int[] nArray3 = prov.ProvidedCoverPerShiftGroup[groups[j]];
                        int n8 = rosterDay;
                        nArray3[n8] = nArray3[n8] + 1;
                        ++j;
                    }
                }
                if (req.CoverPerPeriodUsed && shift.ShiftType.CoversPeriods) {
                    int j = 0;
                    while (j < shift.ShiftType.Periods.length) {
                        int[] nArray4 = prov.ProvidedCoverPerPeriod[shift.ShiftType.Periods[j]];
                        int n9 = rosterDay;
                        nArray4[n9] = nArray4[n9] + 1;
                        ++j;
                    }
                    if (rosterDay + 1 < this.SchedulingPeriod.NumDaysInPeriod) {
                        j = 0;
                        while (j < shift.ShiftType.NextDayPeriods.length) {
                            int[] nArray5 = prov.ProvidedCoverPerPeriod[shift.ShiftType.NextDayPeriods[j]];
                            int n10 = rosterDay + 1;
                            nArray5[n10] = nArray5[n10] + 1;
                            ++j;
                        }
                    }
                }
            }
            ++i2;
        }
        return true;
    }

    public boolean UnAssignShift(Shift shift) {
        if (shift == null || !shift.isAssigned()) {
            return false;
        }
        Employee employee = shift.Employee;
        shift.Employee = null;
        int rosterDay = shift.RosterDay;
        int shiftIndex = shift.ShiftType.Index;
        --employee.ShiftsCount;
        employee.ShiftsOnDay[rosterDay][shiftIndex] = null;
        int shiftAssignmentIndex = rosterDay * this.SchedulingPeriod.ShiftTypesCount + shift.ShiftType.Index;
        employee.ShiftAssignments[shiftAssignmentIndex] = false;
        if (shift.ShiftType.getSpansMidnight()) {
            employee.NightShifts[rosterDay] = false;
        }
        int n = rosterDay;
        employee.ShiftCountPerDay[n] = employee.ShiftCountPerDay[n] - 1;
        if (employee.ShiftCountPerDay[rosterDay] == 0) {
            if (employee.EmployeeDescription.DayOffRequestIsHoliday[rosterDay]) {
                employee.DayType[rosterDay] = 2;
                ++employee.HolidayDaysOffGranted;
            } else {
                employee.DayType[rosterDay] = 0;
            }
            if (!employee.EmployeeDescription.DayOffRequestIsWork[rosterDay]) {
                ++employee.DaysOffCount;
            }
        }
        int n2 = shiftIndex;
        employee.ShiftTypeCount[n2] = employee.ShiftTypeCount[n2] - 1;
        int i = 0;
        while (i < shift.ShiftType.ShiftGroupCount) {
            ShiftGroup grp = shift.ShiftType.ShiftGroups[i];
            int n3 = grp.Index;
            employee.ShiftGroupCount[n3] = employee.ShiftGroupCount[n3] - 1;
            int[] nArray = employee.ShiftGroupPerDayCount[rosterDay];
            int n4 = grp.Index;
            nArray[n4] = nArray[n4] - 1;
            ++i;
        }
        int week = shift.WeekNumber;
        int[] nArray = employee.ShiftTypePerWeekCount[week - 1];
        int n5 = shiftIndex;
        nArray[n5] = nArray[n5] - 1;
        employee.HoursWorked -= shift.ShiftType.HoursWorked;
        int n6 = week - 1;
        employee.HoursWorkedPerWeek[n6] = employee.HoursWorkedPerWeek[n6] - shift.ShiftType.HoursWorked;
        int i2 = 0;
        while (i2 < this.SchedulingPeriod.CoverRequirements.Requirements.length) {
            CoverRequirement req = this.SchedulingPeriod.CoverRequirements.Requirements[i2];
            CoverProvided prov = this.CoverProvided[i2];
            if (this.SchedulingPeriod.EmployeeHasSkillForCover(employee.EmployeeDescription, req)) {
                if (req.CoverPerShiftUsed) {
                    int[] nArray2 = prov.ProvidedCoverPerShift[shiftIndex];
                    int n7 = rosterDay;
                    nArray2[n7] = nArray2[n7] - 1;
                }
                if (req.CoverPerShiftGroupUsed) {
                    int[] groups = this.SchedulingPeriod.GetShiftGroupsContainingShift(shiftIndex);
                    int j = 0;
                    while (j < groups.length) {
                        int[] nArray3 = prov.ProvidedCoverPerShiftGroup[groups[j]];
                        int n8 = rosterDay;
                        nArray3[n8] = nArray3[n8] - 1;
                        ++j;
                    }
                }
                if (req.CoverPerPeriodUsed && shift.ShiftType.CoversPeriods) {
                    int j = 0;
                    while (j < shift.ShiftType.Periods.length) {
                        int[] nArray4 = prov.ProvidedCoverPerPeriod[shift.ShiftType.Periods[j]];
                        int n9 = rosterDay;
                        nArray4[n9] = nArray4[n9] - 1;
                        ++j;
                    }
                    if (rosterDay + 1 < this.SchedulingPeriod.NumDaysInPeriod) {
                        j = 0;
                        while (j < shift.ShiftType.NextDayPeriods.length) {
                            int[] nArray5 = prov.ProvidedCoverPerPeriod[shift.ShiftType.NextDayPeriods[j]];
                            int n10 = rosterDay + 1;
                            nArray5[n10] = nArray5[n10] - 1;
                            ++j;
                        }
                    }
                }
            }
            ++i2;
        }
        return true;
    }

    public int RecalculateAllPenalties() {
        int totPenalty = 0;
        int i = 0;
        while (i < this.Employees.length) {
            Employee employee = this.Employees[i];
            employee.Penalty = SoftConstraints.CalculatePenalty(employee);
            totPenalty += employee.Penalty;
            ++i;
        }
        this.EmployeesPenalty = totPenalty;
        int covPenalty = this.RecalculateCoverPenalty();
        this.CoverPenalty = covPenalty;
        return totPenalty += covPenalty;
    }

    public int RecalculateCoverPenalty() {
        int covPenalty = 0;
        int i = 0;
        while (i < this.CoverPenOnDay.length) {
            this.CoverPenOnDay[i] = 0;
            ++i;
        }
        int x = 0;
        while (x < this.SchedulingPeriod.CoverRequirements.Requirements.length) {
            int i2;
            int pen;
            int diff;
            int newPen;
            int day;
            CoverRequirement req = this.SchedulingPeriod.CoverRequirements.Requirements[x];
            CoverProvided prov = this.CoverProvided[x];
            if (req.CoverPerPeriodUsed) {
                day = 0;
                while (day < this.SchedulingPeriod.NumDaysInPeriod) {
                    int p = 0;
                    while (p < this.SchedulingPeriod.getDayPeriodsCount()) {
                        newPen = 0;
                        if (req.MinCoverPerPeriod[p][day] > 0 && prov.ProvidedCoverPerPeriod[p][day] < req.MinCoverPerPeriod[p][day]) {
                            diff = req.MinCoverPerPeriod[p][day] - prov.ProvidedCoverPerPeriod[p][day];
                            pen = diff * this.SchedulingPeriod.MasterWeights.MinUnderStaffing;
                            newPen += pen;
                        }
                        if (req.MaxCoverPerPeriod[p][day] >= 0 && prov.ProvidedCoverPerPeriod[p][day] > req.MaxCoverPerPeriod[p][day]) {
                            diff = prov.ProvidedCoverPerPeriod[p][day] - req.MaxCoverPerPeriod[p][day];
                            pen = diff * this.SchedulingPeriod.MasterWeights.MaxOverStaffing;
                            newPen += pen;
                        }
                        if (req.PrefCoverPerPeriod[p][day] >= 0 && req.PrefCoverPerPeriod[p][day] != prov.ProvidedCoverPerPeriod[p][day]) {
                            diff = req.PrefCoverPerPeriod[p][day] - prov.ProvidedCoverPerPeriod[p][day];
                            pen = 0;
                            pen = diff < 0 ? Math.abs(diff * this.SchedulingPeriod.MasterWeights.PrefOverStaffing) : diff * this.SchedulingPeriod.MasterWeights.PrefUnderStaffing;
                            newPen += pen;
                        }
                        prov.CoverPerPeriodPenalty[p][day] = newPen;
                        int n = day;
                        this.CoverPenOnDay[n] = this.CoverPenOnDay[n] + newPen;
                        covPenalty += newPen;
                        ++p;
                    }
                    ++day;
                }
            }
            if (req.CoverPerShiftUsed) {
                day = 0;
                while (day < this.SchedulingPeriod.NumDaysInPeriod) {
                    i2 = 0;
                    while (i2 < this.SchedulingPeriod.ShiftTypesCount) {
                        newPen = 0;
                        if (req.MinCoverPerShift[i2][day] > 0 && req.MinCoverPerShift[i2][day] > prov.ProvidedCoverPerShift[i2][day]) {
                            diff = req.MinCoverPerShift[i2][day] - prov.ProvidedCoverPerShift[i2][day];
                            pen = diff * this.SchedulingPeriod.MasterWeights.MinUnderStaffing;
                            newPen += pen;
                        }
                        if (req.MaxCoverPerShift[i2][day] >= 0 && req.MaxCoverPerShift[i2][day] < prov.ProvidedCoverPerShift[i2][day]) {
                            diff = prov.ProvidedCoverPerShift[i2][day] - req.MaxCoverPerShift[i2][day];
                            pen = diff * this.SchedulingPeriod.MasterWeights.MaxOverStaffing;
                            newPen += pen;
                        }
                        if (req.PrefCoverPerShift[i2][day] >= 0 && req.PrefCoverPerShift[i2][day] != prov.ProvidedCoverPerShift[i2][day]) {
                            diff = req.PrefCoverPerShift[i2][day] - prov.ProvidedCoverPerShift[i2][day];
                            pen = 0;
                            pen = diff < 0 ? Math.abs(diff * this.SchedulingPeriod.MasterWeights.PrefOverStaffing) : diff * this.SchedulingPeriod.MasterWeights.PrefUnderStaffing;
                            newPen += pen;
                        }
                        prov.CoverPerShiftPenalty[i2][day] = newPen;
                        int n = day;
                        this.CoverPenOnDay[n] = this.CoverPenOnDay[n] + newPen;
                        covPenalty += newPen;
                        ++i2;
                    }
                    ++day;
                }
            }
            if (req.CoverPerShiftGroupUsed) {
                day = 0;
                while (day < this.SchedulingPeriod.NumDaysInPeriod) {
                    i2 = 0;
                    while (i2 < this.SchedulingPeriod.ShiftGroupsCount) {
                        newPen = 0;
                        if (req.MinCoverPerShiftGroup[i2][day] > 0 && req.MinCoverPerShiftGroup[i2][day] > prov.ProvidedCoverPerShiftGroup[i2][day]) {
                            diff = req.MinCoverPerShiftGroup[i2][day] - prov.ProvidedCoverPerShiftGroup[i2][day];
                            pen = diff * this.SchedulingPeriod.MasterWeights.MinUnderStaffing;
                            newPen += pen;
                        }
                        if (req.MaxCoverPerShiftGroup[i2][day] >= 0 && req.MaxCoverPerShiftGroup[i2][day] < prov.ProvidedCoverPerShiftGroup[i2][day]) {
                            diff = prov.ProvidedCoverPerShiftGroup[i2][day] - req.MaxCoverPerShiftGroup[i2][day];
                            pen = diff * this.SchedulingPeriod.MasterWeights.MaxOverStaffing;
                            newPen += pen;
                        }
                        if (req.PrefCoverPerShiftGroup[i2][day] >= 0 && req.PrefCoverPerShiftGroup[i2][day] != prov.ProvidedCoverPerShiftGroup[i2][day]) {
                            diff = req.PrefCoverPerShiftGroup[i2][day] - prov.ProvidedCoverPerShiftGroup[i2][day];
                            pen = 0;
                            pen = diff < 0 ? Math.abs(diff * this.SchedulingPeriod.MasterWeights.PrefOverStaffing) : diff * this.SchedulingPeriod.MasterWeights.PrefUnderStaffing;
                            newPen += pen;
                        }
                        prov.CoverPerShiftGroupPenalty[i2][day] = newPen;
                        int n = day;
                        this.CoverPenOnDay[n] = this.CoverPenOnDay[n] + newPen;
                        covPenalty += newPen;
                        ++i2;
                    }
                    ++day;
                }
            }
            ++x;
        }
        return covPenalty;
    }

    public Employee GetEmployee(String employeeID) {
        Employee obj = this.EmployeeHash.get(employeeID);
        if (obj == null) {
            return null;
        }
        return obj;
    }

    public void CacheEmployeePenalties(int cacheIndex, boolean violationPenalties) {
        if (violationPenalties) {
            int x = 0;
            while (x < this.Employees.length) {
                Employee employee = this.Employees[x];
                employee.PenaltyCache[cacheIndex] = employee.Penalty;
                System.arraycopy(employee.ConstraintViolationPenalties, 0, employee.ConstraintViolationPenaltiesCache[cacheIndex], 0, employee.ConstraintViolationPenalties.length);
                ++x;
            }
        } else {
            int x = 0;
            while (x < this.Employees.length) {
                Employee employee = this.Employees[x];
                employee.PenaltyCache[cacheIndex] = employee.Penalty;
                ++x;
            }
        }
        this.EmployeesPenaltyCache[cacheIndex] = this.EmployeesPenalty;
    }

    public void CacheEmployeePenalties(int cacheIndex) {
        this.CacheEmployeePenalties(cacheIndex, true);
    }

    public void RestoreEmployeePenalties(int cacheIndex, boolean violationPenalties) {
        if (violationPenalties) {
            int x = 0;
            while (x < this.Employees.length) {
                Employee employee = this.Employees[x];
                employee.Penalty = employee.PenaltyCache[cacheIndex];
                System.arraycopy(employee.ConstraintViolationPenaltiesCache[cacheIndex], 0, employee.ConstraintViolationPenalties, 0, employee.ConstraintViolationPenalties.length);
                ++x;
            }
        } else {
            int x = 0;
            while (x < this.Employees.length) {
                Employee employee = this.Employees[x];
                employee.Penalty = employee.PenaltyCache[cacheIndex];
                ++x;
            }
        }
        this.EmployeesPenalty = this.EmployeesPenaltyCache[cacheIndex];
    }

    public void RestoreEmployeePenalties(int cacheIndex) {
        this.RestoreEmployeePenalties(cacheIndex, true);
    }

    public int UpdateCoverPens(Shift[] shifts) {
        SchedulingPeriod sp = this.SchedulingPeriod;
        int coverChange = 0;
        int x = 0;
        while (x < sp.CoverRequirements.Requirements.length) {
            CoverRequirement req = sp.CoverRequirements.Requirements[x];
            CoverProvided prov = this.CoverProvided[x];
            int z = 0;
            while (z < shifts.length) {
                Shift shift = shifts[z];
                if (shift != null) {
                    int pen;
                    int diff;
                    int newPen;
                    int i;
                    int day = shift.RosterDay;
                    if (req.CoverPerPeriodUsed && shift.ShiftType.CoversPeriods) {
                        i = 0;
                        while (i < shift.ShiftType.Periods.length) {
                            int pen2;
                            int diff2;
                            int p = shift.ShiftType.Periods[i];
                            int newPen2 = 0;
                            if (req.MinCoverPerPeriod[p][day] > 0 && prov.ProvidedCoverPerPeriod[p][day] < req.MinCoverPerPeriod[p][day]) {
                                diff2 = req.MinCoverPerPeriod[p][day] - prov.ProvidedCoverPerPeriod[p][day];
                                pen2 = diff2 * sp.MasterWeights.MinUnderStaffing;
                                newPen2 += pen2;
                            }
                            if (req.MaxCoverPerPeriod[p][day] >= 0 && prov.ProvidedCoverPerPeriod[p][day] > req.MaxCoverPerPeriod[p][day]) {
                                diff2 = prov.ProvidedCoverPerPeriod[p][day] - req.MaxCoverPerPeriod[p][day];
                                pen2 = diff2 * sp.MasterWeights.MaxOverStaffing;
                                newPen2 += pen2;
                            }
                            if (req.PrefCoverPerPeriod[p][day] >= 0 && req.PrefCoverPerPeriod[p][day] != prov.ProvidedCoverPerPeriod[p][day]) {
                                diff2 = req.PrefCoverPerPeriod[p][day] - prov.ProvidedCoverPerPeriod[p][day];
                                pen2 = 0;
                                pen2 = diff2 < 0 ? Math.abs(diff2 * sp.MasterWeights.PrefOverStaffing) : diff2 * sp.MasterWeights.PrefUnderStaffing;
                                newPen2 += pen2;
                            }
                            if (newPen2 != prov.CoverPerPeriodPenalty[p][day]) {
                                int n = day;
                                this.CoverPenOnDay[n] = this.CoverPenOnDay[n] - prov.CoverPerPeriodPenalty[p][day];
                                int n2 = day;
                                this.CoverPenOnDay[n2] = this.CoverPenOnDay[n2] + newPen2;
                                coverChange += newPen2 - prov.CoverPerPeriodPenalty[p][day];
                                prov.CoverPerPeriodPenalty[p][day] = newPen2;
                            }
                            ++i;
                        }
                        int nextDay = day + 1;
                        if (nextDay < this.SchedulingPeriod.NumDaysInPeriod) {
                            int i2 = 0;
                            while (i2 < shift.ShiftType.NextDayPeriods.length) {
                                int pen3;
                                int diff3;
                                int p = shift.ShiftType.NextDayPeriods[i2];
                                int newPen3 = 0;
                                if (req.MinCoverPerPeriod[p][nextDay] > 0 && prov.ProvidedCoverPerPeriod[p][nextDay] < req.MinCoverPerPeriod[p][nextDay]) {
                                    diff3 = req.MinCoverPerPeriod[p][nextDay] - prov.ProvidedCoverPerPeriod[p][nextDay];
                                    pen3 = diff3 * sp.MasterWeights.MinUnderStaffing;
                                    newPen3 += pen3;
                                }
                                if (req.MaxCoverPerPeriod[p][nextDay] >= 0 && prov.ProvidedCoverPerPeriod[p][nextDay] > req.MaxCoverPerPeriod[p][nextDay]) {
                                    diff3 = prov.ProvidedCoverPerPeriod[p][nextDay] - req.MaxCoverPerPeriod[p][nextDay];
                                    pen3 = diff3 * sp.MasterWeights.MaxOverStaffing;
                                    newPen3 += pen3;
                                }
                                if (req.PrefCoverPerPeriod[p][nextDay] >= 0 && req.PrefCoverPerPeriod[p][nextDay] != prov.ProvidedCoverPerPeriod[p][nextDay]) {
                                    diff3 = req.PrefCoverPerPeriod[p][nextDay] - prov.ProvidedCoverPerPeriod[p][nextDay];
                                    pen3 = 0;
                                    pen3 = diff3 < 0 ? Math.abs(diff3 * sp.MasterWeights.PrefOverStaffing) : diff3 * sp.MasterWeights.PrefUnderStaffing;
                                    newPen3 += pen3;
                                }
                                if (newPen3 != prov.CoverPerPeriodPenalty[p][nextDay]) {
                                    int n = nextDay;
                                    this.CoverPenOnDay[n] = this.CoverPenOnDay[n] - prov.CoverPerPeriodPenalty[p][nextDay];
                                    int n3 = nextDay;
                                    this.CoverPenOnDay[n3] = this.CoverPenOnDay[n3] + newPen3;
                                    coverChange += newPen3 - prov.CoverPerPeriodPenalty[p][nextDay];
                                    prov.CoverPerPeriodPenalty[p][nextDay] = newPen3;
                                }
                                ++i2;
                            }
                        }
                    }
                    if (req.CoverPerShiftUsed) {
                        i = shift.ShiftType.Index;
                        newPen = 0;
                        if (req.MinCoverPerShift[i][day] > 0 && req.MinCoverPerShift[i][day] > prov.ProvidedCoverPerShift[i][day]) {
                            diff = req.MinCoverPerShift[i][day] - prov.ProvidedCoverPerShift[i][day];
                            pen = diff * sp.MasterWeights.MinUnderStaffing;
                            newPen += pen;
                        }
                        if (req.MaxCoverPerShift[i][day] >= 0 && req.MaxCoverPerShift[i][day] < prov.ProvidedCoverPerShift[i][day]) {
                            diff = prov.ProvidedCoverPerShift[i][day] - req.MaxCoverPerShift[i][day];
                            pen = diff * sp.MasterWeights.MaxOverStaffing;
                            newPen += pen;
                        }
                        if (req.PrefCoverPerShift[i][day] >= 0 && req.PrefCoverPerShift[i][day] != prov.ProvidedCoverPerShift[i][day]) {
                            diff = req.PrefCoverPerShift[i][day] - prov.ProvidedCoverPerShift[i][day];
                            pen = 0;
                            pen = diff < 0 ? Math.abs(diff * sp.MasterWeights.PrefOverStaffing) : diff * sp.MasterWeights.PrefUnderStaffing;
                            newPen += pen;
                        }
                        if (newPen != prov.CoverPerShiftPenalty[i][day]) {
                            int n = day;
                            this.CoverPenOnDay[n] = this.CoverPenOnDay[n] - prov.CoverPerShiftPenalty[i][day];
                            int n4 = day;
                            this.CoverPenOnDay[n4] = this.CoverPenOnDay[n4] + newPen;
                            coverChange += newPen - prov.CoverPerShiftPenalty[i][day];
                            prov.CoverPerShiftPenalty[i][day] = newPen;
                        }
                    }
                    if (req.CoverPerShiftGroupUsed) {
                        i = 0;
                        while (i < sp.ShiftGroupsCount) {
                            if (sp.ShiftGroupContainsShiftType(i, shift.ShiftType.Index)) {
                                newPen = 0;
                                if (req.MinCoverPerShiftGroup[i][day] > 0 && req.MinCoverPerShiftGroup[i][day] > prov.ProvidedCoverPerShiftGroup[i][day]) {
                                    diff = req.MinCoverPerShiftGroup[i][day] - prov.ProvidedCoverPerShiftGroup[i][day];
                                    pen = diff * sp.MasterWeights.MinUnderStaffing;
                                    newPen += pen;
                                }
                                if (req.MaxCoverPerShiftGroup[i][day] >= 0 && req.MaxCoverPerShiftGroup[i][day] < prov.ProvidedCoverPerShiftGroup[i][day]) {
                                    diff = prov.ProvidedCoverPerShiftGroup[i][day] - req.MaxCoverPerShiftGroup[i][day];
                                    pen = diff * sp.MasterWeights.MaxOverStaffing;
                                    newPen += pen;
                                }
                                if (req.PrefCoverPerShiftGroup[i][day] >= 0 && req.PrefCoverPerShiftGroup[i][day] != prov.ProvidedCoverPerShiftGroup[i][day]) {
                                    diff = req.PrefCoverPerShiftGroup[i][day] - prov.ProvidedCoverPerShiftGroup[i][day];
                                    pen = 0;
                                    pen = diff < 0 ? Math.abs(diff * sp.MasterWeights.PrefOverStaffing) : diff * sp.MasterWeights.PrefUnderStaffing;
                                    newPen += pen;
                                }
                                if (newPen != prov.CoverPerShiftGroupPenalty[i][day]) {
                                    int n = day;
                                    this.CoverPenOnDay[n] = this.CoverPenOnDay[n] - prov.CoverPerShiftGroupPenalty[i][day];
                                    int n5 = day;
                                    this.CoverPenOnDay[n5] = this.CoverPenOnDay[n5] + newPen;
                                    coverChange += newPen - prov.CoverPerShiftGroupPenalty[i][day];
                                    prov.CoverPerShiftGroupPenalty[i][day] = newPen;
                                }
                            }
                            ++i;
                        }
                    }
                }
                ++z;
            }
            ++x;
        }
        return coverChange;
    }

    public void Empty() {
        int i = 0;
        while (i < this.Employees.length) {
            int day = 0;
            while (day < this.SchedulingPeriod.NumDaysInPeriod) {
                int j = 0;
                while (j < this.SchedulingPeriod.ShiftTypesCount) {
                    if (this.Employees[i].ShiftsOnDay[day][j] != null) {
                        this.UnAssignShift(this.Employees[i].ShiftsOnDay[day][j]);
                    }
                    ++j;
                }
                ++day;
            }
            ++i;
        }
        this.RecalculateAllPenalties();
    }

    public void MakeInitialAssignments() {
        if (!this.SchedulingPeriod.ContainsInitialAssignments) {
            return;
        }
        Employee[] employeeArray = this.Employees;
        int n = this.Employees.length;
        int n2 = 0;
        while (n2 < n) {
            Employee employee = employeeArray[n2];
            int day = 0;
            while (day < this.SchedulingPeriod.NumDaysInPeriod) {
                int i = 0;
                while (i < this.SchedulingPeriod.ShiftTypesCount) {
                    ShiftType st;
                    Shift shift;
                    int violationCount;
                    int index = day * this.SchedulingPeriod.ShiftTypesCount + i;
                    if (employee.EmployeeDescription.PreAssignments[index] && (violationCount = employee.ViolationsForAssigningShift(shift = new Shift(st = this.SchedulingPeriod.GetShiftType(i), this.SchedulingPeriod.ConvertRosterDayToDate(day), this.SchedulingPeriod))) != -1) {
                        this.AssignShift(employee, shift);
                    }
                    ++i;
                }
                ++day;
            }
            ++n2;
        }
        this.RecalculateAllPenalties();
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        RosterPrinter.PrintRosterAsHTML(this, sw, true, "", "", "", DateTime.getNow().ToShortDateString(), "", "");
        return sw.toString();
    }
}

