/*
 * Decompiled with CFR 0.152.
 */
package ASAP.NRP.Solvers.Crossover;

import ASAP.NRP.Core.Employee;
import ASAP.NRP.Core.Roster;
import ASAP.NRP.Core.Shift;
import ASAP.NRP.Solvers.Crossover.Assignment;
import ASAP.NRP.Solvers.Crossover.Vote;
import ASAP.NRP.Solvers.Crossover.Voter;
import java.util.ArrayList;
import java.util.Collections;

public class Crossover {
    public static void MEH_Crossover(Roster schedule1, Roster schedule2, Roster offspring1, Roster offspring2, int MAX_BEST_ASSIGNMENTS) {
        Shift shift2;
        Employee offspring2Employee;
        Shift shift1;
        Employee offspring1Employee;
        Assignment a;
        Assignment[] s1Shifts = Crossover.MEH_GetBestShifts(schedule1, MAX_BEST_ASSIGNMENTS);
        Assignment[] s2Shifts = Crossover.MEH_GetBestShifts(schedule2, MAX_BEST_ASSIGNMENTS);
        int i = 0;
        while (i < s1Shifts.length) {
            a = s1Shifts[i];
            offspring1Employee = offspring1.GetEmployee(a.Shift.Employee.EmployeeDescription.ID);
            if (offspring1Employee.ViolationsForAssigningShift(shift1 = (Shift)a.Shift.Clone()) != -1) {
                offspring1.AssignShift(offspring1Employee, shift1);
            }
            if ((offspring2Employee = offspring2.GetEmployee(a.Shift.Employee.EmployeeDescription.ID)).ViolationsForAssigningShift(shift2 = (Shift)a.Shift.Clone()) != -1) {
                offspring2.AssignShift(offspring2Employee, shift2);
            }
            ++i;
        }
        i = 0;
        while (i < s2Shifts.length) {
            a = s2Shifts[i];
            offspring1Employee = offspring1.GetEmployee(a.Shift.Employee.EmployeeDescription.ID);
            if (offspring1Employee.ViolationsForAssigningShift(shift1 = (Shift)a.Shift.Clone()) != -1) {
                offspring1.AssignShift(offspring1Employee, shift1);
            }
            if ((offspring2Employee = offspring2.GetEmployee(a.Shift.Employee.EmployeeDescription.ID)).ViolationsForAssigningShift(shift2 = (Shift)a.Shift.Clone()) != -1) {
                offspring2.AssignShift(offspring2Employee, shift2);
            }
            ++i;
        }
        offspring1.RecalculateAllPenalties();
        offspring2.RecalculateAllPenalties();
    }

    private static Assignment[] MEH_GetBestShifts(Roster schedule, int MAX_BEST_ASSIGNMENTS) {
        ArrayList<Assignment> aList = new ArrayList<Assignment>();
        int origPen = schedule.getTotalPenalty();
        int i = 0;
        while (i < schedule.Employees.length) {
            int day = 0;
            while (day < schedule.SchedulingPeriod.NumDaysInPeriod) {
                int j = 0;
                while (j < schedule.SchedulingPeriod.ShiftTypesCount) {
                    Shift shift = schedule.Employees[i].ShiftsOnDay[day][j];
                    if (shift != null) {
                        Employee employee1 = shift.Employee;
                        Shift[] shifts1 = new Shift[]{shift};
                        schedule.CacheEmployeePenalties(0, false);
                        schedule.UnAssignShift(shift);
                        schedule.CoverPenalty += schedule.UpdateCoverPens(shifts1);
                        employee1.RecalculatePenalty();
                        int diff = schedule.getTotalPenalty() - origPen;
                        schedule.AssignShift(employee1, shift);
                        schedule.RestoreEmployeePenalties(0, false);
                        schedule.CoverPenalty += schedule.UpdateCoverPens(shifts1);
                        aList.add(new Assignment(shift, diff));
                        Collections.sort(aList);
                        while (aList.size() > MAX_BEST_ASSIGNMENTS) {
                            aList.remove(aList.size() - 1);
                        }
                    }
                    ++j;
                }
                ++day;
            }
            ++i;
        }
        Assignment[] a = new Assignment[aList.size()];
        return aList.toArray(a);
    }

    public static void SS_Crossover(Roster schedule1, Roster schedule2, Roster newSchedule, Roster newSchedule2) {
        boolean matchFound;
        newSchedule.Empty();
        ArrayList<Vote> votes = new ArrayList<Vote>();
        Roster[] referenceSet = new Roster[]{schedule1, schedule2};
        int z = 0;
        while (z < referenceSet.length) {
            Roster schedule = referenceSet[z];
            Voter voter = new Voter(schedule);
            int i = 0;
            while (i < schedule.Employees.length) {
                int day = 0;
                while (day < schedule.SchedulingPeriod.NumDaysInPeriod) {
                    int j = 0;
                    while (j < schedule.SchedulingPeriod.ShiftTypesCount) {
                        Shift shift = schedule.Employees[i].ShiftsOnDay[day][j];
                        if (shift != null) {
                            boolean found = false;
                            int x = 0;
                            while (x < votes.size()) {
                                Vote vote = (Vote)votes.get(x);
                                if (vote.ScheduleDay == shift.RosterDay && vote.ShiftTypeID == shift.ShiftType.ID && vote.EmployeeID == shift.Employee.EmployeeDescription.ID) {
                                    vote.Voters.add(voter);
                                    found = true;
                                    break;
                                }
                                ++x;
                            }
                            if (!found) {
                                Vote vote = new Vote(shift.RosterDay, shift.ShiftType.ID, shift.Employee.EmployeeDescription.ID, shift);
                                vote.Voters.add(voter);
                                votes.add(vote);
                            }
                        }
                        ++j;
                    }
                    ++day;
                }
                ++i;
            }
            ++z;
        }
        do {
            matchFound = false;
            Collections.sort(votes, Collections.reverseOrder());
            int index = 0;
            int i = 0;
            while (i < votes.size()) {
                Vote vote = (Vote)votes.get(i);
                Shift shift = (Shift)vote.Shift.Clone();
                Employee employee = newSchedule.GetEmployee(vote.EmployeeID);
                if (employee.ViolationsForAssigningShift(shift) != -1) {
                    newSchedule.AssignShift(employee, shift);
                    int j = 0;
                    while (j < vote.Voters.size()) {
                        Voter voter = vote.Voters.get(j);
                        ++voter.VotesSuccessful;
                        ++j;
                    }
                    matchFound = true;
                    break;
                }
                ++index;
                ++i;
            }
            if (!matchFound) continue;
            int x = 0;
            while (x <= index) {
                votes.remove(0);
                ++x;
            }
        } while (votes.size() != 0 && matchFound);
        newSchedule.RecalculateAllPenalties();
        Crossover.SetRoster(newSchedule2, newSchedule);
    }

    public static void Crossover_A(Roster parent1, Roster parent2, Roster child1, Roster child2) {
        child1.Empty();
        int i = 0;
        while (i < parent1.Employees.length) {
            Employee p1employee = parent1.Employees[i];
            Employee p2employee = parent2.GetEmployee(p1employee.EmployeeDescription.ID);
            int day = 0;
            while (day < parent1.SchedulingPeriod.NumDaysInPeriod) {
                int j = 0;
                while (j < parent1.SchedulingPeriod.ShiftTypesCount) {
                    Shift shift = p1employee.ShiftsOnDay[day][j];
                    if (shift != null && p2employee.ShiftsOnDay[day][j] != null) {
                        Shift s = (Shift)shift.Clone();
                        Employee c1employee = child1.GetEmployee(p1employee.EmployeeDescription.ID);
                        if (c1employee.ViolationsForAssigningShift(s) != -1) {
                            child1.AssignShift(c1employee, s);
                        }
                    }
                    ++j;
                }
                ++day;
            }
            ++i;
        }
        child1.RecalculateAllPenalties();
        Crossover.SetRoster(child2, child1);
    }

    public static void SetRoster(Roster roster1, Roster roster2) {
        roster1.Empty();
        int i = 0;
        while (i < roster2.Employees.length) {
            Employee employee2 = roster2.Employees[i];
            Employee employee1 = roster1.GetEmployee(employee2.EmployeeDescription.ID);
            int day = 0;
            while (day < roster2.SchedulingPeriod.NumDaysInPeriod) {
                int j = 0;
                while (j < roster2.SchedulingPeriod.ShiftTypesCount) {
                    Shift shift1;
                    Shift shift2 = employee2.ShiftsOnDay[day][j];
                    if (shift2 != null && (shift1 = (Shift)shift2.Clone()) != null) {
                        roster1.AssignShift(employee1, shift1);
                    }
                    ++j;
                }
                ++day;
            }
            ++i;
        }
        roster1.RecalculateAllPenalties();
        roster1.getTotalPenalty();
        roster2.getTotalPenalty();
    }
}

