/*
 * Decompiled with CFR 0.152.
 */
package ASAP.NRP.Solvers.VariableDepthSearch;

import ASAP.NRP.Core.Constraints.ANROM.CompleteWeekends;
import ASAP.NRP.Core.Constraints.ANROM.IdenticalShiftTypesDuringWeekend;
import ASAP.NRP.Core.Constraints.ANROM.MaxConsecutiveWorkingWeekends;
import ASAP.NRP.Core.Constraints.ANROM.MaxNumAssignments;
import ASAP.NRP.Core.Constraints.ANROM.MaxShiftTypes;
import ASAP.NRP.Core.Constraints.ANROM.MinTimeBetweenShifts;
import ASAP.NRP.Core.Constraints.ANROM.NoNightShiftBeforeFreeWeekend;
import ASAP.NRP.Core.Constraints.ANROM.NumConsecutiveShiftTypes;
import ASAP.NRP.Core.Constraints.ANROM.RequestedDaysOff;
import ASAP.NRP.Core.Constraints.ANROM.RequestedDaysOn;
import ASAP.NRP.Core.Constraints.ANROM.RequestedShiftsOff;
import ASAP.NRP.Core.Constraints.ANROM.RequestedShiftsOn;
import ASAP.NRP.Core.Constraints.ANROM.ShiftTypeSuccessions;
import ASAP.NRP.Core.Constraints.GPost.MaxShiftsPerDay;
import ASAP.NRP.Core.Constraints.Ikegami.MaxWeekendsOff;
import ASAP.NRP.Core.Constraints.Montreal.MaxConsecutiveFreeWeekends;
import ASAP.NRP.Core.Constraints.Montreal.MinConsecutiveFreeWeekends;
import ASAP.NRP.Core.Constraints.Montreal.MinConsecutiveWorkingWeekends;
import ASAP.NRP.Core.Constraints.QMC.RequestedShiftGroupsOn;
import ASAP.NRP.Core.Constraints.SoftConstraint;
import ASAP.NRP.Core.Constraints.TEC.MaxShiftGroups;
import ASAP.NRP.Core.Employee;
import ASAP.NRP.Core.EmployeeDescription;
import ASAP.NRP.Core.Roster;
import ASAP.NRP.Core.SchedulingPeriod;
import ASAP.NRP.Core.Shift;
import ASAP.NRP.Core.ShiftGroup;
import ASAP.NRP.Core.ShiftType;
import ASAP.NRP.Solvers.VariableDepthSearch.Hrz1Emp1Swp_M;
import ASAP.NRP.Solvers.VariableDepthSearch.New1Emp1Swp_M;
import ASAP.NRP.Solvers.VariableDepthSearch.TestShiftDB;
import java.util.ArrayList;
import java.util.Random;

public class PatternTester {
    New1Emp1Swp_M n1;
    Hrz1Emp1Swp_M h1;
    boolean cacheViolationPens = true;
    int TEST_PATTERNS_MAX_ATTEMPTS = 5;
    boolean SATISFY_WEEKENDS = true;
    SoftConstraint[][] EmployeesWeekendConstraints;
    int[][] EmployeeOKshifts;
    final boolean SHOW_ERROR_MSGS = false;
    Random rand;
    TestShiftDB testShiftDB;

    public void ImprovePattern(Roster roster, TestShiftDB testShiftDB, int employeeIndex, Random rand) {
        this.testShiftDB = testShiftDB;
        if (roster.Employees.length == 0 || roster.SchedulingPeriod.ShiftTypesCount == 0) {
            return;
        }
        roster.RecalculateAllPenalties();
        if (roster.getTotalPenalty() == 0) {
            return;
        }
        this.rand = rand;
        this.n1 = new New1Emp1Swp_M(testShiftDB);
        this.n1.TIME_LIMIT = false;
        this.n1.SKIP_ZERO_PENS = false;
        this.n1.MAX_BLOCK_SIZE = 5;
        this.n1.VIOLATION_HEURISTIC_THRESHOLD = 0;
        this.n1.VERBOSE = false;
        this.h1 = new Hrz1Emp1Swp_M(testShiftDB);
        this.h1.MAX_BLOCK_SIZE = 5;
        this.h1.TIME_LIMIT = false;
        this.h1.VIOLATION_HEURISTIC_THRESHOLD = 0;
        this.h1.SKIP_ZERO_PEN = false;
        this.h1.VERBOSE = false;
        this.n1.setRNG(rand);
        this.h1.setRNG(rand);
        this.EmployeesWeekendConstraints = new SoftConstraint[roster.SchedulingPeriod.EmployeesCount][];
        int i = 0;
        while (i < roster.SchedulingPeriod.EmployeesCount) {
            EmployeeDescription emp = roster.SchedulingPeriod.GetEmployeeDescription(i);
            this.CreateWeekendSoftConstraints(emp);
            ++i;
        }
        SchedulingPeriod schedulingPeriod = roster.SchedulingPeriod;
        int shiftTypesCount = schedulingPeriod.ShiftTypesCount;
        this.EmployeeOKshifts = new int[roster.SchedulingPeriod.EmployeesCount][];
        int e = 0;
        while (e < roster.Employees.length) {
            Employee employee = roster.Employees[e];
            ArrayList<Integer> okShifts = new ArrayList<Integer>();
            int i2 = 0;
            while (i2 < shiftTypesCount) {
                int max;
                if (employee.EmployeeDescription.Contract == null || (max = employee.EmployeeDescription.Contract.MaxShiftTypes[i2]) != 0) {
                    ShiftType st = schedulingPeriod.GetShiftType(i2);
                    if (st.AutoAllocate && (!st.RequiresSkills || schedulingPeriod.EmployeeHasSkillsForShiftType(employee.EmployeeDescription, i2))) {
                        int[] groups = roster.SchedulingPeriod.GetShiftGroupsContainingShift(i2);
                        boolean permit = true;
                        if (employee.EmployeeDescription.Contract != null) {
                            int j = 0;
                            while (j < groups.length) {
                                int max2 = employee.EmployeeDescription.Contract.MaxShiftGroups[groups[j]];
                                if (max2 == 0) {
                                    permit = false;
                                    break;
                                }
                                ++j;
                            }
                        }
                        if (permit) {
                            okShifts.add(new Integer(i2));
                        }
                    }
                }
                ++i2;
            }
            this.EmployeeOKshifts[employee.EmployeeDescription.IndexID] = new int[okShifts.size()];
            i2 = 0;
            while (i2 < okShifts.size()) {
                this.EmployeeOKshifts[employee.EmployeeDescription.IndexID][i2] = (Integer)okShifts.get(i2);
                ++i2;
            }
            ++e;
        }
        Employee employee = roster.Employees[employeeIndex];
        boolean[] bestPattern = this.TestPatternsHeuristically(employee, roster.getTotalPenalty(), false, roster.getTotalPenalty(), 0);
        if (bestPattern != null) {
            int j;
            int d = 0;
            while (d < roster.SchedulingPeriod.NumDaysInPeriod) {
                j = 0;
                while (j < roster.SchedulingPeriod.ShiftTypesCount) {
                    Shift shift = employee.ShiftsOnDay[d][j];
                    if (shift != null) {
                        roster.UnAssignShift(shift);
                    }
                    ++j;
                }
                ++d;
            }
            d = 0;
            while (d < roster.SchedulingPeriod.NumDaysInPeriod) {
                j = 0;
                while (j < roster.SchedulingPeriod.ShiftTypesCount) {
                    int index = d * roster.SchedulingPeriod.ShiftTypesCount + j;
                    if (bestPattern[index]) {
                        Shift shift = (Shift)testShiftDB.GetTestShift(j, d).Clone();
                        if (shift == null) {
                            // empty if block
                        }
                        roster.AssignShift(employee, shift);
                    }
                    ++j;
                }
                ++d;
            }
            employee.RecalculatePenalty();
            roster.CoverPenalty = roster.RecalculateCoverPenalty();
        }
    }

    private boolean[] TestPatternsHeuristically(Employee employee, int bestPenalty, boolean moveFound, int originalPenalty, int penaltyCachePos) {
        Roster roster = employee.Roster;
        int currentTotalPenalty = roster.getTotalPenalty();
        int currentEmployeesPenalty = roster.EmployeesPenalty;
        boolean[] bestPattern = null;
        boolean[] requestsPattern = null;
        Shift[] initialShifts = new Shift[employee.ShiftsCount];
        int pos = 0;
        int day = 0;
        while (day < roster.SchedulingPeriod.NumDaysInPeriod) {
            int index = 0;
            while (index < roster.SchedulingPeriod.ShiftTypesCount) {
                Shift shift = employee.ShiftsOnDay[day][index];
                if (shift != null) {
                    if (shift.ShiftType.AutoAllocate && !employee.EmployeeDescription.FrozenDay[day]) {
                        roster.UnAssignShift(shift);
                    }
                    initialShifts[pos++] = shift;
                }
                ++index;
            }
            ++day;
        }
        roster.CoverPenalty = roster.RecalculateCoverPenalty();
        this.SatisfyRequests(employee);
        if (this.SATISFY_WEEKENDS) {
            this.SatisfyWeekends(employee, true, penaltyCachePos + 1);
        }
        employee.RecalculatePenalty();
        roster.CacheEmployeePenalties(penaltyCachePos + 1, this.cacheViolationPens);
        int i = 1;
        while (i <= this.TEST_PATTERNS_MAX_ATTEMPTS) {
            if (requestsPattern == null) {
                requestsPattern = new boolean[employee.ShiftAssignments.length];
                System.arraycopy(employee.ShiftAssignments, 0, requestsPattern, 0, employee.ShiftAssignments.length);
            } else {
                int day2 = 0;
                while (day2 < roster.SchedulingPeriod.NumDaysInPeriod) {
                    int x = 0;
                    while (x < roster.SchedulingPeriod.ShiftTypesCount) {
                        int index = day2 * roster.SchedulingPeriod.ShiftTypesCount + x;
                        if (requestsPattern[index]) {
                            Shift shift = (Shift)this.testShiftDB.GetTestShift(x, day2).Clone();
                            roster.AssignShift(employee, shift);
                        }
                        ++x;
                    }
                    ++day2;
                }
                roster.RestoreEmployeePenalties(penaltyCachePos + 1, this.cacheViolationPens);
                roster.CoverPenalty = roster.RecalculateCoverPenalty();
            }
            this.ConstructPattern(employee, i, true, penaltyCachePos + 2);
            boolean valid = false;
            int e1Change = roster.EmployeesPenalty - currentEmployeesPenalty;
            if (roster.getTotalPenalty() < originalPenalty || currentTotalPenalty + e1Change < originalPenalty) {
                valid = true;
            }
            if (valid && (!moveFound || roster.getTotalPenalty() < bestPenalty)) {
                moveFound = true;
                bestPenalty = roster.getTotalPenalty();
                bestPattern = new boolean[employee.ShiftAssignments.length];
                System.arraycopy(employee.ShiftAssignments, 0, bestPattern, 0, employee.ShiftAssignments.length);
            }
            employee.UnAssignAllShifts();
            roster.CoverPenalty = roster.RecalculateCoverPenalty();
            ++i;
        }
        i = 0;
        while (i < initialShifts.length) {
            roster.AssignShift(employee, initialShifts[i]);
            ++i;
        }
        roster.CoverPenalty = roster.RecalculateCoverPenalty();
        employee.RecalculatePenalty();
        return bestPattern;
    }

    private void ConstructPattern(Employee employee, int maxLength, boolean calculateCoverPenalty, int cachePosition) {
        boolean cacheViolationPens = true;
        Roster roster = employee.Roster;
        int failedAttempts = 0;
        int[] shiftTypes = this.EmployeeOKshifts[employee.EmployeeDescription.IndexID];
        if (shiftTypes.length == 0) {
            return;
        }
        boolean moveFound = true;
        while (moveFound) {
            moveFound = false;
            int bestPenalty = employee.Roster.getTotalPenalty();
            Shift[] bestShifts = null;
            int i = 0;
            while (i < shiftTypes.length) {
                int shiftIndex = shiftTypes[i];
                int blockSize = 1;
                while (blockSize <= maxLength) {
                    int day = 0;
                    while (day < roster.SchedulingPeriod.NumDaysInPeriod - blockSize + 1) {
                        Shift[] shifts = new Shift[blockSize];
                        int x = 0;
                        while (x < blockSize) {
                            shifts[x] = this.testShiftDB.GetTestShift(shiftIndex, day + x);
                            ++x;
                        }
                        boolean valid = true;
                        int x2 = 0;
                        while (x2 < shifts.length) {
                            if (employee.ViolationsForAssigningShift(shifts[x2]) == -1 || employee.EmployeeDescription.FrozenDay[day + x2]) {
                                valid = false;
                                break;
                            }
                            ++x2;
                        }
                        if (valid) {
                            roster.CacheEmployeePenalties(cachePosition, cacheViolationPens);
                            x2 = 0;
                            while (x2 < shifts.length) {
                                roster.AssignShift(employee, shifts[x2]);
                                ++x2;
                            }
                            if (calculateCoverPenalty) {
                                employee.Roster.CoverPenalty += employee.Roster.UpdateCoverPens(shifts);
                            }
                            employee.RecalculatePenalty(bestPenalty + 1, day, day + blockSize - 1, false);
                            if (roster.getTotalPenalty() < bestPenalty || roster.getTotalPenalty() == bestPenalty && this.rand.nextDouble() > 0.5) {
                                bestShifts = shifts;
                                bestPenalty = roster.getTotalPenalty();
                            }
                            x2 = 0;
                            while (x2 < shifts.length) {
                                roster.UnAssignShift(shifts[x2]);
                                ++x2;
                            }
                            roster.RestoreEmployeePenalties(cachePosition, cacheViolationPens);
                            if (calculateCoverPenalty) {
                                roster.CoverPenalty += roster.UpdateCoverPens(shifts);
                            }
                        }
                        ++day;
                    }
                    ++blockSize;
                }
                ++i;
            }
            if (bestShifts != null) {
                Shift[] shifts = new Shift[bestShifts.length];
                int x = 0;
                while (x < bestShifts.length) {
                    shifts[x] = (Shift)bestShifts[x].Clone();
                    Shift cfr_ignored_0 = shifts[x];
                    roster.AssignShift(employee, shifts[x]);
                    ++x;
                }
                if (calculateCoverPenalty) {
                    employee.Roster.CoverPenalty += employee.Roster.UpdateCoverPens(shifts);
                }
                employee.RecalculatePenalty();
                moveFound = true;
                continue;
            }
            ++failedAttempts;
        }
        this.n1.TotalEvaluations = 0L;
        this.n1.cachePosition = cachePosition;
        this.n1.CALCULATE_COVER_PENALTY = calculateCoverPenalty;
        this.n1.SearchSingleEmployee(employee);
        this.h1.TotalEvaluations = 0L;
        this.h1.cachePosition = cachePosition;
        this.h1.CALCULATE_COVER_PENALTY = calculateCoverPenalty;
        this.h1.SearchSingleEmployee(employee);
    }

    private void SatisfyRequests(Employee employee) {
        int day;
        int stc;
        Roster roster;
        if (employee.EmployeeDescription.ShiftOnRequestCount != 0) {
            roster = employee.Roster;
            stc = roster.SchedulingPeriod.ShiftTypesCount;
            day = 0;
            while (day < employee.Roster.SchedulingPeriod.NumDaysInPeriod) {
                if (!employee.EmployeeDescription.FrozenDay[day]) {
                    int i = 0;
                    while (i < stc) {
                        if (employee.EmployeeDescription.ShiftOnRequests[day * stc + i] != 0) {
                            Shift shift;
                            ShiftType st = roster.SchedulingPeriod.GetShiftType(i);
                            if (st.AutoAllocate && employee.ViolationsForAssigningShift(shift = (Shift)this.testShiftDB.GetTestShift(st.Index, day).Clone()) != -1) {
                                roster.AssignShift(employee, shift);
                                roster.CoverPenalty += roster.UpdateCoverPens(new Shift[]{shift});
                            }
                        }
                        ++i;
                    }
                }
                ++day;
            }
        }
        if (employee.EmployeeDescription.ShiftGroupOnRequests != null) {
            roster = employee.Roster;
            int i = 0;
            while (i < employee.EmployeeDescription.ShiftGroupOnRequests.length) {
                day = employee.EmployeeDescription.ShiftGroupOnRequests[i].Day;
                if (!employee.EmployeeDescription.FrozenDay[day]) {
                    ShiftGroup group = employee.EmployeeDescription.ShiftGroupOnRequests[i].ShiftGroup;
                    Shift bestShift = null;
                    int bestCoverPenalty = 0;
                    int j = 0;
                    while (j < group.Group.length) {
                        Shift shift = this.testShiftDB.GetTestShift(group.Group[j].Index, day);
                        if (shift.ShiftType.AutoAllocate && employee.ViolationsForAssigningShift(shift) != -1) {
                            roster.AssignShift(employee, shift);
                            roster.CoverPenalty += roster.UpdateCoverPens(new Shift[]{shift});
                            if (bestShift == null || roster.CoverPenalty < bestCoverPenalty) {
                                bestShift = shift;
                                bestCoverPenalty = roster.CoverPenalty;
                            }
                            roster.UnAssignShift(shift);
                            roster.CoverPenalty += roster.UpdateCoverPens(new Shift[]{shift});
                        }
                        ++j;
                    }
                    if (bestShift != null) {
                        Shift shift = (Shift)bestShift.Clone();
                        roster.AssignShift(employee, shift);
                        roster.CoverPenalty += roster.UpdateCoverPens(new Shift[]{shift});
                    }
                }
                ++i;
            }
        }
        if (employee.EmployeeDescription.DayOnRequestCount != 0) {
            roster = employee.Roster;
            stc = roster.SchedulingPeriod.ShiftTypesCount;
            day = 0;
            while (day < employee.Roster.SchedulingPeriod.NumDaysInPeriod) {
                if (!employee.EmployeeDescription.FrozenDay[day] && employee.EmployeeDescription.DayOnRequests[day] != 0 && employee.DayType[day] != 1) {
                    Shift bestShift = null;
                    int bestCoverPenalty = 0;
                    int i = 0;
                    while (i < stc) {
                        Shift shift = this.testShiftDB.GetTestShift(i, day);
                        if (shift.ShiftType.AutoAllocate && employee.ViolationsForAssigningShift(shift) != -1) {
                            roster.AssignShift(employee, shift);
                            roster.CoverPenalty += roster.UpdateCoverPens(new Shift[]{shift});
                            if (bestShift == null || roster.CoverPenalty < bestCoverPenalty) {
                                bestShift = shift;
                                bestCoverPenalty = roster.CoverPenalty;
                            }
                            roster.UnAssignShift(shift);
                            roster.CoverPenalty += roster.UpdateCoverPens(new Shift[]{shift});
                        }
                        ++i;
                    }
                    if (bestShift != null) {
                        Shift shift = (Shift)bestShift.Clone();
                        roster.AssignShift(employee, shift);
                        roster.CoverPenalty += roster.UpdateCoverPens(new Shift[]{shift});
                    }
                }
                ++day;
            }
        }
    }

    private void SatisfyWeekends(Employee employee, boolean calculateCoverPenalty, int cachePosition) {
        this.CalculateWeekendsPenalty(employee, -1);
        Roster roster = employee.Roster;
        int day = 0;
        while (day < roster.SchedulingPeriod.NumDaysInPeriod) {
            if (!employee.EmployeeDescription.FrozenDay[day]) {
                Shift bestShift1 = null;
                Shift bestShift2 = null;
                int bestPenalty = roster.EmployeesPenalty;
                int i = 0;
                while (i < roster.SchedulingPeriod.ShiftTypesCount) {
                    Shift shift1 = this.testShiftDB.GetTestShift(i, day);
                    if (shift1.ShiftType.AutoAllocate && employee.ViolationsForAssigningShift(shift1) != -1) {
                        Shift shift2;
                        roster.CacheEmployeePenalties(cachePosition, this.cacheViolationPens);
                        roster.AssignShift(employee, shift1);
                        if (calculateCoverPenalty) {
                            roster.CoverPenalty += roster.UpdateCoverPens(new Shift[]{shift1});
                        }
                        this.CalculateWeekendsPenalty(employee, -1);
                        if (roster.EmployeesPenalty < bestPenalty) {
                            bestShift1 = shift1;
                            bestPenalty = roster.EmployeesPenalty;
                        }
                        if (day + 1 < roster.SchedulingPeriod.NumDaysInPeriod && !employee.EmployeeDescription.FrozenDay[day + 1] && employee.ViolationsForAssigningShift(shift2 = this.testShiftDB.GetTestShift(i, day + 1)) != -1 && shift2.ShiftType.AutoAllocate) {
                            roster.AssignShift(employee, shift2);
                            if (calculateCoverPenalty) {
                                roster.CoverPenalty += roster.UpdateCoverPens(new Shift[]{shift2});
                            }
                            this.CalculateWeekendsPenalty(employee, bestPenalty);
                            if (roster.EmployeesPenalty < bestPenalty) {
                                bestShift1 = shift1;
                                bestShift2 = shift2;
                                bestPenalty = roster.EmployeesPenalty;
                            }
                            roster.UnAssignShift(shift2);
                            if (calculateCoverPenalty) {
                                roster.CoverPenalty += roster.UpdateCoverPens(new Shift[]{shift2});
                            }
                        }
                        roster.UnAssignShift(shift1);
                        if (calculateCoverPenalty) {
                            roster.CoverPenalty += roster.UpdateCoverPens(new Shift[]{shift1});
                        }
                        roster.RestoreEmployeePenalties(cachePosition, this.cacheViolationPens);
                    }
                    ++i;
                }
                if (bestShift1 != null) {
                    Shift shift1 = (Shift)bestShift1.Clone();
                    roster.AssignShift(employee, shift1);
                    if (calculateCoverPenalty) {
                        roster.CoverPenalty += roster.UpdateCoverPens(new Shift[]{shift1});
                    }
                    if (bestShift2 != null) {
                        Shift shift2 = (Shift)bestShift2.Clone();
                        roster.AssignShift(employee, shift2);
                        if (calculateCoverPenalty) {
                            roster.CoverPenalty += roster.UpdateCoverPens(new Shift[]{shift2});
                        }
                    }
                    this.CalculateWeekendsPenalty(employee, -1);
                }
            }
            ++day;
        }
        day = 0;
        while (day < roster.SchedulingPeriod.NumDaysInPeriod) {
            if (!employee.EmployeeDescription.FrozenDay[day] && employee.DayType[day] == 1) {
                Shift shift = employee.GetShift(day);
                if (shift.ShiftType.AutoAllocate) {
                    int origPen = roster.EmployeesPenalty;
                    roster.CacheEmployeePenalties(cachePosition, this.cacheViolationPens);
                    roster.UnAssignShift(shift);
                    if (calculateCoverPenalty) {
                        roster.CoverPenalty += roster.UpdateCoverPens(new Shift[]{shift});
                    }
                    this.CalculateWeekendsPenalty(employee, origPen + 1);
                    if (roster.EmployeesPenalty > origPen) {
                        roster.AssignShift(employee, shift);
                        if (calculateCoverPenalty) {
                            roster.CoverPenalty += roster.UpdateCoverPens(new Shift[]{shift});
                        }
                        roster.RestoreEmployeePenalties(cachePosition, this.cacheViolationPens);
                    }
                }
            }
            ++day;
        }
    }

    public int CalculateWeekendsPenalty(Employee employee, int bestPenalty) {
        int originalPenalty = employee.Penalty;
        int newPenalty = 0;
        if (bestPenalty >= 0) {
            int diff = bestPenalty - (employee.Roster.EmployeesPenalty - originalPenalty);
            int i = 0;
            while (i < this.EmployeesWeekendConstraints[employee.EmployeeDescription.IndexID].length) {
                if ((newPenalty += this.EmployeesWeekendConstraints[employee.EmployeeDescription.IndexID][i].Calculate(employee)) < diff) {
                    ++i;
                    continue;
                }
                break;
            }
        } else {
            int i = 0;
            while (i < this.EmployeesWeekendConstraints[employee.EmployeeDescription.IndexID].length) {
                newPenalty += this.EmployeesWeekendConstraints[employee.EmployeeDescription.IndexID][i].Calculate(employee);
                ++i;
            }
        }
        employee.Roster.EmployeesPenalty = employee.Roster.EmployeesPenalty - originalPenalty + newPenalty;
        employee.Penalty = newPenalty;
        return employee.Roster.EmployeesPenalty;
    }

    private void CreateWeekendSoftConstraints(EmployeeDescription employee) {
        int weight;
        if (employee.Contract == null) {
            this.EmployeesWeekendConstraints[employee.IndexID] = new SoftConstraint[0];
            return;
        }
        SchedulingPeriod schedulingPeriod = employee.SchedulingPeriod;
        ArrayList<SoftConstraint> array = new ArrayList<SoftConstraint>();
        if (employee.Contract.MaxShiftTypesIsOn) {
            weight = schedulingPeriod.MasterWeights.MaxShiftTypes;
            if (employee.Contract.MaxShiftTypesWeight > -1) {
                weight = employee.Contract.MaxShiftTypesWeight;
            }
            if (employee.Contract.MaxShiftTypesUsed) {
                array.add(new MaxShiftTypes(weight));
            }
            if (employee.Contract.MaxShiftGroupsUsed) {
                array.add(new MaxShiftGroups(weight));
            }
        }
        if (schedulingPeriod.MasterWeights.MinTimeBetweenShifts > 0) {
            weight = schedulingPeriod.MasterWeights.MinTimeBetweenShifts;
            array.add(new MinTimeBetweenShifts(weight));
        }
        if (employee.Contract.MaxNumAssignmentsIsOn) {
            weight = schedulingPeriod.MasterWeights.MaxNumAssignments;
            if (employee.Contract.MaxNumAssignmentsWeight > -1) {
                weight = employee.Contract.MaxNumAssignmentsWeight;
            }
            array.add(new MaxNumAssignments(weight));
        }
        if (employee.Contract.MaxShiftsPerDayIsOn) {
            weight = schedulingPeriod.MasterWeights.MaxShiftsPerDay;
            if (employee.Contract.MaxShiftsPerDayWeight > -1) {
                weight = employee.Contract.MaxShiftsPerDayWeight;
            }
            array.add(new MaxShiftsPerDay(weight));
        }
        if (employee.Contract.MaxConsecutiveWorkingWeekendsIsOn) {
            weight = schedulingPeriod.MasterWeights.MaxConsecutiveWorkingWeekends;
            if (employee.Contract.MaxConsecutiveWorkingWeekendsWeight > -1) {
                weight = employee.Contract.MaxConsecutiveWorkingWeekendsWeight;
            }
            array.add(new MaxConsecutiveWorkingWeekends(weight));
        }
        if (employee.Contract.MinConsecutiveWorkingWeekendsIsOn) {
            weight = schedulingPeriod.MasterWeights.MinConsecutiveWorkingWeekends;
            if (employee.Contract.MinConsecutiveWorkingWeekendsWeight > -1) {
                weight = employee.Contract.MinConsecutiveWorkingWeekendsWeight;
            }
            array.add(new MinConsecutiveWorkingWeekends(weight));
        }
        if (employee.Contract.MaxConsecutiveFreeWeekendsIsOn) {
            weight = schedulingPeriod.MasterWeights.MaxConsecutiveFreeWeekends;
            if (employee.Contract.MaxConsecutiveFreeWeekendsWeight > -1) {
                weight = employee.Contract.MaxConsecutiveFreeWeekendsWeight;
            }
            array.add(new MaxConsecutiveFreeWeekends(weight));
        }
        if (employee.Contract.MinConsecutiveFreeWeekendsIsOn) {
            weight = schedulingPeriod.MasterWeights.MinConsecutiveFreeWeekends;
            if (employee.Contract.MinConsecutiveFreeWeekendsWeight > -1) {
                weight = employee.Contract.MinConsecutiveFreeWeekendsWeight;
            }
            array.add(new MinConsecutiveFreeWeekends(weight));
        }
        if (employee.Contract.CompleteWeekends) {
            weight = schedulingPeriod.MasterWeights.CompleteWeekends;
            if (employee.Contract.CompleteWeekendsWeight > -1) {
                weight = employee.Contract.CompleteWeekendsWeight;
            }
            array.add(new CompleteWeekends(weight));
        }
        if (employee.Contract.IdenticalShiftTypesDuringWeekend) {
            weight = schedulingPeriod.MasterWeights.IdenticalShiftTypesDuringWeekend;
            if (employee.Contract.IdenticalShiftTypesDuringWeekendWeight > -1) {
                weight = employee.Contract.IdenticalShiftTypesDuringWeekendWeight;
            }
            array.add(new IdenticalShiftTypesDuringWeekend(weight));
        }
        if (employee.Contract.NoNightShiftBeforeFreeWeekend) {
            weight = schedulingPeriod.MasterWeights.NoNightShiftBeforeFreeWeekend;
            if (employee.Contract.NoNightShiftBeforeFreeWeekendWeight > -1) {
                weight = employee.Contract.NoNightShiftBeforeFreeWeekendWeight;
            }
            array.add(new NoNightShiftBeforeFreeWeekend(weight));
        }
        if (employee.Contract.ValidNumConsecutiveShiftTypesIsOn) {
            weight = schedulingPeriod.MasterWeights.ValidNumConsecutiveShiftTypes;
            if (employee.Contract.ValidNumConsecutiveShiftTypesWeight > -1) {
                weight = employee.Contract.ValidNumConsecutiveShiftTypesWeight;
            }
            array.add(new NumConsecutiveShiftTypes(weight));
        }
        if (employee.Contract.ValidShiftTypeSuccessionsIsOn) {
            weight = schedulingPeriod.MasterWeights.ValidShiftTypeSuccessions;
            if (employee.Contract.ValidShiftTypeSuccessionsWeight > -1) {
                weight = employee.Contract.ValidShiftTypeSuccessionsWeight;
            }
            array.add(new ShiftTypeSuccessions(weight));
        }
        if (employee.Contract.MaxWeekendsOffIsOn) {
            weight = employee.Contract.MaxWeekendsOffWeight > -1 ? employee.Contract.MaxWeekendsOffWeight : schedulingPeriod.MasterWeights.MaxWeekendsOff;
            array.add(new MaxWeekendsOff(weight));
        }
        if (employee.DayOffRequestCount > 0) {
            array.add(new RequestedDaysOff());
        }
        if (employee.DayOnRequestCount > 0) {
            array.add(new RequestedDaysOn());
        }
        if (employee.ShiftOffRequestCount > 0) {
            array.add(new RequestedShiftsOff());
        }
        if (employee.ShiftOnRequestCount > 0) {
            array.add(new RequestedShiftsOn());
        }
        if (employee.ShiftGroupOnRequests != null && employee.ShiftGroupOnRequests.length > 0) {
            array.add(new RequestedShiftGroupsOn());
        }
        this.EmployeesWeekendConstraints[employee.IndexID] = array.toArray(new SoftConstraint[0]);
    }
}

