/*
 * Decompiled with CFR 0.152.
 */
package ASAP.NRP.Solvers.VariableDepthSearch;

import ASAP.NRP.Core.Constraints.ANROM.CompleteWeekends;
import ASAP.NRP.Core.Constraints.ANROM.IdenticalShiftTypesDuringWeekend;
import ASAP.NRP.Core.Constraints.ANROM.MaxConsecutiveWorkingWeekends;
import ASAP.NRP.Core.Constraints.ANROM.MaxNumAssignments;
import ASAP.NRP.Core.Constraints.ANROM.MaxShiftTypes;
import ASAP.NRP.Core.Constraints.ANROM.MinTimeBetweenShifts;
import ASAP.NRP.Core.Constraints.ANROM.NoNightShiftBeforeFreeWeekend;
import ASAP.NRP.Core.Constraints.ANROM.NumConsecutiveShiftTypes;
import ASAP.NRP.Core.Constraints.ANROM.RequestedDaysOff;
import ASAP.NRP.Core.Constraints.ANROM.RequestedDaysOn;
import ASAP.NRP.Core.Constraints.ANROM.RequestedShiftsOff;
import ASAP.NRP.Core.Constraints.ANROM.RequestedShiftsOn;
import ASAP.NRP.Core.Constraints.ANROM.ShiftTypeSuccessions;
import ASAP.NRP.Core.Constraints.Azaiez.MaxWeekendDays;
import ASAP.NRP.Core.Constraints.GPost.MaxShiftsPerDay;
import ASAP.NRP.Core.Constraints.Ikegami.MaxWeekendsOff;
import ASAP.NRP.Core.Constraints.Montreal.MaxConsecutiveFreeWeekends;
import ASAP.NRP.Core.Constraints.Montreal.MinConsecutiveFreeWeekends;
import ASAP.NRP.Core.Constraints.Montreal.MinConsecutiveWorkingWeekends;
import ASAP.NRP.Core.Constraints.QMC.RequestedShiftGroupsOn;
import ASAP.NRP.Core.Constraints.SoftConstraint;
import ASAP.NRP.Core.Constraints.SoftConstraints;
import ASAP.NRP.Core.Constraints.TEC.MaxShiftGroups;
import ASAP.NRP.Core.DateTime;
import ASAP.NRP.Core.Employee;
import ASAP.NRP.Core.EmployeeDescription;
import ASAP.NRP.Core.Roster;
import ASAP.NRP.Core.SchedulingPeriod;
import ASAP.NRP.Core.Shift;
import ASAP.NRP.Core.ShiftGroup;
import ASAP.NRP.Core.ShiftType;
import ASAP.NRP.Solvers.Solver;
import ASAP.NRP.Solvers.VariableDepthSearch.Hrz1Emp1Swp_M;
import ASAP.NRP.Solvers.VariableDepthSearch.New1Emp1Swp_M;
import ASAP.NRP.Solvers.VariableDepthSearch.TestShiftDB;
import ASAP.NRP.Solvers.VariableDepthSearch.Vrt2Emp1Swp_M;
import java.util.ArrayList;
import java.util.Random;

public class VDS_B
implements Solver,
TestShiftDB {
    public boolean Stopped = true;
    public String Author = "Tim";
    public String Title = "VDS_B";
    public long TotalEvaluations = 0L;
    public int RandomSeed = 1;
    public int PreferredRunTime = 5000;
    public boolean VERBOSE = true;
    public boolean SYSTEM_TIME_RANDOM_SEED = true;
    public boolean TIME_LIMIT = true;
    public boolean USE_QUICKSEARCH = true;
    public boolean POSITIVE_GAIN_HEURISTIC = true;
    public boolean VIOLATION_FLAG_HEURISTIC = false;
    public int MAX_DEPTH = 500;
    public int NEXT_MOVE_MAX_BLOCK_SIZE = 5;
    public int MAX_BLOCK_SIZE_AT_DEPTH_ZERO = 2;
    public int TEST_PATTERNS_MAX_ATTEMPTS = 2;
    public boolean TEST_PATTERNS_AT_START = true;
    public boolean SATISFY_WEEKENDS = true;
    public boolean TEST_PATTERNS_DURING_IMPROVE_EMPLOYEE = false;
    final boolean CYC_HEURISTIC = true;
    DateTime start;
    DateTime end;
    Random rand;
    boolean finished;
    int lastImprovementEmployee1;
    int lastImprovementEmployee2;
    int lastImprovementDay;
    int lastImprovementBlockSize;
    int lastImprovementShiftType;
    int lastImprovementType;
    final int TOTAL_IMPROVEMENT = 0;
    final int IMPROVE_EMPLOYEE_NEXT = 1;
    final int IMPROVE_COVER_NEXT = 2;
    final int NEW_SHIFTS = 3;
    final int BETWEEN_EMPLOYEES = 4;
    final int NEW_PATTERN = 5;
    int[][] movesMade;
    final int EMPLOYEE1 = 0;
    final int EMPLOYEE2 = 1;
    final int START_DAY = 2;
    final int BLOCK_SIZE = 3;
    final int TYPE = 4;
    final int SHIFT_INDEX = 5;
    Shift[][] TestShifts;
    Shift[][][] AllShifts;
    int[][] EmployeeOKshifts;
    int currentRosterHash;
    int[][][] hashRandomValues;
    int[] hashEmployeeRandVals;
    int[] hashDaysRandVals;
    int[] HashKeyArray;
    SoftConstraint[][] EmployeesWeekendConstraints;
    boolean cacheViolationPens = false;
    boolean updateViolationFlags = false;
    New1Emp1Swp_M n1;
    Hrz1Emp1Swp_M h1;
    Roster bestRoster = null;
    int guiBestPenalty;
    public boolean SchedulingPeriodContainsNonAutoAssignShifts = false;
    public boolean[] EmployeeDescriptionHasFrozenDays;
    final boolean SHOW_ERROR_MSGS = false;
    boolean randSet = false;

    @Override
    public void setStopped(boolean stopped) {
        this.Stopped = stopped;
    }

    @Override
    public boolean getStopped() {
        return this.Stopped;
    }

    @Override
    public String getAuthor() {
        return this.Author;
    }

    @Override
    public int getRandomSeed() {
        return this.RandomSeed;
    }

    @Override
    public long getTotalEvaluations() {
        return this.TotalEvaluations;
    }

    @Override
    public void setRandomSeed(int seed) {
        this.RandomSeed = seed;
    }

    @Override
    public String getTitle() {
        return this.Title;
    }

    public void setRNG(Random rand) {
        this.rand = rand;
        this.n1.setRNG(rand);
        this.h1.setRNG(rand);
        this.randSet = true;
    }

    public VDS_B() {
        this.UpdateTitle();
        this.n1 = new New1Emp1Swp_M(this);
        this.n1.TIME_LIMIT = false;
        this.n1.SKIP_ZERO_PENS = false;
        this.n1.MAX_BLOCK_SIZE = 5;
        this.n1.VIOLATION_HEURISTIC_THRESHOLD = 0;
        this.n1.RandomSeed = this.RandomSeed;
        this.n1.VERBOSE = false;
        this.h1 = new Hrz1Emp1Swp_M(this);
        this.h1.MAX_BLOCK_SIZE = 5;
        this.h1.RandomSeed = this.RandomSeed;
        this.h1.TIME_LIMIT = false;
        this.h1.VIOLATION_HEURISTIC_THRESHOLD = 0;
        this.h1.SKIP_ZERO_PEN = false;
        this.h1.VERBOSE = false;
    }

    @Override
    public void Solve(Roster roster) {
        EmployeeDescription emp;
        if (roster.Employees.length == 0 || roster.SchedulingPeriod.ShiftTypesCount == 0) {
            return;
        }
        roster.RecalculateAllPenalties();
        if (roster.getTotalPenalty() == 0) {
            return;
        }
        if (this.SYSTEM_TIME_RANDOM_SEED) {
            this.RandomSeed = (int)DateTime.getNow().getTicks();
        }
        if (!this.randSet) {
            this.rand = new Random(this.RandomSeed);
            this.n1.setRNG(this.rand);
            this.h1.setRNG(this.rand);
        }
        this.Stopped = false;
        this.TotalEvaluations = 0L;
        this.guiBestPenalty = -1;
        this.SchedulingPeriodContainsNonAutoAssignShifts = false;
        int i = 0;
        while (i < roster.SchedulingPeriod.ShiftTypesCount) {
            if (!roster.SchedulingPeriod.GetShiftType((int)i).AutoAllocate) {
                this.SchedulingPeriodContainsNonAutoAssignShifts = true;
                break;
            }
            ++i;
        }
        this.EmployeeDescriptionHasFrozenDays = new boolean[roster.SchedulingPeriod.EmployeesCount];
        i = 0;
        while (i < roster.SchedulingPeriod.EmployeesCount) {
            emp = roster.SchedulingPeriod.GetEmployeeDescription(i);
            int j = 0;
            while (j < emp.FrozenDay.length) {
                if (emp.FrozenDay[j]) {
                    this.EmployeeDescriptionHasFrozenDays[emp.IndexID] = true;
                    break;
                }
                ++j;
            }
            ++i;
        }
        this.EmployeesWeekendConstraints = new SoftConstraint[roster.SchedulingPeriod.EmployeesCount][];
        i = 0;
        while (i < roster.SchedulingPeriod.EmployeesCount) {
            emp = roster.SchedulingPeriod.GetEmployeeDescription(i);
            this.CreateWeekendSoftConstraints(emp);
            ++i;
        }
        this.CheckAlgorithmParameters(roster);
        this.UpdateTitle();
        SchedulingPeriod schedulingPeriod = roster.SchedulingPeriod;
        this.AllShifts = new Shift[schedulingPeriod.NumDaysInPeriod][schedulingPeriod.ShiftTypesCount][roster.Employees.length];
        this.TestShifts = new Shift[schedulingPeriod.NumDaysInPeriod][schedulingPeriod.ShiftTypesCount];
        int day = 0;
        while (day < schedulingPeriod.NumDaysInPeriod) {
            DateTime date = schedulingPeriod.ConvertRosterDayToDate(day);
            int i2 = 0;
            while (i2 < schedulingPeriod.ShiftTypesCount) {
                ShiftType st = schedulingPeriod.GetShiftType(i2);
                this.TestShifts[day][i2] = new Shift(st, date, schedulingPeriod);
                int j = 0;
                while (j < roster.Employees.length) {
                    this.AllShifts[day][i2][j] = new Shift(st, date, schedulingPeriod);
                    ++j;
                }
                ++i2;
            }
            ++day;
        }
        this.hashRandomValues = new int[roster.Employees.length][schedulingPeriod.NumDaysInPeriod][schedulingPeriod.ShiftTypesCount];
        this.hashEmployeeRandVals = new int[roster.Employees.length];
        this.hashDaysRandVals = new int[schedulingPeriod.NumDaysInPeriod];
        int e = 0;
        while (e < roster.Employees.length) {
            this.hashEmployeeRandVals[e] = this.rand.nextInt(Integer.MAX_VALUE);
            int day2 = 0;
            while (day2 < schedulingPeriod.NumDaysInPeriod) {
                int s = 0;
                while (s < schedulingPeriod.ShiftTypesCount) {
                    this.hashRandomValues[e][day2][s] = this.rand.nextInt(Integer.MAX_VALUE);
                    ++s;
                }
                ++day2;
            }
            ++e;
        }
        day = 0;
        while (day < schedulingPeriod.NumDaysInPeriod) {
            this.hashDaysRandVals[day] = this.rand.nextInt(Integer.MAX_VALUE);
            ++day;
        }
        int shiftTypesCount = schedulingPeriod.ShiftTypesCount;
        this.EmployeeOKshifts = new int[roster.SchedulingPeriod.EmployeesCount][];
        int e2 = 0;
        while (e2 < roster.Employees.length) {
            Employee employee = roster.Employees[e2];
            ArrayList<Integer> okShifts = new ArrayList<Integer>();
            int i3 = 0;
            while (i3 < shiftTypesCount) {
                int max;
                if (employee.EmployeeDescription.Contract == null || (max = employee.EmployeeDescription.Contract.MaxShiftTypes[i3]) != 0) {
                    ShiftType st = schedulingPeriod.GetShiftType(i3);
                    if (st.AutoAllocate && (!st.RequiresSkills || schedulingPeriod.EmployeeHasSkillsForShiftType(employee.EmployeeDescription, i3))) {
                        int[] groups = roster.SchedulingPeriod.GetShiftGroupsContainingShift(i3);
                        boolean permit = true;
                        if (employee.EmployeeDescription.Contract != null) {
                            int j = 0;
                            while (j < groups.length) {
                                int max2 = employee.EmployeeDescription.Contract.MaxShiftGroups[groups[j]];
                                if (max2 == 0) {
                                    permit = false;
                                    break;
                                }
                                ++j;
                            }
                        }
                        if (permit) {
                            okShifts.add(new Integer(i3));
                        }
                    }
                }
                ++i3;
            }
            this.EmployeeOKshifts[employee.EmployeeDescription.IndexID] = new int[okShifts.size()];
            i3 = 0;
            while (i3 < okShifts.size()) {
                this.EmployeeOKshifts[employee.EmployeeDescription.IndexID][i3] = (Integer)okShifts.get(i3);
                ++i3;
            }
            ++e2;
        }
        this.movesMade = new int[this.MAX_DEPTH][6];
        this.start = DateTime.getNow();
        this.end = DateTime.getNow().AddMilliseconds(this.PreferredRunTime);
        Roster originalRoster = (Roster)roster.Clone();
        this.Search(roster);
        if (this.TIME_LIMIT && roster.getTotalPenalty() != 0) {
            this.bestRoster = (Roster)roster.Clone();
            while (!this.Stopped && this.bestRoster.getTotalPenalty() != 0 && DateTime.getNow().isLessThan(this.end)) {
                this.SetRoster(roster, originalRoster);
                this.Search(roster);
                if (roster.getTotalPenalty() >= this.bestRoster.getTotalPenalty()) continue;
                this.bestRoster = (Roster)roster.Clone();
            }
            this.SetRoster(roster, this.bestRoster);
        }
        if (this.VERBOSE) {
            System.out.println("Search finished. Total moves tested=" + this.TotalEvaluations + " Pen=" + roster.getTotalPenalty());
        }
    }

    private void Search(Roster roster) {
        this.cacheViolationPens = false;
        this.updateViolationFlags = false;
        if (this.VIOLATION_FLAG_HEURISTIC) {
            this.cacheViolationPens = true;
            this.updateViolationFlags = true;
        }
        this.lastImprovementEmployee1 = -1;
        this.lastImprovementEmployee2 = -1;
        this.lastImprovementDay = -1;
        this.lastImprovementBlockSize = -1;
        this.lastImprovementType = -1;
        this.lastImprovementShiftType = -2;
        this.finished = false;
        this.ShuffleEmployees(roster);
        if (this.TIME_LIMIT && DateTime.getNow().isGreaterThan(this.end)) {
            return;
        }
        int movesCount = this.SwapShiftsDepthOne(roster);
        if (this.VERBOSE) {
            System.out.println("\nTotal moves tested=" + this.TotalEvaluations + ", totalImprovingMoves=" + movesCount);
            System.out.println("Variable depth search finished. Total moves tested=" + this.TotalEvaluations + ", totalImprovingMoves=" + movesCount);
        }
    }

    private int SwapShiftsDepthOne(Roster roster) {
        int startMovesCount;
        int maxHashSize = (roster.SchedulingPeriod.ShiftTypesCount + 1) * this.MAX_DEPTH + (roster.Employees.length - 1) * this.MAX_DEPTH * 3 + 1;
        this.ResetHashTable(maxHashSize);
        if (this.TEST_PATTERNS_AT_START) {
            this.ConstructRoster(roster);
        }
        if (roster.getTotalPenalty() == 0 || this.TIME_LIMIT && DateTime.getNow().isGreaterThan(this.end)) {
            return 0;
        }
        if (this.USE_QUICKSEARCH) {
            this.QuickSearch(roster);
        }
        roster.RecalculateAllPenalties();
        if (roster.getTotalPenalty() == 0 || this.TIME_LIMIT && DateTime.getNow().isGreaterThan(this.end)) {
            return 0;
        }
        this.currentRosterHash = this.CalculateHash(roster);
        this.AddHashKey(this.currentRosterHash);
        int movesCount = 0;
        do {
            startMovesCount = movesCount;
            int blockSize = 1;
            while (blockSize <= this.MAX_BLOCK_SIZE_AT_DEPTH_ZERO) {
                int i = 0;
                while (i < roster.Employees.length) {
                    Employee employee1 = roster.Employees[i];
                    int day = 0;
                    while (day < roster.SchedulingPeriod.NumDaysInPeriod - blockSize + 1) {
                        block114: {
                            int x;
                            int x2;
                            boolean employee1Violations;
                            boolean coverViolations;
                            block117: {
                                int x3;
                                block116: {
                                    block115: {
                                        if (this.VERBOSE) {
                                            System.out.println("VDSB: Swp..D1: BlckSze=" + blockSize + " E1=" + employee1.EmployeeDescription.getName() + " Day=" + day + " Evals=" + this.TotalEvaluations + " Pen=" + roster.getTotalPenalty() + " EPen=" + roster.EmployeesPenalty + " CovPen=" + roster.CoverPenalty);
                                        }
                                        this.GuiPrint("Stage : VDS", roster);
                                        if (this.Stopped || roster.getTotalPenalty() == 0) {
                                            return movesCount;
                                        }
                                        if (this.lastImprovementDay == day && this.lastImprovementEmployee1 == employee1.Index && this.lastImprovementBlockSize == blockSize && this.lastImprovementType == 3) {
                                            return movesCount;
                                        }
                                        coverViolations = false;
                                        int x4 = 0;
                                        while (x4 < blockSize) {
                                            if (roster.CoverPenOnDay[day + x4] > 0) {
                                                coverViolations = true;
                                                break;
                                            }
                                            ++x4;
                                        }
                                        if (employee1.Penalty == 0 && !coverViolations) break block114;
                                        if (!this.SchedulingPeriodContainsNonAutoAssignShifts) break block115;
                                        boolean fixedShifts = false;
                                        x3 = 0;
                                        while (x3 < blockSize) {
                                            Shift s = employee1.GetShift(day + x3);
                                            if (s != null && s.isFixed()) {
                                                fixedShifts = true;
                                                break;
                                            }
                                            ++x3;
                                        }
                                        if (fixedShifts) break block114;
                                    }
                                    if (!this.EmployeeDescriptionHasFrozenDays[employee1.EmployeeDescription.IndexID]) break block116;
                                    boolean frozen = false;
                                    x3 = 0;
                                    while (x3 < blockSize) {
                                        if (employee1.EmployeeDescription.FrozenDay[day + x3]) {
                                            frozen = true;
                                            break;
                                        }
                                        ++x3;
                                    }
                                    if (frozen) break block114;
                                }
                                employee1Violations = false;
                                if (!this.VIOLATION_FLAG_HEURISTIC) break block117;
                                x3 = 0;
                                while (x3 < blockSize) {
                                    if (employee1.ConstraintViolationPenalties[day + x3] > 0) {
                                        employee1Violations = true;
                                        break;
                                    }
                                    ++x3;
                                }
                                if (!coverViolations && !employee1Violations) break block114;
                            }
                            boolean moveMade = false;
                            int originalPenalty = roster.getTotalPenalty();
                            int originalCoverPenalty = roster.CoverPenalty;
                            int originalEmployeesPenalty = roster.EmployeesPenalty;
                            int[] originalCoverPenOnDay = new int[roster.SchedulingPeriod.NumDaysInPeriod];
                            System.arraycopy(roster.CoverPenOnDay, 0, originalCoverPenOnDay, 0, roster.CoverPenOnDay.length);
                            this.ResetHashTable(maxHashSize);
                            this.AddHashKey(this.currentRosterHash);
                            Shift[] shifts1 = new Shift[blockSize];
                            roster.CacheEmployeePenalties(0, this.cacheViolationPens);
                            int x5 = 0;
                            while (x5 < blockSize) {
                                shifts1[x5] = employee1.GetShift(day + x5);
                                if (shifts1[x5] != null) {
                                    roster.UnAssignShift(shifts1[x5]);
                                    this.currentRosterHash ^= this.hashRandomValues[i][day + x5][shifts1[x5].ShiftType.Index];
                                }
                                ++x5;
                            }
                            roster.CoverPenalty += roster.UpdateCoverPens(shifts1);
                            int k = -1;
                            while (k < roster.SchedulingPeriod.ShiftTypesCount) {
                                if (!this.SchedulingPeriodContainsNonAutoAssignShifts || k < 0 || roster.SchedulingPeriod.GetShiftType((int)k).AutoAllocate) {
                                    Shift[] shifts2 = new Shift[blockSize];
                                    boolean different = false;
                                    x2 = 0;
                                    while (x2 < blockSize) {
                                        if (k < 0) {
                                            shifts2[x2] = null;
                                            if (shifts1[x2] != null) {
                                                different = true;
                                            }
                                        } else {
                                            shifts2[x2] = this.GetTestShift(k, day + x2);
                                            if (shifts1[x2] == null || shifts1[x2].ShiftType.Index != k) {
                                                different = true;
                                            }
                                        }
                                        ++x2;
                                    }
                                    if (!(!different || shifts1[0] == null && shifts2[0] == null || shifts1[blockSize - 1] == null && shifts2[blockSize - 1] == null)) {
                                        boolean valid = true;
                                        x = 0;
                                        while (x < blockSize) {
                                            if (employee1.ViolationsForAssigningShift(shifts2[x]) == -1) {
                                                valid = false;
                                                break;
                                            }
                                            ++x;
                                        }
                                        if (valid) {
                                            int nextHash;
                                            roster.CacheEmployeePenalties(1, this.cacheViolationPens);
                                            if (k >= 0) {
                                                x = 0;
                                                while (x < blockSize) {
                                                    roster.AssignShift(employee1, shifts2[x]);
                                                    this.currentRosterHash ^= this.hashRandomValues[i][day + x][k];
                                                    ++x;
                                                }
                                                employee1.Roster.CoverPenalty += employee1.Roster.UpdateCoverPens(shifts2);
                                            }
                                            employee1.RecalculatePenalty(day, day + blockSize - 1, true);
                                            ++this.TotalEvaluations;
                                            if (roster.getTotalPenalty() < originalPenalty) {
                                                moveMade = true;
                                                ++movesCount;
                                                if (shifts2[0] != null) {
                                                    x = 0;
                                                    while (x < blockSize) {
                                                        roster.UnAssignShift(shifts2[x]);
                                                        if (shifts2[x] != null) {
                                                            Shift s = this.GetShift(shifts2[x].ShiftType.Index, shifts2[x].RosterDay);
                                                            roster.AssignShift(employee1, s);
                                                        }
                                                        ++x;
                                                    }
                                                }
                                                if (this.updateViolationFlags && employee1.EmployeeDescription.Contract != null && employee1.EmployeeDescription.Contract.BadPatternsIsOn) {
                                                    employee1.RecalculatePenalty();
                                                }
                                            } else if (roster.CoverPenalty < originalCoverPenalty && this.MAX_DEPTH > 1 && (!this.TIME_LIMIT || DateTime.getNow().isLessThan(this.end))) {
                                                if (shifts2[0] != null) {
                                                    x = 0;
                                                    while (x < blockSize) {
                                                        roster.UnAssignShift(shifts2[x]);
                                                        if (shifts2[x] != null) {
                                                            shifts2[x] = this.GetShift(shifts2[x].ShiftType.Index, shifts2[x].RosterDay);
                                                            roster.AssignShift(employee1, shifts2[x]);
                                                        }
                                                        ++x;
                                                    }
                                                }
                                                if (this.updateViolationFlags && employee1.EmployeeDescription.Contract != null && employee1.EmployeeDescription.Contract.BadPatternsIsOn) {
                                                    employee1.RecalculatePenalty();
                                                }
                                                if (!this.PreviouslyTested(nextHash = this.currentRosterHash ^ this.hashEmployeeRandVals[employee1.Index])) {
                                                    moveMade = this.ImproveEmployee(employee1, originalPenalty, 2, originalCoverPenalty);
                                                }
                                            } else if (roster.EmployeesPenalty < originalEmployeesPenalty && this.MAX_DEPTH > 1 && (!this.TIME_LIMIT || DateTime.getNow().isLessThan(this.end))) {
                                                this.movesMade[0][0] = employee1.Index;
                                                this.movesMade[0][2] = day;
                                                this.movesMade[0][3] = blockSize;
                                                this.movesMade[0][4] = 3;
                                                this.movesMade[0][5] = k;
                                                if (shifts2[0] != null) {
                                                    x = 0;
                                                    while (x < blockSize) {
                                                        roster.UnAssignShift(shifts2[x]);
                                                        if (shifts2[x] != null) {
                                                            shifts2[x] = this.GetShift(shifts2[x].ShiftType.Index, shifts2[x].RosterDay);
                                                            roster.AssignShift(employee1, shifts2[x]);
                                                        }
                                                        ++x;
                                                    }
                                                }
                                                nextHash = this.currentRosterHash;
                                                boolean[] badDays = new boolean[roster.SchedulingPeriod.NumDaysInPeriod];
                                                int d = 0;
                                                while (d < badDays.length) {
                                                    if (roster.CoverPenOnDay[d] > originalCoverPenOnDay[d]) {
                                                        badDays[d] = true;
                                                        nextHash ^= this.hashDaysRandVals[d];
                                                    }
                                                    ++d;
                                                }
                                                if (this.updateViolationFlags && employee1.EmployeeDescription.Contract != null && employee1.EmployeeDescription.Contract.BadPatternsIsOn) {
                                                    employee1.RecalculatePenalty();
                                                }
                                                if (!this.PreviouslyTested(nextHash)) {
                                                    moveMade = this.ImproveCover(roster, badDays, originalPenalty, 2, originalCoverPenalty);
                                                }
                                            }
                                            if (moveMade) {
                                                this.lastImprovementEmployee1 = employee1.Index;
                                                this.lastImprovementBlockSize = blockSize;
                                                this.lastImprovementDay = day;
                                                this.lastImprovementShiftType = k;
                                                this.lastImprovementType = 3;
                                                ++movesCount;
                                                break;
                                            }
                                            if (k >= 0) {
                                                x = 0;
                                                while (x < blockSize) {
                                                    roster.UnAssignShift(shifts2[x]);
                                                    this.currentRosterHash ^= this.hashRandomValues[i][day + x][k];
                                                    ++x;
                                                }
                                                roster.CoverPenalty += roster.UpdateCoverPens(shifts2);
                                            }
                                            roster.RestoreEmployeePenalties(1, this.cacheViolationPens);
                                        }
                                    }
                                }
                                ++k;
                            }
                            if (moveMade) break block114;
                            x5 = 0;
                            while (x5 < blockSize) {
                                if (shifts1[x5] != null) {
                                    roster.AssignShift(employee1, shifts1[x5]);
                                    this.currentRosterHash ^= this.hashRandomValues[i][day + x5][shifts1[x5].ShiftType.Index];
                                }
                                ++x5;
                            }
                            roster.CoverPenalty += roster.UpdateCoverPens(shifts1);
                            roster.RestoreEmployeePenalties(0, this.cacheViolationPens);
                            if (employee1.EmployeeDescription.Contract != null && employee1.EmployeeDescription.Contract.BadPatternsIsOn && employee1.EmployeeDescription.BadPatternConstraint != null) {
                                employee1.EmployeeDescription.BadPatternConstraint.Calculate(employee1, day, day + blockSize - 1);
                            }
                            if (this.Stopped || this.finished || this.TIME_LIMIT && DateTime.getNow().isGreaterThan(this.end) || roster.getTotalPenalty() == 0) {
                                return movesCount;
                            }
                            shifts1 = new Shift[blockSize];
                            roster.CacheEmployeePenalties(0, this.cacheViolationPens);
                            x5 = 0;
                            while (x5 < blockSize) {
                                shifts1[x5] = employee1.GetShift(day + x5);
                                if (shifts1[x5] != null) {
                                    roster.UnAssignShift(shifts1[x5]);
                                    this.currentRosterHash ^= this.hashRandomValues[i][day + x5][shifts1[x5].ShiftType.Index];
                                }
                                ++x5;
                            }
                            roster.CoverPenalty += roster.UpdateCoverPens(shifts1);
                            int j = i + 1;
                            while (j < roster.Employees.length) {
                                block118: {
                                    Shift[] shifts2;
                                    Employee employee2;
                                    block120: {
                                        block119: {
                                            employee2 = roster.Employees[j];
                                            if (this.lastImprovementEmployee1 == employee1.Index && this.lastImprovementEmployee2 == employee2.Index && this.lastImprovementDay == day && this.lastImprovementBlockSize == blockSize && this.lastImprovementType == 4) {
                                                this.finished = true;
                                                break;
                                            }
                                            if (employee1.Penalty == 0 && employee2.Penalty == 0 && !coverViolations) break block118;
                                            if (!this.EmployeeDescriptionHasFrozenDays[employee2.EmployeeDescription.IndexID]) break block119;
                                            boolean frozen = false;
                                            x2 = 0;
                                            while (x2 < blockSize) {
                                                if (employee2.EmployeeDescription.FrozenDay[day + x2]) {
                                                    frozen = true;
                                                    break;
                                                }
                                                ++x2;
                                            }
                                            if (frozen) break block118;
                                        }
                                        shifts2 = new Shift[blockSize];
                                        boolean employee2Violations = false;
                                        x = 0;
                                        while (x < blockSize) {
                                            shifts2[x] = employee2.GetShift(day + x);
                                            if (employee2.ConstraintViolationPenalties[day + x] > 0) {
                                                employee2Violations = true;
                                            }
                                            ++x;
                                        }
                                        if (this.VIOLATION_FLAG_HEURISTIC && !employee1Violations && !employee2Violations) break block118;
                                        if (!this.SchedulingPeriodContainsNonAutoAssignShifts) break block120;
                                        boolean fixedShifts = false;
                                        int x6 = 0;
                                        while (x6 < blockSize) {
                                            if (shifts2[x6] != null && shifts2[x6].isFixed()) {
                                                fixedShifts = true;
                                                break;
                                            }
                                            ++x6;
                                        }
                                        if (fixedShifts) break block118;
                                    }
                                    if (!(shifts1[0] == null && shifts2[0] == null || shifts1[blockSize - 1] == null && shifts2[blockSize - 1] == null)) {
                                        x = 0;
                                        while (x < blockSize) {
                                            if (shifts2[x] != null) {
                                                roster.UnAssignShift(shifts2[x]);
                                                this.currentRosterHash ^= this.hashRandomValues[j][day + x][shifts2[x].ShiftType.Index];
                                            }
                                            ++x;
                                        }
                                        roster.CoverPenalty += roster.UpdateCoverPens(shifts2);
                                        boolean valid = true;
                                        int x7 = 0;
                                        while (x7 < blockSize) {
                                            if (employee2.ViolationsForAssigningShift(shifts1[x7]) == -1 || employee1.ViolationsForAssigningShift(shifts2[x7]) == -1) {
                                                valid = false;
                                                break;
                                            }
                                            ++x7;
                                        }
                                        if (valid) {
                                            roster.CacheEmployeePenalties(1, this.cacheViolationPens);
                                            x7 = 0;
                                            while (x7 < blockSize) {
                                                if (shifts1[x7] != null) {
                                                    roster.AssignShift(employee2, shifts1[x7]);
                                                    this.currentRosterHash ^= this.hashRandomValues[j][day + x7][shifts1[x7].ShiftType.Index];
                                                }
                                                if (shifts2[x7] != null) {
                                                    roster.AssignShift(employee1, shifts2[x7]);
                                                    this.currentRosterHash ^= this.hashRandomValues[i][day + x7][shifts2[x7].ShiftType.Index];
                                                }
                                                ++x7;
                                            }
                                            roster.CoverPenalty += roster.UpdateCoverPens(shifts2);
                                            roster.CoverPenalty += roster.UpdateCoverPens(shifts1);
                                            int tempPen = roster.getTotalPenalty();
                                            employee1.RecalculatePenalty(day, day + blockSize - 1, true);
                                            int e1Change = roster.getTotalPenalty() - tempPen;
                                            employee2.RecalculatePenalty(day, day + blockSize - 1, true);
                                            int e2Change = roster.getTotalPenalty() - (tempPen + e1Change);
                                            int covChange = roster.CoverPenalty - originalCoverPenalty;
                                            ++this.TotalEvaluations;
                                            if (roster.getTotalPenalty() < originalPenalty) {
                                                if (this.updateViolationFlags) {
                                                    if (employee1.EmployeeDescription.Contract != null && employee1.EmployeeDescription.Contract.BadPatternsIsOn) {
                                                        employee1.RecalculatePenalty();
                                                    }
                                                    if (employee2.EmployeeDescription.Contract != null && employee2.EmployeeDescription.Contract.BadPatternsIsOn) {
                                                        employee2.RecalculatePenalty();
                                                    }
                                                }
                                                moveMade = true;
                                            } else if (this.MAX_DEPTH > 1 && (!this.TIME_LIMIT || DateTime.getNow().isLessThan(this.end))) {
                                                int nextHash;
                                                this.movesMade[0][0] = employee1.Index;
                                                this.movesMade[0][1] = employee2.Index;
                                                this.movesMade[0][2] = day;
                                                this.movesMade[0][3] = blockSize;
                                                this.movesMade[0][4] = 4;
                                                if (this.updateViolationFlags) {
                                                    if (employee1.EmployeeDescription.Contract != null && employee1.EmployeeDescription.Contract.BadPatternsIsOn) {
                                                        employee1.RecalculatePenalty();
                                                    }
                                                    if (employee2.EmployeeDescription.Contract != null && employee2.EmployeeDescription.Contract.BadPatternsIsOn) {
                                                        employee2.RecalculatePenalty();
                                                    }
                                                }
                                                if (e2Change + covChange < 0 && !this.PreviouslyTested(nextHash = this.currentRosterHash ^ this.hashEmployeeRandVals[employee1.Index])) {
                                                    moveMade = this.ImproveEmployee(employee1, originalPenalty, 2, originalCoverPenalty);
                                                }
                                                if (!(moveMade || e1Change + covChange >= 0 || this.TIME_LIMIT && !DateTime.getNow().isLessThan(this.end) || this.PreviouslyTested(nextHash = this.currentRosterHash ^ this.hashEmployeeRandVals[employee2.Index]))) {
                                                    moveMade = this.ImproveEmployee(employee2, originalPenalty, 2, originalCoverPenalty);
                                                }
                                                if (!(moveMade || e1Change + e2Change >= 0 || this.TIME_LIMIT && !DateTime.getNow().isLessThan(this.end))) {
                                                    int hash = this.currentRosterHash;
                                                    boolean[] badDays = new boolean[roster.SchedulingPeriod.NumDaysInPeriod];
                                                    int d = 0;
                                                    while (d < badDays.length) {
                                                        if (roster.CoverPenOnDay[d] > originalCoverPenOnDay[d]) {
                                                            badDays[d] = true;
                                                            hash ^= this.hashDaysRandVals[d];
                                                        }
                                                        ++d;
                                                    }
                                                    if (!this.PreviouslyTested(hash)) {
                                                        moveMade = this.ImproveCover(roster, badDays, originalPenalty, 2, originalCoverPenalty);
                                                    }
                                                }
                                            }
                                            if (moveMade) {
                                                this.lastImprovementEmployee1 = employee1.Index;
                                                this.lastImprovementEmployee2 = employee2.Index;
                                                this.lastImprovementBlockSize = blockSize;
                                                this.lastImprovementDay = day;
                                                this.lastImprovementType = 4;
                                                ++movesCount;
                                                break;
                                            }
                                            int x8 = 0;
                                            while (x8 < blockSize) {
                                                if (shifts1[x8] != null) {
                                                    roster.UnAssignShift(shifts1[x8]);
                                                    this.currentRosterHash ^= this.hashRandomValues[j][day + x8][shifts1[x8].ShiftType.Index];
                                                }
                                                if (shifts2[x8] != null) {
                                                    roster.UnAssignShift(shifts2[x8]);
                                                    this.currentRosterHash ^= this.hashRandomValues[i][day + x8][shifts2[x8].ShiftType.Index];
                                                }
                                                ++x8;
                                            }
                                            roster.CoverPenalty += roster.UpdateCoverPens(shifts1);
                                            roster.CoverPenalty += roster.UpdateCoverPens(shifts2);
                                            roster.RestoreEmployeePenalties(1, this.cacheViolationPens);
                                            if (employee2.EmployeeDescription.Contract != null && employee2.EmployeeDescription.Contract.BadPatternsIsOn && employee2.EmployeeDescription.BadPatternConstraint != null) {
                                                employee2.EmployeeDescription.BadPatternConstraint.Calculate(employee2, day, day + blockSize - 1);
                                            }
                                        }
                                        x7 = 0;
                                        while (x7 < blockSize) {
                                            if (shifts2[x7] != null) {
                                                roster.AssignShift(employee2, shifts2[x7]);
                                                this.currentRosterHash ^= this.hashRandomValues[j][day + x7][shifts2[x7].ShiftType.Index];
                                            }
                                            ++x7;
                                        }
                                        roster.CoverPenalty += roster.UpdateCoverPens(shifts2);
                                        if (employee2.EmployeeDescription.Contract != null && employee2.EmployeeDescription.Contract.BadPatternsIsOn && employee2.EmployeeDescription.BadPatternConstraint != null) {
                                            employee2.EmployeeDescription.BadPatternConstraint.Calculate(employee2, day, day + blockSize - 1);
                                        }
                                    }
                                }
                                ++j;
                            }
                            if (!moveMade) {
                                x5 = 0;
                                while (x5 < blockSize) {
                                    if (shifts1[x5] != null) {
                                        roster.AssignShift(employee1, shifts1[x5]);
                                        this.currentRosterHash ^= this.hashRandomValues[i][day + x5][shifts1[x5].ShiftType.Index];
                                    }
                                    ++x5;
                                }
                                roster.CoverPenalty += roster.UpdateCoverPens(shifts1);
                                roster.RestoreEmployeePenalties(0, this.cacheViolationPens);
                                if (employee1.EmployeeDescription.Contract != null && employee1.EmployeeDescription.Contract.BadPatternsIsOn && employee1.EmployeeDescription.BadPatternConstraint != null) {
                                    employee1.EmployeeDescription.BadPatternConstraint.Calculate(employee1, day, day + blockSize - 1);
                                }
                            }
                            if (this.Stopped || this.finished || this.TIME_LIMIT && DateTime.getNow().isGreaterThan(this.end) || roster.getTotalPenalty() == 0) {
                                return movesCount;
                            }
                        }
                        ++day;
                    }
                    ++i;
                }
                if (this.VERBOSE) {
                    System.out.println("After SwapShiftsDepthOne (blockSize=" + blockSize + ") (" + movesCount + " moves), roster.Penalty = " + roster.getTotalPenalty());
                }
                ++blockSize;
            }
        } while (movesCount != startMovesCount);
        return movesCount;
    }

    private boolean ImproveEmployee(Employee employee1, int originalPenalty, int currentDepth, int originalCoverPenalty) {
        this.AddHashKey(this.currentRosterHash ^ this.hashEmployeeRandVals[employee1.Index]);
        Roster roster = employee1.Roster;
        int maxBlockSize = this.NEXT_MOVE_MAX_BLOCK_SIZE;
        int penaltyCachePos = currentDepth;
        boolean moveFound = false;
        int bestPenalty = 0;
        int bestDay = 0;
        Employee nextEmployee = null;
        Employee bestEmployee2 = null;
        Shift[] bestShifts1 = null;
        Shift[] bestShifts2 = null;
        int bestSwapType = -1;
        int bestNextImprovement = -1;
        int currentTotalPenalty = roster.getTotalPenalty();
        int currentCoverPenalty = roster.CoverPenalty;
        int currentEmployeesPenalty = roster.EmployeesPenalty;
        int[] originalCoverPenOnDay = new int[roster.SchedulingPeriod.NumDaysInPeriod];
        System.arraycopy(roster.CoverPenOnDay, 0, originalCoverPenOnDay, 0, roster.CoverPenOnDay.length);
        int blockSize = 1;
        while (blockSize <= maxBlockSize) {
            int day = 0;
            while (day < roster.SchedulingPeriod.NumDaysInPeriod - blockSize + 1) {
                block168: {
                    int x;
                    int x2;
                    int d;
                    int x3;
                    Shift[] shifts1;
                    boolean employee1Violations;
                    boolean coverViolations;
                    block169: {
                        int x4;
                        block167: {
                            if (!this.EmployeeDescriptionHasFrozenDays[employee1.EmployeeDescription.IndexID]) break block167;
                            boolean frozen = false;
                            x4 = 0;
                            while (x4 < blockSize) {
                                if (employee1.EmployeeDescription.FrozenDay[day + x4]) {
                                    frozen = true;
                                    break;
                                }
                                ++x4;
                            }
                            if (frozen) break block168;
                        }
                        coverViolations = false;
                        x4 = 0;
                        while (x4 < blockSize) {
                            if (roster.CoverPenOnDay[day + x4] > 0) {
                                coverViolations = true;
                                break;
                            }
                            ++x4;
                        }
                        employee1Violations = false;
                        if (this.VIOLATION_FLAG_HEURISTIC) {
                            int x5 = 0;
                            while (x5 < blockSize) {
                                if (employee1.ConstraintViolationPenalties[day + x5] > 0) {
                                    employee1Violations = true;
                                    break;
                                }
                                ++x5;
                            }
                        }
                        shifts1 = new Shift[blockSize];
                        if (!this.SchedulingPeriodContainsNonAutoAssignShifts) break block169;
                        boolean fixedShift = false;
                        int x6 = 0;
                        while (x6 < blockSize) {
                            Shift s = employee1.GetShift(day + x6);
                            if (s != null && s.isFixed()) {
                                fixedShift = true;
                                break;
                            }
                            ++x6;
                        }
                        if (fixedShift) break block168;
                    }
                    if ((coverViolations || employee1.Penalty != 0) && (!this.VIOLATION_FLAG_HEURISTIC || coverViolations || employee1Violations)) {
                        roster.CacheEmployeePenalties(penaltyCachePos, this.cacheViolationPens);
                        x3 = 0;
                        while (x3 < blockSize) {
                            shifts1[x3] = employee1.GetShift(day + x3);
                            if (shifts1[x3] != null) {
                                roster.UnAssignShift(shifts1[x3]);
                                this.currentRosterHash ^= this.hashRandomValues[employee1.Index][day + x3][shifts1[x3].ShiftType.Index];
                            }
                            ++x3;
                        }
                        roster.CoverPenalty += roster.UpdateCoverPens(shifts1);
                        int k = -1;
                        while (k < roster.SchedulingPeriod.ShiftTypesCount) {
                            Shift[] shifts2 = new Shift[blockSize];
                            if (!this.SchedulingPeriodContainsNonAutoAssignShifts || k < 0 || roster.SchedulingPeriod.GetShiftType((int)k).AutoAllocate) {
                                boolean madePreviously = false;
                                d = 0;
                                while (d < currentDepth - 1) {
                                    if (this.movesMade[d][4] == 3 && this.movesMade[d][2] == day && this.movesMade[d][3] == blockSize && this.movesMade[d][0] == employee1.Index && this.movesMade[d][5] == k) {
                                        madePreviously = true;
                                        break;
                                    }
                                    ++d;
                                }
                                if (!madePreviously) {
                                    boolean different = false;
                                    x2 = 0;
                                    while (x2 < blockSize) {
                                        if (k < 0) {
                                            shifts2[x2] = null;
                                            if (shifts1[x2] != null) {
                                                different = true;
                                            }
                                        } else {
                                            shifts2[x2] = this.GetTestShift(k, day + x2);
                                            if (shifts1[x2] == null || shifts1[x2].ShiftType.Index != k) {
                                                different = true;
                                            }
                                        }
                                        ++x2;
                                    }
                                    if (!(!different || shifts1[0] == null && shifts2[0] == null || shifts1[blockSize - 1] == null && shifts2[blockSize - 1] == null)) {
                                        boolean valid = true;
                                        x = 0;
                                        while (x < blockSize) {
                                            if (employee1.ViolationsForAssigningShift(shifts2[x]) == -1) {
                                                valid = false;
                                                break;
                                            }
                                            ++x;
                                        }
                                        if (valid) {
                                            int x7;
                                            roster.CacheEmployeePenalties(penaltyCachePos + 1, this.cacheViolationPens);
                                            if (k >= 0) {
                                                x = 0;
                                                while (x < blockSize) {
                                                    roster.AssignShift(employee1, shifts2[x]);
                                                    this.currentRosterHash ^= this.hashRandomValues[employee1.Index][day + x][k];
                                                    ++x;
                                                }
                                                employee1.Roster.CoverPenalty += employee1.Roster.UpdateCoverPens(shifts2);
                                            }
                                            if (moveFound) {
                                                employee1.RecalculatePenalty(bestPenalty, day, day + blockSize - 1, false);
                                            } else {
                                                employee1.RecalculatePenalty(day, day + blockSize - 1, false);
                                            }
                                            ++this.TotalEvaluations;
                                            boolean validSwap = false;
                                            int nextImprovement = -1;
                                            if (roster.getTotalPenalty() < originalPenalty) {
                                                validSwap = true;
                                                nextImprovement = 0;
                                            } else {
                                                int nextHash;
                                                int e1Change = roster.EmployeesPenalty - currentEmployeesPenalty;
                                                int covChange = roster.CoverPenalty - currentCoverPenalty;
                                                if (currentTotalPenalty + e1Change < originalPenalty) {
                                                    int hash = this.currentRosterHash;
                                                    int d2 = 0;
                                                    while (d2 < roster.SchedulingPeriod.NumDaysInPeriod) {
                                                        if (roster.CoverPenOnDay[d2] > originalCoverPenOnDay[d2]) {
                                                            hash ^= this.hashDaysRandVals[d2];
                                                        }
                                                        ++d2;
                                                    }
                                                    if (!this.PreviouslyTested(hash)) {
                                                        validSwap = true;
                                                        nextImprovement = 2;
                                                    }
                                                } else if (currentTotalPenalty + covChange < originalPenalty && !this.PreviouslyTested(nextHash = this.currentRosterHash ^ this.hashEmployeeRandVals[employee1.Index])) {
                                                    validSwap = true;
                                                    nextImprovement = 1;
                                                }
                                            }
                                            if (validSwap && (!moveFound || roster.getTotalPenalty() < bestPenalty)) {
                                                moveFound = true;
                                                bestPenalty = roster.getTotalPenalty();
                                                bestDay = day;
                                                bestNextImprovement = nextImprovement;
                                                bestSwapType = 3;
                                                nextEmployee = employee1;
                                                bestShifts1 = new Shift[blockSize];
                                                bestShifts2 = new Shift[blockSize];
                                                x7 = 0;
                                                while (x7 < blockSize) {
                                                    bestShifts1[x7] = shifts1[x7];
                                                    bestShifts2[x7] = shifts2[x7];
                                                    ++x7;
                                                }
                                            }
                                            if (k >= 0) {
                                                x7 = 0;
                                                while (x7 < blockSize) {
                                                    roster.UnAssignShift(shifts2[x7]);
                                                    this.currentRosterHash ^= this.hashRandomValues[employee1.Index][day + x7][k];
                                                    ++x7;
                                                }
                                                roster.CoverPenalty += roster.UpdateCoverPens(shifts2);
                                            }
                                            roster.RestoreEmployeePenalties(penaltyCachePos + 1, this.cacheViolationPens);
                                        }
                                    }
                                }
                            }
                            ++k;
                        }
                        x3 = 0;
                        while (x3 < blockSize) {
                            if (shifts1[x3] != null) {
                                roster.AssignShift(employee1, shifts1[x3]);
                                this.currentRosterHash ^= this.hashRandomValues[employee1.Index][day + x3][shifts1[x3].ShiftType.Index];
                            }
                            ++x3;
                        }
                        roster.CoverPenalty += roster.UpdateCoverPens(shifts1);
                        roster.RestoreEmployeePenalties(penaltyCachePos, this.cacheViolationPens);
                    }
                    shifts1 = new Shift[blockSize];
                    roster.CacheEmployeePenalties(penaltyCachePos, this.cacheViolationPens);
                    x3 = 0;
                    while (x3 < blockSize) {
                        shifts1[x3] = employee1.GetShift(day + x3);
                        if (shifts1[x3] != null) {
                            roster.UnAssignShift(shifts1[x3]);
                            this.currentRosterHash ^= this.hashRandomValues[employee1.Index][day + x3][shifts1[x3].ShiftType.Index];
                        }
                        ++x3;
                    }
                    roster.CoverPenalty += roster.UpdateCoverPens(shifts1);
                    int j = 0;
                    while (j < roster.Employees.length) {
                        block170: {
                            int x8;
                            Shift[] shifts2;
                            Employee employee2;
                            block172: {
                                block171: {
                                    employee2 = roster.Employees[j];
                                    if (employee1 == employee2 || employee1.Penalty == 0 && employee2.Penalty == 0 && !coverViolations) break block170;
                                    if (!this.EmployeeDescriptionHasFrozenDays[employee2.EmployeeDescription.IndexID]) break block171;
                                    boolean frozen = false;
                                    x2 = 0;
                                    while (x2 < blockSize) {
                                        if (employee2.EmployeeDescription.FrozenDay[day + x2]) {
                                            frozen = true;
                                            break;
                                        }
                                        ++x2;
                                    }
                                    if (frozen) break block170;
                                }
                                boolean madePreviously = false;
                                d = 0;
                                while (d < currentDepth - 1) {
                                    if (this.movesMade[d][4] == 4 && this.movesMade[d][2] == day && this.movesMade[d][3] == blockSize && (this.movesMade[d][0] == employee1.Index && this.movesMade[d][1] == employee2.Index || this.movesMade[d][0] == employee2.Index && this.movesMade[d][1] == employee1.Index)) {
                                        madePreviously = true;
                                        break;
                                    }
                                    ++d;
                                }
                                if (madePreviously) break block170;
                                shifts2 = new Shift[blockSize];
                                boolean employee2Violations = false;
                                x = 0;
                                while (x < blockSize) {
                                    shifts2[x] = employee2.GetShift(day + x);
                                    if (employee2.ConstraintViolationPenalties[day + x] > 0) {
                                        employee2Violations = true;
                                    }
                                    ++x;
                                }
                                if (this.VIOLATION_FLAG_HEURISTIC && !coverViolations && !employee1Violations && !employee2Violations) break block170;
                                if (!this.SchedulingPeriodContainsNonAutoAssignShifts) break block172;
                                boolean fixedShifts = false;
                                x8 = 0;
                                while (x8 < blockSize) {
                                    if (shifts2[x8] != null && shifts2[x8].isFixed()) {
                                        fixedShifts = true;
                                        break;
                                    }
                                    ++x8;
                                }
                                if (fixedShifts) break block170;
                            }
                            if (!(shifts1[0] == null && shifts2[0] == null || shifts1[blockSize - 1] == null && shifts2[blockSize - 1] == null)) {
                                x = 0;
                                while (x < blockSize) {
                                    if (shifts2[x] != null) {
                                        roster.UnAssignShift(shifts2[x]);
                                        this.currentRosterHash ^= this.hashRandomValues[j][day + x][shifts2[x].ShiftType.Index];
                                    }
                                    ++x;
                                }
                                roster.CoverPenalty += roster.UpdateCoverPens(shifts2);
                                boolean valid = true;
                                x8 = 0;
                                while (x8 < blockSize) {
                                    if (employee2.ViolationsForAssigningShift(shifts1[x8]) == -1 || employee1.ViolationsForAssigningShift(shifts2[x8]) == -1) {
                                        valid = false;
                                        break;
                                    }
                                    ++x8;
                                }
                                if (valid) {
                                    int x9;
                                    roster.CacheEmployeePenalties(penaltyCachePos + 1, this.cacheViolationPens);
                                    x8 = 0;
                                    while (x8 < blockSize) {
                                        if (shifts1[x8] != null) {
                                            roster.AssignShift(employee2, shifts1[x8]);
                                            this.currentRosterHash ^= this.hashRandomValues[j][day + x8][shifts1[x8].ShiftType.Index];
                                        }
                                        if (shifts2[x8] != null) {
                                            roster.AssignShift(employee1, shifts2[x8]);
                                            this.currentRosterHash ^= this.hashRandomValues[employee1.Index][day + x8][shifts2[x8].ShiftType.Index];
                                        }
                                        ++x8;
                                    }
                                    roster.CoverPenalty += roster.UpdateCoverPens(shifts2);
                                    roster.CoverPenalty += roster.UpdateCoverPens(shifts1);
                                    int covChange = roster.CoverPenalty - currentCoverPenalty;
                                    int tempPen = roster.getTotalPenalty();
                                    if (moveFound) {
                                        employee1.RecalculatePenalty(bestPenalty + employee2.Penalty, day, day + blockSize - 1, false);
                                    } else {
                                        employee1.RecalculatePenalty(day, day + blockSize - 1, false);
                                    }
                                    int e1Change = roster.getTotalPenalty() - tempPen;
                                    int tempPen2 = roster.getTotalPenalty();
                                    if (moveFound) {
                                        employee2.RecalculatePenalty(bestPenalty, day, day + blockSize - 1, false);
                                    } else {
                                        employee2.RecalculatePenalty(day, day + blockSize - 1, false);
                                    }
                                    int e2Change = roster.getTotalPenalty() - tempPen2;
                                    ++this.TotalEvaluations;
                                    boolean validMove = false;
                                    Employee possibleEmployee = null;
                                    int nextImprovement = -1;
                                    if (roster.getTotalPenalty() < originalPenalty) {
                                        validMove = true;
                                        nextImprovement = -1;
                                    } else {
                                        int penIgnoringE1 = currentTotalPenalty + e2Change + covChange;
                                        int penIgnoringE2 = currentTotalPenalty + e1Change + covChange;
                                        int penIgnoringCov = currentTotalPenalty + e1Change + e2Change;
                                        int lowest1 = 0;
                                        int lowest2 = 0;
                                        int lowest3 = 0;
                                        Employee possibleEmployee1 = null;
                                        int nextImprovement1 = 0;
                                        Employee possibleEmployee2 = null;
                                        int nextImprovement2 = 0;
                                        Employee possibleEmployee3 = null;
                                        int nextImprovement3 = 0;
                                        if (penIgnoringCov <= penIgnoringE1 && penIgnoringCov <= penIgnoringE2) {
                                            lowest1 = penIgnoringCov;
                                            nextImprovement1 = 2;
                                            if (penIgnoringE1 <= penIgnoringE2) {
                                                lowest2 = penIgnoringE1;
                                                nextImprovement2 = 1;
                                                possibleEmployee2 = employee1;
                                                lowest3 = penIgnoringE2;
                                                nextImprovement3 = 1;
                                                possibleEmployee3 = employee2;
                                            } else {
                                                lowest2 = penIgnoringE2;
                                                nextImprovement2 = 1;
                                                possibleEmployee2 = employee2;
                                                lowest3 = penIgnoringE1;
                                                nextImprovement3 = 1;
                                                possibleEmployee3 = employee1;
                                            }
                                        } else if (penIgnoringE1 <= penIgnoringCov && penIgnoringE1 <= penIgnoringE2) {
                                            lowest1 = penIgnoringE1;
                                            nextImprovement1 = 1;
                                            possibleEmployee1 = employee1;
                                            if (penIgnoringCov <= penIgnoringE2) {
                                                lowest2 = penIgnoringCov;
                                                nextImprovement2 = 2;
                                                lowest3 = penIgnoringE2;
                                                nextImprovement3 = 1;
                                                possibleEmployee3 = employee2;
                                            } else {
                                                lowest2 = penIgnoringE2;
                                                nextImprovement2 = 1;
                                                possibleEmployee2 = employee2;
                                                lowest3 = penIgnoringCov;
                                                nextImprovement3 = 2;
                                            }
                                        } else if (penIgnoringE2 <= penIgnoringCov && penIgnoringE2 <= penIgnoringE1) {
                                            lowest1 = penIgnoringE2;
                                            nextImprovement1 = 1;
                                            possibleEmployee1 = employee2;
                                            if (penIgnoringCov <= penIgnoringE1) {
                                                lowest2 = penIgnoringCov;
                                                nextImprovement2 = 2;
                                                lowest3 = penIgnoringE1;
                                                nextImprovement3 = 1;
                                                possibleEmployee3 = employee1;
                                            } else {
                                                lowest2 = penIgnoringE1;
                                                nextImprovement2 = 1;
                                                possibleEmployee2 = employee1;
                                                lowest3 = penIgnoringCov;
                                                nextImprovement3 = 2;
                                            }
                                        }
                                        if (this.isValidMove(lowest1, nextImprovement1, possibleEmployee1, originalPenalty, roster, originalCoverPenOnDay)) {
                                            validMove = true;
                                            nextImprovement = nextImprovement1;
                                            possibleEmployee = possibleEmployee1;
                                        } else if (this.isValidMove(lowest2, nextImprovement2, possibleEmployee2, originalPenalty, roster, originalCoverPenOnDay)) {
                                            validMove = true;
                                            nextImprovement = nextImprovement2;
                                            possibleEmployee = possibleEmployee2;
                                        } else if (this.isValidMove(lowest3, nextImprovement3, possibleEmployee3, originalPenalty, roster, originalCoverPenOnDay)) {
                                            validMove = true;
                                            nextImprovement = nextImprovement3;
                                            possibleEmployee = possibleEmployee3;
                                        }
                                    }
                                    if (validMove && (!moveFound || roster.getTotalPenalty() < bestPenalty)) {
                                        moveFound = true;
                                        bestPenalty = roster.getTotalPenalty();
                                        bestDay = day;
                                        nextEmployee = possibleEmployee;
                                        bestEmployee2 = employee2;
                                        bestSwapType = 4;
                                        bestNextImprovement = nextImprovement;
                                        bestShifts1 = new Shift[blockSize];
                                        bestShifts2 = new Shift[blockSize];
                                        x9 = 0;
                                        while (x9 < blockSize) {
                                            bestShifts1[x9] = shifts1[x9];
                                            bestShifts2[x9] = shifts2[x9];
                                            ++x9;
                                        }
                                    }
                                    x9 = 0;
                                    while (x9 < blockSize) {
                                        if (shifts1[x9] != null) {
                                            roster.UnAssignShift(shifts1[x9]);
                                            this.currentRosterHash ^= this.hashRandomValues[j][day + x9][shifts1[x9].ShiftType.Index];
                                        }
                                        if (shifts2[x9] != null) {
                                            roster.UnAssignShift(shifts2[x9]);
                                            this.currentRosterHash ^= this.hashRandomValues[employee1.Index][day + x9][shifts2[x9].ShiftType.Index];
                                        }
                                        ++x9;
                                    }
                                    roster.CoverPenalty += roster.UpdateCoverPens(shifts1);
                                    roster.CoverPenalty += roster.UpdateCoverPens(shifts2);
                                    roster.RestoreEmployeePenalties(penaltyCachePos + 1, this.cacheViolationPens);
                                }
                                x8 = 0;
                                while (x8 < blockSize) {
                                    if (shifts2[x8] != null) {
                                        roster.AssignShift(employee2, shifts2[x8]);
                                        this.currentRosterHash ^= this.hashRandomValues[j][day + x8][shifts2[x8].ShiftType.Index];
                                    }
                                    ++x8;
                                }
                                roster.CoverPenalty += roster.UpdateCoverPens(shifts2);
                            }
                        }
                        ++j;
                    }
                    x3 = 0;
                    while (x3 < blockSize) {
                        if (shifts1[x3] != null) {
                            roster.AssignShift(employee1, shifts1[x3]);
                            this.currentRosterHash ^= this.hashRandomValues[employee1.Index][day + x3][shifts1[x3].ShiftType.Index];
                        }
                        ++x3;
                    }
                    roster.CoverPenalty += roster.UpdateCoverPens(shifts1);
                    roster.RestoreEmployeePenalties(penaltyCachePos, this.cacheViolationPens);
                    if (this.Stopped) {
                        return false;
                    }
                }
                ++day;
            }
            ++blockSize;
        }
        boolean[] bestPattern = null;
        if (this.TEST_PATTERNS_DURING_IMPROVE_EMPLOYEE && (bestPattern = this.TestPatternsHeuristically(employee1, bestPenalty, moveFound, originalPenalty, penaltyCachePos)) != null) {
            moveFound = true;
            bestSwapType = 5;
            bestNextImprovement = 2;
        }
        if (moveFound) {
            int blockSize2;
            boolean moveMade = false;
            Shift[] shifts2 = null;
            int day = bestDay;
            Shift[] initialShifts = null;
            if (bestSwapType == 3) {
                int shiftIndex;
                blockSize2 = bestShifts1.length;
                roster.CacheEmployeePenalties(penaltyCachePos, this.cacheViolationPens);
                int x = 0;
                while (x < blockSize2) {
                    if (bestShifts1[x] != null) {
                        roster.UnAssignShift((Shift)bestShifts1[x]);
                        this.currentRosterHash ^= this.hashRandomValues[employee1.Index][day + x][bestShifts1[x].ShiftType.Index];
                    }
                    ++x;
                }
                roster.CoverPenalty += roster.UpdateCoverPens(bestShifts1);
                shifts2 = new Shift[blockSize2];
                if (bestShifts2[0] != null) {
                    shiftIndex = bestShifts2[0].ShiftType.Index;
                    x = 0;
                    while (x < blockSize2) {
                        shifts2[x] = this.GetShift(bestShifts2[x].ShiftType.Index, day + x);
                        roster.AssignShift(employee1, shifts2[x]);
                        this.currentRosterHash ^= this.hashRandomValues[employee1.Index][day + x][shifts2[x].ShiftType.Index];
                        ++x;
                    }
                    employee1.Roster.CoverPenalty += employee1.Roster.UpdateCoverPens(shifts2);
                    employee1.RecalculatePenalty(day, day + blockSize2 - 1, true);
                } else {
                    shiftIndex = -1;
                    employee1.RecalculatePenalty(day, day + blockSize2 - 1, true);
                }
                if (this.updateViolationFlags && employee1.EmployeeDescription.Contract != null && employee1.EmployeeDescription.Contract.BadPatternsIsOn) {
                    employee1.RecalculatePenalty();
                }
                this.movesMade[currentDepth - 1][4] = 3;
                this.movesMade[currentDepth - 1][0] = employee1.Index;
                this.movesMade[currentDepth - 1][2] = day;
                this.movesMade[currentDepth - 1][3] = blockSize2;
                this.movesMade[currentDepth - 1][5] = shiftIndex;
            } else if (bestSwapType == 4) {
                blockSize2 = bestShifts1.length;
                Employee employee2 = bestEmployee2;
                roster.CacheEmployeePenalties(penaltyCachePos, this.cacheViolationPens);
                int x = 0;
                while (x < blockSize2) {
                    if (bestShifts1[x] != null) {
                        roster.UnAssignShift((Shift)bestShifts1[x]);
                        this.currentRosterHash ^= this.hashRandomValues[employee1.Index][day + x][bestShifts1[x].ShiftType.Index];
                    }
                    if (bestShifts2[x] != null) {
                        roster.UnAssignShift((Shift)bestShifts2[x]);
                        this.currentRosterHash ^= this.hashRandomValues[employee2.Index][day + x][bestShifts2[x].ShiftType.Index];
                    }
                    ++x;
                }
                roster.CoverPenalty += roster.UpdateCoverPens(bestShifts1);
                roster.CoverPenalty += roster.UpdateCoverPens(bestShifts2);
                x = 0;
                while (x < blockSize2) {
                    if (bestShifts1[x] != null) {
                        roster.AssignShift(employee2, (Shift)bestShifts1[x]);
                        this.currentRosterHash ^= this.hashRandomValues[employee2.Index][day + x][bestShifts1[x].ShiftType.Index];
                    }
                    if (bestShifts2[x] != null) {
                        roster.AssignShift(employee1, (Shift)bestShifts2[x]);
                        this.currentRosterHash ^= this.hashRandomValues[employee1.Index][day + x][bestShifts2[x].ShiftType.Index];
                    }
                    ++x;
                }
                roster.CoverPenalty += roster.UpdateCoverPens(bestShifts1);
                roster.CoverPenalty += roster.UpdateCoverPens(bestShifts2);
                employee1.Roster.CoverPenalty += employee1.Roster.UpdateCoverPens(bestShifts2);
                employee1.RecalculatePenalty(day, day + blockSize2 - 1, true);
                employee2.Roster.CoverPenalty += employee2.Roster.UpdateCoverPens(bestShifts1);
                employee2.RecalculatePenalty(day, day + blockSize2 - 1, true);
                if (this.updateViolationFlags) {
                    if (employee1.EmployeeDescription.Contract != null && employee1.EmployeeDescription.Contract.BadPatternsIsOn) {
                        employee1.RecalculatePenalty();
                    }
                    if (employee2.EmployeeDescription.Contract != null && employee2.EmployeeDescription.Contract.BadPatternsIsOn) {
                        employee2.RecalculatePenalty();
                    }
                }
                this.movesMade[currentDepth - 1][4] = 4;
                this.movesMade[currentDepth - 1][0] = employee1.Index;
                this.movesMade[currentDepth - 1][1] = employee2.Index;
                this.movesMade[currentDepth - 1][2] = day;
                this.movesMade[currentDepth - 1][3] = blockSize2;
            } else if (bestSwapType == 5) {
                roster.CacheEmployeePenalties(penaltyCachePos, this.cacheViolationPens);
                initialShifts = new Shift[employee1.ShiftsCount];
                int pos = 0;
                int d = 0;
                while (d < roster.SchedulingPeriod.NumDaysInPeriod) {
                    int j = 0;
                    while (j < roster.SchedulingPeriod.ShiftTypesCount) {
                        Shift shift = employee1.ShiftsOnDay[d][j];
                        if (shift != null) {
                            initialShifts[pos++] = shift;
                            roster.UnAssignShift(shift);
                            this.currentRosterHash ^= this.hashRandomValues[employee1.Index][d][j];
                        }
                        ++j;
                    }
                    ++d;
                }
                d = 0;
                while (d < roster.SchedulingPeriod.NumDaysInPeriod) {
                    int j = 0;
                    while (j < roster.SchedulingPeriod.ShiftTypesCount) {
                        int index = d * roster.SchedulingPeriod.ShiftTypesCount + j;
                        if (bestPattern[index]) {
                            Shift shift = this.GetShift(j, d);
                            roster.AssignShift(employee1, shift);
                            this.currentRosterHash ^= this.hashRandomValues[employee1.Index][d][j];
                        }
                        ++j;
                    }
                    ++d;
                }
                employee1.RecalculatePenalty();
                roster.CoverPenalty = roster.RecalculateCoverPenalty();
                this.movesMade[currentDepth - 1][4] = 5;
                this.movesMade[currentDepth - 1][0] = employee1.Index;
            } else {
                return false;
            }
            if (roster.getTotalPenalty() < originalPenalty) {
                moveMade = true;
            } else if (currentDepth < this.MAX_DEPTH && (!this.TIME_LIMIT || DateTime.getNow().isLessThan(this.end))) {
                if (bestNextImprovement == 2) {
                    int d;
                    boolean[] badDays = new boolean[roster.SchedulingPeriod.NumDaysInPeriod];
                    if (bestSwapType == 5) {
                        d = 0;
                        while (d < roster.SchedulingPeriod.NumDaysInPeriod) {
                            badDays[d] = true;
                            ++d;
                        }
                    } else {
                        d = 0;
                        while (d < badDays.length) {
                            if (roster.CoverPenOnDay[d] > originalCoverPenOnDay[d]) {
                                badDays[d] = true;
                            }
                            ++d;
                        }
                    }
                    moveMade = this.ImproveCover(roster, badDays, originalPenalty, currentDepth + 1, originalCoverPenalty);
                } else if (bestNextImprovement == 1) {
                    moveMade = this.ImproveEmployee(nextEmployee, originalPenalty, currentDepth + 1, originalCoverPenalty);
                }
            }
            if (moveMade) {
                return true;
            }
            if (bestSwapType == 3) {
                int blockSize3 = bestShifts1.length;
                if (shifts2[0] != null) {
                    int x = 0;
                    while (x < blockSize3) {
                        roster.UnAssignShift(shifts2[x]);
                        this.currentRosterHash ^= this.hashRandomValues[employee1.Index][day + x][shifts2[x].ShiftType.Index];
                        ++x;
                    }
                    roster.CoverPenalty += roster.UpdateCoverPens(shifts2);
                }
                int x = 0;
                while (x < blockSize3) {
                    if (bestShifts1[x] != null) {
                        roster.AssignShift(employee1, (Shift)bestShifts1[x]);
                        this.currentRosterHash ^= this.hashRandomValues[employee1.Index][day + x][bestShifts1[x].ShiftType.Index];
                    }
                    ++x;
                }
                roster.CoverPenalty += roster.UpdateCoverPens(bestShifts1);
                roster.RestoreEmployeePenalties(penaltyCachePos, this.cacheViolationPens);
                if (employee1.EmployeeDescription.Contract != null && employee1.EmployeeDescription.Contract.BadPatternsIsOn && employee1.EmployeeDescription.BadPatternConstraint != null) {
                    employee1.EmployeeDescription.BadPatternConstraint.Calculate(employee1, day, day + blockSize3 - 1);
                }
            } else if (bestSwapType == 4) {
                int blockSize4 = bestShifts1.length;
                Employee employee2 = bestEmployee2;
                int x = 0;
                while (x < blockSize4) {
                    if (bestShifts1[x] != null) {
                        roster.UnAssignShift((Shift)bestShifts1[x]);
                        this.currentRosterHash ^= this.hashRandomValues[employee2.Index][day + x][bestShifts1[x].ShiftType.Index];
                    }
                    if (bestShifts2[x] != null) {
                        roster.UnAssignShift((Shift)bestShifts2[x]);
                        this.currentRosterHash ^= this.hashRandomValues[employee1.Index][day + x][bestShifts2[x].ShiftType.Index];
                    }
                    ++x;
                }
                roster.CoverPenalty += roster.UpdateCoverPens(bestShifts1);
                roster.CoverPenalty += roster.UpdateCoverPens(bestShifts2);
                x = 0;
                while (x < blockSize4) {
                    if (bestShifts2[x] != null) {
                        roster.AssignShift(employee2, (Shift)bestShifts2[x]);
                        this.currentRosterHash ^= this.hashRandomValues[employee2.Index][day + x][bestShifts2[x].ShiftType.Index];
                    }
                    if (bestShifts1[x] != null) {
                        roster.AssignShift(employee1, (Shift)bestShifts1[x]);
                        this.currentRosterHash ^= this.hashRandomValues[employee1.Index][day + x][bestShifts1[x].ShiftType.Index];
                    }
                    ++x;
                }
                roster.CoverPenalty += roster.UpdateCoverPens(bestShifts1);
                roster.CoverPenalty += roster.UpdateCoverPens(bestShifts2);
                roster.RestoreEmployeePenalties(penaltyCachePos, this.cacheViolationPens);
                if (employee1.EmployeeDescription.Contract != null && employee1.EmployeeDescription.Contract.BadPatternsIsOn && employee1.EmployeeDescription.BadPatternConstraint != null) {
                    employee1.EmployeeDescription.BadPatternConstraint.Calculate(employee1, day, day + blockSize4 - 1);
                }
                if (employee2.EmployeeDescription.Contract != null && employee2.EmployeeDescription.Contract.BadPatternsIsOn && employee2.EmployeeDescription.BadPatternConstraint != null) {
                    employee2.EmployeeDescription.BadPatternConstraint.Calculate(employee2, day, day + blockSize4 - 1);
                }
            } else if (bestSwapType == 5) {
                int d = 0;
                while (d < roster.SchedulingPeriod.NumDaysInPeriod) {
                    int j = 0;
                    while (j < roster.SchedulingPeriod.ShiftTypesCount) {
                        if (employee1.ShiftsOnDay[d][j] != null) {
                            roster.UnAssignShift(employee1.ShiftsOnDay[d][j]);
                            this.currentRosterHash ^= this.hashRandomValues[employee1.Index][d][j];
                        }
                        ++j;
                    }
                    ++d;
                }
                int i = 0;
                while (i < initialShifts.length) {
                    Shift shift = initialShifts[i];
                    roster.AssignShift(employee1, shift);
                    this.currentRosterHash ^= this.hashRandomValues[employee1.Index][shift.RosterDay][shift.ShiftType.Index];
                    ++i;
                }
                roster.CoverPenalty = roster.RecalculateCoverPenalty();
                roster.RestoreEmployeePenalties(penaltyCachePos, this.cacheViolationPens);
                if (employee1.EmployeeDescription.Contract != null && employee1.EmployeeDescription.Contract.BadPatternsIsOn && employee1.EmployeeDescription.BadPatternConstraint != null) {
                    employee1.EmployeeDescription.BadPatternConstraint.Calculate(employee1);
                }
            }
            return false;
        }
        return false;
    }

    private boolean ImproveCover(Roster roster, boolean[] badDays, int originalPenalty, int currentDepth, int originalCoverPenalty) {
        int x;
        int maxBlockSize = this.NEXT_MOVE_MAX_BLOCK_SIZE;
        int penaltyCachePos = currentDepth;
        boolean moveFound = false;
        int bestPenalty = 0;
        int bestDay = 0;
        Employee nextEmployee = null;
        Shift[] bestShifts1 = null;
        Shift[] bestShifts2 = null;
        int currentTotalPenalty = roster.getTotalPenalty();
        int currentCoverPenalty = roster.CoverPenalty;
        int hash = this.currentRosterHash;
        int i = 0;
        while (i < badDays.length) {
            if (badDays[i]) {
                hash ^= this.hashDaysRandVals[i];
            }
            ++i;
        }
        this.AddHashKey(hash);
        int blockSize = 1;
        while (blockSize <= maxBlockSize) {
            int day = 0;
            while (day < roster.SchedulingPeriod.NumDaysInPeriod - blockSize + 1) {
                block62: {
                    boolean validDay = false;
                    int x2 = 0;
                    while (x2 < blockSize) {
                        if (badDays[day + x2]) {
                            validDay = true;
                            break;
                        }
                        ++x2;
                    }
                    if (!validDay) break block62;
                    int i2 = 0;
                    while (i2 < roster.Employees.length) {
                        block64: {
                            Employee employee1;
                            block65: {
                                block63: {
                                    employee1 = roster.Employees[i2];
                                    if (!this.SchedulingPeriodContainsNonAutoAssignShifts) break block63;
                                    boolean fixedShift = false;
                                    x = 0;
                                    while (x < blockSize) {
                                        Shift s = employee1.GetShift(day + x);
                                        if (s != null && s.isFixed()) {
                                            fixedShift = true;
                                            break;
                                        }
                                        ++x;
                                    }
                                    if (fixedShift) break block64;
                                }
                                if (!this.EmployeeDescriptionHasFrozenDays[employee1.EmployeeDescription.IndexID]) break block65;
                                boolean frozen = false;
                                x = 0;
                                while (x < blockSize) {
                                    if (employee1.EmployeeDescription.FrozenDay[day + x]) {
                                        frozen = true;
                                        break;
                                    }
                                    ++x;
                                }
                                if (frozen) break block64;
                            }
                            Shift[] shifts1 = new Shift[blockSize];
                            roster.CacheEmployeePenalties(penaltyCachePos, this.cacheViolationPens);
                            x = 0;
                            while (x < blockSize) {
                                shifts1[x] = employee1.GetShift(day + x);
                                if (shifts1[x] != null) {
                                    roster.UnAssignShift(shifts1[x]);
                                    this.currentRosterHash ^= this.hashRandomValues[employee1.Index][day + x][shifts1[x].ShiftType.Index];
                                }
                                ++x;
                            }
                            roster.CoverPenalty += roster.UpdateCoverPens(shifts1);
                            int k = -1;
                            while (k < roster.SchedulingPeriod.ShiftTypesCount) {
                                if (!this.SchedulingPeriodContainsNonAutoAssignShifts || k < 0 || roster.SchedulingPeriod.GetShiftType((int)k).AutoAllocate) {
                                    Shift[] shifts2 = new Shift[blockSize];
                                    boolean madePreviously = false;
                                    int d = 0;
                                    while (d < currentDepth - 1) {
                                        if (this.movesMade[d][4] == 3 && this.movesMade[d][2] == day && this.movesMade[d][3] == blockSize && this.movesMade[d][0] == employee1.Index && this.movesMade[d][5] == k) {
                                            madePreviously = true;
                                            break;
                                        }
                                        ++d;
                                    }
                                    if (!madePreviously) {
                                        boolean different = false;
                                        int x3 = 0;
                                        while (x3 < blockSize) {
                                            if (k < 0) {
                                                shifts2[x3] = null;
                                                if (shifts1[x3] != null) {
                                                    different = true;
                                                }
                                            } else {
                                                shifts2[x3] = this.GetTestShift(k, day + x3);
                                                if (shifts1[x3] == null || shifts1[x3].ShiftType.Index != k) {
                                                    different = true;
                                                }
                                            }
                                            ++x3;
                                        }
                                        if (different) {
                                            boolean valid = true;
                                            int x4 = 0;
                                            while (x4 < blockSize) {
                                                if (employee1.ViolationsForAssigningShift(shifts2[x4]) == -1) {
                                                    valid = false;
                                                    break;
                                                }
                                                ++x4;
                                            }
                                            if (valid) {
                                                int x5;
                                                roster.CacheEmployeePenalties(penaltyCachePos + 1, this.cacheViolationPens);
                                                if (k >= 0) {
                                                    x4 = 0;
                                                    while (x4 < blockSize) {
                                                        roster.AssignShift(employee1, shifts2[x4]);
                                                        this.currentRosterHash ^= this.hashRandomValues[employee1.Index][day + x4][k];
                                                        ++x4;
                                                    }
                                                    if (moveFound) {
                                                        employee1.Roster.CoverPenalty += employee1.Roster.UpdateCoverPens(shifts2);
                                                        employee1.RecalculatePenalty(bestPenalty, day, day + blockSize - 1, false);
                                                    } else {
                                                        employee1.Roster.CoverPenalty += employee1.Roster.UpdateCoverPens(shifts2);
                                                        employee1.RecalculatePenalty(day, day + blockSize - 1, false);
                                                    }
                                                } else if (moveFound) {
                                                    employee1.RecalculatePenalty(bestPenalty, day, day + blockSize - 1, false);
                                                } else {
                                                    employee1.RecalculatePenalty(day, day + blockSize - 1, false);
                                                }
                                                ++this.TotalEvaluations;
                                                boolean validSwap = false;
                                                if (roster.getTotalPenalty() < originalPenalty) {
                                                    validSwap = true;
                                                } else {
                                                    int nextHash;
                                                    int covChange = roster.CoverPenalty - currentCoverPenalty;
                                                    if (currentTotalPenalty + covChange < originalPenalty && !this.PreviouslyTested(nextHash = this.currentRosterHash ^ this.hashEmployeeRandVals[employee1.Index])) {
                                                        validSwap = true;
                                                    }
                                                }
                                                if (validSwap && (!moveFound || roster.getTotalPenalty() < bestPenalty)) {
                                                    moveFound = true;
                                                    bestPenalty = roster.getTotalPenalty();
                                                    bestDay = day;
                                                    nextEmployee = employee1;
                                                    bestShifts1 = new Shift[blockSize];
                                                    bestShifts2 = new Shift[blockSize];
                                                    x5 = 0;
                                                    while (x5 < blockSize) {
                                                        bestShifts1[x5] = shifts1[x5];
                                                        bestShifts2[x5] = shifts2[x5];
                                                        ++x5;
                                                    }
                                                }
                                                if (k >= 0) {
                                                    x5 = 0;
                                                    while (x5 < blockSize) {
                                                        roster.UnAssignShift(shifts2[x5]);
                                                        this.currentRosterHash ^= this.hashRandomValues[employee1.Index][day + x5][k];
                                                        ++x5;
                                                    }
                                                    roster.CoverPenalty += roster.UpdateCoverPens(shifts2);
                                                }
                                                roster.RestoreEmployeePenalties(penaltyCachePos + 1, this.cacheViolationPens);
                                            }
                                        }
                                    }
                                }
                                ++k;
                            }
                            x = 0;
                            while (x < blockSize) {
                                if (shifts1[x] != null) {
                                    roster.AssignShift(employee1, shifts1[x]);
                                    this.currentRosterHash ^= this.hashRandomValues[employee1.Index][day + x][shifts1[x].ShiftType.Index];
                                }
                                ++x;
                            }
                            roster.CoverPenalty += roster.UpdateCoverPens(shifts1);
                            roster.RestoreEmployeePenalties(penaltyCachePos, this.cacheViolationPens);
                            if (this.Stopped) {
                                return false;
                            }
                        }
                        ++i2;
                    }
                }
                ++day;
            }
            ++blockSize;
        }
        if (moveFound) {
            int shiftIndex;
            boolean moveMade = false;
            Shift[] shifts2 = null;
            int blockSize2 = bestShifts1.length;
            Employee employee1 = nextEmployee;
            int day = bestDay;
            roster.CacheEmployeePenalties(penaltyCachePos, this.cacheViolationPens);
            int x6 = 0;
            while (x6 < blockSize2) {
                if (bestShifts1[x6] != null) {
                    roster.UnAssignShift((Shift)bestShifts1[x6]);
                    this.currentRosterHash ^= this.hashRandomValues[employee1.Index][day + x6][bestShifts1[x6].ShiftType.Index];
                }
                ++x6;
            }
            roster.CoverPenalty += roster.UpdateCoverPens(bestShifts1);
            shifts2 = new Shift[blockSize2];
            if (bestShifts2[0] != null) {
                shiftIndex = bestShifts2[0].ShiftType.Index;
                x = 0;
                while (x < blockSize2) {
                    shifts2[x] = this.GetShift(bestShifts2[x].ShiftType.Index, day + x);
                    roster.AssignShift(employee1, shifts2[x]);
                    this.currentRosterHash ^= this.hashRandomValues[employee1.Index][day + x][shifts2[x].ShiftType.Index];
                    ++x;
                }
                employee1.Roster.CoverPenalty += employee1.Roster.UpdateCoverPens(shifts2);
                employee1.RecalculatePenalty(day, day + blockSize2 - 1, true);
            } else {
                shiftIndex = -1;
                employee1.RecalculatePenalty(day, day + blockSize2 - 1, true);
            }
            if (this.updateViolationFlags && employee1.EmployeeDescription.Contract != null && employee1.EmployeeDescription.Contract.BadPatternsIsOn) {
                employee1.RecalculatePenalty();
            }
            this.movesMade[currentDepth - 1][4] = 3;
            this.movesMade[currentDepth - 1][0] = employee1.Index;
            this.movesMade[currentDepth - 1][2] = day;
            this.movesMade[currentDepth - 1][3] = blockSize2;
            this.movesMade[currentDepth - 1][5] = shiftIndex;
            if (roster.getTotalPenalty() < originalPenalty) {
                moveMade = true;
                return true;
            }
            if (currentDepth < this.MAX_DEPTH && (!this.TIME_LIMIT || DateTime.getNow().isLessThan(this.end))) {
                moveMade = this.ImproveEmployee(nextEmployee, originalPenalty, currentDepth + 1, originalCoverPenalty);
            }
            if (moveMade) {
                return true;
            }
            if (shifts2[0] != null) {
                x = 0;
                while (x < blockSize2) {
                    roster.UnAssignShift(shifts2[x]);
                    this.currentRosterHash ^= this.hashRandomValues[employee1.Index][day + x][shifts2[x].ShiftType.Index];
                    ++x;
                }
                roster.CoverPenalty += roster.UpdateCoverPens(shifts2);
            }
            x = 0;
            while (x < blockSize2) {
                if (bestShifts1[x] != null) {
                    roster.AssignShift(employee1, (Shift)bestShifts1[x]);
                    this.currentRosterHash ^= this.hashRandomValues[employee1.Index][day + x][bestShifts1[x].ShiftType.Index];
                }
                ++x;
            }
            roster.CoverPenalty += roster.UpdateCoverPens(bestShifts1);
            roster.RestoreEmployeePenalties(penaltyCachePos, this.cacheViolationPens);
            if (employee1.EmployeeDescription.Contract != null && employee1.EmployeeDescription.Contract.BadPatternsIsOn && employee1.EmployeeDescription.BadPatternConstraint != null) {
                employee1.EmployeeDescription.BadPatternConstraint.Calculate(employee1, day, day + blockSize2 - 1);
            }
            return false;
        }
        return false;
    }

    private void UpdateTitle() {
        this.Title = "VDS_B ";
        this.Title = String.valueOf(this.Title) + " MAX_DEPTH=" + this.MAX_DEPTH;
        this.Title = String.valueOf(this.Title) + ", MAX_BLOCK_SIZE_AT_DEPTH_ZERO=" + this.MAX_BLOCK_SIZE_AT_DEPTH_ZERO;
        this.Title = String.valueOf(this.Title) + ", NEXT_MOVE_MAX_BLOCK_SIZE=" + this.NEXT_MOVE_MAX_BLOCK_SIZE;
        if (this.TIME_LIMIT) {
            this.Title = String.valueOf(this.Title) + ", Max time limit ";
        }
        if (this.TEST_PATTERNS_AT_START) {
            this.Title = String.valueOf(this.Title) + ", TEST_PATTERNS_AT_START ";
        }
        if (this.POSITIVE_GAIN_HEURISTIC) {
            this.Title = String.valueOf(this.Title) + ", POSITIVE_GAIN_HEURISTIC ";
        }
        if (this.VIOLATION_FLAG_HEURISTIC) {
            this.Title = String.valueOf(this.Title) + ", VIOLATION_FLAG_HEURISTIC ";
        }
        if (this.TEST_PATTERNS_DURING_IMPROVE_EMPLOYEE) {
            this.Title = String.valueOf(this.Title) + ", TEST_PATTERNS_DURING_IMPROVE_EMPLOYEE ";
        }
    }

    private void ShuffleEmployees(Roster roster) {
        int i = 0;
        while (i < roster.Employees.length * 3) {
            int index1 = this.rand.nextInt(roster.Employees.length);
            int index2 = this.rand.nextInt(roster.Employees.length);
            Employee temp = roster.Employees[index1];
            roster.Employees[index1] = roster.Employees[index2];
            roster.Employees[index2].Index = index1;
            roster.Employees[index2] = temp;
            temp.Index = index2;
            ++i;
        }
    }

    @Override
    public Shift GetTestShift(int stIndex, int day) {
        return this.TestShifts[day][stIndex];
    }

    private int CalculateHash(Roster roster) {
        int hash = 0;
        int e = 0;
        while (e < roster.Employees.length) {
            Employee employee = roster.Employees[e];
            int day = 0;
            while (day < roster.SchedulingPeriod.NumDaysInPeriod) {
                int index = 0;
                while (index < roster.SchedulingPeriod.ShiftTypesCount) {
                    if (employee.ShiftsOnDay[day][index] != null) {
                        hash ^= this.hashRandomValues[e][day][index];
                    }
                    ++index;
                }
                ++day;
            }
            ++e;
        }
        return hash;
    }

    private void ResetHashTable(int maxSize) {
        this.HashKeyArray = new int[maxSize];
    }

    private void AddHashKey(int key) {
        int i = this.FindHashSlot(key);
        if (this.HashKeyArray[i] == 0) {
            this.HashKeyArray[i] = key;
        }
    }

    private int FindHashSlot(int key) {
        int i = key % this.HashKeyArray.length;
        while (this.HashKeyArray[i] != 0 && this.HashKeyArray[i] != key) {
            i = (i + 1) % this.HashKeyArray.length;
        }
        return i;
    }

    private boolean PreviouslyTested(int key) {
        int index = this.FindHashSlot(key);
        return this.HashKeyArray[index] != 0;
    }

    private boolean[] TestPatternsHeuristically(Employee employee, int bestPenalty, boolean moveFound, int originalPenalty, int penaltyCachePos) {
        Roster roster = employee.Roster;
        int currentTotalPenalty = roster.getTotalPenalty();
        int currentEmployeesPenalty = roster.EmployeesPenalty;
        boolean[] bestPattern = null;
        boolean[] requestsPattern = null;
        Shift[] initialShifts = new Shift[employee.ShiftsCount];
        int emptyPatternHash = this.currentRosterHash;
        int e = employee.Index;
        int pos = 0;
        int day = 0;
        while (day < roster.SchedulingPeriod.NumDaysInPeriod) {
            int index = 0;
            while (index < roster.SchedulingPeriod.ShiftTypesCount) {
                Shift shift = employee.ShiftsOnDay[day][index];
                if (shift != null) {
                    if (shift.ShiftType.AutoAllocate && !employee.EmployeeDescription.FrozenDay[day]) {
                        roster.UnAssignShift(shift);
                    }
                    initialShifts[pos++] = shift;
                    emptyPatternHash ^= this.hashRandomValues[e][day][index];
                }
                ++index;
            }
            ++day;
        }
        roster.CoverPenalty = roster.RecalculateCoverPenalty();
        this.SatisfyRequests(employee);
        if (this.SATISFY_WEEKENDS) {
            this.SatisfyWeekends(employee, true, penaltyCachePos + 1);
        }
        employee.RecalculatePenalty();
        roster.CacheEmployeePenalties(penaltyCachePos + 1, this.cacheViolationPens);
        int i = 1;
        while (i <= this.TEST_PATTERNS_MAX_ATTEMPTS) {
            if (requestsPattern == null) {
                requestsPattern = new boolean[employee.ShiftAssignments.length];
                System.arraycopy(employee.ShiftAssignments, 0, requestsPattern, 0, employee.ShiftAssignments.length);
            } else {
                int day2 = 0;
                while (day2 < roster.SchedulingPeriod.NumDaysInPeriod) {
                    int x = 0;
                    while (x < roster.SchedulingPeriod.ShiftTypesCount) {
                        int index = day2 * roster.SchedulingPeriod.ShiftTypesCount + x;
                        if (requestsPattern[index]) {
                            Shift shift = this.GetShift(x, day2);
                            roster.AssignShift(employee, shift);
                        }
                        ++x;
                    }
                    ++day2;
                }
                roster.RestoreEmployeePenalties(penaltyCachePos + 1, this.cacheViolationPens);
                roster.CoverPenalty = roster.RecalculateCoverPenalty();
            }
            this.ConstructPattern(employee, i, true, penaltyCachePos + 2);
            if (this.VERBOSE) {
                System.out.println("CnstrctPttrn :: Emp: " + employee.EmployeeDescription.LastName + " Attempt: " + i + " EmpPen: " + employee.Penalty + " TotPen=" + roster.getTotalPenalty() + " CovPen=" + roster.CoverPenalty);
            }
            boolean valid = false;
            int e1Change = roster.EmployeesPenalty - currentEmployeesPenalty;
            if (roster.getTotalPenalty() < originalPenalty || currentTotalPenalty + e1Change < originalPenalty) {
                valid = true;
            }
            if (valid && (!moveFound || roster.getTotalPenalty() < bestPenalty)) {
                int tempHash = emptyPatternHash;
                int day3 = 0;
                while (day3 < roster.SchedulingPeriod.NumDaysInPeriod) {
                    int index = 0;
                    while (index < roster.SchedulingPeriod.ShiftTypesCount) {
                        if (employee.ShiftsOnDay[day3][index] != null) {
                            tempHash ^= this.hashRandomValues[e][day3][index];
                        }
                        ++index;
                    }
                    ++day3;
                }
                day3 = 0;
                while (day3 < roster.SchedulingPeriod.NumDaysInPeriod) {
                    tempHash ^= this.hashDaysRandVals[day3];
                    ++day3;
                }
                if (!this.PreviouslyTested(tempHash)) {
                    moveFound = true;
                    bestPenalty = roster.getTotalPenalty();
                    bestPattern = new boolean[employee.ShiftAssignments.length];
                    System.arraycopy(employee.ShiftAssignments, 0, bestPattern, 0, employee.ShiftAssignments.length);
                }
            }
            employee.UnAssignAllShifts();
            roster.CoverPenalty = roster.RecalculateCoverPenalty();
            ++i;
        }
        i = 0;
        while (i < initialShifts.length) {
            roster.AssignShift(employee, initialShifts[i]);
            ++i;
        }
        roster.CoverPenalty = roster.RecalculateCoverPenalty();
        employee.RecalculatePenalty();
        return bestPattern;
    }

    private void ConstructPattern(Employee employee, int maxLength, boolean calculateCoverPenalty, int cachePosition) {
        Roster roster = employee.Roster;
        int failedAttempts = 0;
        int[] shiftTypes = this.EmployeeOKshifts[employee.EmployeeDescription.IndexID];
        if (shiftTypes.length == 0) {
            return;
        }
        boolean moveFound = true;
        while (moveFound) {
            moveFound = false;
            int bestPenalty = employee.Roster.getTotalPenalty();
            Shift[] bestShifts = null;
            int i = 0;
            while (i < shiftTypes.length) {
                int shiftIndex = shiftTypes[i];
                int blockSize = 1;
                while (blockSize <= maxLength) {
                    int day = 0;
                    while (day < roster.SchedulingPeriod.NumDaysInPeriod - blockSize + 1) {
                        Shift[] shifts = new Shift[blockSize];
                        int x = 0;
                        while (x < blockSize) {
                            shifts[x] = this.GetTestShift(shiftIndex, day + x);
                            ++x;
                        }
                        boolean valid = true;
                        int x2 = 0;
                        while (x2 < shifts.length) {
                            if (employee.ViolationsForAssigningShift(shifts[x2]) == -1 || employee.EmployeeDescription.FrozenDay[day + x2]) {
                                valid = false;
                                break;
                            }
                            ++x2;
                        }
                        if (valid) {
                            roster.CacheEmployeePenalties(cachePosition, this.cacheViolationPens);
                            x2 = 0;
                            while (x2 < shifts.length) {
                                roster.AssignShift(employee, shifts[x2]);
                                ++x2;
                            }
                            if (calculateCoverPenalty) {
                                employee.Roster.CoverPenalty += employee.Roster.UpdateCoverPens(shifts);
                            }
                            employee.RecalculatePenalty(bestPenalty + 1, day, day + blockSize - 1, false);
                            ++this.TotalEvaluations;
                            if (roster.getTotalPenalty() < bestPenalty || roster.getTotalPenalty() == bestPenalty && this.rand.nextDouble() > 0.5) {
                                bestShifts = shifts;
                                bestPenalty = roster.getTotalPenalty();
                            }
                            x2 = 0;
                            while (x2 < shifts.length) {
                                roster.UnAssignShift(shifts[x2]);
                                ++x2;
                            }
                            roster.RestoreEmployeePenalties(cachePosition, this.cacheViolationPens);
                            if (calculateCoverPenalty) {
                                roster.CoverPenalty += roster.UpdateCoverPens(shifts);
                            }
                        }
                        ++day;
                    }
                    ++blockSize;
                }
                ++i;
            }
            if (bestShifts != null) {
                Shift[] shifts = new Shift[bestShifts.length];
                int x = 0;
                while (x < bestShifts.length) {
                    shifts[x] = this.GetShift(bestShifts[x].ShiftType, bestShifts[x].RosterDay);
                    Shift cfr_ignored_0 = shifts[x];
                    roster.AssignShift(employee, shifts[x]);
                    ++x;
                }
                if (calculateCoverPenalty) {
                    employee.Roster.CoverPenalty += employee.Roster.UpdateCoverPens(shifts);
                }
                employee.RecalculatePenalty();
                moveFound = true;
                continue;
            }
            ++failedAttempts;
        }
        this.n1.TotalEvaluations = 0L;
        this.n1.cachePosition = cachePosition;
        this.n1.CALCULATE_COVER_PENALTY = calculateCoverPenalty;
        this.n1.SearchSingleEmployee(employee);
        this.TotalEvaluations += this.n1.TotalEvaluations;
        this.h1.TotalEvaluations = 0L;
        this.h1.cachePosition = cachePosition;
        this.h1.CALCULATE_COVER_PENALTY = calculateCoverPenalty;
        this.h1.SearchSingleEmployee(employee);
        this.TotalEvaluations += this.h1.TotalEvaluations;
    }

    @Override
    public Shift GetShift(ShiftType st, int day) {
        if (st == null) {
            return null;
        }
        return this.GetShift(st.Index, day);
    }

    @Override
    public Shift GetShift(int stIndex, int day) {
        int i = 0;
        while (i < this.AllShifts[day][stIndex].length) {
            if (!this.AllShifts[day][stIndex][i].isAssigned()) {
                return this.AllShifts[day][stIndex][i];
            }
            ++i;
        }
        return null;
    }

    private void SatisfyRequests(Employee employee) {
        int day;
        int stc;
        Roster roster;
        if (employee.EmployeeDescription.ShiftOnRequestCount != 0) {
            roster = employee.Roster;
            stc = roster.SchedulingPeriod.ShiftTypesCount;
            day = 0;
            while (day < employee.Roster.SchedulingPeriod.NumDaysInPeriod) {
                if (!employee.EmployeeDescription.FrozenDay[day]) {
                    int i = 0;
                    while (i < stc) {
                        if (employee.EmployeeDescription.ShiftOnRequests[day * stc + i] != 0) {
                            Shift shift;
                            ShiftType st = roster.SchedulingPeriod.GetShiftType(i);
                            if (st.AutoAllocate && employee.ViolationsForAssigningShift(shift = this.GetShift(st, day)) != -1) {
                                roster.AssignShift(employee, shift);
                                roster.CoverPenalty += roster.UpdateCoverPens(new Shift[]{shift});
                                ++this.TotalEvaluations;
                            }
                        }
                        ++i;
                    }
                }
                ++day;
            }
        }
        if (employee.EmployeeDescription.ShiftGroupOnRequests != null) {
            roster = employee.Roster;
            int i = 0;
            while (i < employee.EmployeeDescription.ShiftGroupOnRequests.length) {
                day = employee.EmployeeDescription.ShiftGroupOnRequests[i].Day;
                if (!employee.EmployeeDescription.FrozenDay[day]) {
                    ShiftGroup group = employee.EmployeeDescription.ShiftGroupOnRequests[i].ShiftGroup;
                    Shift bestShift = null;
                    int bestCoverPenalty = 0;
                    int j = 0;
                    while (j < group.Group.length) {
                        Shift shift = this.GetTestShift(group.Group[j].Index, day);
                        if (shift.ShiftType.AutoAllocate && employee.ViolationsForAssigningShift(shift) != -1) {
                            roster.AssignShift(employee, shift);
                            roster.CoverPenalty += roster.UpdateCoverPens(new Shift[]{shift});
                            ++this.TotalEvaluations;
                            if (bestShift == null || roster.CoverPenalty < bestCoverPenalty) {
                                bestShift = shift;
                                bestCoverPenalty = roster.CoverPenalty;
                            }
                            roster.UnAssignShift(shift);
                            roster.CoverPenalty += roster.UpdateCoverPens(new Shift[]{shift});
                        }
                        ++j;
                    }
                    if (bestShift != null) {
                        Shift shift = this.GetShift(bestShift.ShiftType, bestShift.RosterDay);
                        roster.AssignShift(employee, shift);
                        roster.CoverPenalty += roster.UpdateCoverPens(new Shift[]{shift});
                    }
                }
                ++i;
            }
        }
        if (employee.EmployeeDescription.DayOnRequestCount != 0) {
            roster = employee.Roster;
            stc = roster.SchedulingPeriod.ShiftTypesCount;
            day = 0;
            while (day < employee.Roster.SchedulingPeriod.NumDaysInPeriod) {
                if (!employee.EmployeeDescription.FrozenDay[day] && employee.EmployeeDescription.DayOnRequests[day] != 0 && employee.DayType[day] != 1) {
                    Shift bestShift = null;
                    int bestCoverPenalty = 0;
                    int i = 0;
                    while (i < stc) {
                        Shift shift = this.GetTestShift(i, day);
                        if (shift.ShiftType.AutoAllocate && employee.ViolationsForAssigningShift(shift) != -1) {
                            roster.AssignShift(employee, shift);
                            roster.CoverPenalty += roster.UpdateCoverPens(new Shift[]{shift});
                            ++this.TotalEvaluations;
                            if (bestShift == null || roster.CoverPenalty < bestCoverPenalty) {
                                bestShift = shift;
                                bestCoverPenalty = roster.CoverPenalty;
                            }
                            roster.UnAssignShift(shift);
                            roster.CoverPenalty += roster.UpdateCoverPens(new Shift[]{shift});
                        }
                        ++i;
                    }
                    if (bestShift != null) {
                        Shift shift = this.GetShift(bestShift.ShiftType, bestShift.RosterDay);
                        roster.AssignShift(employee, shift);
                        roster.CoverPenalty += roster.UpdateCoverPens(new Shift[]{shift});
                    }
                }
                ++day;
            }
        }
    }

    private void SatisfyWeekends(Employee employee, boolean calculateCoverPenalty, int cachePosition) {
        this.CalculateWeekendsPenalty(employee, -1);
        Roster roster = employee.Roster;
        int day = 0;
        while (day < roster.SchedulingPeriod.NumDaysInPeriod) {
            if (!employee.EmployeeDescription.FrozenDay[day]) {
                Shift bestShift1 = null;
                Shift bestShift2 = null;
                int bestPenalty = roster.EmployeesPenalty;
                int i = 0;
                while (i < roster.SchedulingPeriod.ShiftTypesCount) {
                    Shift shift1 = this.GetTestShift(i, day);
                    if (shift1.ShiftType.AutoAllocate && employee.ViolationsForAssigningShift(shift1) != -1) {
                        Shift shift2;
                        roster.CacheEmployeePenalties(cachePosition, this.cacheViolationPens);
                        roster.AssignShift(employee, shift1);
                        if (calculateCoverPenalty) {
                            roster.CoverPenalty += roster.UpdateCoverPens(new Shift[]{shift1});
                        }
                        this.CalculateWeekendsPenalty(employee, -1);
                        ++this.TotalEvaluations;
                        if (roster.EmployeesPenalty < bestPenalty) {
                            bestShift1 = shift1;
                            bestPenalty = roster.EmployeesPenalty;
                        }
                        if (day + 1 < roster.SchedulingPeriod.NumDaysInPeriod && !employee.EmployeeDescription.FrozenDay[day + 1] && employee.ViolationsForAssigningShift(shift2 = this.GetTestShift(i, day + 1)) != -1 && shift2.ShiftType.AutoAllocate) {
                            roster.AssignShift(employee, shift2);
                            if (calculateCoverPenalty) {
                                roster.CoverPenalty += roster.UpdateCoverPens(new Shift[]{shift2});
                            }
                            this.CalculateWeekendsPenalty(employee, bestPenalty);
                            ++this.TotalEvaluations;
                            if (roster.EmployeesPenalty < bestPenalty) {
                                bestShift1 = shift1;
                                bestShift2 = shift2;
                                bestPenalty = roster.EmployeesPenalty;
                            }
                            roster.UnAssignShift(shift2);
                            if (calculateCoverPenalty) {
                                roster.CoverPenalty += roster.UpdateCoverPens(new Shift[]{shift2});
                            }
                        }
                        roster.UnAssignShift(shift1);
                        if (calculateCoverPenalty) {
                            roster.CoverPenalty += roster.UpdateCoverPens(new Shift[]{shift1});
                        }
                        roster.RestoreEmployeePenalties(cachePosition, this.cacheViolationPens);
                    }
                    ++i;
                }
                if (bestShift1 != null) {
                    Shift shift1 = this.GetShift(bestShift1.ShiftType, bestShift1.RosterDay);
                    roster.AssignShift(employee, shift1);
                    if (calculateCoverPenalty) {
                        roster.CoverPenalty += roster.UpdateCoverPens(new Shift[]{shift1});
                    }
                    if (bestShift2 != null) {
                        Shift shift2 = this.GetShift(bestShift2.ShiftType, bestShift2.RosterDay);
                        roster.AssignShift(employee, shift2);
                        if (calculateCoverPenalty) {
                            roster.CoverPenalty += roster.UpdateCoverPens(new Shift[]{shift2});
                        }
                    }
                    this.CalculateWeekendsPenalty(employee, -1);
                }
            }
            ++day;
        }
        day = 0;
        while (day < roster.SchedulingPeriod.NumDaysInPeriod) {
            if (!employee.EmployeeDescription.FrozenDay[day] && employee.DayType[day] == 1) {
                Shift shift = employee.GetShift(day);
                if (shift.ShiftType.AutoAllocate) {
                    int origPen = roster.EmployeesPenalty;
                    roster.CacheEmployeePenalties(cachePosition, this.cacheViolationPens);
                    roster.UnAssignShift(shift);
                    if (calculateCoverPenalty) {
                        roster.CoverPenalty += roster.UpdateCoverPens(new Shift[]{shift});
                    }
                    this.CalculateWeekendsPenalty(employee, origPen + 1);
                    ++this.TotalEvaluations;
                    if (roster.EmployeesPenalty > origPen) {
                        roster.AssignShift(employee, shift);
                        if (calculateCoverPenalty) {
                            roster.CoverPenalty += roster.UpdateCoverPens(new Shift[]{shift});
                        }
                        roster.RestoreEmployeePenalties(cachePosition, this.cacheViolationPens);
                    }
                }
            }
            ++day;
        }
    }

    public int CalculateWeekendsPenalty(Employee employee, int bestPenalty) {
        int originalPenalty = employee.Penalty;
        int newPenalty = 0;
        if (bestPenalty >= 0) {
            int diff = bestPenalty - (employee.Roster.EmployeesPenalty - originalPenalty);
            int i = 0;
            while (i < this.EmployeesWeekendConstraints[employee.EmployeeDescription.IndexID].length) {
                if ((newPenalty += this.EmployeesWeekendConstraints[employee.EmployeeDescription.IndexID][i].Calculate(employee)) < diff) {
                    ++i;
                    continue;
                }
                break;
            }
        } else {
            int i = 0;
            while (i < this.EmployeesWeekendConstraints[employee.EmployeeDescription.IndexID].length) {
                newPenalty += this.EmployeesWeekendConstraints[employee.EmployeeDescription.IndexID][i].Calculate(employee);
                ++i;
            }
        }
        employee.Roster.EmployeesPenalty = employee.Roster.EmployeesPenalty - originalPenalty + newPenalty;
        employee.Penalty = newPenalty;
        return employee.Roster.EmployeesPenalty;
    }

    public void DumpShifts(String msg, Shift[] shifts) {
        System.out.print(msg);
        int i = 0;
        while (i < shifts.length) {
            Shift s = shifts[i];
            if (s == null) {
                System.out.print("_ (_) | ");
            } else {
                System.out.print(String.valueOf(s.ShiftType.ID) + " (" + s.RosterDay + ") | ");
            }
            ++i;
        }
        System.out.println(".");
    }

    private boolean isValidMove(int lowest, int nextImprovement, Employee possibleEmployee, int originalPenalty, Roster roster, int[] originalCoverPenOnDay) {
        if (lowest >= originalPenalty) {
            return false;
        }
        boolean validMove = false;
        if (nextImprovement == 2) {
            int hash = this.currentRosterHash;
            int d = 0;
            while (d < roster.SchedulingPeriod.NumDaysInPeriod) {
                if (roster.CoverPenOnDay[d] > originalCoverPenOnDay[d]) {
                    hash ^= this.hashDaysRandVals[d];
                }
                ++d;
            }
            validMove = !this.PreviouslyTested(hash);
        } else if (nextImprovement == 1) {
            int nextHash = this.currentRosterHash ^ this.hashEmployeeRandVals[possibleEmployee.Index];
            validMove = !this.PreviouslyTested(nextHash);
        }
        return validMove;
    }

    private void ConstructRoster(Roster roster) {
        this.GuiPrint("Stage : Testing Patterns", roster);
        int noImprov = 0;
        boolean finish = false;
        block0: while (!finish) {
            int i = 0;
            while (i < roster.Employees.length) {
                this.GuiPrint("Stage : Testing Patterns", roster);
                if (this.Stopped || this.TIME_LIMIT && DateTime.getNow().isGreaterThan(this.end)) {
                    return;
                }
                Employee employee = roster.Employees[i];
                boolean[] bestPattern = this.TestPatternsHeuristically(employee, roster.getTotalPenalty(), false, roster.getTotalPenalty(), 0);
                if (bestPattern != null) {
                    int j;
                    int d = 0;
                    while (d < roster.SchedulingPeriod.NumDaysInPeriod) {
                        j = 0;
                        while (j < roster.SchedulingPeriod.ShiftTypesCount) {
                            Shift shift = employee.ShiftsOnDay[d][j];
                            if (shift != null) {
                                roster.UnAssignShift(shift);
                            }
                            ++j;
                        }
                        ++d;
                    }
                    d = 0;
                    while (d < roster.SchedulingPeriod.NumDaysInPeriod) {
                        j = 0;
                        while (j < roster.SchedulingPeriod.ShiftTypesCount) {
                            int index = d * roster.SchedulingPeriod.ShiftTypesCount + j;
                            if (bestPattern[index]) {
                                Shift shift = this.GetShift(j, d);
                                roster.AssignShift(employee, shift);
                            }
                            ++j;
                        }
                        ++d;
                    }
                    employee.RecalculatePenalty();
                    roster.CoverPenalty = roster.RecalculateCoverPenalty();
                    noImprov = 0;
                    if (roster.getTotalPenalty() == 0) {
                        return;
                    }
                } else if (++noImprov >= roster.Employees.length) {
                    finish = true;
                    continue block0;
                }
                ++i;
            }
        }
    }

    private void QuickSearch(Roster roster) {
        int startPen;
        this.GuiPrint("Stage : Quick Search", roster);
        if (this.Stopped) {
            return;
        }
        int MAX_BLOCK_SIZE = 5;
        boolean[] N_TRY_BLOCK_SIZE = new boolean[MAX_BLOCK_SIZE];
        boolean[] H_TRY_BLOCK_SIZE = new boolean[MAX_BLOCK_SIZE];
        boolean[] V_TRY_BLOCK_SIZE = new boolean[MAX_BLOCK_SIZE];
        int i = 0;
        while (i < MAX_BLOCK_SIZE) {
            V_TRY_BLOCK_SIZE[i] = true;
            H_TRY_BLOCK_SIZE[i] = true;
            N_TRY_BLOCK_SIZE[i] = true;
            ++i;
        }
        int iteration = 0;
        do {
            startPen = roster.getTotalPenalty();
            ++iteration;
            New1Emp1Swp_M n1 = new New1Emp1Swp_M(this);
            n1.TIME_LIMIT = false;
            n1.CALCULATE_COVER_PENALTY = true;
            n1.SKIP_ZERO_PENS = false;
            n1.MAX_BLOCK_SIZE = MAX_BLOCK_SIZE;
            n1.VIOLATION_HEURISTIC_THRESHOLD = 0;
            n1.RandomSeed = this.RandomSeed;
            n1.VERBOSE = false;
            n1.TRY_BLOCK_SIZE = N_TRY_BLOCK_SIZE;
            n1.Solve(roster);
            this.TotalEvaluations += n1.TotalEvaluations;
            int x = 0;
            while (x < n1.BlockSizeMovesCount.length) {
                if (this.VERBOSE) {
                    System.out.println("N/1E/1S : BlockSize=" + (x + 1) + " Moves=" + n1.BlockSizeMovesCount[x]);
                }
                if (n1.BlockSizeMovesCount[x] == 0) {
                    N_TRY_BLOCK_SIZE[x] = false;
                }
                ++x;
            }
            if (this.VERBOSE) {
                System.out.println("Pen=" + roster.getTotalPenalty());
            }
            this.GuiPrint("Stage : Quick Search", roster);
            if (this.Stopped || roster.getTotalPenalty() == 0 || this.TIME_LIMIT && DateTime.getNow().isGreaterThan(this.end)) {
                return;
            }
            Hrz1Emp1Swp_M h1 = new Hrz1Emp1Swp_M(this);
            h1.TIME_LIMIT = false;
            h1.CALCULATE_COVER_PENALTY = true;
            h1.SKIP_ZERO_PEN = false;
            h1.MAX_BLOCK_SIZE = MAX_BLOCK_SIZE;
            h1.VIOLATION_HEURISTIC_THRESHOLD = 0;
            h1.RandomSeed = this.RandomSeed;
            h1.VERBOSE = false;
            h1.TRY_BLOCK_SIZE = H_TRY_BLOCK_SIZE;
            h1.Solve(roster);
            this.TotalEvaluations += h1.TotalEvaluations;
            int x2 = 0;
            while (x2 < h1.BlockSizeMovesCount.length) {
                if (this.VERBOSE) {
                    System.out.println("H/1E/1S : BlockSize=" + (x2 + 1) + " Moves=" + h1.BlockSizeMovesCount[x2]);
                }
                if (h1.BlockSizeMovesCount[x2] == 0) {
                    H_TRY_BLOCK_SIZE[x2] = false;
                }
                ++x2;
            }
            if (this.VERBOSE) {
                System.out.println("Pen=" + roster.getTotalPenalty());
            }
            this.GuiPrint("Stage : Quick Search", roster);
            if (this.Stopped || roster.getTotalPenalty() == 0 || this.TIME_LIMIT && DateTime.getNow().isGreaterThan(this.end)) {
                return;
            }
            Vrt2Emp1Swp_M v1 = new Vrt2Emp1Swp_M(this);
            v1.TIME_LIMIT = false;
            v1.MAX_BLOCK_SIZE = MAX_BLOCK_SIZE;
            v1.VIOLATION_HEURISTIC_THRESHOLD = 0;
            v1.RandomSeed = this.RandomSeed;
            v1.VERBOSE = false;
            v1.TRY_BLOCK_SIZE = V_TRY_BLOCK_SIZE;
            v1.Solve(roster);
            this.TotalEvaluations += v1.TotalEvaluations;
            int x3 = 0;
            while (x3 < v1.BlockSizeMovesCount.length) {
                if (this.VERBOSE) {
                    System.out.println("V/2E/1S : BlockSize=" + (x3 + 1) + " Moves=" + v1.BlockSizeMovesCount[x3]);
                }
                if (v1.BlockSizeMovesCount[x3] == 0) {
                    V_TRY_BLOCK_SIZE[x3] = false;
                }
                ++x3;
            }
            if (this.VERBOSE) {
                System.out.println("Pen=" + roster.getTotalPenalty());
            }
            this.GuiPrint("Stage : Quick Search", roster);
            if (!this.Stopped && roster.getTotalPenalty() != 0 && (!this.TIME_LIMIT || !DateTime.getNow().isGreaterThan(this.end))) continue;
            return;
        } while (roster.getTotalPenalty() != startPen);
    }

    private void CheckAlgorithmParameters(Roster roster) {
        if (this.NEXT_MOVE_MAX_BLOCK_SIZE < 1) {
            System.out.println("Warning : NEXT_MOVE_MAX_BLOCK_SIZE is a bit small! Changing to 1.");
            this.NEXT_MOVE_MAX_BLOCK_SIZE = 1;
        }
        if (this.NEXT_MOVE_MAX_BLOCK_SIZE > roster.SchedulingPeriod.NumDaysInPeriod) {
            System.out.println("Warning : NEXT_MOVE_MAX_BLOCK_SIZE is a bit big! Changing to " + roster.SchedulingPeriod.NumDaysInPeriod + ".");
            this.NEXT_MOVE_MAX_BLOCK_SIZE = roster.SchedulingPeriod.NumDaysInPeriod;
        }
        if (this.MAX_BLOCK_SIZE_AT_DEPTH_ZERO < 1) {
            System.out.println("Warning : MAX_BLOCK_SIZE_AT_DEPTH_ZERO is a bit small! Changing to 1.");
            this.MAX_BLOCK_SIZE_AT_DEPTH_ZERO = 1;
        }
        if (this.MAX_BLOCK_SIZE_AT_DEPTH_ZERO > roster.SchedulingPeriod.NumDaysInPeriod) {
            System.out.println("Warning : MAX_BLOCK_SIZE_AT_DEPTH_ZERO is a bit big! Changing to " + roster.SchedulingPeriod.NumDaysInPeriod + ".");
            this.MAX_BLOCK_SIZE_AT_DEPTH_ZERO = roster.SchedulingPeriod.NumDaysInPeriod;
        }
    }

    public boolean TestPen(Roster roster, String msg) {
        int p1 = roster.getTotalPenalty();
        int totPenalty = 0;
        int i = 0;
        while (i < roster.Employees.length) {
            Employee employee = roster.Employees[i];
            totPenalty += SoftConstraints.CalculatePenalty(employee, 0, roster.SchedulingPeriod.NumDaysInPeriod - 1, false);
            ++i;
        }
        if (p1 != (totPenalty += roster.RecalculateCoverPenalty())) {
            System.out.println("p1 != totPenalty " + p1 + " .equalsIgnoreCase(" + totPenalty + " " + msg);
            return false;
        }
        return true;
    }

    public void DumpPattern(String msg, Employee employee) {
        System.out.print(String.valueOf(msg) + " : ");
        int day = 0;
        while (day < employee.Roster.SchedulingPeriod.NumDaysInPeriod) {
            int x = 0;
            while (x < employee.Roster.SchedulingPeriod.ShiftTypesCount) {
                if (employee.ShiftsOnDay[day][x] != null) {
                    System.out.print(employee.ShiftsOnDay[day][x].ShiftType.Label);
                }
                ++x;
            }
            System.out.print("|");
            ++day;
        }
        System.out.println();
    }

    private void GuiPrint(String message, Roster roster) {
        int penalty = roster.getTotalPenalty();
        if (this.guiBestPenalty < 0 || penalty < this.guiBestPenalty) {
            this.guiBestPenalty = penalty;
        }
        if (this.bestRoster != null && this.bestRoster.getTotalPenalty() < this.guiBestPenalty) {
            this.guiBestPenalty = this.bestRoster.getTotalPenalty();
        }
    }

    private void SetRoster(Roster roster1, Roster roster2) {
        roster1.Empty();
        int i = 0;
        while (i < roster2.Employees.length) {
            Employee employee2 = roster2.Employees[i];
            Employee employee1 = roster1.GetEmployee(employee2.EmployeeDescription.ID);
            int day = 0;
            while (day < roster2.SchedulingPeriod.NumDaysInPeriod) {
                int j = 0;
                while (j < roster2.SchedulingPeriod.ShiftTypesCount) {
                    Shift shift1;
                    Shift shift2 = employee2.ShiftsOnDay[day][j];
                    if (shift2 != null && (shift1 = this.GetShift(shift2.ShiftType.Index, day)) != null) {
                        roster1.AssignShift(employee1, shift1);
                    }
                    ++j;
                }
                ++day;
            }
            ++i;
        }
        roster1.RecalculateAllPenalties();
        if (roster1.getTotalPenalty() != roster2.getTotalPenalty()) {
            // empty if block
        }
    }

    private void CreateWeekendSoftConstraints(EmployeeDescription employee) {
        int weight;
        if (employee.Contract == null) {
            this.EmployeesWeekendConstraints[employee.IndexID] = new SoftConstraint[0];
            return;
        }
        SchedulingPeriod schedulingPeriod = employee.SchedulingPeriod;
        ArrayList<SoftConstraint> array = new ArrayList<SoftConstraint>();
        if (employee.Contract.MaxShiftTypesIsOn) {
            weight = schedulingPeriod.MasterWeights.MaxShiftTypes;
            if (employee.Contract.MaxShiftTypesWeight > -1) {
                weight = employee.Contract.MaxShiftTypesWeight;
            }
            if (employee.Contract.MaxShiftTypesUsed) {
                array.add(new MaxShiftTypes(weight));
            }
            if (employee.Contract.MaxShiftGroupsUsed) {
                array.add(new MaxShiftGroups(weight));
            }
        }
        if (schedulingPeriod.MasterWeights.MinTimeBetweenShifts > 0) {
            weight = schedulingPeriod.MasterWeights.MinTimeBetweenShifts;
            array.add(new MinTimeBetweenShifts(weight));
        }
        if (employee.Contract.MaxNumAssignmentsIsOn) {
            weight = schedulingPeriod.MasterWeights.MaxNumAssignments;
            if (employee.Contract.MaxNumAssignmentsWeight > -1) {
                weight = employee.Contract.MaxNumAssignmentsWeight;
            }
            array.add(new MaxNumAssignments(weight));
        }
        if (employee.Contract.MaxShiftsPerDayIsOn) {
            weight = schedulingPeriod.MasterWeights.MaxShiftsPerDay;
            if (employee.Contract.MaxShiftsPerDayWeight > -1) {
                weight = employee.Contract.MaxShiftsPerDayWeight;
            }
            array.add(new MaxShiftsPerDay(weight));
        }
        if (employee.Contract.MaxConsecutiveWorkingWeekendsIsOn) {
            weight = schedulingPeriod.MasterWeights.MaxConsecutiveWorkingWeekends;
            if (employee.Contract.MaxConsecutiveWorkingWeekendsWeight > -1) {
                weight = employee.Contract.MaxConsecutiveWorkingWeekendsWeight;
            }
            array.add(new MaxConsecutiveWorkingWeekends(weight));
        }
        if (employee.Contract.MinConsecutiveWorkingWeekendsIsOn) {
            weight = schedulingPeriod.MasterWeights.MinConsecutiveWorkingWeekends;
            if (employee.Contract.MinConsecutiveWorkingWeekendsWeight > -1) {
                weight = employee.Contract.MinConsecutiveWorkingWeekendsWeight;
            }
            array.add(new MinConsecutiveWorkingWeekends(weight));
        }
        if (employee.Contract.MaxConsecutiveFreeWeekendsIsOn) {
            weight = schedulingPeriod.MasterWeights.MaxConsecutiveFreeWeekends;
            if (employee.Contract.MaxConsecutiveFreeWeekendsWeight > -1) {
                weight = employee.Contract.MaxConsecutiveFreeWeekendsWeight;
            }
            array.add(new MaxConsecutiveFreeWeekends(weight));
        }
        if (employee.Contract.MinConsecutiveFreeWeekendsIsOn) {
            weight = schedulingPeriod.MasterWeights.MinConsecutiveFreeWeekends;
            if (employee.Contract.MinConsecutiveFreeWeekendsWeight > -1) {
                weight = employee.Contract.MinConsecutiveFreeWeekendsWeight;
            }
            array.add(new MinConsecutiveFreeWeekends(weight));
        }
        if (employee.Contract.CompleteWeekends) {
            weight = schedulingPeriod.MasterWeights.CompleteWeekends;
            if (employee.Contract.CompleteWeekendsWeight > -1) {
                weight = employee.Contract.CompleteWeekendsWeight;
            }
            array.add(new CompleteWeekends(weight));
        }
        if (employee.Contract.IdenticalShiftTypesDuringWeekend) {
            weight = schedulingPeriod.MasterWeights.IdenticalShiftTypesDuringWeekend;
            if (employee.Contract.IdenticalShiftTypesDuringWeekendWeight > -1) {
                weight = employee.Contract.IdenticalShiftTypesDuringWeekendWeight;
            }
            array.add(new IdenticalShiftTypesDuringWeekend(weight));
        }
        if (employee.Contract.NoNightShiftBeforeFreeWeekend) {
            weight = schedulingPeriod.MasterWeights.NoNightShiftBeforeFreeWeekend;
            if (employee.Contract.NoNightShiftBeforeFreeWeekendWeight > -1) {
                weight = employee.Contract.NoNightShiftBeforeFreeWeekendWeight;
            }
            array.add(new NoNightShiftBeforeFreeWeekend(weight));
        }
        if (employee.Contract.ValidNumConsecutiveShiftTypesIsOn) {
            weight = schedulingPeriod.MasterWeights.ValidNumConsecutiveShiftTypes;
            if (employee.Contract.ValidNumConsecutiveShiftTypesWeight > -1) {
                weight = employee.Contract.ValidNumConsecutiveShiftTypesWeight;
            }
            array.add(new NumConsecutiveShiftTypes(weight));
        }
        if (employee.Contract.ValidShiftTypeSuccessionsIsOn) {
            weight = schedulingPeriod.MasterWeights.ValidShiftTypeSuccessions;
            if (employee.Contract.ValidShiftTypeSuccessionsWeight > -1) {
                weight = employee.Contract.ValidShiftTypeSuccessionsWeight;
            }
            array.add(new ShiftTypeSuccessions(weight));
        }
        if (employee.Contract.MaxWeekendsOffIsOn) {
            weight = employee.Contract.MaxWeekendsOffWeight > -1 ? employee.Contract.MaxWeekendsOffWeight : schedulingPeriod.MasterWeights.MaxWeekendsOff;
            array.add(new MaxWeekendsOff(weight));
        }
        if (employee.Contract.MaxWeekendDaysIsOn) {
            weight = schedulingPeriod.MasterWeights.MaxWeekendDays;
            if (employee.Contract.MaxWeekendDaysWeight > -1) {
                weight = employee.Contract.MaxWeekendDaysWeight;
            }
            array.add(new MaxWeekendDays(weight));
        }
        if (employee.DayOffRequestCount > 0) {
            array.add(new RequestedDaysOff());
        }
        if (employee.DayOnRequestCount > 0) {
            array.add(new RequestedDaysOn());
        }
        if (employee.ShiftOffRequestCount > 0) {
            array.add(new RequestedShiftsOff());
        }
        if (employee.ShiftOnRequestCount > 0) {
            array.add(new RequestedShiftsOn());
        }
        if (employee.ShiftGroupOnRequests != null && employee.ShiftGroupOnRequests.length > 0) {
            array.add(new RequestedShiftGroupsOn());
        }
        this.EmployeesWeekendConstraints[employee.IndexID] = array.toArray(new SoftConstraint[0]);
    }

    @Override
    public boolean getSchedulingPeriodContainsNonAutoAssignShifts() {
        return this.SchedulingPeriodContainsNonAutoAssignShifts;
    }

    @Override
    public boolean[] getEmployeeDescriptionHasFrozenDays() {
        return this.EmployeeDescriptionHasFrozenDays;
    }
}

