/*
 * Decompiled with CFR 0.152.
 */
package PersonnelScheduling;

import ASAP.NRP.Core.Employee;
import ASAP.NRP.Core.Roster;
import ASAP.NRP.Core.Shift;
import ASAP.NRP.Core.Tools.RosterLoader;
import ASAP.NRP.Solvers.Crossover.Crossover;
import ASAP.NRP.Solvers.VariableDepthSearch.Hrz1Emp1Swp_M;
import ASAP.NRP.Solvers.VariableDepthSearch.New1Emp1Swp_M;
import ASAP.NRP.Solvers.VariableDepthSearch.PatternTester;
import ASAP.NRP.Solvers.VariableDepthSearch.VDS_B;
import ASAP.NRP.Solvers.VariableDepthSearch.Vrt2Emp1Swp_M;
import AbstractClasses.ProblemDomain;
import PersonnelScheduling.Instance;
import PersonnelScheduling.TestShiftDB2;
import java.io.File;
import java.io.InputStream;

public class PersonnelScheduling
extends ProblemDomain {
    int MAX_VDS_TIME = 10000;
    int MAX_BLOCK_SIZE_AT_DEPTH_ZERO = 3;
    int VDS_MAX_DEPTH = 250;
    final boolean SHOW_ERROR_MSGS = false;
    int bestPenalty = -1;
    Roster bestRoster;
    TestShiftDB2 shiftsDB;
    Roster[] solutions = new Roster[2];
    String schedulingPeriodID = null;
    final Instance[] dataSets = new Instance[]{new Instance("BCV-3.46.1", 3280, false), new Instance("BCV-A.12.2", 1953, false), new Instance("ORTEC02", 270, true), new Instance("Ikegami-3Shift-DATA1", 2, true), new Instance("Ikegami-3Shift-DATA1.1", 3, true), new Instance("Ikegami-3Shift-DATA1.2", 3, true), new Instance("CHILD-A2", 1111, false), new Instance("ERRVH-A", 2197, false), new Instance("ERRVH-B", 6859, false), new Instance("MER-A", 9915, false), new Instance("BCV-A.12.1", 1294, false), new Instance("ORTEC01", 270, true)};
    final int[] localSearches;
    final int[] ruinRecreates;
    final int[] crossovers;
    final int[] mutators;
    final int[] heuristicsWhichUseDepthOfSearch;
    final int[] heuristicsWhichUseIntensityOfMut;

    public PersonnelScheduling(long seed) {
        super(seed);
        int[] nArray = new int[5];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        this.localSearches = nArray;
        this.ruinRecreates = new int[]{5, 6, 7};
        this.crossovers = new int[]{8, 9, 10};
        this.mutators = new int[]{11};
        this.heuristicsWhichUseDepthOfSearch = new int[]{3, 4};
        this.heuristicsWhichUseIntensityOfMut = new int[]{6, 7, 8, 11};
    }

    public int getNumberOfHeuristics() {
        return 12;
    }

    public int[] getHeuristicsOfType(ProblemDomain.HeuristicType hType) {
        switch (hType) {
            case LOCAL_SEARCH: {
                return this.localSearches;
            }
            case RUIN_RECREATE: {
                return this.ruinRecreates;
            }
            case CROSSOVER: {
                return this.crossovers;
            }
            case MUTATION: {
                return this.mutators;
            }
        }
        return null;
    }

    public int[] getHeuristicsThatUseDepthOfSearch() {
        return this.heuristicsWhichUseDepthOfSearch;
    }

    public int[] getHeuristicsThatUseIntensityOfMutation() {
        return this.heuristicsWhichUseIntensityOfMut;
    }

    private boolean isCrossover(int hid) {
        if (this.crossovers == null || this.crossovers.length == 0) {
            return false;
        }
        int i = 0;
        while (i < this.crossovers.length) {
            if (this.crossovers[i] == hid) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isLocalSearch(int hid) {
        if (this.localSearches == null || this.localSearches.length == 0) {
            return false;
        }
        int i = 0;
        while (i < this.localSearches.length) {
            if (this.localSearches[i] == hid) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public double applyHeuristic(int heuristicID, int solIn1, int solIn2, int solOut1) {
        int pen;
        long startTime = System.currentTimeMillis();
        if (!this.isCrossover(heuristicID)) {
            double s1 = this.applyHeuristic(heuristicID, solIn1, solOut1);
            if (heuristicID > 0 && heuristicID < this.heuristicCallTimeRecord.length) {
                int n = heuristicID;
                this.heuristicCallTimeRecord[n] = this.heuristicCallTimeRecord[n] + (int)(System.currentTimeMillis() - startTime);
            }
            return s1;
        }
        Roster r1 = new Roster(this.bestRoster.SchedulingPeriod);
        Roster r2 = new Roster(this.bestRoster.SchedulingPeriod);
        if (heuristicID == 8) {
            int n = (int)Math.round((1.0 - this.getIntensityOfMutation()) * 16.0);
            int MAX_BEST_ASSIGNMENTS = 4 + n;
            Crossover.MEH_Crossover(this.solutions[solIn1], this.solutions[solIn2], r1, r2, MAX_BEST_ASSIGNMENTS);
        } else if (heuristicID == 9) {
            Crossover.SS_Crossover(this.solutions[solIn1], this.solutions[solIn2], r1, r2);
        } else if (heuristicID == 10) {
            Crossover.Crossover_A(this.solutions[solIn1], this.solutions[solIn2], r1, r2);
        } else {
            System.out.println("Unknown heuristicID: " + heuristicID);
            return 0.0;
        }
        if (heuristicID > 0 && heuristicID < this.heuristicCallRecord.length) {
            int n = heuristicID;
            this.heuristicCallRecord[n] = this.heuristicCallRecord[n] + 1;
            int n2 = heuristicID;
            this.heuristicCallTimeRecord[n2] = this.heuristicCallTimeRecord[n2] + (int)(System.currentTimeMillis() - startTime);
        }
        if (r1.getTotalPenalty() < r2.getTotalPenalty()) {
            pen = r1.getTotalPenalty();
            this.solutions[solOut1] = r1;
            if (pen < this.bestPenalty) {
                this.bestPenalty = pen;
                this.bestRoster = (Roster)r1.Clone();
            }
            return pen;
        }
        pen = r2.getTotalPenalty();
        this.solutions[solOut1] = r2;
        if (pen < this.bestPenalty) {
            this.bestPenalty = pen;
            this.bestRoster = (Roster)r2.Clone();
        }
        return pen;
    }

    public double applyHeuristic(int heuristicID, int solutionIn, int solutionOut) {
        long startTime = System.currentTimeMillis();
        Roster tempRoster = (Roster)this.solutions[solutionIn].Clone();
        int origPen = tempRoster.getTotalPenalty();
        if (heuristicID > 0 && heuristicID < this.heuristicCallRecord.length) {
            int n = heuristicID;
            this.heuristicCallRecord[n] = this.heuristicCallRecord[n] + 1;
        }
        if (this.isCrossover(heuristicID)) {
            this.copySolution(solutionIn, solutionOut);
            if (heuristicID > 0 && heuristicID < this.heuristicCallTimeRecord.length) {
                int n = heuristicID;
                this.heuristicCallTimeRecord[n] = this.heuristicCallTimeRecord[n] + (int)(System.currentTimeMillis() - startTime);
            }
            return this.solutions[solutionIn].getTotalPenalty();
        }
        if (heuristicID == 0) {
            int MAX_BLOCK_SIZE = 5;
            boolean[] N_TRY_BLOCK_SIZE = new boolean[MAX_BLOCK_SIZE];
            int i = 0;
            while (i < N_TRY_BLOCK_SIZE.length) {
                N_TRY_BLOCK_SIZE[i] = true;
                ++i;
            }
            New1Emp1Swp_M n1 = new New1Emp1Swp_M(this.shiftsDB);
            n1.TIME_LIMIT = false;
            n1.CALCULATE_COVER_PENALTY = true;
            n1.SKIP_ZERO_PENS = false;
            n1.MAX_BLOCK_SIZE = MAX_BLOCK_SIZE;
            n1.VIOLATION_HEURISTIC_THRESHOLD = 0;
            n1.setRNG(this.rng);
            n1.VERBOSE = false;
            n1.TRY_BLOCK_SIZE = N_TRY_BLOCK_SIZE;
            n1.Solve(tempRoster);
        } else if (heuristicID == 1) {
            int MAX_BLOCK_SIZE = 5;
            boolean[] H_TRY_BLOCK_SIZE = new boolean[MAX_BLOCK_SIZE];
            int i = 0;
            while (i < H_TRY_BLOCK_SIZE.length) {
                H_TRY_BLOCK_SIZE[i] = true;
                ++i;
            }
            Hrz1Emp1Swp_M h1 = new Hrz1Emp1Swp_M(this.shiftsDB);
            h1.TIME_LIMIT = false;
            h1.CALCULATE_COVER_PENALTY = true;
            h1.SKIP_ZERO_PEN = false;
            h1.MAX_BLOCK_SIZE = MAX_BLOCK_SIZE;
            h1.VIOLATION_HEURISTIC_THRESHOLD = 0;
            h1.setRNG(this.rng);
            h1.VERBOSE = false;
            h1.TRY_BLOCK_SIZE = H_TRY_BLOCK_SIZE;
            h1.Solve(tempRoster);
        } else if (heuristicID == 2) {
            int MAX_BLOCK_SIZE = 5;
            boolean[] V_TRY_BLOCK_SIZE = new boolean[MAX_BLOCK_SIZE];
            int i = 0;
            while (i < V_TRY_BLOCK_SIZE.length) {
                V_TRY_BLOCK_SIZE[i] = true;
                ++i;
            }
            Vrt2Emp1Swp_M v1 = new Vrt2Emp1Swp_M(this.shiftsDB);
            v1.TIME_LIMIT = false;
            v1.MAX_BLOCK_SIZE = MAX_BLOCK_SIZE;
            v1.VIOLATION_HEURISTIC_THRESHOLD = 0;
            v1.setRNG(this.rng);
            v1.VERBOSE = false;
            v1.TRY_BLOCK_SIZE = V_TRY_BLOCK_SIZE;
            v1.Solve(tempRoster);
        } else if (heuristicID == 3) {
            int maxRunTime = (int)(this.getDepthOfSearch() * (double)this.MAX_VDS_TIME);
            VDS_B search = new VDS_B();
            search.USE_QUICKSEARCH = false;
            search.setRNG(this.rng);
            search.VERBOSE = false;
            search.SYSTEM_TIME_RANDOM_SEED = false;
            search.TIME_LIMIT = true;
            search.PreferredRunTime = maxRunTime;
            search.POSITIVE_GAIN_HEURISTIC = true;
            search.VIOLATION_FLAG_HEURISTIC = false;
            search.MAX_DEPTH = this.VDS_MAX_DEPTH;
            search.NEXT_MOVE_MAX_BLOCK_SIZE = 5;
            search.MAX_BLOCK_SIZE_AT_DEPTH_ZERO = this.MAX_BLOCK_SIZE_AT_DEPTH_ZERO;
            search.TEST_PATTERNS_MAX_ATTEMPTS = 2;
            search.TEST_PATTERNS_AT_START = false;
            search.SATISFY_WEEKENDS = false;
            search.TEST_PATTERNS_DURING_IMPROVE_EMPLOYEE = false;
            search.Solve(tempRoster);
        } else if (heuristicID == 4) {
            int maxRunTime = (int)(this.getDepthOfSearch() * (double)this.MAX_VDS_TIME);
            VDS_B search = new VDS_B();
            search.USE_QUICKSEARCH = false;
            search.setRNG(this.rng);
            search.VERBOSE = false;
            search.SYSTEM_TIME_RANDOM_SEED = false;
            search.TIME_LIMIT = true;
            search.PreferredRunTime = maxRunTime;
            search.POSITIVE_GAIN_HEURISTIC = true;
            search.VIOLATION_FLAG_HEURISTIC = false;
            search.MAX_DEPTH = this.VDS_MAX_DEPTH;
            search.NEXT_MOVE_MAX_BLOCK_SIZE = 5;
            search.MAX_BLOCK_SIZE_AT_DEPTH_ZERO = this.MAX_BLOCK_SIZE_AT_DEPTH_ZERO;
            search.TEST_PATTERNS_MAX_ATTEMPTS = 2;
            search.TEST_PATTERNS_AT_START = true;
            search.SATISFY_WEEKENDS = true;
            search.TEST_PATTERNS_DURING_IMPROVE_EMPLOYEE = true;
            search.Solve(tempRoster);
        } else if (heuristicID == 5) {
            int employeeIndex = this.rng.nextInt(tempRoster.Employees.length);
            PatternTester pt = new PatternTester();
            pt.ImprovePattern(tempRoster, this.shiftsDB, employeeIndex, this.rng);
        } else if (heuristicID == 6 || heuristicID == 7) {
            boolean[] pats = new boolean[tempRoster.Employees.length];
            long numToTryUnassign = heuristicID == 6 ? Math.round(this.getIntensityOfMutation() * 4.0) + 2L : Math.round(this.getIntensityOfMutation() * (double)tempRoster.Employees.length);
            int x = 0;
            while ((long)x < numToTryUnassign) {
                int index = this.rng.nextInt(tempRoster.Employees.length);
                if (!pats[index]) {
                    tempRoster.Employees[index].UnAssignAllShifts();
                    pats[index] = true;
                }
                ++x;
            }
            x = 0;
            while (x < pats.length) {
                if (pats[x]) {
                    PatternTester pt = new PatternTester();
                    pt.ImprovePattern(tempRoster, this.shiftsDB, x, this.rng);
                }
                ++x;
            }
        } else if (heuristicID == 11) {
            long attempts = Math.round(this.getIntensityOfMutation() * 80.0);
            int x = 0;
            while ((long)x < attempts) {
                int employeeIndex = this.rng.nextInt(tempRoster.Employees.length);
                int dayIndex = this.rng.nextInt(tempRoster.SchedulingPeriod.NumDaysInPeriod);
                Employee employee1 = tempRoster.Employees[employeeIndex];
                int j = 0;
                while (j < tempRoster.SchedulingPeriod.ShiftTypesCount) {
                    Shift shift = employee1.ShiftsOnDay[dayIndex][j];
                    if (shift != null) {
                        Shift[] shifts1 = new Shift[]{shift};
                        tempRoster.UnAssignShift(shift);
                        tempRoster.CoverPenalty += tempRoster.UpdateCoverPens(shifts1);
                        employee1.RecalculatePenalty();
                        break;
                    }
                    ++j;
                }
                ++x;
            }
        } else {
            System.out.println("Unknown heuristicID: " + heuristicID);
        }
        tempRoster.RecalculateAllPenalties();
        int pen = tempRoster.getTotalPenalty();
        if (pen < this.bestPenalty) {
            this.bestPenalty = pen;
            this.bestRoster = (Roster)tempRoster.Clone();
        }
        if (solutionOut >= 0 && solutionOut < this.solutions.length) {
            if (this.isLocalSearch(heuristicID) && tempRoster.getTotalPenalty() > origPen) {
                this.copySolution(solutionIn, solutionOut);
                pen = origPen;
            } else {
                if (this.solutions[solutionOut] == null) {
                    this.solutions[solutionOut] = (Roster)tempRoster.Clone();
                }
                this.SetRoster(this.solutions[solutionOut], tempRoster);
            }
        }
        if (heuristicID > 0 && heuristicID < this.heuristicCallTimeRecord.length) {
            int n = heuristicID;
            this.heuristicCallTimeRecord[n] = this.heuristicCallTimeRecord[n] + (int)(System.currentTimeMillis() - startTime);
        }
        return pen;
    }

    public int getNumberOfInstances() {
        return this.dataSets.length;
    }

    public void setMemorySize(int solutionCount) {
        if (this.solutions == null) {
            this.solutions = new Roster[2];
        }
        this.solutions = PersonnelScheduling.ArrayResize(this.solutions, solutionCount);
    }

    public double getBestSolutionValue() {
        return this.bestRoster.getTotalPenalty();
    }

    public void loadInstance(int instanceID) {
        this.emptySolutions();
        if (instanceID < 0 || instanceID >= this.dataSets.length) {
            System.out.println("Invalid instanceID: " + instanceID);
            return;
        }
        this.schedulingPeriodID = this.dataSets[instanceID].getName();
        RosterLoader rosterLoader = new RosterLoader();
        rosterLoader.VERBOSE = false;
        try {
            InputStream fis = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("data/" + this.schedulingPeriodID + ".ros");
            if (fis != null) {
                this.bestRoster = rosterLoader.CreateEmptyRoster(fis);
            } else {
                String fName = ".\\data\\" + this.schedulingPeriodID + ".ros";
                File file = new File(fName);
                if (!file.exists() && !(file = new File(fName = "..\\NRPJava\\data\\" + this.schedulingPeriodID + ".ros")).exists()) {
                    System.out.println("Unable to find data file.");
                }
                this.bestRoster = rosterLoader.CreateEmptyRoster(fName);
            }
        }
        catch (Exception ex) {
            System.out.println("Error: " + ex.getMessage());
        }
        if (this.bestRoster == null) {
            System.out.println("Problem loading instanceID: " + instanceID + " (" + this.schedulingPeriodID + ")");
            return;
        }
        this.bestRoster.RecalculateAllPenalties();
        this.shiftsDB = new TestShiftDB2(this.bestRoster);
        this.MakeInitialAssignments(this.bestRoster);
        this.bestPenalty = this.bestRoster.getTotalPenalty();
    }

    public void initialiseSolution(int index) {
        if (index < 0 || index >= this.solutions.length) {
            return;
        }
        if (this.solutions[index] == null) {
            this.solutions[index] = (Roster)this.bestRoster.Clone();
        }
        this.solutions[index].Empty();
        this.MakeInitialAssignments(this.solutions[index]);
        int pen = this.solutions[index].getTotalPenalty();
        if (pen < this.bestPenalty) {
            this.bestPenalty = pen;
            this.bestRoster = (Roster)this.solutions[index].Clone();
        }
    }

    public double getFunctionValue(int solutionIndex) {
        return this.solutions[solutionIndex].getTotalPenalty();
    }

    public String bestSolutionToString() {
        if (this.bestRoster == null) {
            return "";
        }
        return this.bestRoster.toString();
    }

    public String solutionToString(int solIndex) {
        if (solIndex >= 0 && solIndex < this.solutions.length && this.solutions[solIndex] != null) {
            return this.solutions[solIndex].toString();
        }
        return "";
    }

    public String toString() {
        return "Personnel Scheduling";
    }

    public void copySolution(int src, int dest) {
        if (this.solutions[src] == null) {
            return;
        }
        if (this.solutions[dest] == null) {
            this.solutions[dest] = (Roster)this.solutions[src].Clone();
        }
        this.SetRoster(this.solutions[dest], this.solutions[src]);
    }

    private void SetRoster(Roster roster1, Roster roster2) {
        roster1.Empty();
        int i = 0;
        while (i < roster2.Employees.length) {
            Employee employee2 = roster2.Employees[i];
            Employee employee1 = roster1.GetEmployee(employee2.EmployeeDescription.ID);
            int day = 0;
            while (day < roster2.SchedulingPeriod.NumDaysInPeriod) {
                int j = 0;
                while (j < roster2.SchedulingPeriod.ShiftTypesCount) {
                    Shift shift1;
                    Shift shift2 = employee2.ShiftsOnDay[day][j];
                    if (shift2 != null && (shift1 = (Shift)shift2.Clone()) != null) {
                        roster1.AssignShift(employee1, shift1);
                    }
                    ++j;
                }
                ++day;
            }
            ++i;
        }
        roster1.RecalculateAllPenalties();
        if (roster1.getTotalPenalty() != roster2.getTotalPenalty()) {
            // empty if block
        }
    }

    private void emptySolutions() {
        int i = 0;
        while (i < this.solutions.length) {
            this.solutions[i] = null;
            ++i;
        }
    }

    private void MakeInitialAssignments(Roster roster) {
        int MAX_BLOCK_SIZE = 5;
        boolean[] N_TRY_BLOCK_SIZE = new boolean[MAX_BLOCK_SIZE];
        N_TRY_BLOCK_SIZE[0] = true;
        N_TRY_BLOCK_SIZE[1] = true;
        N_TRY_BLOCK_SIZE[2] = true;
        N_TRY_BLOCK_SIZE[3] = true;
        N_TRY_BLOCK_SIZE[4] = true;
        New1Emp1Swp_M n1 = new New1Emp1Swp_M(this.shiftsDB);
        n1.TIME_LIMIT = false;
        n1.CALCULATE_COVER_PENALTY = true;
        n1.SKIP_ZERO_PENS = false;
        n1.MAX_BLOCK_SIZE = MAX_BLOCK_SIZE;
        n1.VIOLATION_HEURISTIC_THRESHOLD = 0;
        n1.setRNG(this.rng);
        n1.VERBOSE = false;
        n1.TRY_BLOCK_SIZE = N_TRY_BLOCK_SIZE;
        n1.Solve(roster);
    }

    private static Roster[] ArrayResize(Roster[] input, int newSize) {
        Roster[] newArray = new Roster[newSize];
        System.arraycopy(input, 0, newArray, 0, newSize < input.length ? newSize : input.length);
        return newArray;
    }

    public boolean compareSolutions(int solutionIndex1, int solutionIndex2) {
        if (this.solutions[solutionIndex1] == null || this.solutions[solutionIndex2] == null) {
            return false;
        }
        Roster r1 = this.solutions[solutionIndex1];
        Roster r2 = this.solutions[solutionIndex2];
        if (r1.getTotalPenalty() != r2.getTotalPenalty()) {
            return false;
        }
        int i = 0;
        while (i < r1.Employees.length) {
            Employee e1 = r1.Employees[i];
            Employee e2 = r2.GetEmployee(e1.EmployeeDescription.ID);
            int j = 0;
            while (j < e1.ShiftAssignments.length) {
                if (e1.ShiftAssignments[j] != e2.ShiftAssignments[j]) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }
}

