/*
 * Decompiled with CFR 0.152.
 */
package PersonnelScheduling;

import ASAP.NRP.Core.DateTime;
import ASAP.NRP.Core.EmployeeDescription;
import ASAP.NRP.Core.Roster;
import ASAP.NRP.Core.SchedulingPeriod;
import ASAP.NRP.Core.Shift;
import ASAP.NRP.Core.ShiftType;
import ASAP.NRP.Solvers.VariableDepthSearch.TestShiftDB;

class TestShiftDB2
implements TestShiftDB {
    Shift[][] TestShifts;
    Shift[][][] AllShifts;
    public boolean SchedulingPeriodContainsNonAutoAssignShifts = false;
    public boolean[] EmployeeDescriptionHasFrozenDays;

    public TestShiftDB2(Roster roster) {
        int i = 0;
        while (i < roster.SchedulingPeriod.ShiftTypesCount) {
            if (!roster.SchedulingPeriod.GetShiftType((int)i).AutoAllocate) {
                this.SchedulingPeriodContainsNonAutoAssignShifts = true;
                break;
            }
            ++i;
        }
        this.EmployeeDescriptionHasFrozenDays = new boolean[roster.SchedulingPeriod.EmployeesCount];
        i = 0;
        while (i < roster.SchedulingPeriod.EmployeesCount) {
            EmployeeDescription emp = roster.SchedulingPeriod.GetEmployeeDescription(i);
            int j = 0;
            while (j < emp.FrozenDay.length) {
                if (emp.FrozenDay[j]) {
                    this.EmployeeDescriptionHasFrozenDays[emp.IndexID] = true;
                    break;
                }
                ++j;
            }
            ++i;
        }
        SchedulingPeriod schedulingPeriod = roster.SchedulingPeriod;
        this.AllShifts = new Shift[schedulingPeriod.NumDaysInPeriod][schedulingPeriod.ShiftTypesCount][roster.Employees.length];
        this.TestShifts = new Shift[schedulingPeriod.NumDaysInPeriod][schedulingPeriod.ShiftTypesCount];
        int day = 0;
        while (day < schedulingPeriod.NumDaysInPeriod) {
            DateTime date = schedulingPeriod.ConvertRosterDayToDate(day);
            int i2 = 0;
            while (i2 < schedulingPeriod.ShiftTypesCount) {
                ShiftType st = schedulingPeriod.GetShiftType(i2);
                this.TestShifts[day][i2] = new Shift(st, date, schedulingPeriod);
                int j = 0;
                while (j < roster.Employees.length) {
                    this.AllShifts[day][i2][j] = new Shift(st, date, schedulingPeriod);
                    ++j;
                }
                ++i2;
            }
            ++day;
        }
    }

    @Override
    public Shift GetTestShift(int stIndex, int day) {
        return this.TestShifts[day][stIndex];
    }

    @Override
    public Shift GetShift(ShiftType st, int day) {
        if (st == null) {
            return null;
        }
        return this.GetShift(st.Index, day);
    }

    @Override
    public Shift GetShift(int stIndex, int day) {
        int i = 0;
        while (i < this.AllShifts[day][stIndex].length) {
            if (!this.AllShifts[day][stIndex][i].isAssigned()) {
                return this.AllShifts[day][stIndex][i];
            }
            ++i;
        }
        return null;
    }

    @Override
    public boolean getSchedulingPeriodContainsNonAutoAssignShifts() {
        return this.SchedulingPeriodContainsNonAutoAssignShifts;
    }

    @Override
    public boolean[] getEmployeeDescriptionHasFrozenDays() {
        return this.EmployeeDescriptionHasFrozenDays;
    }
}

