/*
 * Decompiled with CFR 0.152.
 */
package ASAP.NRP.Core.Constraints.ANROM;

import ASAP.NRP.Core.Constraints.SoftConstraint;
import ASAP.NRP.Core.Constraints.SoftConstraints;
import ASAP.NRP.Core.Employee;
import ASAP.NRP.Core.EmployeeDescription;
import ASAP.NRP.Core.SchedulingPeriod;

public class AlternativeSkillCategory
implements SoftConstraint {
    public String Title = "Alternative skill";
    public String LongTitle = "";
    public int Weight = 0;
    public String ID = "";

    public AlternativeSkillCategory(int weight) {
        this.Weight = weight;
    }

    @Override
    public String getTitle() {
        return this.Title;
    }

    @Override
    public int getWeight() {
        return this.Weight;
    }

    @Override
    public void Delete(EmployeeDescription employee) {
    }

    @Override
    public String ToXml(EmployeeDescription employee) {
        return "";
    }

    @Override
    public String GetDescription(Employee employee) {
        return "";
    }

    @Override
    public int Calculate(Employee employee, int startDay, int endDay) {
        return this.Calculate(employee);
    }

    public int Calculate(Employee employee, int maxPenalty, int startDay, int endDay) {
        return this.Calculate(employee);
    }

    @Override
    public int Calculate(Employee employee, int startDay, int endDay, boolean updateStructure) {
        return this.Calculate(employee);
    }

    @Override
    public int Calculate(Employee employee) {
        if (this.Weight == 0) {
            return 0;
        }
        SchedulingPeriod schedulingPeriod = employee.Roster.SchedulingPeriod;
        int penalty = 0;
        int shiftCount = schedulingPeriod.ShiftTypesCount;
        int numDaysInPeriod = schedulingPeriod.NumDaysInPeriod;
        int i = 0;
        while (i < numDaysInPeriod) {
            if (employee.DayType[i] == 1) {
                int index = shiftCount * i;
                int j = 0;
                while (j < shiftCount) {
                    int shift1 = index + j;
                    if (employee.ShiftAssignments[shift1] && schedulingPeriod.EmployeeUsesSecondarySkillForShiftType(employee.EmployeeDescription, j)) {
                        penalty += this.Weight;
                        int n = i;
                        employee.ConstraintViolationPenalties[n] = employee.ConstraintViolationPenalties[n] + this.Weight;
                        if (SoftConstraints.UpdateViolationDescriptions) {
                            int n2 = i;
                            employee.ViolationDescriptions[n2] = String.valueOf(employee.ViolationDescriptions[n2]) + "Uses secondary skill, penalty=" + this.Weight + ". " + System.getProperty("line.separator");
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        return penalty;
    }
}

