/*
 * Decompiled with CFR 0.152.
 */
package ASAP.NRP.Core.Constraints.ANROM;

import ASAP.NRP.Core.Constraints.SoftConstraint;
import ASAP.NRP.Core.Constraints.SoftConstraints;
import ASAP.NRP.Core.Employee;
import ASAP.NRP.Core.EmployeeDescription;
import ASAP.NRP.Core.SchedulingPeriod;

public class MaxConsecutiveFreeDays
implements SoftConstraint {
    public String Title = "Max consecutive free days";
    public String LongTitle = "";
    public int Weight = 0;
    public String ID = "";

    public MaxConsecutiveFreeDays(int Weight) {
        this.Weight = Weight;
    }

    @Override
    public void Delete(EmployeeDescription employee) {
    }

    @Override
    public String getTitle() {
        return this.Title;
    }

    @Override
    public int getWeight() {
        return this.Weight;
    }

    @Override
    public String ToXml(EmployeeDescription employee) {
        return "";
    }

    @Override
    public String GetDescription(Employee employee) {
        return "Requests max " + employee.EmployeeDescription.Contract.MaxConsecutiveFreeDays + " consecutive free days.";
    }

    @Override
    public int Calculate(Employee employee, int startDay, int endDay) {
        return this.Calculate(employee);
    }

    public int Calculate(Employee employee, int maxPenalty, int startDay, int endDay) {
        return this.Calculate(employee);
    }

    @Override
    public int Calculate(Employee employee, int startDay, int endDay, boolean updateStructure) {
        return this.Calculate(employee);
    }

    @Override
    public int Calculate(Employee employee) {
        if (this.Weight == 0) {
            return 0;
        }
        SchedulingPeriod schedulingPeriod = employee.Roster.SchedulingPeriod;
        int penalty = 0;
        int maxConsecutiveFreeDays = employee.EmployeeDescription.Contract.MaxConsecutiveFreeDays;
        int consecutiveFreeDays = employee.EmployeeDescription.SchedulingHistory.PreviousConsecutiveFreeDays;
        int numDaysInPeriod = schedulingPeriod.NumDaysInPeriod;
        int i = 0;
        while (i < numDaysInPeriod) {
            if (employee.DayType[i] == 0) {
                ++consecutiveFreeDays;
            }
            if (employee.DayType[i] == 1 || employee.EmployeeDescription.DayOffRequestIsWork[i] || i + 1 == numDaysInPeriod) {
                if (consecutiveFreeDays > maxConsecutiveFreeDays) {
                    int pen = this.Weight * (consecutiveFreeDays - maxConsecutiveFreeDays);
                    penalty += pen;
                    int end = i - 1;
                    if (employee.DayType[i] == 0) {
                        end = i;
                    }
                    int j = end;
                    while (j >= 0 && j > end - consecutiveFreeDays) {
                        int n = j;
                        employee.ConstraintViolationPenalties[n] = employee.ConstraintViolationPenalties[n] + pen;
                        if (SoftConstraints.UpdateViolationDescriptions) {
                            int n2 = j;
                            employee.ViolationDescriptions[n2] = String.valueOf(employee.ViolationDescriptions[n2]) + "Too many consecutive free days (max " + maxConsecutiveFreeDays + "). " + System.getProperty("line.separator");
                        }
                        --j;
                    }
                }
                consecutiveFreeDays = 0;
            }
            ++i;
        }
        return penalty;
    }
}

