/*
 * Decompiled with CFR 0.152.
 */
package ASAP.NRP.Core.Constraints.ANROM;

import ASAP.NRP.Core.Constraints.SoftConstraint;
import ASAP.NRP.Core.Constraints.SoftConstraints;
import ASAP.NRP.Core.Employee;
import ASAP.NRP.Core.EmployeeDescription;
import ASAP.NRP.Core.SchedulingPeriod;
import ASAP.NRP.Core.ShiftType;

public class MaxShiftTypesPerWeek
implements SoftConstraint {
    public String Title = "Max shift types per week";
    public String LongTitle = "";
    public int Weight = 0;
    public String ID = "";

    public MaxShiftTypesPerWeek(int Weight) {
        this.Weight = Weight;
    }

    @Override
    public void Delete(EmployeeDescription employee) {
    }

    @Override
    public String getTitle() {
        return this.Title;
    }

    @Override
    public int getWeight() {
        return this.Weight;
    }

    @Override
    public String ToXml(EmployeeDescription employee) {
        return "";
    }

    @Override
    public String GetDescription(Employee employee) {
        String info = "";
        boolean required = false;
        SchedulingPeriod schedulingPeriod = employee.Roster.SchedulingPeriod;
        int i = 0;
        while (i < schedulingPeriod.NumWeeksInPeriod) {
            int x = 0;
            while (x < schedulingPeriod.ShiftTypesCount) {
                ShiftType shiftType = schedulingPeriod.GetShiftType(x);
                String ID = shiftType.ID;
                int j = shiftType.Index;
                if (employee.EmployeeDescription.Contract.MaxShiftTypesPerWeek[i][j] < 0) {
                    info = String.valueOf(info);
                } else {
                    info = String.valueOf(info) + "<br/>In week " + (i + 1) + " requests max " + employee.EmployeeDescription.Contract.MaxShiftTypesPerWeek[i][j] + " '" + ID + "' shifts, receives " + employee.ShiftTypePerWeekCount[i][j];
                    required = true;
                }
                ++x;
            }
            ++i;
        }
        if (required) {
            info = "Max shift types per week " + info;
        }
        return info;
    }

    @Override
    public int Calculate(Employee employee, int startDay, int endDay) {
        return this.Calculate(employee);
    }

    public int Calculate(Employee employee, int maxPenalty, int startDay, int endDay) {
        return this.Calculate(employee);
    }

    @Override
    public int Calculate(Employee employee, int startDay, int endDay, boolean updateStructure) {
        return this.Calculate(employee);
    }

    @Override
    public int Calculate(Employee employee) {
        if (this.Weight == 0) {
            return 0;
        }
        SchedulingPeriod schedulingPeriod = employee.Roster.SchedulingPeriod;
        int penalty = 0;
        int shiftTypeCount = schedulingPeriod.ShiftTypesCount;
        int i = 0;
        while (i < schedulingPeriod.NumWeeksInPeriod) {
            int j = 0;
            while (j < schedulingPeriod.ShiftTypesCount) {
                int max = employee.EmployeeDescription.Contract.MaxShiftTypesPerWeek[i][j];
                int count = employee.ShiftTypePerWeekCount[i][j];
                if (max >= 0 && count > max) {
                    int pen = this.Weight * (count - max);
                    penalty += pen;
                    int k = i * 7;
                    while (k < (i + 1) * 7 && k < schedulingPeriod.NumDaysInPeriod) {
                        if (employee.ShiftAssignments[k * shiftTypeCount + j]) {
                            int n = k;
                            employee.ConstraintViolationPenalties[n] = employee.ConstraintViolationPenalties[n] + pen;
                            if (SoftConstraints.UpdateViolationDescriptions) {
                                int n2 = k;
                                employee.ViolationDescriptions[n2] = String.valueOf(employee.ViolationDescriptions[n2]) + "Requests max " + max + " '" + schedulingPeriod.GetShiftType((int)j).Label + "' shifts in this week. " + System.getProperty("line.separator");
                            }
                        }
                        ++k;
                    }
                }
                ++j;
            }
            ++i;
        }
        return penalty;
    }
}

