/*
 * Decompiled with CFR 0.152.
 */
package ASAP.NRP.Core.Constraints.ANROM;

import ASAP.NRP.Core.Constraints.SoftConstraint;
import ASAP.NRP.Core.Constraints.SoftConstraints;
import ASAP.NRP.Core.Employee;
import ASAP.NRP.Core.EmployeeDescription;
import ASAP.NRP.Core.SchedulingPeriod;

public class MinConsecutiveFreeDays
implements SoftConstraint {
    public String Title = "Min consecutive free days";
    public String LongTitle = "Minimum number of consecutive free days";
    public int Weight = 0;
    public String ID = "ANROM.MinConsecutiveFreeDays";

    public MinConsecutiveFreeDays(int Weight) {
        this.Weight = Weight;
    }

    @Override
    public String getTitle() {
        return this.Title;
    }

    @Override
    public int getWeight() {
        return this.Weight;
    }

    @Override
    public void Delete(EmployeeDescription employee) {
        employee.Contract.MinConsecutiveFreeDaysIsOn = false;
    }

    @Override
    public String ToXml(EmployeeDescription employee) {
        return "<MinConsecutiveFreeDays Weight=\"" + this.Weight + "\">" + employee.Contract.MinConsecutiveFreeDays + "</MinConsecutiveFreeDays>" + System.getProperty("line.separator");
    }

    @Override
    public String GetDescription(Employee employee) {
        return "Requests min " + employee.EmployeeDescription.Contract.MinConsecutiveFreeDays + " consecutive free days.";
    }

    @Override
    public int Calculate(Employee employee, int startDay, int endDay) {
        return this.Calculate(employee);
    }

    public int Calculate(Employee employee, int maxPenalty, int startDay, int endDay) {
        return this.Calculate(employee);
    }

    @Override
    public int Calculate(Employee employee, int startDay, int endDay, boolean updateStructure) {
        return this.Calculate(employee);
    }

    @Override
    public int Calculate(Employee employee) {
        if (this.Weight == 0) {
            return 0;
        }
        SchedulingPeriod schedulingPeriod = employee.Roster.SchedulingPeriod;
        int penalty = 0;
        int minConsecutiveFreeDays = employee.EmployeeDescription.Contract.MinConsecutiveFreeDays;
        int consecutiveFreeDays = employee.EmployeeDescription.SchedulingHistory.PreviousConsecutiveFreeDaysAndHoliday;
        boolean atLeastOneNonWorkingDay = employee.EmployeeDescription.SchedulingHistory.PreviousConsecutiveFreeDaysAndHolidayIncludesAtLeastOneNonWorkingDay;
        int numDaysInPeriod = schedulingPeriod.NumDaysInPeriod;
        int i = 0;
        while (i < numDaysInPeriod) {
            if (employee.DayType[i] != 1) {
                ++consecutiveFreeDays;
                if (employee.DayType[i] == 0) {
                    atLeastOneNonWorkingDay = true;
                }
            } else {
                if (consecutiveFreeDays != 0 && atLeastOneNonWorkingDay && consecutiveFreeDays < minConsecutiveFreeDays) {
                    int end;
                    int extra = minConsecutiveFreeDays - consecutiveFreeDays;
                    int pen = this.Weight * extra;
                    penalty += pen;
                    int j = end = i - 1 + extra;
                    while (j >= 0 && j > end - (consecutiveFreeDays + extra + extra)) {
                        if (j < numDaysInPeriod) {
                            int n = j;
                            employee.ConstraintViolationPenalties[n] = employee.ConstraintViolationPenalties[n] + pen;
                            if (SoftConstraints.UpdateViolationDescriptions) {
                                int n2 = j;
                                employee.ViolationDescriptions[n2] = String.valueOf(employee.ViolationDescriptions[n2]) + "Too few consecutive free days (min " + minConsecutiveFreeDays + "). " + System.getProperty("line.separator");
                            }
                        }
                        --j;
                    }
                }
                consecutiveFreeDays = 0;
                atLeastOneNonWorkingDay = false;
            }
            ++i;
        }
        return penalty;
    }
}

