/*
 * Decompiled with CFR 0.152.
 */
package ASAP.NRP.Core.Constraints.ANROM;

import ASAP.NRP.Core.Constraints.SoftConstraint;
import ASAP.NRP.Core.Constraints.SoftConstraints;
import ASAP.NRP.Core.Employee;
import ASAP.NRP.Core.EmployeeDescription;
import ASAP.NRP.Core.SchedulingPeriod;
import ASAP.NRP.Core.ShiftType;

public class MinTimeBetweenShifts
implements SoftConstraint {
    public String Title = "Min time between shifts";
    public String LongTitle = "";
    public int Weight = 0;
    public String ID = "";

    public MinTimeBetweenShifts(int Weight) {
        this.Weight = Weight;
    }

    @Override
    public void Delete(EmployeeDescription employee) {
    }

    @Override
    public String getTitle() {
        return this.Title;
    }

    @Override
    public int getWeight() {
        return this.Weight;
    }

    @Override
    public String ToXml(EmployeeDescription employee) {
        return "";
    }

    @Override
    public String GetDescription(Employee employee) {
        return "(Penalised per minute over)";
    }

    @Override
    public int Calculate(Employee employee, int startDay, int endDay) {
        return this.Calculate(employee);
    }

    public int Calculate(Employee employee, int maxPenalty, int startDay, int endDay) {
        return this.Calculate(employee);
    }

    @Override
    public int Calculate(Employee employee, int startDay, int endDay, boolean updateStructure) {
        return this.Calculate(employee);
    }

    @Override
    public int Calculate(Employee employee) {
        int i;
        if (this.Weight == 0) {
            return 0;
        }
        SchedulingPeriod schedulingPeriod = employee.Roster.SchedulingPeriod;
        int overlappingMinutes = 0;
        int shiftCount = schedulingPeriod.ShiftTypesCount;
        int numDaysInPeriod = schedulingPeriod.NumDaysInPeriod;
        if (employee.EmployeeDescription.SchedulingHistory.LastDayType == 1 && employee.DayType[0] == 1) {
            i = 0;
            while (i < shiftCount) {
                if (employee.EmployeeDescription.SchedulingHistory.LastDayAssignments[i]) {
                    ShiftType sh1 = schedulingPeriod.GetShiftType(i);
                    int j = 0;
                    while (j < shiftCount) {
                        if (employee.ShiftAssignments[j]) {
                            ShiftType sh2 = schedulingPeriod.GetShiftType(j);
                            int overlap = schedulingPeriod.OverlappingMinutes(sh1, sh2, false);
                            overlappingMinutes += overlap;
                            if (overlap > 0) {
                                int pen = overlap * this.Weight;
                                employee.ConstraintViolationPenalties[0] = employee.ConstraintViolationPenalties[0] + pen;
                                if (SoftConstraints.UpdateViolationDescriptions) {
                                    employee.ViolationDescriptions[0] = String.valueOf(employee.ViolationDescriptions[0]) + "Not enough rest time between shift '" + sh1.Label + "' on the previous day and '" + sh2.Label + "' on this day. " + System.getProperty("line.separator");
                                }
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        i = 0;
        while (i < numDaysInPeriod) {
            if (employee.DayType[i] == 1) {
                int index = shiftCount * i;
                int j = 0;
                while (j < shiftCount) {
                    int shift1 = index + j;
                    if (employee.ShiftAssignments[shift1]) {
                        int pen;
                        int overlap;
                        ShiftType sh2;
                        int shift2;
                        ShiftType sh1 = schedulingPeriod.GetShiftType(j);
                        int k = j + 1;
                        while (k < shiftCount) {
                            shift2 = index + k;
                            if (employee.ShiftAssignments[shift2]) {
                                sh2 = schedulingPeriod.GetShiftType(k);
                                overlap = schedulingPeriod.OverlappingMinutes(sh1, sh2, true);
                                overlappingMinutes += overlap;
                                if (overlap > 0) {
                                    pen = overlap * this.Weight;
                                    int n = i;
                                    employee.ConstraintViolationPenalties[n] = employee.ConstraintViolationPenalties[n] + pen;
                                    if (SoftConstraints.UpdateViolationDescriptions) {
                                        int n2 = i;
                                        employee.ViolationDescriptions[n2] = String.valueOf(employee.ViolationDescriptions[n2]) + "Not enough rest time between shifts '" + sh1.Label + "' and '" + sh2.Label + "' on this day. " + System.getProperty("line.separator");
                                    }
                                }
                            }
                            ++k;
                        }
                        if (i + 1 < numDaysInPeriod && employee.DayType[i + 1] == 1) {
                            k = 0;
                            while (k < shiftCount) {
                                shift2 = index + shiftCount + k;
                                if (employee.ShiftAssignments[shift2]) {
                                    sh2 = schedulingPeriod.GetShiftType(k);
                                    overlap = schedulingPeriod.OverlappingMinutes(sh1, sh2, false);
                                    overlappingMinutes += overlap;
                                    if (overlap > 0) {
                                        pen = overlap * this.Weight;
                                        int n = i;
                                        employee.ConstraintViolationPenalties[n] = employee.ConstraintViolationPenalties[n] + pen;
                                        int n3 = i + 1;
                                        employee.ConstraintViolationPenalties[n3] = employee.ConstraintViolationPenalties[n3] + pen;
                                        if (SoftConstraints.UpdateViolationDescriptions) {
                                            int n4 = i;
                                            employee.ViolationDescriptions[n4] = String.valueOf(employee.ViolationDescriptions[n4]) + "Not enough rest time between shift '" + sh1.Label + "' on this day and '" + sh2.Label + "' on the next day. " + System.getProperty("line.separator");
                                            int n5 = i + 1;
                                            employee.ViolationDescriptions[n5] = String.valueOf(employee.ViolationDescriptions[n5]) + "Not enough rest time between shift '" + sh1.Label + "' on the previous day and '" + sh2.Label + "' on this day. " + System.getProperty("line.separator");
                                        }
                                    }
                                }
                                ++k;
                            }
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        return overlappingMinutes * this.Weight;
    }
}

