/*
 * Decompiled with CFR 0.152.
 */
package ASAP.NRP.Core.Constraints.ANROM;

import ASAP.NRP.Core.Constraints.SoftConstraint;
import ASAP.NRP.Core.Constraints.SoftConstraints;
import ASAP.NRP.Core.Employee;
import ASAP.NRP.Core.EmployeeDescription;
import ASAP.NRP.Core.SchedulingPeriod;
import ASAP.NRP.Core.ShiftGroup;

public class NumConsecutiveShiftGroups
implements SoftConstraint {
    public String Title = "Number of consecutive shifts from a group";
    public String LongTitle = "";
    public int Weight = 0;
    public String ID = "";

    public NumConsecutiveShiftGroups(int Weight) {
        this.Weight = Weight;
    }

    @Override
    public void Delete(EmployeeDescription employee) {
    }

    @Override
    public String getTitle() {
        return this.Title;
    }

    @Override
    public int getWeight() {
        return this.Weight;
    }

    @Override
    public String ToXml(EmployeeDescription employee) {
        return "";
    }

    @Override
    public String GetDescription(Employee employee) {
        String info = "Valid lengths of sequences of consecutive shifts from groups:";
        int index = 0;
        while (index < employee.Roster.SchedulingPeriod.ShiftGroupsCount) {
            ShiftGroup grp = employee.Roster.SchedulingPeriod.GetShiftGroup(index);
            info = String.valueOf(info) + "<br/>" + grp.ID + " (" + grp.Label + ") : ";
            int i = 0;
            while (i < employee.EmployeeDescription.Contract.ValidNumConsecutiveShiftGroups[index].length) {
                int j = i + 1;
                if (employee.EmployeeDescription.Contract.ValidNumConsecutiveShiftGroups[index][i]) {
                    info = String.valueOf(info) + j + ", ";
                }
                ++i;
            }
            ++index;
        }
        return info;
    }

    @Override
    public int Calculate(Employee employee, int startDay, int endDay) {
        return this.Calculate(employee);
    }

    public int Calculate(Employee employee, int maxPenalty, int startDay, int endDay) {
        return this.Calculate(employee);
    }

    @Override
    public int Calculate(Employee employee, int startDay, int endDay, boolean updateStructure) {
        return this.Calculate(employee);
    }

    @Override
    public int Calculate(Employee employee) {
        if (this.Weight == 0) {
            return 0;
        }
        SchedulingPeriod schedulingPeriod = employee.Roster.SchedulingPeriod;
        int penalty = 0;
        int previousConsecutiveDaysOff = employee.EmployeeDescription.SchedulingHistory.PreviousConsecutiveHolidayDaysOff;
        int index = 0;
        while (index < schedulingPeriod.ShiftGroupsCount) {
            int consDays = employee.EmployeeDescription.SchedulingHistory.PreviousConsecutiveShiftGroups[index];
            int consDaysOff = previousConsecutiveDaysOff;
            int numDaysInPeriod = schedulingPeriod.NumDaysInPeriod;
            int i = 0;
            while (i < numDaysInPeriod) {
                if (employee.ShiftGroupPerDayCount[i][index] > 0) {
                    ++consDays;
                } else if (employee.DayType[i] == 2) {
                    ++consDaysOff;
                } else {
                    boolean permitted = false;
                    int j = consDays;
                    while (j <= consDays + consDaysOff && j <= employee.EmployeeDescription.Contract.ValidNumConsecutiveShiftGroups[index].length && j > 0) {
                        if (employee.EmployeeDescription.Contract.ValidNumConsecutiveShiftGroups[index][j - 1]) {
                            permitted = true;
                            break;
                        }
                        ++j;
                    }
                    if (!permitted && consDays != 0) {
                        penalty += this.Weight;
                        int k = i - 1;
                        while (k >= 0 && k >= i - consDays + consDaysOff) {
                            int n = k;
                            employee.ConstraintViolationPenalties[n] = employee.ConstraintViolationPenalties[n] + this.Weight;
                            if (SoftConstraints.UpdateViolationDescriptions) {
                                ShiftGroup grp = schedulingPeriod.GetShiftGroup(index);
                                int n2 = k;
                                employee.ViolationDescriptions[n2] = String.valueOf(employee.ViolationDescriptions[n2]) + "Invalid length of consecutive shifts from group '" + grp.ID + "' (" + grp.Label + ")." + System.getProperty("line.separator");
                            }
                            --k;
                        }
                    }
                    consDays = 0;
                    consDaysOff = 0;
                }
                ++i;
            }
            ++index;
        }
        return penalty;
    }
}

