/*
 * Decompiled with CFR 0.152.
 */
package ASAP.NRP.Core.Constraints.ANROM;

import ASAP.NRP.Core.Constraints.SoftConstraint;
import ASAP.NRP.Core.Constraints.SoftConstraints;
import ASAP.NRP.Core.Employee;
import ASAP.NRP.Core.EmployeeDescription;
import ASAP.NRP.Core.SchedulingPeriod;
import ASAP.NRP.Core.Shift;

public class Tutorship
implements SoftConstraint {
    public String Title = "Tutorship";
    public String LongTitle = "";
    public int Weight = 0;
    public String ID = "";

    public Tutorship(int Weight) {
        this.Weight = Weight;
    }

    @Override
    public void Delete(EmployeeDescription employee) {
    }

    @Override
    public String getTitle() {
        return this.Title;
    }

    @Override
    public int getWeight() {
        return this.Weight;
    }

    @Override
    public String ToXml(EmployeeDescription employee) {
        return "";
    }

    @Override
    public String GetDescription(Employee employee) {
        String info = "Tutors: ";
        if (employee.EmployeeDescription.TutorCount == 0) {
            info = "No tutors ";
        }
        int i = 0;
        while (i < employee.EmployeeDescription.TutorCount) {
            EmployeeDescription tutorDesc = employee.EmployeeDescription.GetTutor(i);
            info = String.valueOf(info) + tutorDesc.getName() + "; ";
            ++i;
        }
        return info;
    }

    @Override
    public int Calculate(Employee employee, int startDay, int endDay) {
        return this.Calculate(employee);
    }

    public int Calculate(Employee employee, int maxPenalty, int startDay, int endDay) {
        return this.Calculate(employee);
    }

    @Override
    public int Calculate(Employee employee, int startDay, int endDay, boolean updateStructure) {
        return this.Calculate(employee);
    }

    @Override
    public int Calculate(Employee employee) {
        if (this.Weight == 0) {
            return 0;
        }
        SchedulingPeriod schedulingPeriod = employee.Roster.SchedulingPeriod;
        int penalty = 0;
        int day = 0;
        while (day < schedulingPeriod.NumDaysInPeriod) {
            int index = 0;
            while (index < schedulingPeriod.ShiftTypesCount) {
                Shift shift = employee.ShiftsOnDay[day][index];
                if (shift != null) {
                    int i = 0;
                    while (i < employee.EmployeeDescription.TutorCount) {
                        EmployeeDescription tutorDesc = employee.EmployeeDescription.GetTutor(i);
                        Employee tutor = employee.Roster.GetEmployee(tutorDesc.ID);
                        if (tutor == null || !tutor.WorksDuringEntirePeriodOfShift(shift)) {
                            penalty += this.Weight;
                            int n = shift.RosterDay;
                            employee.ConstraintViolationPenalties[n] = employee.ConstraintViolationPenalties[n] + this.Weight;
                            if (SoftConstraints.UpdateViolationDescriptions) {
                                int n2 = shift.RosterDay;
                                employee.ViolationDescriptions[n2] = String.valueOf(employee.ViolationDescriptions[n2]) + "Requests tutorship from '" + tutorDesc.getName() + "', penalty=" + this.Weight + ". " + System.getProperty("line.separator");
                            }
                        }
                        ++i;
                    }
                }
                ++index;
            }
            ++day;
        }
        return penalty;
    }
}

