/*
 * Decompiled with CFR 0.152.
 */
package ASAP.NRP.Core.Constraints.ANROM;

import ASAP.NRP.Core.Constraints.SoftConstraint;
import ASAP.NRP.Core.Constraints.SoftConstraints;
import ASAP.NRP.Core.Employee;
import ASAP.NRP.Core.EmployeeDescription;
import ASAP.NRP.Core.SchedulingPeriod;
import ASAP.NRP.Core.Shift;

public class WorkSeparately
implements SoftConstraint {
    public String Title = "Work separately";
    public String LongTitle = "";
    public int Weight = 0;
    public String ID = "";

    public WorkSeparately(int weight) {
        this.Weight = weight;
    }

    @Override
    public void Delete(EmployeeDescription employee) {
    }

    @Override
    public String getTitle() {
        return this.Title;
    }

    @Override
    public int getWeight() {
        return this.Weight;
    }

    @Override
    public String ToXml(EmployeeDescription employee) {
        return "";
    }

    @Override
    public String GetDescription(Employee employee) {
        String info = "Do not work at same time as: ";
        if (employee.EmployeeDescription.AvoidPartnershipsCount == 0) {
            info = "No requirements";
        }
        int i = 0;
        while (i < employee.EmployeeDescription.AvoidPartnershipsCount) {
            EmployeeDescription desc = employee.EmployeeDescription.GetAvoidPartnership(i);
            info = String.valueOf(info) + desc.getName() + "; ";
            ++i;
        }
        return info;
    }

    @Override
    public int Calculate(Employee employee, int startDay, int endDay) {
        return this.Calculate(employee);
    }

    public int Calculate(Employee employee, int maxPenalty, int startDay, int endDay) {
        return this.Calculate(employee);
    }

    @Override
    public int Calculate(Employee employee, int startDay, int endDay, boolean updateStructure) {
        return this.Calculate(employee);
    }

    @Override
    public int Calculate(Employee employee) {
        if (this.Weight == 0) {
            return 0;
        }
        SchedulingPeriod schedulingPeriod = employee.Roster.SchedulingPeriod;
        int penalty = 0;
        int day = 0;
        while (day < schedulingPeriod.NumDaysInPeriod) {
            int index = 0;
            while (index < schedulingPeriod.ShiftTypesCount) {
                Shift shift = employee.ShiftsOnDay[day][index];
                if (shift != null) {
                    int i = 0;
                    while (i < employee.EmployeeDescription.AvoidPartnershipsCount) {
                        EmployeeDescription employee2Desc = employee.EmployeeDescription.GetAvoidPartnership(i);
                        Employee employee2 = employee.Roster.GetEmployee(employee2Desc.ID);
                        if (employee2 != null && employee2.WorksDuringPeriod(shift)) {
                            penalty += this.Weight;
                            int n = shift.RosterDay;
                            employee.ConstraintViolationPenalties[n] = employee.ConstraintViolationPenalties[n] + this.Weight;
                            if (SoftConstraints.UpdateViolationDescriptions) {
                                int n2 = shift.RosterDay;
                                employee.ViolationDescriptions[n2] = String.valueOf(employee.ViolationDescriptions[n2]) + "Requests not to work at same time as employee '" + employee2Desc.getName() + "', penalty=" + this.Weight + ". " + System.getProperty("line.separator");
                            }
                        }
                        ++i;
                    }
                }
                ++index;
            }
            ++day;
        }
        return penalty;
    }
}

