/*
 * Decompiled with CFR 0.152.
 */
package ASAP.NRP.Core.Constraints.Montreal;

import ASAP.NRP.Core.Constraints.SoftConstraint;
import ASAP.NRP.Core.Constraints.SoftConstraints;
import ASAP.NRP.Core.DaysOffRequestBetweenDates;
import ASAP.NRP.Core.Employee;
import ASAP.NRP.Core.EmployeeDescription;

public class DaysOffRequestsBetweenDates
implements SoftConstraint {
    public String Title = "Min/Max days off between two dates";
    public String LongTitle = "";
    public int Weight = 0;
    public String ID = "";

    @Override
    public String GetDescription(Employee employee) {
        return "";
    }

    @Override
    public String getTitle() {
        return this.Title;
    }

    @Override
    public int getWeight() {
        return this.Weight;
    }

    @Override
    public void Delete(EmployeeDescription employee) {
    }

    @Override
    public String ToXml(EmployeeDescription employee) {
        return "";
    }

    @Override
    public int Calculate(Employee employee, int startDay, int endDay) {
        return this.Calculate(employee);
    }

    public int Calculate(Employee employee, int maxPenalty, int startDay, int endDay) {
        return this.Calculate(employee);
    }

    @Override
    public int Calculate(Employee employee, int startDay, int endDay, boolean updateStructure) {
        return this.Calculate(employee);
    }

    @Override
    public int Calculate(Employee employee) {
        if (employee.EmployeeDescription.DaysOffRequestBetweenDatesCount <= 0) {
            return 0;
        }
        int penalty = 0;
        int i = 0;
        while (i < employee.EmployeeDescription.DaysOffRequestsBetweenDates.length) {
            int j;
            int pen;
            DaysOffRequestBetweenDates req = employee.EmployeeDescription.DaysOffRequestsBetweenDates[i];
            int count = 0;
            int j2 = req.StartDay;
            while (j2 <= req.EndDay) {
                if (employee.DayType[j2] != 1) {
                    ++count;
                }
                ++j2;
            }
            if (count < req.Min) {
                pen = req.Weight * (req.Min - count);
                penalty += pen;
                j = req.StartDay;
                while (j <= req.EndDay) {
                    if (employee.DayType[j] == 1) {
                        int n = j;
                        employee.ConstraintViolationPenalties[n] = employee.ConstraintViolationPenalties[n] + pen;
                        if (SoftConstraints.UpdateViolationDescriptions) {
                            int n2 = j;
                            employee.ViolationDescriptions[n2] = String.valueOf(employee.ViolationDescriptions[n2]) + "Too few days off days between " + employee.EmployeeDescription.SchedulingPeriod.ConvertRosterDayToDate(req.StartDay).ToString("yyyy-MM-dd") + " and " + employee.EmployeeDescription.SchedulingPeriod.ConvertRosterDayToDate(req.EndDay).ToString("yyyy-MM-dd") + ". Requests min " + req.Min + " days off (receives " + count + "). " + System.getProperty("line.separator");
                        }
                    }
                    ++j;
                }
            } else if (count > req.Max) {
                pen = req.Weight * (count - req.Max);
                penalty += pen;
                j = req.StartDay;
                while (j <= req.EndDay) {
                    if (employee.DayType[j] != 1) {
                        int n = j;
                        employee.ConstraintViolationPenalties[n] = employee.ConstraintViolationPenalties[n] + pen;
                        if (SoftConstraints.UpdateViolationDescriptions) {
                            int n3 = j;
                            employee.ViolationDescriptions[n3] = String.valueOf(employee.ViolationDescriptions[n3]) + "Too many days off days between " + employee.EmployeeDescription.SchedulingPeriod.ConvertRosterDayToDate(req.StartDay).ToString("yyyy-MM-dd") + " and " + employee.EmployeeDescription.SchedulingPeriod.ConvertRosterDayToDate(req.EndDay).ToString("yyyy-MM-dd") + ". Requests max " + req.Max + " days off (receives " + count + "). " + System.getProperty("line.separator");
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        return penalty;
    }
}

