/*
 * Decompiled with CFR 0.152.
 */
package ASAP.NRP.Core.Constraints.Montreal;

import ASAP.NRP.Core.Constraints.SoftConstraint;
import ASAP.NRP.Core.Constraints.SoftConstraints;
import ASAP.NRP.Core.Employee;
import ASAP.NRP.Core.EmployeeDescription;
import ASAP.NRP.Core.SchedulingPeriod;
import ASAP.NRP.Core.ShiftGroup;

public class MaxConsecutiveShiftGroups
implements SoftConstraint {
    public String Title = "Max consecutive shifts from a group";
    public String LongTitle = "";
    public int Weight = 0;
    public String ID = "";

    public MaxConsecutiveShiftGroups(int Weight) {
        this.Weight = Weight;
    }

    @Override
    public void Delete(EmployeeDescription employee) {
    }

    @Override
    public String getTitle() {
        return this.Title;
    }

    @Override
    public int getWeight() {
        return this.Weight;
    }

    @Override
    public String ToXml(EmployeeDescription employee) {
        return "";
    }

    @Override
    public String GetDescription(Employee employee) {
        String info = "Max consecutive shifts from a group";
        SchedulingPeriod sp = employee.Roster.SchedulingPeriod;
        int x = 0;
        while (x < sp.ShiftGroupsCount) {
            ShiftGroup sg = sp.GetShiftGroup(x);
            String ID = sg.Label;
            int i = sg.Index;
            int max = employee.EmployeeDescription.Contract.MaxConsecutiveShiftGroups[i];
            if (max > 0) {
                info = String.valueOf(info) + "<br/>Requests max " + max + " consecutive shifts from group '" + ID + "'";
            }
            ++x;
        }
        return info;
    }

    @Override
    public int Calculate(Employee employee, int startDay, int endDay) {
        return this.Calculate(employee);
    }

    public int Calculate(Employee employee, int maxPenalty, int startDay, int endDay) {
        return this.Calculate(employee);
    }

    @Override
    public int Calculate(Employee employee, int startDay, int endDay, boolean updateStructure) {
        return this.Calculate(employee);
    }

    @Override
    public int Calculate(Employee employee) {
        if (this.Weight == 0) {
            return 0;
        }
        SchedulingPeriod schedulingPeriod = employee.Roster.SchedulingPeriod;
        int penalty = 0;
        int shiftTypeCount = schedulingPeriod.ShiftTypesCount;
        int shiftGroupCount = schedulingPeriod.ShiftGroupsCount;
        int numDaysInPeriod = schedulingPeriod.NumDaysInPeriod;
        int index = 0;
        while (index < shiftGroupCount) {
            int max = employee.EmployeeDescription.Contract.MaxConsecutiveShiftGroups[index];
            if (max >= 1) {
                ShiftGroup group = schedulingPeriod.GetShiftGroup(index);
                int consDays = employee.EmployeeDescription.SchedulingHistory.PreviousConsecutiveShiftGroups[index];
                int day = 0;
                while (day < numDaysInPeriod) {
                    boolean shiftWorked = false;
                    int i = 0;
                    while (i < group.Group.length) {
                        if (employee.ShiftAssignments[day * shiftTypeCount + group.Group[i].Index]) {
                            shiftWorked = true;
                            break;
                        }
                        ++i;
                    }
                    if (shiftWorked) {
                        ++consDays;
                    }
                    if (!shiftWorked || day + 1 == numDaysInPeriod) {
                        if (consDays > max) {
                            int pen = this.Weight * (consDays - max);
                            penalty += pen;
                            int end = day - 1;
                            if (shiftWorked) {
                                end = day;
                            }
                            int j = end;
                            while (j >= 0 && j > end - consDays) {
                                int n = j;
                                employee.ConstraintViolationPenalties[n] = employee.ConstraintViolationPenalties[n] + pen;
                                if (SoftConstraints.UpdateViolationDescriptions) {
                                    String label = group.Label;
                                    int n2 = j;
                                    employee.ViolationDescriptions[n2] = String.valueOf(employee.ViolationDescriptions[n2]) + "Max " + max + " consecutive shifts from shift group '" + label + "' required." + System.getProperty("line.separator");
                                }
                                --j;
                            }
                        }
                        consDays = 0;
                    }
                    ++day;
                }
            }
            ++index;
        }
        return penalty;
    }
}

