/*
 * Decompiled with CFR 0.152.
 */
package ASAP.NRP.Core.Constraints.Montreal;

import ASAP.NRP.Core.Constraints.SoftConstraint;
import ASAP.NRP.Core.Constraints.SoftConstraints;
import ASAP.NRP.Core.Employee;
import ASAP.NRP.Core.EmployeeDescription;
import ASAP.NRP.Core.SchedulingPeriod;
import ASAP.NRP.Core.ShiftType;

public class MaxConsecutiveShiftTypes
implements SoftConstraint {
    public String Title = "Max consecutive shift types";
    public String LongTitle = "";
    public int Weight = 0;
    public String ID = "";

    public MaxConsecutiveShiftTypes(int Weight) {
        this.Weight = Weight;
    }

    @Override
    public String getTitle() {
        return this.Title;
    }

    @Override
    public int getWeight() {
        return this.Weight;
    }

    @Override
    public void Delete(EmployeeDescription employee) {
    }

    @Override
    public String ToXml(EmployeeDescription employee) {
        return "";
    }

    @Override
    public String GetDescription(Employee employee) {
        String info = "Max consecutive shift types";
        SchedulingPeriod schedulingPeriod = employee.Roster.SchedulingPeriod;
        int x = 0;
        while (x < schedulingPeriod.ShiftTypesCount) {
            ShiftType shiftType = schedulingPeriod.GetShiftType(x);
            String ID = shiftType.ID;
            int i = shiftType.Index;
            int max = employee.EmployeeDescription.Contract.MaxConsecutiveShiftTypes[i];
            if (max > 0) {
                info = String.valueOf(info) + "<br/>Requests max " + max + " consecutive '" + ID + "' shifts";
            }
            ++x;
        }
        return info;
    }

    @Override
    public int Calculate(Employee employee, int startDay, int endDay) {
        return this.Calculate(employee);
    }

    public int Calculate(Employee employee, int maxPenalty, int startDay, int endDay) {
        return this.Calculate(employee);
    }

    @Override
    public int Calculate(Employee employee, int startDay, int endDay, boolean updateStructure) {
        return this.Calculate(employee);
    }

    @Override
    public int Calculate(Employee employee) {
        if (this.Weight == 0) {
            return 0;
        }
        SchedulingPeriod schedulingPeriod = employee.Roster.SchedulingPeriod;
        int penalty = 0;
        int shiftTypeCount = schedulingPeriod.ShiftTypesCount;
        int numDaysInPeriod = schedulingPeriod.NumDaysInPeriod;
        int shiftIndex = 0;
        while (shiftIndex < shiftTypeCount) {
            int max = employee.EmployeeDescription.Contract.MaxConsecutiveShiftTypes[shiftIndex];
            if (max >= 1) {
                int consDays = employee.EmployeeDescription.SchedulingHistory.PreviousConsecutiveShifts[shiftIndex];
                int i = 0;
                while (i < numDaysInPeriod) {
                    boolean shiftWorked = employee.ShiftAssignments[i * shiftTypeCount + shiftIndex];
                    if (shiftWorked) {
                        ++consDays;
                    }
                    if (!shiftWorked || i + 1 == numDaysInPeriod) {
                        if (consDays > max) {
                            int pen = this.Weight * (consDays - max);
                            penalty += pen;
                            int end = i - 1;
                            if (shiftWorked) {
                                end = i;
                            }
                            int j = end;
                            while (j >= 0 && j > end - consDays) {
                                int n = j;
                                employee.ConstraintViolationPenalties[n] = employee.ConstraintViolationPenalties[n] + pen;
                                if (SoftConstraints.UpdateViolationDescriptions) {
                                    String label = schedulingPeriod.GetShiftType((int)shiftIndex).Label;
                                    int n2 = j;
                                    employee.ViolationDescriptions[n2] = String.valueOf(employee.ViolationDescriptions[n2]) + "Max " + max + " consecutive '" + label + "' shifts required." + System.getProperty("line.separator");
                                }
                                --j;
                            }
                        }
                        consDays = 0;
                    }
                    ++i;
                }
            }
            ++shiftIndex;
        }
        return penalty;
    }
}

