/*
 * Decompiled with CFR 0.152.
 */
package ASAP.NRP.Core.Constraints.Montreal;

import ASAP.NRP.Core.Constraints.SoftConstraint;
import ASAP.NRP.Core.Constraints.SoftConstraints;
import ASAP.NRP.Core.Employee;
import ASAP.NRP.Core.EmployeeDescription;
import ASAP.NRP.Core.SchedulingPeriod;
import ASAP.NRP.Core.ShiftGroup;

public class MaxShiftGroupRatios
implements SoftConstraint {
    public String Title = "Max shift group ratios";
    public String LongTitle = "";
    public int Weight = 0;
    public String ID = "";

    public MaxShiftGroupRatios(int Weight) {
        this.Weight = Weight;
    }

    @Override
    public String getTitle() {
        return this.Title;
    }

    @Override
    public int getWeight() {
        return this.Weight;
    }

    @Override
    public void Delete(EmployeeDescription employee) {
    }

    @Override
    public String ToXml(EmployeeDescription employee) {
        return "";
    }

    @Override
    public String GetDescription(Employee employee) {
        String info = "Max shift group ratios";
        SchedulingPeriod schedulingPeriod = employee.Roster.SchedulingPeriod;
        int totShifts = employee.ShiftsCount;
        int x = 0;
        while (x < schedulingPeriod.ShiftGroupsCount) {
            ShiftGroup shiftGroup = schedulingPeriod.GetShiftGroup(x);
            String ID = shiftGroup.ID;
            int i = shiftGroup.Index;
            if (employee.EmployeeDescription.Contract.MaxShiftGroupRatios[i] >= 0) {
                int ratio = 0;
                if (totShifts != 0) {
                    ratio = (int)((float)employee.ShiftGroupCount[i] / (float)totShifts * 100.0f);
                }
                info = String.valueOf(info) + "<br/>Requests max " + employee.EmployeeDescription.Contract.MaxShiftGroupRatios[i] + "% shifts from group '" + ID + "' (" + shiftGroup.Label + "), receives " + ratio + "%";
            }
            ++x;
        }
        return info;
    }

    @Override
    public int Calculate(Employee employee, int startDay, int endDay) {
        return this.Calculate(employee);
    }

    @Override
    public int Calculate(Employee employee, int startDay, int endDay, boolean updateStructure) {
        return this.Calculate(employee);
    }

    @Override
    public int Calculate(Employee employee) {
        if (this.Weight == 0) {
            return 0;
        }
        SchedulingPeriod schedulingPeriod = employee.Roster.SchedulingPeriod;
        int penalty = 0;
        int shiftCount = schedulingPeriod.ShiftGroupsCount;
        int totShifts = employee.ShiftsCount;
        int i = 0;
        while (i < shiftCount) {
            int max = employee.EmployeeDescription.Contract.MaxShiftGroupRatios[i];
            int ratio = 0;
            if (totShifts != 0) {
                ratio = (int)((float)employee.ShiftGroupCount[i] / (float)totShifts * 100.0f);
            }
            if (max >= 0 && ratio > max) {
                int pen = this.Weight * (ratio - max);
                penalty += pen;
                int day = 0;
                while (day < schedulingPeriod.NumDaysInPeriod) {
                    if (employee.ShiftGroupPerDayCount[day][i] > 0) {
                        int n = day;
                        employee.ConstraintViolationPenalties[n] = employee.ConstraintViolationPenalties[n] + pen;
                        if (SoftConstraints.UpdateViolationDescriptions) {
                            int n2 = day;
                            employee.ViolationDescriptions[n2] = String.valueOf(employee.ViolationDescriptions[n2]) + "Requests max " + max + "% shifts from group '" + schedulingPeriod.GetShiftGroup((int)i).ID + "' (" + schedulingPeriod.GetShiftGroup((int)i).Label + "), receives " + ratio + "% " + System.getProperty("line.separator");
                        }
                    }
                    ++day;
                }
            }
            ++i;
        }
        return penalty;
    }
}

