/*
 * Decompiled with CFR 0.152.
 */
package ASAP.NRP.Core.Constraints.Montreal;

import ASAP.NRP.Core.Constraints.SoftConstraint;
import ASAP.NRP.Core.Constraints.SoftConstraints;
import ASAP.NRP.Core.Employee;
import ASAP.NRP.Core.EmployeeDescription;
import ASAP.NRP.Core.SchedulingPeriod;
import ASAP.NRP.Core.ShiftType;

public class MaxShiftTypeRatios
implements SoftConstraint {
    public String Title = "Max shift type ratios";
    public String LongTitle = "";
    public int Weight = 0;
    public String ID = "";

    public MaxShiftTypeRatios(int Weight) {
        this.Weight = Weight;
    }

    @Override
    public String getTitle() {
        return this.Title;
    }

    @Override
    public int getWeight() {
        return this.Weight;
    }

    @Override
    public void Delete(EmployeeDescription employee) {
    }

    @Override
    public String ToXml(EmployeeDescription employee) {
        return "";
    }

    @Override
    public String GetDescription(Employee employee) {
        String info = "Max shift type ratios";
        SchedulingPeriod schedulingPeriod = employee.Roster.SchedulingPeriod;
        int totShifts = employee.ShiftsCount;
        int x = 0;
        while (x < schedulingPeriod.ShiftTypesCount) {
            ShiftType shiftType = schedulingPeriod.GetShiftType(x);
            String ID = shiftType.ID;
            int i = shiftType.Index;
            if (employee.EmployeeDescription.Contract.MaxShiftTypeRatios[i] >= 0) {
                int ratio = 0;
                if (totShifts != 0) {
                    ratio = (int)((float)employee.ShiftTypeCount[i] / (float)totShifts * 100.0f);
                }
                info = String.valueOf(info) + "<br/>Requests max " + employee.EmployeeDescription.Contract.MaxShiftTypeRatios[i] + "% '" + ID + "' shifts, receives " + ratio + "%";
            }
            ++x;
        }
        return info;
    }

    @Override
    public int Calculate(Employee employee, int startDay, int endDay) {
        return this.Calculate(employee);
    }

    public int Calculate(Employee employee, int maxPenalty, int startDay, int endDay) {
        return this.Calculate(employee);
    }

    @Override
    public int Calculate(Employee employee, int startDay, int endDay, boolean updateStructure) {
        return this.Calculate(employee);
    }

    @Override
    public int Calculate(Employee employee) {
        if (this.Weight == 0) {
            return 0;
        }
        SchedulingPeriod schedulingPeriod = employee.Roster.SchedulingPeriod;
        int penalty = 0;
        int shiftCount = schedulingPeriod.ShiftTypesCount;
        int totShifts = employee.ShiftsCount;
        int i = 0;
        while (i < shiftCount) {
            int max = employee.EmployeeDescription.Contract.MaxShiftTypeRatios[i];
            int ratio = 0;
            if (totShifts != 0) {
                ratio = (int)((float)employee.ShiftTypeCount[i] / (float)totShifts * 100.0f);
            }
            if (max >= 0 && ratio > max) {
                int pen = this.Weight * (ratio - max);
                penalty += pen;
                int day = 0;
                while (day < schedulingPeriod.NumDaysInPeriod) {
                    int index = shiftCount * day + i;
                    if (employee.ShiftAssignments[index]) {
                        int n = day;
                        employee.ConstraintViolationPenalties[n] = employee.ConstraintViolationPenalties[n] + pen;
                        if (SoftConstraints.UpdateViolationDescriptions) {
                            int n2 = day;
                            employee.ViolationDescriptions[n2] = String.valueOf(employee.ViolationDescriptions[n2]) + "Requests max " + max + "% '" + schedulingPeriod.GetShiftType((int)i).ID + "' shifts, receives " + ratio + "% " + System.getProperty("line.separator");
                        }
                    }
                    ++day;
                }
            }
            ++i;
        }
        return penalty;
    }
}

