/*
 * Decompiled with CFR 0.152.
 */
package ASAP.NRP.Core.Constraints.Montreal;

import ASAP.NRP.Core.Constraints.SoftConstraint;
import ASAP.NRP.Core.Constraints.SoftConstraints;
import ASAP.NRP.Core.Employee;
import ASAP.NRP.Core.EmployeeDescription;
import ASAP.NRP.Core.SchedulingPeriod;

public class MinConsecutiveFreeWeekends
implements SoftConstraint {
    public String Title = "Min consecutive free weekends";
    public String LongTitle = "";
    public int Weight = 0;
    public String ID = "";

    public MinConsecutiveFreeWeekends(int Weight) {
        this.Weight = Weight;
    }

    @Override
    public String getTitle() {
        return this.Title;
    }

    @Override
    public int getWeight() {
        return this.Weight;
    }

    @Override
    public void Delete(EmployeeDescription employee) {
    }

    @Override
    public String ToXml(EmployeeDescription employee) {
        return "";
    }

    @Override
    public String GetDescription(Employee employee) {
        return "Requests min " + employee.EmployeeDescription.Contract.MinConsecutiveFreeWeekends + " consecutive free weekends.";
    }

    @Override
    public int Calculate(Employee employee, int startDay, int endDay) {
        return this.Calculate(employee);
    }

    public int Calculate(Employee employee, int maxPenalty, int startDay, int endDay) {
        return this.Calculate(employee);
    }

    @Override
    public int Calculate(Employee employee, int startDay, int endDay, boolean updateStructure) {
        return this.Calculate(employee);
    }

    @Override
    public int Calculate(Employee employee) {
        if (this.Weight == 0) {
            return 0;
        }
        SchedulingPeriod schedulingPeriod = employee.Roster.SchedulingPeriod;
        int penalty = 0;
        int min = employee.EmployeeDescription.Contract.MinConsecutiveFreeWeekends;
        int consecutive = 0;
        int saturdayIndex = schedulingPeriod.FirstSaturday;
        if (saturdayIndex == 6) {
            if (employee.EmployeeDescription.SchedulingHistory.LastDayType == 0 && employee.DayType[0] == 0) {
                consecutive = 1;
            }
        } else if (saturdayIndex < 0) {
            if (consecutive < min) {
                penalty += this.Weight * (min - consecutive);
            }
            return penalty;
        }
        int numDaysInPeriod = schedulingPeriod.NumDaysInPeriod;
        while (saturdayIndex < numDaysInPeriod) {
            boolean free = false;
            if (employee.DayType[saturdayIndex] == 0 && saturdayIndex + 1 < employee.DayType.length && employee.DayType[saturdayIndex + 1] == 0) {
                ++consecutive;
                free = true;
            }
            if (!free || saturdayIndex + 7 >= numDaysInPeriod) {
                if (consecutive != 0 && consecutive < min) {
                    int temp;
                    int extra = min - consecutive;
                    int pen = this.Weight * extra;
                    penalty += pen;
                    int i = temp = saturdayIndex + (extra - 1) * 7;
                    while (i >= saturdayIndex) {
                        if (i < numDaysInPeriod && employee.DayType[i] != 0) {
                            int n = i;
                            employee.ConstraintViolationPenalties[n] = employee.ConstraintViolationPenalties[n] + pen;
                            if (SoftConstraints.UpdateViolationDescriptions) {
                                int n2 = i;
                                employee.ViolationDescriptions[n2] = String.valueOf(employee.ViolationDescriptions[n2]) + "Too few consecutive free weekends. " + System.getProperty("line.separator");
                            }
                        }
                        if (i + 1 < numDaysInPeriod && employee.DayType[i + 1] != 0) {
                            int n = i + 1;
                            employee.ConstraintViolationPenalties[n] = employee.ConstraintViolationPenalties[n] + pen;
                            if (SoftConstraints.UpdateViolationDescriptions) {
                                int n3 = i + 1;
                                employee.ViolationDescriptions[n3] = String.valueOf(employee.ViolationDescriptions[n3]) + "Too few consecutive free weekends. " + System.getProperty("line.separator");
                            }
                        }
                        i -= 7;
                    }
                    i = saturdayIndex - 7;
                    while (i >= 0 && i > saturdayIndex - (consecutive + 7)) {
                        if (i < numDaysInPeriod) {
                            int n = i;
                            employee.ConstraintViolationPenalties[n] = employee.ConstraintViolationPenalties[n] + pen;
                            if (SoftConstraints.UpdateViolationDescriptions) {
                                int n4 = i;
                                employee.ViolationDescriptions[n4] = String.valueOf(employee.ViolationDescriptions[n4]) + "Too few consecutive free weekends. " + System.getProperty("line.separator");
                            }
                        }
                        if (i + 1 < numDaysInPeriod) {
                            int n = i + 1;
                            employee.ConstraintViolationPenalties[n] = employee.ConstraintViolationPenalties[n] + pen;
                            if (SoftConstraints.UpdateViolationDescriptions) {
                                int n5 = i + 1;
                                employee.ViolationDescriptions[n5] = String.valueOf(employee.ViolationDescriptions[n5]) + "Too few consecutive free weekends. " + System.getProperty("line.separator");
                            }
                        }
                        i -= 7;
                    }
                    i = temp = saturdayIndex - (consecutive + 7);
                    while (i >= 0 && i >= saturdayIndex - min * 7) {
                        if (i < numDaysInPeriod && employee.DayType[i] != 0) {
                            int n = i;
                            employee.ConstraintViolationPenalties[n] = employee.ConstraintViolationPenalties[n] + pen;
                            if (SoftConstraints.UpdateViolationDescriptions) {
                                int n6 = i;
                                employee.ViolationDescriptions[n6] = String.valueOf(employee.ViolationDescriptions[n6]) + "Too few consecutive free weekends. " + System.getProperty("line.separator");
                            }
                        }
                        if (i + 1 < numDaysInPeriod && employee.DayType[i + 1] != 0) {
                            int n = i + 1;
                            employee.ConstraintViolationPenalties[n] = employee.ConstraintViolationPenalties[n] + pen;
                            if (SoftConstraints.UpdateViolationDescriptions) {
                                int n7 = i + 1;
                                employee.ViolationDescriptions[n7] = String.valueOf(employee.ViolationDescriptions[n7]) + "Too few consecutive free weekends. " + System.getProperty("line.separator");
                            }
                        }
                        i -= 7;
                    }
                }
                consecutive = 0;
            }
            saturdayIndex += 7;
        }
        return penalty;
    }
}

