/*
 * Decompiled with CFR 0.152.
 */
package ASAP.NRP.Core.Constraints.Montreal;

import ASAP.NRP.Core.Constraints.SoftConstraint;
import ASAP.NRP.Core.Constraints.SoftConstraints;
import ASAP.NRP.Core.Employee;
import ASAP.NRP.Core.EmployeeDescription;
import ASAP.NRP.Core.SchedulingPeriod;

public class MinConsecutiveWorkingWeekends
implements SoftConstraint {
    public String Title = "Min consecutive working weekends";
    public String LongTitle = "";
    public int Weight = 0;
    public String ID = "";

    public MinConsecutiveWorkingWeekends(int weight) {
        this.Weight = weight;
    }

    @Override
    public String getTitle() {
        return this.Title;
    }

    @Override
    public int getWeight() {
        return this.Weight;
    }

    @Override
    public void Delete(EmployeeDescription employee) {
    }

    @Override
    public String ToXml(EmployeeDescription employee) {
        return "";
    }

    @Override
    public String GetDescription(Employee employee) {
        return "Requests min " + employee.EmployeeDescription.Contract.MinConsecutiveWorkingWeekends + " consecutive working weekends.";
    }

    @Override
    public int Calculate(Employee employee, int startDay, int endDay) {
        return this.Calculate(employee);
    }

    public int Calculate(Employee employee, int maxPenalty, int startDay, int endDay) {
        return this.Calculate(employee);
    }

    @Override
    public int Calculate(Employee employee, int startDay, int endDay, boolean updateStructure) {
        return this.Calculate(employee);
    }

    @Override
    public int Calculate(Employee employee) {
        if (this.Weight == 0) {
            return 0;
        }
        SchedulingPeriod schedulingPeriod = employee.Roster.SchedulingPeriod;
        int penalty = 0;
        int min = employee.EmployeeDescription.Contract.MinConsecutiveWorkingWeekends;
        int consecutiveWorkingWeekends = employee.EmployeeDescription.SchedulingHistory.PreviousConsecutiveWorkingWeekends;
        int saturdayIndex = schedulingPeriod.FirstSaturday;
        if (saturdayIndex == 6) {
            if (consecutiveWorkingWeekends == 0 && employee.DayType[0] == 1) {
                consecutiveWorkingWeekends = 1;
            }
        } else if (saturdayIndex < 0) {
            if (consecutiveWorkingWeekends < min) {
                penalty += this.Weight * (min - consecutiveWorkingWeekends);
            }
            return penalty;
        }
        int numDaysInPeriod = schedulingPeriod.NumDaysInPeriod;
        while (saturdayIndex < numDaysInPeriod) {
            boolean workingWeekend = false;
            if (employee.DayType[saturdayIndex] == 1) {
                ++consecutiveWorkingWeekends;
                workingWeekend = true;
            } else if (saturdayIndex + 1 < employee.DayType.length && employee.DayType[saturdayIndex + 1] == 1) {
                ++consecutiveWorkingWeekends;
                workingWeekend = true;
            }
            if (!workingWeekend && consecutiveWorkingWeekends != 0) {
                if (consecutiveWorkingWeekends < min) {
                    int temp;
                    int extra = min - consecutiveWorkingWeekends;
                    int pen = this.Weight * extra;
                    penalty += pen;
                    int i = temp = saturdayIndex + (extra - 1) * 7;
                    while (i >= saturdayIndex) {
                        if (i + 1 < numDaysInPeriod && employee.DayType[i] != 1 && employee.DayType[i + 1] != 1) {
                            int n = i;
                            employee.ConstraintViolationPenalties[n] = employee.ConstraintViolationPenalties[n] + pen;
                            if (SoftConstraints.UpdateViolationDescriptions) {
                                int n2 = i;
                                employee.ViolationDescriptions[n2] = String.valueOf(employee.ViolationDescriptions[n2]) + "Too few consecutive working weekends. " + System.getProperty("line.separator");
                            }
                            int n3 = i + 1;
                            employee.ConstraintViolationPenalties[n3] = employee.ConstraintViolationPenalties[n3] + pen;
                            if (SoftConstraints.UpdateViolationDescriptions) {
                                int n4 = i + 1;
                                employee.ViolationDescriptions[n4] = String.valueOf(employee.ViolationDescriptions[n4]) + "Too few consecutive working weekends. " + System.getProperty("line.separator");
                            }
                        }
                        i -= 7;
                    }
                    i = saturdayIndex - 7;
                    while (i >= 0 && i > saturdayIndex - (consecutiveWorkingWeekends + 7)) {
                        if (i < numDaysInPeriod) {
                            int n = i;
                            employee.ConstraintViolationPenalties[n] = employee.ConstraintViolationPenalties[n] + pen;
                            if (SoftConstraints.UpdateViolationDescriptions) {
                                int n5 = i;
                                employee.ViolationDescriptions[n5] = String.valueOf(employee.ViolationDescriptions[n5]) + "Too few consecutive working weekends. " + System.getProperty("line.separator");
                            }
                        }
                        if (i + 1 < numDaysInPeriod) {
                            int n = i + 1;
                            employee.ConstraintViolationPenalties[n] = employee.ConstraintViolationPenalties[n] + pen;
                            if (SoftConstraints.UpdateViolationDescriptions) {
                                int n6 = i + 1;
                                employee.ViolationDescriptions[n6] = String.valueOf(employee.ViolationDescriptions[n6]) + "Too few consecutive working weekends. " + System.getProperty("line.separator");
                            }
                        }
                        i -= 7;
                    }
                    i = temp = saturdayIndex - (consecutiveWorkingWeekends + 7);
                    while (i >= 0 && i >= saturdayIndex - min * 7) {
                        if (employee.DayType[i] != 1 && employee.DayType[i + 1] != 1) {
                            int n = i;
                            employee.ConstraintViolationPenalties[n] = employee.ConstraintViolationPenalties[n] + pen;
                            if (SoftConstraints.UpdateViolationDescriptions) {
                                int n7 = i;
                                employee.ViolationDescriptions[n7] = String.valueOf(employee.ViolationDescriptions[n7]) + "Too few consecutive working weekends. " + System.getProperty("line.separator");
                            }
                            int n8 = i + 1;
                            employee.ConstraintViolationPenalties[n8] = employee.ConstraintViolationPenalties[n8] + pen;
                            if (SoftConstraints.UpdateViolationDescriptions) {
                                int n9 = i + 1;
                                employee.ViolationDescriptions[n9] = String.valueOf(employee.ViolationDescriptions[n9]) + "Too few consecutive working weekends. " + System.getProperty("line.separator");
                            }
                        }
                        i -= 7;
                    }
                }
                consecutiveWorkingWeekends = 0;
            }
            saturdayIndex += 7;
        }
        return penalty;
    }
}

