/*
 * Decompiled with CFR 0.152.
 */
package ASAP.NRP.Core.Constraints.ORTEC01;

import ASAP.NRP.Core.Constraints.SoftConstraint;
import ASAP.NRP.Core.Constraints.SoftConstraints;
import ASAP.NRP.Core.Employee;
import ASAP.NRP.Core.EmployeeDescription;
import ASAP.NRP.Core.SchedulingPeriod;

public class MaxWorkingWeekendsIncFriNight
implements SoftConstraint {
    public String Title = "Max working weekends (includes night shifts on Friday nights).";
    public String LongTitle = "";
    public int Weight = 0;
    public String ID = "";

    public MaxWorkingWeekendsIncFriNight(int Weight) {
        this.Weight = Weight;
    }

    @Override
    public String getTitle() {
        return this.Title;
    }

    @Override
    public int getWeight() {
        return this.Weight;
    }

    @Override
    public void Delete(EmployeeDescription employee) {
    }

    @Override
    public String ToXml(EmployeeDescription employee) {
        return "";
    }

    @Override
    public String GetDescription(Employee employee) {
        return "Requests max " + employee.EmployeeDescription.Contract.MaxWorkingWeekendsIncFriNight + "  working weekends.";
    }

    @Override
    public int Calculate(Employee employee, int startDay, int endDay) {
        return this.Calculate(employee);
    }

    public int Calculate(Employee employee, int maxPenalty, int startDay, int endDay) {
        return this.Calculate(employee);
    }

    @Override
    public int Calculate(Employee employee, int startDay, int endDay, boolean updateStructure) {
        return this.Calculate(employee);
    }

    @Override
    public int Calculate(Employee employee) {
        SchedulingPeriod schedulingPeriod = employee.Roster.SchedulingPeriod;
        int penalty = 0;
        int MaxWorkingWeekendsIncFriNight2 = employee.EmployeeDescription.Contract.MaxWorkingWeekendsIncFriNight;
        int penaltyValue = schedulingPeriod.MasterWeights.MaxWorkingWeekendsIncFriNight;
        if (!employee.EmployeeDescription.Contract.MaxWorkingWeekendsIncFriNightIsOn || penaltyValue == 0) {
            return penalty;
        }
        int weekendsWorked = 0;
        if (employee.DayType[3] == 1 || employee.DayType[4] == 1) {
            ++weekendsWorked;
        }
        if (employee.DayType[10] == 1 || employee.DayType[11] == 1) {
            ++weekendsWorked;
        }
        if (employee.DayType[17] == 1 || employee.DayType[18] == 1) {
            ++weekendsWorked;
        }
        if (employee.DayType[24] == 1 || employee.DayType[25] == 1) {
            ++weekendsWorked;
        }
        if (employee.ShiftsOnDay[30][schedulingPeriod.GetShiftType((String)"N").Index] != null) {
            ++weekendsWorked;
        }
        if (weekendsWorked > MaxWorkingWeekendsIncFriNight2) {
            penalty += penaltyValue;
            int[] weekendDays = new int[]{3, 4, 10, 11, 17, 18, 24, 25};
            int i = 0;
            while (i < weekendDays.length) {
                int day = weekendDays[i];
                if (employee.DayType[day] == 1) {
                    int n = day;
                    employee.ConstraintViolationPenalties[n] = employee.ConstraintViolationPenalties[n] + penaltyValue;
                    if (SoftConstraints.UpdateViolationDescriptions) {
                        int n2 = day;
                        employee.ViolationDescriptions[n2] = String.valueOf(employee.ViolationDescriptions[n2]) + "Too many working weekends. " + System.getProperty("line.separator");
                    }
                }
                ++i;
            }
            if (employee.ShiftsOnDay[30][schedulingPeriod.GetShiftType((String)"N").Index] != null) {
                employee.ConstraintViolationPenalties[30] = employee.ConstraintViolationPenalties[30] + penaltyValue;
                if (SoftConstraints.UpdateViolationDescriptions) {
                    employee.ViolationDescriptions[30] = String.valueOf(employee.ViolationDescriptions[30]) + "Too many working weekends. " + System.getProperty("line.separator");
                }
            }
        }
        return penalty;
    }
}

