/*
 * Decompiled with CFR 0.152.
 */
package ASAP.NRP.Core.Constraints.TEC;

import ASAP.NRP.Core.Constraints.SoftConstraint;
import ASAP.NRP.Core.Constraints.SoftConstraints;
import ASAP.NRP.Core.Employee;
import ASAP.NRP.Core.EmployeeDescription;
import ASAP.NRP.Core.SchedulingPeriod;
import ASAP.NRP.Core.ShiftGroup;

public class MaxShiftGroups
implements SoftConstraint {
    public String Title = "Max shift groups";
    public String LongTitle = "";
    public int Weight = 0;
    public String ID = "";

    public MaxShiftGroups(int Weight) {
        this.Weight = Weight;
    }

    @Override
    public String getTitle() {
        return this.Title;
    }

    @Override
    public int getWeight() {
        return this.Weight;
    }

    @Override
    public void Delete(EmployeeDescription employee) {
    }

    @Override
    public String ToXml(EmployeeDescription employee) {
        return "";
    }

    @Override
    public String GetDescription(Employee employee) {
        String info = "Max shift groups";
        SchedulingPeriod sp = employee.Roster.SchedulingPeriod;
        int x = 0;
        while (x < sp.ShiftGroupsCount) {
            ShiftGroup sg = sp.GetShiftGroup(x);
            String ID = sg.ID;
            int i = sg.Index;
            info = employee.EmployeeDescription.Contract.MaxShiftGroups[i] < 0 ? String.valueOf(info) + "<br/>No limit on shifts from group '" + ID + "' (" + sg.Label + "), receives " + employee.ShiftGroupCount[i] : String.valueOf(info) + "<br/>Requests max " + employee.EmployeeDescription.Contract.MaxShiftGroups[i] + " shifts from group '" + ID + "' (" + sg.Label + "), receives " + employee.ShiftGroupCount[i];
            ++x;
        }
        return info;
    }

    @Override
    public int Calculate(Employee employee, int startDay, int endDay) {
        return this.Calculate(employee);
    }

    public int Calculate(Employee employee, int maxPenalty, int startDay, int endDay) {
        return this.Calculate(employee);
    }

    @Override
    public int Calculate(Employee employee, int startDay, int endDay, boolean updateStructure) {
        return this.Calculate(employee);
    }

    @Override
    public int Calculate(Employee employee) {
        if (this.Weight == 0) {
            return 0;
        }
        SchedulingPeriod sp = employee.Roster.SchedulingPeriod;
        int penalty = 0;
        int i = 0;
        while (i < sp.ShiftGroupsCount) {
            int max = employee.EmployeeDescription.Contract.MaxShiftGroups[i];
            int count = employee.ShiftGroupCount[i];
            if (max >= 0 && count > max) {
                int pen = this.Weight * (count - max);
                penalty += pen;
                int day = 0;
                while (day < sp.NumDaysInPeriod) {
                    if (employee.ShiftGroupPerDayCount[day][i] > 0) {
                        int n = day;
                        employee.ConstraintViolationPenalties[n] = employee.ConstraintViolationPenalties[n] + pen;
                        if (SoftConstraints.UpdateViolationDescriptions) {
                            int n2 = day;
                            employee.ViolationDescriptions[n2] = String.valueOf(employee.ViolationDescriptions[n2]) + "Requests max " + max + " shifts from group '" + sp.GetShiftGroup((int)i).ID + "' (" + sp.GetShiftGroup((int)i).Label + "). " + System.getProperty("line.separator");
                        }
                    }
                    ++day;
                }
            }
            ++i;
        }
        return penalty;
    }
}

