/*
 * Decompiled with CFR 0.152.
 */
package ASAP.NRP.Core.Constraints.TEC;

import ASAP.NRP.Core.Constraints.SoftConstraint;
import ASAP.NRP.Core.Employee;
import ASAP.NRP.Core.EmployeeDescription;
import ASAP.NRP.Core.SchedulingPeriod;
import ASAP.NRP.Core.ShiftType;
import ASAP.NRP.Core.ShiftTypeAndValue;

public class MinShiftTypes
implements SoftConstraint {
    public String Title = "Min shift types";
    public String LongTitle = "Maximum number of shifts of a particular type";
    public int Weight = 0;
    public String ID = "TEC.MinShiftTypes";

    public MinShiftTypes(int Weight) {
        this.Weight = Weight;
    }

    @Override
    public String getTitle() {
        return this.Title;
    }

    @Override
    public int getWeight() {
        return this.Weight;
    }

    @Override
    public void Delete(EmployeeDescription employee) {
        int i = 0;
        while (i < employee.Contract.MinShiftTypes.length) {
            employee.Contract.MinShiftTypes[i] = -1;
            ++i;
        }
        employee.Contract.MinShiftTypesAL.clear();
        employee.Contract.MinShiftTypesUsed = false;
        employee.Contract.MinShiftTypesIsOn = false;
    }

    @Override
    public String ToXml(EmployeeDescription employee) {
        String str = "<MinShiftTypes Weight=\"" + this.Weight + "\">" + System.getProperty("line.separator");
        for (ShiftTypeAndValue stv : employee.Contract.MinShiftTypesAL) {
            if (stv.Value < 0) continue;
            str = String.valueOf(str) + " <MinShiftType><ShiftType>" + stv.ShiftType.ID + "</ShiftType><Value>" + stv.Value + "</Value></MinShiftType>" + System.getProperty("line.separator");
        }
        str = String.valueOf(str) + "</MinShiftTypes>" + System.getProperty("line.separator");
        return str;
    }

    @Override
    public String GetDescription(Employee employee) {
        String info = "Min shift types";
        SchedulingPeriod schedulingPeriod = employee.Roster.SchedulingPeriod;
        int x = 0;
        while (x < schedulingPeriod.ShiftTypesCount) {
            ShiftType shiftType = schedulingPeriod.GetShiftType(x);
            String ID = shiftType.Label;
            int i = shiftType.Index;
            info = employee.EmployeeDescription.Contract.MinShiftTypes[i] <= 0 ? String.valueOf(info) + "<br/>No minimum '" + ID + "' shifts, receives " + employee.ShiftTypeCount[i] : String.valueOf(info) + "<br/>Requests min " + employee.EmployeeDescription.Contract.MinShiftTypes[i] + " '" + ID + "' shifts, receives " + employee.ShiftTypeCount[i];
            ++x;
        }
        return info;
    }

    @Override
    public int Calculate(Employee employee, int startDay, int endDay) {
        return this.Calculate(employee);
    }

    public int Calculate(Employee employee, int maxPenalty, int startDay, int endDay) {
        return this.Calculate(employee);
    }

    @Override
    public int Calculate(Employee employee, int startDay, int endDay, boolean updateStructure) {
        return this.Calculate(employee);
    }

    @Override
    public int Calculate(Employee employee) {
        if (this.Weight == 0) {
            return 0;
        }
        SchedulingPeriod schedulingPeriod = employee.Roster.SchedulingPeriod;
        int penalty = 0;
        int shiftCount = schedulingPeriod.ShiftTypesCount;
        int i = 0;
        while (i < shiftCount) {
            int min = employee.EmployeeDescription.Contract.MinShiftTypes[i];
            int count = employee.ShiftTypeCount[i];
            if (min > 0 && count < min) {
                int pen = this.Weight * (min - count);
                penalty += pen;
            }
            ++i;
        }
        return penalty;
    }
}

