/*
 * Decompiled with CFR 0.152.
 */
package ASAP.NRP.Core;

import ASAP.NRP.Core.CoverRequirement;
import ASAP.NRP.Core.DateTime;
import ASAP.NRP.Core.Parsers.Cover;
import ASAP.NRP.Core.Parsers.CoverSpecification;
import ASAP.NRP.Core.Parsers.DateCoverSpecification;
import ASAP.NRP.Core.Parsers.DayCoverSpecification;
import ASAP.NRP.Core.Period;
import ASAP.NRP.Core.SchedulingPeriod;
import java.util.ArrayList;
import java.util.Arrays;

public class CoverRequirements {
    SchedulingPeriod schedulingPeriod;
    ArrayList<CoverSpecification> CoverSpecifications = new ArrayList();
    public CoverRequirement[] Requirements = new CoverRequirement[0];

    public CoverRequirements(SchedulingPeriod schedulingPeriod) {
        this.schedulingPeriod = schedulingPeriod;
    }

    public ArrayList<CoverSpecification> GetCoverSpecifications() {
        return this.CoverSpecifications;
    }

    public boolean AddCoverSpecification(CoverSpecification coverSpec, boolean updateArrays) {
        DateTime date;
        if (coverSpec instanceof DateCoverSpecification && !this.schedulingPeriod.IsDateWithinSchedulingPeriod(date = ((DateCoverSpecification)coverSpec).Date)) {
            System.out.println("Date Specific Cover for date : " + date + " not in scheduling period range. ");
            return false;
        }
        this.CoverSpecifications.add(coverSpec);
        if (updateArrays) {
            this.UpdateCoverRequirementArrays();
        }
        return true;
    }

    public void UpdateCoverRequirementArrays() {
        CoverSpecification dcs;
        ArrayList<CoverRequirement> allReqs = new ArrayList<CoverRequirement>();
        boolean anySkillFound = false;
        ArrayList<String> singleSkills = new ArrayList<String>();
        ArrayList<String> skillGroups = new ArrayList<String>();
        for (CoverSpecification spec : this.GetCoverSpecifications()) {
            for (Cover cover : spec.CoverRequirements) {
                CoverRequirement req;
                String skillID = cover.SkillID;
                if (cover.SkillType == CoverRequirement.SkillTypes.AnySkill) {
                    if (anySkillFound) continue;
                    req = new CoverRequirement(skillID, cover.SkillType, this.schedulingPeriod);
                    allReqs.add(req);
                    anySkillFound = true;
                    continue;
                }
                if (cover.SkillType == CoverRequirement.SkillTypes.SingleSkill) {
                    if (singleSkills.contains(skillID)) continue;
                    singleSkills.add(skillID);
                    req = new CoverRequirement(skillID, cover.SkillType, this.schedulingPeriod);
                    allReqs.add(req);
                    continue;
                }
                if (cover.SkillType != CoverRequirement.SkillTypes.SkillGroup || skillGroups.contains(skillID)) continue;
                skillGroups.add(skillID);
                req = new CoverRequirement(skillID, cover.SkillType, this.schedulingPeriod);
                allReqs.add(req);
            }
        }
        this.Requirements = allReqs.toArray(this.Requirements);
        try {
            Arrays.sort(this.Requirements);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
        try {
            int i = 0;
            while (i < this.Requirements.length) {
                this.Requirements[i].Index = i;
                ++i;
            }
            for (CoverSpecification obj : this.GetCoverSpecifications()) {
                if (!(obj instanceof DayCoverSpecification)) continue;
                dcs = (DayCoverSpecification)obj;
                DateTime tempDate = this.schedulingPeriod.StartDate;
                DateTime endDate = this.schedulingPeriod.EndDate;
                int dayNum = 0;
                while (tempDate.isLessThan(endDate)) {
                    if (((DayCoverSpecification)dcs).Day.equals(tempDate.getDayOfWeekString())) {
                        for (Object obj2 : ((DayCoverSpecification)dcs).CoverRequirements) {
                            CoverRequirement req;
                            int index;
                            Cover cover = (Cover)obj2;
                            if (cover.Type == Cover.CoverType.Shift) {
                                index = this.schedulingPeriod.GetShiftType((String)cover.ID).Index;
                                req = this.GetCoverRequirement(cover.SkillID, cover.SkillType);
                                req.CoverPerShiftUsed = true;
                                req.MinCoverPerShift[index][dayNum] = cover.Min;
                                req.MaxCoverPerShift[index][dayNum] = cover.Max;
                                req.PrefCoverPerShift[index][dayNum] = cover.Preferred;
                                continue;
                            }
                            if (cover.Type == Cover.CoverType.ShiftGroup) {
                                index = this.schedulingPeriod.GetShiftGroup((String)cover.ID).Index;
                                req = this.GetCoverRequirement(cover.SkillID, cover.SkillType);
                                req.CoverPerShiftGroupUsed = true;
                                req.MinCoverPerShiftGroup[index][dayNum] = cover.Min;
                                req.MaxCoverPerShiftGroup[index][dayNum] = cover.Max;
                                req.PrefCoverPerShiftGroup[index][dayNum] = cover.Preferred;
                                continue;
                            }
                            if (cover.Type != Cover.CoverType.Period) continue;
                            index = this.schedulingPeriod.GetDayPeriod((Period)cover.Period).Index;
                            req = this.GetCoverRequirement(cover.SkillID, cover.SkillType);
                            req.CoverPerPeriodUsed = true;
                            req.MinCoverPerPeriod[index][dayNum] = cover.Min;
                            req.MaxCoverPerPeriod[index][dayNum] = cover.Max;
                            req.PrefCoverPerPeriod[index][dayNum] = cover.Preferred;
                        }
                    }
                    ++dayNum;
                    tempDate = tempDate.AddDays(1);
                }
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
        for (CoverSpecification obj : this.GetCoverSpecifications()) {
            if (!(obj instanceof DateCoverSpecification)) continue;
            dcs = (DateCoverSpecification)obj;
            if (!this.schedulingPeriod.IsDateWithinSchedulingPeriod(dcs.Date)) continue;
            int dayNum = this.schedulingPeriod.ConvertDateToRosterDay(dcs.Date);
            for (Object obj2 : dcs.CoverRequirements) {
                CoverRequirement req;
                int index;
                Cover cover = (Cover)obj2;
                if (cover.Type == Cover.CoverType.Shift) {
                    index = this.schedulingPeriod.GetShiftType((String)cover.ID).Index;
                    req = this.GetCoverRequirement(cover.SkillID, cover.SkillType);
                    req.CoverPerShiftUsed = true;
                    req.MinCoverPerShift[index][dayNum] = cover.Min;
                    req.MaxCoverPerShift[index][dayNum] = cover.Max;
                    req.PrefCoverPerShift[index][dayNum] = cover.Preferred;
                    continue;
                }
                if (cover.Type == Cover.CoverType.ShiftGroup) {
                    index = this.schedulingPeriod.GetShiftGroup((String)cover.ID).Index;
                    req = this.GetCoverRequirement(cover.SkillID, cover.SkillType);
                    req.CoverPerShiftGroupUsed = true;
                    req.MinCoverPerShiftGroup[index][dayNum] = cover.Min;
                    req.MaxCoverPerShiftGroup[index][dayNum] = cover.Max;
                    req.PrefCoverPerShiftGroup[index][dayNum] = cover.Preferred;
                    continue;
                }
                if (cover.Type != Cover.CoverType.Period) continue;
                index = this.schedulingPeriod.GetDayPeriod((Period)cover.Period).Index;
                req = this.GetCoverRequirement(cover.SkillID, cover.SkillType);
                req.CoverPerPeriodUsed = true;
                req.MinCoverPerPeriod[index][dayNum] = cover.Min;
                req.MaxCoverPerPeriod[index][dayNum] = cover.Max;
                req.PrefCoverPerPeriod[index][dayNum] = cover.Preferred;
            }
        }
    }

    private CoverRequirement GetCoverRequirement(String skillID, CoverRequirement.SkillTypes skillType) {
        if (this.Requirements == null) {
            return null;
        }
        int i = 0;
        while (i < this.Requirements.length) {
            if (this.Requirements[i].SkillType == skillType && skillID.equals(this.Requirements[i].SkillID)) {
                return this.Requirements[i];
            }
            ++i;
        }
        return null;
    }
}

