/*
 * Decompiled with CFR 0.152.
 */
package ASAP.NRP.Core;

import ASAP.NRP.Core.Constraints.SoftConstraints;
import ASAP.NRP.Core.EmployeeDescription;
import ASAP.NRP.Core.Roster;
import ASAP.NRP.Core.SchedulingPeriod;
import ASAP.NRP.Core.Shift;

public class Employee
implements Comparable<Object> {
    public EmployeeDescription EmployeeDescription;
    public Roster Roster;
    public int Index = 0;
    public int ShiftsCount = 0;
    public Shift[][] ShiftsOnDay;
    public int[] DayType;
    public boolean[] ShiftAssignments;
    public boolean[] NightShifts;
    public int[] ShiftCountPerDay;
    public int[] ShiftTypeCount;
    public int[] ShiftGroupCount;
    public int[][] ShiftGroupPerDayCount;
    public int[][] ShiftTypePerWeekCount;
    public double[] HoursWorkedPerWeek;
    public int DaysOffCount = 0;
    public int[] ConstraintViolationPenalties;
    public String[] ViolationDescriptions;
    public int Penalty = 0;
    public double HoursWorked = 0.0;
    public int HolidayDaysOffGranted = 0;
    public int[] PenaltyCache;
    public int[][] ConstraintViolationPenaltiesCache;

    public Employee(Roster roster, EmployeeDescription employeeDescription) {
        this.Roster = roster;
        this.EmployeeDescription = employeeDescription;
        SchedulingPeriod schedulingPeriod = roster.SchedulingPeriod;
        this.DaysOffCount = schedulingPeriod.NumDaysInPeriod;
        this.DayType = new int[schedulingPeriod.NumDaysInPeriod];
        int i = 0;
        while (i < this.DayType.length) {
            this.DayType[i] = 0;
            if (employeeDescription.DayOffRequestIsWork[i]) {
                --this.DaysOffCount;
            }
            ++i;
        }
        this.ShiftAssignments = new boolean[schedulingPeriod.NumDaysInPeriod * schedulingPeriod.ShiftTypesCount];
        this.NightShifts = new boolean[schedulingPeriod.NumDaysInPeriod];
        this.ShiftCountPerDay = new int[schedulingPeriod.NumDaysInPeriod];
        this.ShiftTypeCount = new int[schedulingPeriod.ShiftTypesCount];
        this.ShiftGroupCount = new int[schedulingPeriod.ShiftGroupsCount];
        this.ShiftGroupPerDayCount = new int[schedulingPeriod.NumDaysInPeriod][schedulingPeriod.ShiftGroupsCount];
        this.ShiftTypePerWeekCount = new int[schedulingPeriod.NumWeeksInPeriod][schedulingPeriod.ShiftTypesCount];
        this.ShiftsOnDay = new Shift[schedulingPeriod.NumDaysInPeriod][schedulingPeriod.ShiftTypesCount];
        this.HoursWorkedPerWeek = new double[schedulingPeriod.NumWeeksInPeriod];
        this.ConstraintViolationPenalties = new int[schedulingPeriod.NumDaysInPeriod];
        this.ViolationDescriptions = new String[schedulingPeriod.NumDaysInPeriod];
        this.PenaltyCache = new int[this.Roster.CacheSize];
        this.ConstraintViolationPenaltiesCache = new int[this.Roster.CacheSize][];
        i = 0;
        while (i < this.Roster.CacheSize) {
            this.ConstraintViolationPenaltiesCache[i] = new int[schedulingPeriod.NumDaysInPeriod];
            ++i;
        }
        i = 0;
        while (i < schedulingPeriod.NumDaysInPeriod) {
            if (employeeDescription.DayOffRequestIsHoliday[i] && this.DayType[i] == 0) {
                this.DayType[i] = 2;
                ++this.HolidayDaysOffGranted;
            }
            this.ViolationDescriptions[i] = "";
            ++i;
        }
    }

    @Override
    public int compareTo(Object obj) {
        int p1 = this.Penalty;
        int p2 = ((Employee)obj).Penalty;
        return p2 - p1;
    }

    public String toString() {
        return this.EmployeeDescription.getName();
    }

    public boolean WorksDuringEntirePeriodOfShift(Shift shift) {
        int day = 0;
        while (day < this.Roster.SchedulingPeriod.NumDaysInPeriod) {
            int index = 0;
            while (index < this.Roster.SchedulingPeriod.ShiftTypesCount) {
                Shift shift2 = this.ShiftsOnDay[day][index];
                if (shift2 != null && shift2.StartTime.isLessThanOrEqual(shift.StartTime) && shift2.EndTime.isGreaterThanOrEqual(shift.EndTime)) {
                    return true;
                }
                ++index;
            }
            ++day;
        }
        return false;
    }

    public boolean WorksDuringPeriod(Shift shift) {
        int day = 0;
        while (day < this.Roster.SchedulingPeriod.NumDaysInPeriod) {
            int index = 0;
            while (index < this.Roster.SchedulingPeriod.ShiftTypesCount) {
                Shift shift2 = this.ShiftsOnDay[day][index];
                if (shift2 != null && (shift.StartTime.isGreaterThanOrEqual(shift2.StartTime) && shift.StartTime.isLessThan(shift2.EndTime) || shift2.StartTime.isGreaterThanOrEqual(shift.StartTime) && shift2.StartTime.isLessThan(shift.EndTime))) {
                    return true;
                }
                ++index;
            }
            ++day;
        }
        return false;
    }

    public Shift GetShift(int rosterDay) {
        if (this.DayType[rosterDay] != 1) {
            return null;
        }
        int i = 0;
        while (i < this.Roster.SchedulingPeriod.ShiftTypesCount) {
            if (this.ShiftsOnDay[rosterDay][i] != null) {
                return this.ShiftsOnDay[rosterDay][i];
            }
            ++i;
        }
        return null;
    }

    public void RecalculatePenalty() {
        int originalPenalty = this.Penalty;
        int newPenalty = SoftConstraints.CalculatePenalty(this);
        this.Roster.EmployeesPenalty = this.Roster.EmployeesPenalty - originalPenalty + newPenalty;
        this.Penalty = newPenalty;
        int i = 0;
        while (i < this.EmployeeDescription.VerticallyRelatedEmployeesCount) {
            String employee2ID = this.EmployeeDescription.GetVerticallyRelatedEmployee((int)i).ID;
            Employee employee2 = this.Roster.GetEmployee(employee2ID);
            if (employee2 != null) {
                originalPenalty = employee2.Penalty;
                newPenalty = SoftConstraints.CalculatePenalty(employee2);
                this.Roster.EmployeesPenalty = this.Roster.EmployeesPenalty - originalPenalty + newPenalty;
                employee2.Penalty = newPenalty;
            }
            ++i;
        }
    }

    public void RecalculatePenalty(int startDay, int endDay, boolean updateStructure) {
        int originalPenalty = this.Penalty;
        int newPenalty = SoftConstraints.CalculatePenalty(this, startDay, endDay, updateStructure);
        this.Roster.EmployeesPenalty = this.Roster.EmployeesPenalty - originalPenalty + newPenalty;
        this.Penalty = newPenalty;
        int i = 0;
        while (i < this.EmployeeDescription.VerticallyRelatedEmployeesCount) {
            String employee2ID = this.EmployeeDescription.GetVerticallyRelatedEmployee((int)i).ID;
            Employee employee2 = this.Roster.GetEmployee(employee2ID);
            if (employee2 != null) {
                originalPenalty = employee2.Penalty;
                newPenalty = SoftConstraints.CalculatePenalty(employee2, startDay, endDay, updateStructure);
                this.Roster.EmployeesPenalty = this.Roster.EmployeesPenalty - originalPenalty + newPenalty;
                employee2.Penalty = newPenalty;
            }
            ++i;
        }
    }

    public void RecalculatePenalty(int maxPenalty, int startDay, int endDay, boolean updateStructure) {
        int newPenalty;
        int originalPenalty;
        int i = 0;
        while (i < this.EmployeeDescription.VerticallyRelatedEmployeesCount) {
            String employee2ID = this.EmployeeDescription.GetVerticallyRelatedEmployee((int)i).ID;
            Employee employee2 = this.Roster.GetEmployee(employee2ID);
            if (employee2 != null) {
                originalPenalty = employee2.Penalty;
                newPenalty = SoftConstraints.CalculatePenalty(employee2, startDay, endDay, updateStructure);
                this.Roster.EmployeesPenalty = this.Roster.EmployeesPenalty - originalPenalty + newPenalty;
                employee2.Penalty = newPenalty;
            }
            ++i;
        }
        originalPenalty = this.Penalty;
        int maxEmployeePen = maxPenalty - (this.Roster.getTotalPenalty() - originalPenalty);
        newPenalty = 0;
        if (maxEmployeePen > 0) {
            newPenalty = SoftConstraints.CalculatePenalty(this, maxEmployeePen, startDay, endDay, updateStructure);
        }
        this.Roster.EmployeesPenalty = this.Roster.EmployeesPenalty - originalPenalty + newPenalty;
        this.Penalty = newPenalty;
    }

    public void RecalculatePenalty(int maxPenalty) {
        int newPenalty;
        int originalPenalty;
        int i = 0;
        while (i < this.EmployeeDescription.VerticallyRelatedEmployeesCount) {
            String employee2ID = this.EmployeeDescription.GetVerticallyRelatedEmployee((int)i).ID;
            Employee employee2 = this.Roster.GetEmployee(employee2ID);
            if (employee2 != null) {
                originalPenalty = employee2.Penalty;
                newPenalty = SoftConstraints.CalculatePenalty(employee2);
                this.Roster.EmployeesPenalty = this.Roster.EmployeesPenalty - originalPenalty + newPenalty;
                employee2.Penalty = newPenalty;
            }
            ++i;
        }
        originalPenalty = this.Penalty;
        int maxEmployeePen = maxPenalty - (this.Roster.getTotalPenalty() - originalPenalty);
        newPenalty = 0;
        if (maxEmployeePen > 0) {
            newPenalty = SoftConstraints.CalculatePenalty(this, maxEmployeePen);
        }
        this.Roster.EmployeesPenalty = this.Roster.EmployeesPenalty - originalPenalty + newPenalty;
        this.Penalty = newPenalty;
    }

    public int ViolationsForAssigningShift(Shift shift) {
        int violationCount = 0;
        if (shift == null) {
            return 0;
        }
        if (shift.Employee != null) {
            return -1;
        }
        int rosterDay = shift.RosterDay;
        int shiftAssignmentIndex = rosterDay * this.Roster.SchedulingPeriod.ShiftTypesCount + shift.ShiftType.Index;
        if (this.ShiftAssignments[shiftAssignmentIndex]) {
            return -1;
        }
        return violationCount;
    }

    public void UnAssignAllShifts() {
        int day = 0;
        while (day < this.Roster.SchedulingPeriod.NumDaysInPeriod) {
            int j = 0;
            while (j < this.Roster.SchedulingPeriod.ShiftTypesCount) {
                if (this.ShiftsOnDay[day][j] != null) {
                    this.Roster.UnAssignShift(this.ShiftsOnDay[day][j]);
                }
                ++j;
            }
            ++day;
        }
    }

    public int UnAssignAllShifts(int day) {
        int count = 0;
        int j = 0;
        while (j < this.Roster.SchedulingPeriod.ShiftTypesCount) {
            if (this.ShiftsOnDay[day][j] != null && this.Roster.UnAssignShift(this.ShiftsOnDay[day][j])) {
                ++count;
            }
            ++j;
        }
        return count;
    }
}

