/*
 * Decompiled with CFR 0.152.
 */
package ASAP.NRP.Core.Parsers;

import ASAP.NRP.Core.BankHoliday;
import ASAP.NRP.Core.CSharpConversionHelper;
import ASAP.NRP.Core.Constraints.TEC.Pattern;
import ASAP.NRP.Core.Constraints.TEC.PatternGroup;
import ASAP.NRP.Core.Contract;
import ASAP.NRP.Core.CoverRequirement;
import ASAP.NRP.Core.DateTime;
import ASAP.NRP.Core.EmployeeDescription;
import ASAP.NRP.Core.MasterWeights;
import ASAP.NRP.Core.Parsers.Cover;
import ASAP.NRP.Core.Parsers.DateCoverSpecification;
import ASAP.NRP.Core.Parsers.DayCoverSpecification;
import ASAP.NRP.Core.Parsers.Parser;
import ASAP.NRP.Core.Parsers.XmlConvert;
import ASAP.NRP.Core.Parsers.XmlReader;
import ASAP.NRP.Core.Period;
import ASAP.NRP.Core.SchedulingPeriod;
import ASAP.NRP.Core.ShiftGroup;
import ASAP.NRP.Core.ShiftType;
import ASAP.NRP.Core.Skill;
import ASAP.NRP.Core.SkillGroup;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Random;

public class SchedulingPeriodParser
extends Parser {
    SchedulingPeriod schedulingPeriod;
    DateTime overridingStartDate;
    DateTime overridingEndDate;
    boolean overrideDates = false;
    Hashtable<String, Contract> ContractsHash = new Hashtable();

    public SchedulingPeriod Parse(String filePath) {
        try {
            FileInputStream fis = new FileInputStream(filePath);
            SchedulingPeriod sp = this.Parse(fis);
            if (sp != null) {
                sp.FilePath = filePath;
            }
            return sp;
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
            return null;
        }
    }

    public SchedulingPeriod Parse(InputStream inputStream) {
        try {
            XmlReader reader = new XmlReader(inputStream);
            if (this.VERBOSE) {
                System.out.println("Parsing Scheduling Period ...");
            }
            SchedulingPeriod sp = this.Parse(reader);
            return sp;
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
            return null;
        }
    }

    public void SwitchDateOverridingOn(DateTime startDate, DateTime endDate) {
        this.overrideDates = true;
        this.overridingStartDate = startDate;
        this.overridingEndDate = endDate;
    }

    public void SwitchDateOverridingOff() {
        this.overrideDates = false;
    }

    public SchedulingPeriod Parse(XmlReader reader) {
        reader.MoveToContent();
        String SchedulingPeriodID = reader.GetAttribute("ID");
        String OrganisationID = reader.GetAttribute("OrganisationID");
        String DepartmentID = reader.GetAttribute("DepartmentID");
        if (this.VERBOSE) {
            System.out.println("OrganisationID = " + OrganisationID);
            System.out.println("DepartmentID = " + DepartmentID);
        }
        reader.ReadStartElement("SchedulingPeriod");
        DateTime StartDate = reader.ReadElementContentAsDateTime();
        DateTime EndDate = reader.ReadElementContentAsDateTime();
        if (this.overrideDates) {
            StartDate = this.overridingStartDate;
            EndDate = this.overridingEndDate;
        }
        if (this.VERBOSE) {
            System.out.println("StartDate = " + StartDate.ToShortDateString());
            System.out.println("EndDate = " + EndDate.ToShortDateString());
        }
        if (StartDate.isGreaterThan(EndDate)) {
            System.out.println("Error : End date is earlier than start date.");
            return null;
        }
        EndDate = EndDate.AddDays(1);
        this.schedulingPeriod = new SchedulingPeriod(StartDate, EndDate);
        if (SchedulingPeriodID != null) {
            this.schedulingPeriod.SchedulingPeriodID = SchedulingPeriodID;
        }
        if (OrganisationID != null) {
            this.schedulingPeriod.OrganisationID = OrganisationID;
        }
        if (DepartmentID != null) {
            this.schedulingPeriod.DepartmentID = DepartmentID;
        }
        if (reader.Name.equalsIgnoreCase("Skills")) {
            reader.ReadStartElement("Skills");
            while (!reader.Name.equalsIgnoreCase("Skills")) {
                Skill skill = this.ParseSkill(reader);
                this.schedulingPeriod.AddSkill(skill);
            }
            reader.ReadEndElement();
        }
        if (reader.Name.equalsIgnoreCase("SkillGroups")) {
            reader.ReadStartElement("SkillGroups");
            while (!reader.Name.equalsIgnoreCase("SkillGroups")) {
                SkillGroup skillGroup = this.ParseSkillGroup(reader);
                this.schedulingPeriod.AddSkillGroup(skillGroup);
            }
            reader.ReadEndElement();
        }
        reader.ReadStartElement("ShiftTypes");
        while (!reader.Name.equalsIgnoreCase("ShiftTypes")) {
            ShiftType shiftType = this.ParseShiftType(reader);
            this.schedulingPeriod.AddShiftType(shiftType);
        }
        reader.ReadEndElement();
        if (reader.Name.equalsIgnoreCase("ShiftGroups")) {
            reader.ReadStartElement("ShiftGroups");
            while (!reader.Name.equalsIgnoreCase("ShiftGroups")) {
                ShiftGroup shiftGroup = this.ParseShiftGroup(reader);
                if (shiftGroup.Group.length <= 0) continue;
                this.schedulingPeriod.AddShiftGroup(shiftGroup);
            }
            reader.ReadEndElement();
        }
        reader.ReadStartElement("Contracts");
        while (!reader.Name.equalsIgnoreCase("Contracts")) {
            Contract contract = this.ParseContract(reader);
            this.AddContract(contract);
        }
        reader.ReadEndElement();
        reader.ReadStartElement("Employees");
        while (!reader.Name.equalsIgnoreCase("Employees")) {
            EmployeeDescription employee = this.ParseEmployee(reader);
            this.schedulingPeriod.AddEmployeeDescription(employee);
        }
        reader.ReadEndElement();
        reader.ReadStartElement("CoverRequirements");
        this.ParseCoverRequirements(reader);
        reader.ReadEndElement();
        if (reader.Name.equalsIgnoreCase("MasterWeights")) {
            reader.ReadStartElement("MasterWeights");
            this.schedulingPeriod.MasterWeights = this.ParseMasterWeights(reader);
            reader.ReadEndElement();
        }
        if (reader.Name.equalsIgnoreCase("DayOffRequests")) {
            reader.ReadStartElement("DayOffRequests");
            while (!reader.Name.equalsIgnoreCase("DayOffRequests")) {
                this.ParseRequestedDayOff(reader);
            }
            reader.ReadEndElement();
        }
        if (reader.Name.equalsIgnoreCase("DayOnRequests")) {
            reader.ReadStartElement("DayOnRequests");
            while (!reader.Name.equalsIgnoreCase("DayOnRequests")) {
                this.ParseRequestedDayOn(reader);
            }
            reader.ReadEndElement();
        }
        if (reader.Name.equalsIgnoreCase("ShiftOffRequests")) {
            reader.ReadStartElement("ShiftOffRequests");
            while (!reader.Name.equalsIgnoreCase("ShiftOffRequests")) {
                this.ParseRequestedShiftOff(reader);
            }
            reader.ReadEndElement();
        }
        if (reader.Name.equalsIgnoreCase("ShiftOnRequests")) {
            reader.ReadStartElement("ShiftOnRequests");
            while (!reader.Name.equalsIgnoreCase("ShiftOnRequests")) {
                this.ParseRequestedShiftOn(reader);
            }
            reader.ReadEndElement();
        }
        if (reader.Name.equalsIgnoreCase("DayOffRequestsBetweenDates")) {
            reader.ReadStartElement("DayOffRequestsBetweenDates");
            while (!reader.Name.equalsIgnoreCase("DayOffRequestsBetweenDates")) {
                this.ParseDayOffRequestBetweenDates(reader);
            }
            reader.ReadEndElement();
        }
        if (reader.Name.equalsIgnoreCase("Partnerships")) {
            reader.ReadStartElement("Partnerships");
            while (!reader.Name.equalsIgnoreCase("Partnerships")) {
                this.ParsePartnership(reader);
            }
            reader.ReadEndElement();
        }
        if (reader.Name.equalsIgnoreCase("BankHolidays")) {
            reader.ReadStartElement("BankHolidays");
            this.ParseBankHolidays(reader);
            reader.ReadEndElement();
        }
        if (reader.Name.equalsIgnoreCase("SchedulingHistory")) {
            reader.ReadStartElement("SchedulingHistory");
            this.ParseSchedulingHistory(reader);
            reader.ReadEndElement();
        }
        if (reader.Name.equalsIgnoreCase("PreAssignments")) {
            reader.ReadStartElement("PreAssignments");
            this.ParsePreAssignments(reader);
            reader.ReadEndElement();
        }
        if (reader.Name.equalsIgnoreCase("FrozenDays")) {
            reader.ReadStartElement("FrozenDays");
            this.ParseFrozenDays(reader);
            reader.ReadEndElement();
        }
        reader.Close();
        this.schedulingPeriod.ParsingFinished();
        return this.schedulingPeriod;
    }

    private BankHoliday ParseBankHoliday(XmlReader reader) {
        DateTime date;
        String Name;
        String ID = reader.GetAttribute("ID");
        if (this.VERBOSE) {
            System.out.println("Parsing BankHoliday, ID = " + ID);
        }
        BankHoliday bankHoliday = new BankHoliday(ID);
        reader.ReadStartElement("BankHoliday");
        reader.ReadStartElement("Name");
        bankHoliday.Name = Name = reader.ReadString();
        reader.ReadEndElement();
        reader.ReadStartElement("Date");
        String DateString = reader.ReadString();
        bankHoliday.Date = date = DateTime.ParseDate(DateString);
        reader.ReadEndElement();
        if (this.VERBOSE) {
            System.out.println("Name = " + Name);
            System.out.println("Date = " + date);
            System.out.println(" ");
        }
        reader.ReadEndElement();
        return bankHoliday;
    }

    private boolean ParseBankHolidays(XmlReader reader) {
        while (!reader.Name.equalsIgnoreCase("BankHolidays")) {
            BankHoliday bankHoliday = this.ParseBankHoliday(reader);
            this.schedulingPeriod.AddBankHoliday(bankHoliday);
        }
        if (this.VERBOSE) {
            System.out.println("BankHolidays Parsed.");
            System.out.println("----------------------------------------------");
        }
        return true;
    }

    private Contract ParseContract(XmlReader reader) {
        String ContractID = reader.GetAttribute("ID");
        if (this.VERBOSE) {
            System.out.println("Parsing Contract, ContractID = " + ContractID);
        }
        Contract contract = new Contract(ContractID, this.schedulingPeriod);
        reader.ReadStartElement("Contract");
        while (!reader.Name.equalsIgnoreCase("Contract")) {
            ShiftGroup s;
            ShiftGroup sg;
            ShiftType st;
            Object sh;
            String weightStr;
            String weightStr2;
            String onStr;
            if (reader.Name.equalsIgnoreCase("Label")) {
                String Label;
                reader.ReadStartElement("Label");
                contract.Label = Label = reader.ReadString();
                reader.ReadEndElement();
                if (!this.VERBOSE) continue;
                System.out.println("Label=" + Label);
                continue;
            }
            if (reader.Name.equalsIgnoreCase("MaxNumAssignments")) {
                int MaxNumAssignments2;
                boolean on = true;
                onStr = null;
                onStr = reader.GetAttribute("on");
                if (onStr != null) {
                    on = XmlConvert.ToBoolean(onStr);
                }
                int weight = -1;
                weightStr2 = reader.GetAttribute("weight");
                if (weightStr2 != null) {
                    weight = Integer.parseInt(weightStr2);
                }
                contract.MaxNumAssignmentsWeight = weight;
                contract.MaxNumAssignments = MaxNumAssignments2 = Integer.parseInt(reader.ReadString());
                contract.MaxNumAssignmentsIsOn = on;
                reader.ReadEndElement();
                if (!this.VERBOSE) continue;
                System.out.println("MaxNumAssignments=" + MaxNumAssignments2 + " weight=" + contract.MaxNumAssignmentsWeight + " contract.MaxNumAssignmentsIsOn=" + contract.MaxNumAssignmentsIsOn);
                continue;
            }
            if (reader.Name.equalsIgnoreCase("MinNumAssignments")) {
                int MinNumAssignments;
                boolean on = true;
                onStr = null;
                onStr = reader.GetAttribute("on");
                if (onStr != null) {
                    on = XmlConvert.ToBoolean(onStr);
                }
                int weight = -1;
                weightStr2 = reader.GetAttribute("weight");
                if (weightStr2 != null) {
                    weight = Integer.parseInt(weightStr2);
                }
                contract.MinNumAssignmentsWeight = weight;
                contract.MinNumAssignments = MinNumAssignments = Integer.parseInt(reader.ReadString());
                contract.MinNumAssignmentsIsOn = on;
                reader.ReadEndElement();
                if (!this.VERBOSE) continue;
                System.out.println("MinNumAssignments=" + MinNumAssignments + " weight=" + contract.MinNumAssignmentsWeight);
                continue;
            }
            if (reader.Name.equalsIgnoreCase("MaxDaysOff")) {
                int MaxDaysOff2;
                boolean on = true;
                onStr = null;
                onStr = reader.GetAttribute("on");
                if (onStr != null) {
                    on = XmlConvert.ToBoolean(onStr);
                }
                int weight = -1;
                weightStr2 = reader.GetAttribute("weight");
                if (weightStr2 != null) {
                    weight = Integer.parseInt(weightStr2);
                }
                contract.MaxDaysOffWeight = weight;
                contract.MaxDaysOff = MaxDaysOff2 = Integer.parseInt(reader.ReadString());
                contract.MaxDaysOffIsOn = on;
                reader.ReadEndElement();
                if (!this.VERBOSE) continue;
                System.out.println("MaxDaysOff=" + MaxDaysOff2 + " weight=" + contract.MaxDaysOffWeight + " contract.MaxDaysOffIsOn=" + contract.MaxDaysOffIsOn);
                continue;
            }
            if (reader.Name.equalsIgnoreCase("MinDaysOff")) {
                int MinDaysOff2;
                boolean on = true;
                onStr = null;
                onStr = reader.GetAttribute("on");
                if (onStr != null) {
                    on = XmlConvert.ToBoolean(onStr);
                }
                int weight = -1;
                weightStr2 = reader.GetAttribute("weight");
                if (weightStr2 != null) {
                    weight = Integer.parseInt(weightStr2);
                }
                contract.MinDaysOffWeight = weight;
                contract.MinDaysOff = MinDaysOff2 = Integer.parseInt(reader.ReadString());
                contract.MinDaysOffIsOn = on;
                reader.ReadEndElement();
                if (!this.VERBOSE) continue;
                System.out.println("MinDaysOff=" + MinDaysOff2 + " weight=" + contract.MinDaysOffWeight + " contract.MinDaysOffIsOn=" + contract.MinDaysOffIsOn);
                continue;
            }
            if (reader.Name.equalsIgnoreCase("MaxConsecutiveWorkingDays")) {
                int MaxConsecutiveWorkingDays2;
                boolean on = true;
                onStr = null;
                onStr = reader.GetAttribute("on");
                if (onStr != null) {
                    on = XmlConvert.ToBoolean(onStr);
                }
                int weight = -1;
                weightStr2 = reader.GetAttribute("weight");
                if (weightStr2 != null) {
                    weight = Integer.parseInt(weightStr2);
                }
                contract.MaxConsecutiveWorkingDaysWeight = weight;
                contract.MaxConsecutiveWorkingDays = MaxConsecutiveWorkingDays2 = Integer.parseInt(reader.ReadString());
                contract.MaxConsecutiveWorkingDaysIsOn = on;
                reader.ReadEndElement();
                if (!this.VERBOSE) continue;
                System.out.println("MaxConsecutiveWorkingDays=" + MaxConsecutiveWorkingDays2 + " weight=" + contract.MaxConsecutiveWorkingDaysWeight);
                continue;
            }
            if (reader.Name.equalsIgnoreCase("MinConsecutiveWorkingDays")) {
                int MinConsecutiveWorkingDays2;
                boolean on = true;
                onStr = null;
                onStr = reader.GetAttribute("on");
                if (onStr != null) {
                    on = XmlConvert.ToBoolean(onStr);
                }
                int weight = -1;
                weightStr2 = reader.GetAttribute("weight");
                if (weightStr2 != null) {
                    weight = Integer.parseInt(weightStr2);
                }
                contract.MinConsecutiveWorkingDaysWeight = weight;
                contract.MinConsecutiveWorkingDays = MinConsecutiveWorkingDays2 = Integer.parseInt(reader.ReadString());
                contract.MinConsecutiveWorkingDaysIsOn = on;
                reader.ReadEndElement();
                if (!this.VERBOSE) continue;
                System.out.println("MinConsecutiveWorkingDays=" + MinConsecutiveWorkingDays2 + " weight=" + contract.MinConsecutiveWorkingDaysWeight);
                continue;
            }
            if (reader.Name.equalsIgnoreCase("MaxWorkingBankHolidays")) {
                int MaxWorkingBankHolidays2;
                boolean on = true;
                onStr = null;
                onStr = reader.GetAttribute("on");
                if (onStr != null) {
                    on = XmlConvert.ToBoolean(onStr);
                }
                int weight = -1;
                weightStr2 = reader.GetAttribute("weight");
                if (weightStr2 != null) {
                    weight = Integer.parseInt(weightStr2);
                }
                contract.MaxWorkingBankHolidaysWeight = weight;
                contract.MaxWorkingBankHolidays = MaxWorkingBankHolidays2 = Integer.parseInt(reader.ReadString());
                contract.MaxWorkingBankHolidaysIsOn = on;
                reader.ReadEndElement();
                if (!this.VERBOSE) continue;
                System.out.println("MaxWorkingBankHolidays=" + MaxWorkingBankHolidays2 + " weight=" + contract.MaxWorkingBankHolidaysWeight);
                continue;
            }
            if (reader.Name.equalsIgnoreCase("MaxConsecutiveFreeDays")) {
                int MaxConsecutiveFreeDays2;
                boolean on = true;
                onStr = null;
                onStr = reader.GetAttribute("on");
                if (onStr != null) {
                    on = XmlConvert.ToBoolean(onStr);
                }
                int weight = -1;
                weightStr2 = reader.GetAttribute("weight");
                if (weightStr2 != null) {
                    weight = Integer.parseInt(weightStr2);
                }
                contract.MaxConsecutiveFreeDaysWeight = weight;
                contract.MaxConsecutiveFreeDays = MaxConsecutiveFreeDays2 = Integer.parseInt(reader.ReadString());
                contract.MaxConsecutiveFreeDaysIsOn = on;
                reader.ReadEndElement();
                if (!this.VERBOSE) continue;
                System.out.println("MaxConsecutiveFreeDays=" + MaxConsecutiveFreeDays2 + " weight=" + contract.MaxConsecutiveFreeDaysWeight);
                continue;
            }
            if (reader.Name.equalsIgnoreCase("MinConsecutiveFreeDays")) {
                int MinConsecutiveFreeDays2;
                boolean on = true;
                onStr = null;
                onStr = reader.GetAttribute("on");
                if (onStr != null) {
                    on = XmlConvert.ToBoolean(onStr);
                }
                int weight = -1;
                weightStr2 = reader.GetAttribute("weight");
                if (weightStr2 != null) {
                    weight = Integer.parseInt(weightStr2);
                }
                contract.MinConsecutiveFreeDaysWeight = weight;
                contract.MinConsecutiveFreeDays = MinConsecutiveFreeDays2 = Integer.parseInt(reader.ReadString());
                contract.MinConsecutiveFreeDaysIsOn = on;
                reader.ReadEndElement();
                if (!this.VERBOSE) continue;
                System.out.println("MinConsecutiveFreeDays=" + MinConsecutiveFreeDays2 + " weight=" + contract.MinConsecutiveFreeDaysWeight);
                continue;
            }
            if (reader.Name.equalsIgnoreCase("MaxConsecutiveWorkingWeekends")) {
                int MaxConsecutiveWorkingWeekends2;
                boolean on = true;
                onStr = null;
                onStr = reader.GetAttribute("on");
                if (onStr != null) {
                    on = XmlConvert.ToBoolean(onStr);
                }
                int weight = -1;
                weightStr2 = reader.GetAttribute("weight");
                if (weightStr2 != null) {
                    weight = Integer.parseInt(weightStr2);
                }
                contract.MaxConsecutiveWorkingWeekendsWeight = weight;
                contract.MaxConsecutiveWorkingWeekends = MaxConsecutiveWorkingWeekends2 = Integer.parseInt(reader.ReadString());
                contract.MaxConsecutiveWorkingWeekendsIsOn = on;
                reader.ReadEndElement();
                if (!this.VERBOSE) continue;
                System.out.println("MaxConsecutiveWorkingWeekends=" + MaxConsecutiveWorkingWeekends2 + " weight=" + contract.MaxConsecutiveWorkingWeekendsWeight);
                continue;
            }
            if (reader.Name.equalsIgnoreCase("MaxWorkingWeekends")) {
                int MaxWorkingWeekends2;
                boolean on = true;
                onStr = null;
                onStr = reader.GetAttribute("on");
                if (onStr != null) {
                    on = XmlConvert.ToBoolean(onStr);
                }
                int weight = -1;
                weightStr2 = reader.GetAttribute("weight");
                if (weightStr2 != null) {
                    weight = Integer.parseInt(weightStr2);
                }
                contract.MaxWorkingWeekendsWeight = weight;
                contract.MaxWorkingWeekends = MaxWorkingWeekends2 = Integer.parseInt(reader.ReadString());
                contract.MaxWorkingWeekendsIsOn = on;
                reader.ReadEndElement();
                if (!this.VERBOSE) continue;
                System.out.println("MaxWorkingWeekends=" + MaxWorkingWeekends2 + " weight=" + contract.MaxWorkingWeekendsWeight);
                continue;
            }
            if (reader.Name.equalsIgnoreCase("MaxWorkingWeekendsInFourWeeks")) {
                int MaxWorkingWeekendsInFourWeeks2;
                boolean on = true;
                onStr = null;
                onStr = reader.GetAttribute("on");
                if (onStr != null) {
                    on = XmlConvert.ToBoolean(onStr);
                }
                int weight = -1;
                weightStr2 = reader.GetAttribute("weight");
                if (weightStr2 != null) {
                    weight = Integer.parseInt(weightStr2);
                }
                contract.MaxWorkingWeekendsInFourWeeksWeight = weight;
                contract.MaxWorkingWeekendsInFourWeeks = MaxWorkingWeekendsInFourWeeks2 = Integer.parseInt(reader.ReadString());
                contract.MaxWorkingWeekendsInFourWeeksIsOn = on;
                reader.ReadEndElement();
                if (!this.VERBOSE) continue;
                System.out.println("MaxWorkingWeekendsInFourWeeks=" + MaxWorkingWeekendsInFourWeeks2 + " weight=" + contract.MaxWorkingWeekendsInFourWeeksWeight);
                continue;
            }
            if (reader.Name.equalsIgnoreCase("MaxWorkingWeekendsIncFriNight")) {
                int MaxWorkingWeekendsIncFriNight2;
                boolean on = true;
                onStr = null;
                onStr = reader.GetAttribute("on");
                if (onStr != null) {
                    on = XmlConvert.ToBoolean(onStr);
                }
                int weight = -1;
                weightStr2 = reader.GetAttribute("weight");
                if (weightStr2 != null) {
                    weight = Integer.parseInt(weightStr2);
                }
                contract.MaxWorkingWeekendsIncFriNightWeight = weight;
                contract.MaxWorkingWeekendsIncFriNight = MaxWorkingWeekendsIncFriNight2 = Integer.parseInt(reader.ReadString());
                contract.MaxWorkingWeekendsIncFriNightIsOn = on;
                reader.ReadEndElement();
                if (!this.VERBOSE) continue;
                System.out.println("MaxWorkingWeekendsIncFriNight=" + MaxWorkingWeekendsIncFriNight2 + " weight=" + contract.MaxWorkingWeekendsIncFriNightWeight);
                continue;
            }
            if (reader.Name.equalsIgnoreCase("MaxWeekendsOff")) {
                int MaxWeekendsOff2;
                boolean on = true;
                onStr = null;
                onStr = reader.GetAttribute("on");
                if (onStr != null) {
                    on = XmlConvert.ToBoolean(onStr);
                }
                int weight = -1;
                weightStr2 = reader.GetAttribute("weight");
                if (weightStr2 != null) {
                    weight = Integer.parseInt(weightStr2);
                }
                contract.MaxWeekendsOffWeight = weight;
                contract.MaxWeekendsOff = MaxWeekendsOff2 = Integer.parseInt(reader.ReadString());
                contract.MaxWeekendsOffIsOn = on;
                reader.ReadEndElement();
                if (!this.VERBOSE) continue;
                System.out.println("MaxWeekendsOff=" + MaxWeekendsOff2 + " weight=" + contract.MaxWeekendsOffWeight);
                continue;
            }
            if (reader.Name.equalsIgnoreCase("MaxWorkingDaysPerWeek")) {
                int MaxWorkingDaysPerWeek2;
                boolean on = true;
                onStr = null;
                onStr = reader.GetAttribute("on");
                if (onStr != null) {
                    on = XmlConvert.ToBoolean(onStr);
                }
                int weight = -1;
                weightStr2 = reader.GetAttribute("weight");
                if (weightStr2 != null) {
                    weight = Integer.parseInt(weightStr2);
                }
                contract.MaxWorkingDaysPerWeekWeight = weight;
                contract.MaxWorkingDaysPerWeek = MaxWorkingDaysPerWeek2 = Integer.parseInt(reader.ReadString());
                contract.MaxWorkingDaysPerWeekIsOn = on;
                reader.ReadEndElement();
                if (!this.VERBOSE) continue;
                System.out.println("MaxWorkingDaysPerWeek=" + MaxWorkingDaysPerWeek2 + " weight=" + contract.MaxWorkingDaysPerWeekWeight);
                continue;
            }
            if (reader.Name.equalsIgnoreCase("MaxShiftsPerWeekStartMon")) {
                int MaxShiftsPerWeekStartMon2;
                boolean on = true;
                onStr = null;
                onStr = reader.GetAttribute("on");
                if (onStr != null) {
                    on = XmlConvert.ToBoolean(onStr);
                }
                int weight = -1;
                weightStr2 = reader.GetAttribute("weight");
                if (weightStr2 != null) {
                    weight = Integer.parseInt(weightStr2);
                }
                contract.MaxShiftsPerWeekStartMonWeight = weight;
                contract.MaxShiftsPerWeekStartMon = MaxShiftsPerWeekStartMon2 = Integer.parseInt(reader.ReadString());
                contract.MaxShiftsPerWeekStartMonIsOn = on;
                reader.ReadEndElement();
                if (!this.VERBOSE) continue;
                System.out.println("MaxShiftsPerWeekStartMon=" + MaxShiftsPerWeekStartMon2 + " weight=" + contract.MaxShiftsPerWeekStartMonWeight);
                continue;
            }
            if (reader.Name.equalsIgnoreCase("MinShiftsPerWeekStartMon")) {
                int MinShiftsPerWeekStartMon2;
                boolean on = true;
                onStr = null;
                onStr = reader.GetAttribute("on");
                if (onStr != null) {
                    on = XmlConvert.ToBoolean(onStr);
                }
                int weight = -1;
                weightStr2 = reader.GetAttribute("weight");
                if (weightStr2 != null) {
                    weight = Integer.parseInt(weightStr2);
                }
                contract.MinShiftsPerWeekStartMonWeight = weight;
                contract.MinShiftsPerWeekStartMon = MinShiftsPerWeekStartMon2 = Integer.parseInt(reader.ReadString());
                contract.MinShiftsPerWeekStartMonIsOn = on;
                reader.ReadEndElement();
                if (!this.VERBOSE) continue;
                System.out.println("MinShiftsPerWeekStartMon=" + MinShiftsPerWeekStartMon2 + " weight=" + contract.MinShiftsPerWeekStartMonWeight);
                continue;
            }
            if (reader.Name.equalsIgnoreCase("MaxWeekendDays")) {
                int MaxWeekendDays2;
                boolean on = true;
                onStr = null;
                onStr = reader.GetAttribute("on");
                if (onStr != null) {
                    on = XmlConvert.ToBoolean(onStr);
                }
                int weight = -1;
                weightStr2 = reader.GetAttribute("weight");
                if (weightStr2 != null) {
                    weight = Integer.parseInt(weightStr2);
                }
                contract.MaxWeekendDaysWeight = weight;
                contract.MaxWeekendDays = MaxWeekendDays2 = Integer.parseInt(reader.ReadString());
                contract.MaxWeekendDaysIsOn = on;
                reader.ReadEndElement();
                if (!this.VERBOSE) continue;
                System.out.println("MaxWeekendDays=" + MaxWeekendDays2 + " weight=" + contract.MaxWeekendDaysWeight);
                continue;
            }
            if (reader.Name.equalsIgnoreCase("WeekendDefinition")) {
                reader.ReadStartElement("WeekendDefinition");
                String WeekendDefinition = reader.ReadString();
                contract.SetWeekendDefinition(WeekendDefinition);
                reader.ReadEndElement();
                if (!this.VERBOSE) continue;
                System.out.println("WeekendDefinition=" + WeekendDefinition);
                continue;
            }
            if (reader.Name.equalsIgnoreCase("CompleteWeekends")) {
                boolean CompleteWeekends2;
                int weight = -1;
                weightStr = reader.GetAttribute("weight");
                if (weightStr != null) {
                    weight = Integer.parseInt(weightStr);
                }
                contract.CompleteWeekendsWeight = weight;
                contract.CompleteWeekends = CompleteWeekends2 = reader.ReadElementContentAsBoolean();
                if (!this.VERBOSE) continue;
                System.out.println("CompleteWeekends=" + CompleteWeekends2);
                continue;
            }
            if (reader.Name.equalsIgnoreCase("BrokenWeekends")) {
                boolean BrokenWeekends;
                int weight = -1;
                weightStr = reader.GetAttribute("weight");
                if (weightStr != null) {
                    weight = Integer.parseInt(weightStr);
                }
                contract.BrokenWeekendsWeight = weight;
                contract.BrokenWeekends = BrokenWeekends = reader.ReadElementContentAsBoolean();
                if (!this.VERBOSE) continue;
                System.out.println("BrokenWeekends=" + BrokenWeekends);
                continue;
            }
            if (reader.Name.equalsIgnoreCase("IdenticalShiftTypesDuringWeekend")) {
                boolean IdenticalShiftTypesDuringWeekend2;
                int weight = -1;
                weightStr = reader.GetAttribute("weight");
                if (weightStr != null) {
                    weight = Integer.parseInt(weightStr);
                }
                contract.IdenticalShiftTypesDuringWeekendWeight = weight;
                contract.IdenticalShiftTypesDuringWeekend = IdenticalShiftTypesDuringWeekend2 = reader.ReadElementContentAsBoolean();
                if (!this.VERBOSE) continue;
                System.out.println("IdenticalShiftTypesDuringWeekend=" + IdenticalShiftTypesDuringWeekend2);
                continue;
            }
            if (reader.Name.equalsIgnoreCase("NoNightShiftBeforeFreeWeekend")) {
                boolean NoNightShiftBeforeFreeWeekend2;
                int weight = -1;
                weightStr = reader.GetAttribute("weight");
                if (weightStr != null) {
                    weight = Integer.parseInt(weightStr);
                }
                contract.NoNightShiftBeforeFreeWeekendWeight = weight;
                contract.NoNightShiftBeforeFreeWeekend = NoNightShiftBeforeFreeWeekend2 = reader.ReadElementContentAsBoolean();
                if (!this.VERBOSE) continue;
                System.out.println("NoNightShiftBeforeFreeWeekend=" + NoNightShiftBeforeFreeWeekend2);
                continue;
            }
            if (reader.Name.equalsIgnoreCase("TwoFreeDaysAfterNightShifts")) {
                boolean TwoFreeDaysAfterNightShifts2;
                int weight = -1;
                weightStr = reader.GetAttribute("weight");
                if (weightStr != null) {
                    weight = Integer.parseInt(weightStr);
                }
                contract.TwoFreeDaysAfterNightShiftsWeight = weight;
                contract.TwoFreeDaysAfterNightShifts = TwoFreeDaysAfterNightShifts2 = reader.ReadElementContentAsBoolean();
                if (!this.VERBOSE) continue;
                System.out.println("TwoFreeDaysAfterNightShifts=" + TwoFreeDaysAfterNightShifts2);
                continue;
            }
            if (reader.Name.equalsIgnoreCase("AlternativeSkillCategory")) {
                boolean AlternativeSkillCategory2;
                int weight = -1;
                weightStr = reader.GetAttribute("weight");
                if (weightStr != null) {
                    weight = Integer.parseInt(weightStr);
                }
                contract.AlternativeSkillCategoryWeight = weight;
                contract.AlternativeSkillCategory = AlternativeSkillCategory2 = reader.ReadElementContentAsBoolean();
                if (!this.VERBOSE) continue;
                System.out.println("AlternativeSkillCategory=" + AlternativeSkillCategory2);
                continue;
            }
            if (reader.Name.equalsIgnoreCase("MaxAssignmentsForDayOfWeek")) {
                boolean on = true;
                onStr = reader.GetAttribute("on");
                if (onStr != null) {
                    on = XmlConvert.ToBoolean(onStr);
                }
                int weight = -1;
                weightStr2 = reader.GetAttribute("weight");
                if (weightStr2 != null) {
                    weight = Integer.parseInt(weightStr2);
                }
                contract.MaxAssignmentsForDayOfWeekIsOn = on;
                contract.MaxAssignmentsForDayOfWeekWeight = weight;
                if (this.VERBOSE) {
                    System.out.println("MaxAssignmentsForDayOfWeekIsOn=" + on);
                }
                reader.ReadStartElement("MaxAssignmentsForDayOfWeek");
                while (!reader.Name.equalsIgnoreCase("MaxAssignmentsForDayOfWeek")) {
                    reader.ReadStartElement("MaxAssignments");
                    reader.ReadStartElement("Day");
                    String Day = reader.ReadString();
                    reader.ReadEndElement();
                    reader.ReadStartElement("Value");
                    int val = Integer.parseInt(reader.ReadString());
                    reader.ReadEndElement();
                    reader.ReadEndElement();
                    if (this.VERBOSE) {
                        System.out.println("MaxAssignmentsForDayOfWeek: Day = " + Day + ", val = " + val);
                    }
                    if (Day.equalsIgnoreCase("Monday")) {
                        contract.MaxAssignmentsForAllMondays = val;
                        contract.MaxAssignmentsForAllMondaysIsOn = true;
                        continue;
                    }
                    if (Day.equalsIgnoreCase("Tuesday")) {
                        contract.MaxAssignmentsForAllTuesdays = val;
                        contract.MaxAssignmentsForAllTuesdaysIsOn = true;
                        continue;
                    }
                    if (Day.equalsIgnoreCase("Wednesday")) {
                        contract.MaxAssignmentsForAllWednesdays = val;
                        contract.MaxAssignmentsForAllWednesdaysIsOn = true;
                        continue;
                    }
                    if (Day.equalsIgnoreCase("Thursday")) {
                        contract.MaxAssignmentsForAllThursdays = val;
                        contract.MaxAssignmentsForAllThursdaysIsOn = true;
                        continue;
                    }
                    if (Day.equalsIgnoreCase("Friday")) {
                        contract.MaxAssignmentsForAllFridays = val;
                        contract.MaxAssignmentsForAllFridaysIsOn = true;
                        continue;
                    }
                    if (Day.equalsIgnoreCase("Saturday")) {
                        contract.MaxAssignmentsForAllSaturdays = val;
                        contract.MaxAssignmentsForAllSaturdaysIsOn = true;
                        continue;
                    }
                    if (!Day.equalsIgnoreCase("Sunday")) continue;
                    contract.MaxAssignmentsForAllSundays = val;
                    contract.MaxAssignmentsForAllSundaysIsOn = true;
                }
                reader.ReadEndElement();
                if (!this.VERBOSE) continue;
                System.out.println("MaxAssignmentsForDayOfWeekIsOn=" + on);
                continue;
            }
            if (reader.Name.equalsIgnoreCase("ValidNumConsecutiveShiftTypes")) {
                boolean on = true;
                onStr = reader.GetAttribute("on");
                if (onStr != null) {
                    on = XmlConvert.ToBoolean(onStr);
                }
                int weight = -1;
                weightStr2 = reader.GetAttribute("weight");
                if (weightStr2 != null) {
                    weight = Integer.parseInt(weightStr2);
                }
                contract.ValidNumConsecutiveShiftTypesIsOn = on;
                contract.ValidNumConsecutiveShiftTypesWeight = weight;
                if (this.VERBOSE) {
                    System.out.println("ValidNumConsecutiveShiftTypesIsOn=" + on);
                }
                reader.ReadStartElement("ValidNumConsecutiveShiftTypes");
                while (!reader.Name.equalsIgnoreCase("ValidNumConsecutiveShiftTypes")) {
                    ShiftType sh2;
                    reader.ReadStartElement("NumConsecutiveShiftType");
                    reader.ReadStartElement("ShiftType");
                    String ID = reader.ReadString();
                    reader.ReadEndElement();
                    reader.ReadStartElement("Value");
                    int val = Integer.parseInt(reader.ReadString());
                    reader.ReadEndElement();
                    reader.ReadEndElement();
                    if (this.VERBOSE) {
                        System.out.println("ValidNumConsecutiveShiftType: ID = " + ID + ", val = " + val);
                    }
                    if ((sh2 = this.schedulingPeriod.GetShiftType(ID)) == null) {
                        System.out.println("Warning: Constraint ValidNumConsecutiveShiftTypes for ShiftType: " + ID + ", but no definition of ShiftType: " + ID + " found.");
                        continue;
                    }
                    contract.ValidNumConsecutiveShiftTypes[sh2.Index][val - 1] = true;
                }
                reader.ReadEndElement();
                if (!this.VERBOSE) continue;
                System.out.println("ValidNumConsecutiveShiftTypesIsOn=" + on);
                continue;
            }
            if (reader.Name.equalsIgnoreCase("ValidNumConsecutiveShiftGroups")) {
                boolean on = true;
                onStr = reader.GetAttribute("on");
                if (onStr != null) {
                    on = XmlConvert.ToBoolean(onStr);
                }
                int weight = -1;
                weightStr2 = reader.GetAttribute("weight");
                if (weightStr2 != null) {
                    weight = Integer.parseInt(weightStr2);
                }
                contract.ValidNumConsecutiveShiftGroupsIsOn = on;
                contract.ValidNumConsecutiveShiftGroupsWeight = weight;
                if (this.VERBOSE) {
                    System.out.println("ValidNumConsecutiveShiftGroupsIsOn=" + on);
                }
                reader.ReadStartElement("ValidNumConsecutiveShiftGroups");
                while (!reader.Name.equalsIgnoreCase("ValidNumConsecutiveShiftGroups")) {
                    ShiftGroup sh3;
                    reader.ReadStartElement("NumConsecutiveShiftGroup");
                    reader.ReadStartElement("ShiftGroup");
                    String ID = reader.ReadString();
                    reader.ReadEndElement();
                    reader.ReadStartElement("Value");
                    int val = Integer.parseInt(reader.ReadString());
                    reader.ReadEndElement();
                    reader.ReadEndElement();
                    if (this.VERBOSE) {
                        System.out.println("ValidNumConsecutiveShiftGroup: ID = " + ID + ", val = " + val);
                    }
                    if ((sh3 = this.schedulingPeriod.GetShiftGroup(ID)) == null) {
                        System.out.println("Warning: Constraint ValidNumConsecutiveShiftGroups for ShiftGroup: " + ID + ", but no definition of ShiftGroup: " + ID + " found.");
                        continue;
                    }
                    contract.ValidNumConsecutiveShiftGroups[sh3.Index][val - 1] = true;
                }
                reader.ReadEndElement();
                if (!this.VERBOSE) continue;
                System.out.println("ValidNumConsecutiveShiftGroupsIsOn=" + on);
                continue;
            }
            if (reader.Name.equalsIgnoreCase("MaxShiftTypes")) {
                boolean on = true;
                onStr = reader.GetAttribute("on");
                if (onStr != null) {
                    on = XmlConvert.ToBoolean(onStr);
                }
                int weight = -1;
                weightStr2 = reader.GetAttribute("weight");
                if (weightStr2 != null) {
                    weight = Integer.parseInt(weightStr2);
                }
                contract.MaxShiftTypesIsOn = on;
                contract.MaxShiftTypesWeight = weight;
                reader.ReadStartElement("MaxShiftTypes");
                while (!reader.Name.equalsIgnoreCase("MaxShiftTypes")) {
                    reader.ReadStartElement("MaxShiftType");
                    boolean shiftType = false;
                    boolean shiftGroup = false;
                    if (reader.Name.equalsIgnoreCase("ShiftType")) {
                        shiftType = true;
                    } else if (reader.Name.equalsIgnoreCase("ShiftGroup")) {
                        shiftGroup = true;
                    }
                    reader.ReadStartElement();
                    String ID = reader.ReadString();
                    reader.ReadEndElement();
                    reader.ReadStartElement("Value");
                    int val = Integer.parseInt(reader.ReadString());
                    reader.ReadEndElement();
                    reader.ReadEndElement();
                    if (shiftType) {
                        sh = this.schedulingPeriod.GetShiftType(ID);
                        if (sh == null) {
                            System.out.println("Warning: Constraint MaxShiftTypes for ShiftType: " + ID + ", but no definition of ShiftType: " + ID + " found.");
                            continue;
                        }
                        contract.SetMaxShiftType((ShiftType)sh, val);
                        continue;
                    }
                    if (!shiftGroup) continue;
                    sh = this.schedulingPeriod.GetShiftGroup(ID);
                    if (sh == null) {
                        System.out.println("Warning: Constraint MaxShiftTypes for ShiftGroup: " + ID + ", but no definition of ShiftGroup: " + ID + " found.");
                        continue;
                    }
                    contract.SetMaxShiftGroup((ShiftGroup)sh, val);
                }
                reader.ReadEndElement();
                if (!this.VERBOSE) continue;
                System.out.println("MaxShiftTypesIsOn=" + on);
                continue;
            }
            if (reader.Name.equalsIgnoreCase("MinShiftTypes")) {
                boolean on = true;
                onStr = reader.GetAttribute("on");
                if (onStr != null) {
                    on = XmlConvert.ToBoolean(onStr);
                }
                int weight = -1;
                weightStr2 = reader.GetAttribute("weight");
                if (weightStr2 != null) {
                    weight = Integer.parseInt(weightStr2);
                }
                contract.MinShiftTypesIsOn = on;
                contract.MinShiftTypesWeight = weight;
                reader.ReadStartElement("MinShiftTypes");
                while (!reader.Name.equalsIgnoreCase("MinShiftTypes")) {
                    reader.ReadStartElement("MinShiftType");
                    boolean shiftType = false;
                    boolean shiftGroup = false;
                    if (reader.Name.equalsIgnoreCase("ShiftType")) {
                        shiftType = true;
                    } else if (reader.Name.equalsIgnoreCase("ShiftGroup")) {
                        shiftGroup = true;
                    }
                    reader.ReadStartElement();
                    String ID = reader.ReadString();
                    reader.ReadEndElement();
                    reader.ReadStartElement("Value");
                    int val = Integer.parseInt(reader.ReadString());
                    reader.ReadEndElement();
                    reader.ReadEndElement();
                    if (shiftType) {
                        sh = this.schedulingPeriod.GetShiftType(ID);
                        if (sh == null) {
                            System.out.println("Warning: Constraint MinShiftTypes for ShiftType: " + ID + ", but no definition of ShiftType: " + ID + " found.");
                            continue;
                        }
                        contract.SetMinShiftType((ShiftType)sh, val);
                        continue;
                    }
                    if (!shiftGroup) continue;
                    sh = this.schedulingPeriod.GetShiftGroup(ID);
                    if (sh == null) {
                        System.out.println("Warning: Constraint MinShiftTypes for ShiftGroup: " + ID + ", but no definition of ShiftGroup: " + ID + " found.");
                        continue;
                    }
                    contract.SetMinShiftGroup((ShiftGroup)sh, val);
                }
                reader.ReadEndElement();
                if (!this.VERBOSE) continue;
                System.out.println("MinShiftTypesIsOn=" + on);
                continue;
            }
            if (reader.Name.equalsIgnoreCase("MaxShiftTypesPerWeek")) {
                boolean on = true;
                onStr = reader.GetAttribute("on");
                if (onStr != null) {
                    on = XmlConvert.ToBoolean(onStr);
                }
                int weight = -1;
                weightStr2 = reader.GetAttribute("weight");
                if (weightStr2 != null) {
                    weight = Integer.parseInt(weightStr2);
                }
                contract.MaxShiftTypesPerWeekIsOn = on;
                contract.MaxShiftTypesPerWeekWeight = weight;
                reader.ReadStartElement("MaxShiftTypesPerWeek");
                while (!reader.Name.equalsIgnoreCase("MaxShiftTypesPerWeek")) {
                    reader.ReadStartElement("MaxShiftTypePerWeek");
                    reader.ReadStartElement("ShiftType");
                    String ShiftTypeID = reader.ReadString();
                    reader.ReadEndElement();
                    reader.ReadStartElement("Week");
                    int week = Integer.parseInt(reader.ReadString());
                    reader.ReadEndElement();
                    reader.ReadStartElement("Value");
                    int val = Integer.parseInt(reader.ReadString());
                    reader.ReadEndElement();
                    reader.ReadEndElement();
                    ShiftType sh4 = this.schedulingPeriod.GetShiftType(ShiftTypeID);
                    if (sh4 == null) {
                        System.out.println("Warning: Constraint MaxShiftTypesPerWeek for ShiftType: " + ShiftTypeID + ", but no definition of ShiftType: " + ShiftTypeID + " found.");
                        continue;
                    }
                    contract.SetMaxShiftTypePerWeek(sh4, val, week);
                }
                reader.ReadEndElement();
                if (!this.VERBOSE) continue;
                System.out.println("MaxShiftTypesPerWeekIsOn=" + on);
                continue;
            }
            if (reader.Name.equalsIgnoreCase("MaxHoursWorked")) {
                double MaxHoursWorked2;
                boolean on = true;
                onStr = reader.GetAttribute("on");
                if (onStr != null) {
                    on = XmlConvert.ToBoolean(onStr);
                }
                int weight = -1;
                weightStr2 = reader.GetAttribute("weight");
                String threshold = reader.GetAttribute("threshold");
                if (threshold != null) {
                    double MaxHoursWorkedThreshold;
                    contract.MaxHoursWorkedThreshold = MaxHoursWorkedThreshold = Double.parseDouble(threshold);
                }
                if (weightStr2 != null) {
                    weight = Integer.parseInt(weightStr2);
                }
                contract.MaxHoursWorkedIsOn = on;
                contract.MaxHoursWorkedWeight = weight;
                contract.MaxHoursWorked = MaxHoursWorked2 = Double.parseDouble(reader.ReadString());
                reader.Read();
                if (!this.VERBOSE) continue;
                System.out.println("MaxHoursWorked=" + MaxHoursWorked2 + ", on=" + contract.MaxHoursWorkedIsOn);
                continue;
            }
            if (reader.Name.equalsIgnoreCase("MinHoursWorked")) {
                double MinHoursWorked2;
                boolean on = true;
                onStr = reader.GetAttribute("on");
                if (onStr != null) {
                    on = XmlConvert.ToBoolean(onStr);
                }
                int weight = -1;
                weightStr2 = reader.GetAttribute("weight");
                String threshold = reader.GetAttribute("threshold");
                if (threshold != null) {
                    double MinHoursWorkedThreshold;
                    contract.MinHoursWorkedThreshold = MinHoursWorkedThreshold = Double.parseDouble(threshold);
                }
                if (weightStr2 != null) {
                    weight = Integer.parseInt(weightStr2);
                }
                contract.MinHoursWorkedIsOn = on;
                contract.MinHoursWorkedWeight = weight;
                contract.MinHoursWorked = MinHoursWorked2 = Double.parseDouble(reader.ReadString());
                reader.Read();
                if (!this.VERBOSE) continue;
                System.out.println("MinHoursWorked=" + MinHoursWorked2 + ", on=" + contract.MinHoursWorkedIsOn + " threshold=" + contract.MinHoursWorkedThreshold);
                continue;
            }
            if (reader.Name.equalsIgnoreCase("StandardPerformance")) {
                double StandardPerformance;
                reader.ReadStartElement("StandardPerformance");
                contract.StandardPerformance = StandardPerformance = Double.parseDouble(reader.ReadString());
                reader.ReadEndElement();
                if (!this.VERBOSE) continue;
                System.out.println("StandardPerformance=" + StandardPerformance);
                continue;
            }
            if (reader.Name.equalsIgnoreCase("MaxHoursPerWeek")) {
                double MaxHoursPerWeek2;
                boolean on = true;
                onStr = reader.GetAttribute("on");
                if (onStr != null) {
                    on = XmlConvert.ToBoolean(onStr);
                }
                int weight = -1;
                weightStr2 = reader.GetAttribute("weight");
                if (weightStr2 != null) {
                    weight = Integer.parseInt(weightStr2);
                }
                contract.MaxHoursPerWeekIsOn = on;
                contract.MaxHoursPerWeekWeight = weight;
                contract.MaxHoursPerWeek = MaxHoursPerWeek2 = Double.parseDouble(reader.ReadString());
                reader.Read();
                if (!this.VERBOSE) continue;
                System.out.println("MaxHoursPerWeek=" + MaxHoursPerWeek2 + ", on=" + contract.MaxHoursPerWeekIsOn);
                continue;
            }
            if (reader.Name.equalsIgnoreCase("MaxHoursPerFortnight")) {
                double MaxHoursPerFortnight2;
                boolean on = true;
                onStr = reader.GetAttribute("on");
                if (onStr != null) {
                    on = XmlConvert.ToBoolean(onStr);
                }
                int weight = -1;
                weightStr2 = reader.GetAttribute("weight");
                if (weightStr2 != null) {
                    weight = Integer.parseInt(weightStr2);
                }
                contract.MaxHoursPerFortnightIsOn = on;
                contract.MaxHoursPerFortnightWeight = weight;
                contract.MaxHoursPerFortnight = MaxHoursPerFortnight2 = Double.parseDouble(reader.ReadString());
                reader.Read();
                if (!this.VERBOSE) continue;
                System.out.println("MaxHoursPerFortnight=" + MaxHoursPerFortnight2 + ", on=" + contract.MaxHoursPerFortnightIsOn);
                continue;
            }
            if (reader.Name.equalsIgnoreCase("ValidShiftTypeSuccessions")) {
                boolean on = true;
                onStr = reader.GetAttribute("on");
                if (onStr != null) {
                    on = XmlConvert.ToBoolean(onStr);
                }
                int weight = -1;
                weightStr2 = reader.GetAttribute("weight");
                if (weightStr2 != null) {
                    weight = Integer.parseInt(weightStr2);
                }
                contract.ValidShiftTypeSuccessionsIsOn = on;
                contract.ValidShiftTypeSuccessionsWeight = weight;
                reader.ReadStartElement("ValidShiftTypeSuccessions");
                while (!reader.Name.equalsIgnoreCase("ValidShiftTypeSuccessions")) {
                    reader.ReadStartElement("Succession");
                    reader.ReadStartElement("ShiftTypeID1");
                    String ShiftTypeID1 = reader.ReadString();
                    reader.ReadEndElement();
                    reader.ReadStartElement("ShiftTypeID2");
                    String ShiftTypeID2 = reader.ReadString();
                    reader.ReadEndElement();
                    reader.ReadEndElement();
                    if (!ShiftTypeID1.equalsIgnoreCase("")) {
                        if (this.schedulingPeriod.GetShiftType(ShiftTypeID1) == null) {
                            System.out.println("Warning: Constraint ShiftTypeSuccessions for ShiftType: " + ShiftTypeID1 + ", but no definition of ShiftType: " + ShiftTypeID1 + " found.");
                            continue;
                        }
                    } else if (!ShiftTypeID2.equalsIgnoreCase("") && this.schedulingPeriod.GetShiftType(ShiftTypeID2) == null) {
                        System.out.println("Warning: Constraint ShiftTypeSuccessions for ShiftType: " + ShiftTypeID2 + ", but no definition of ShiftType: " + ShiftTypeID2 + " found.");
                        continue;
                    }
                    contract.SetShiftTypeSuccession(ShiftTypeID1, ShiftTypeID2, true);
                }
                reader.ReadEndElement();
                if (!this.VERBOSE) continue;
                System.out.println("ValidShiftTypeSuccessionsIsOn=" + on);
                continue;
            }
            if (reader.Name.equalsIgnoreCase("BadPatterns")) {
                contract.BadPatternsIsOn = true;
                reader.ReadStartElement("BadPatterns");
                while (!reader.Name.equalsIgnoreCase("BadPatterns")) {
                    Pattern pattern = this.ParsePattern(reader);
                    if (pattern != null) {
                        contract.AddBadPattern(pattern);
                    }
                    if (!this.VERBOSE) continue;
                    System.out.println("BadPattern: StartDay=" + pattern.getStartDayOrDate() + " weight=" + pattern.Weight);
                }
                reader.ReadEndElement();
                if (!this.VERBOSE) continue;
                System.out.println("BadPatternsIsOn=true");
                continue;
            }
            if (reader.Name.equalsIgnoreCase("GoodPatterns")) {
                contract.GoodPatternsIsOn = true;
                reader.ReadStartElement("GoodPatterns");
                while (!reader.Name.equalsIgnoreCase("GoodPatterns")) {
                    int weight = Integer.parseInt(reader.GetAttribute("weight"));
                    PatternGroup patternGroup = new PatternGroup(weight);
                    reader.ReadStartElement("PatternGroup");
                    while (!reader.Name.equalsIgnoreCase("PatternGroup")) {
                        Pattern pattern = this.ParsePattern(reader);
                        if (pattern == null) continue;
                        patternGroup.AddPattern(pattern);
                    }
                    reader.ReadEndElement();
                    contract.AddGoodPattern(patternGroup);
                    if (!this.VERBOSE) continue;
                    System.out.println("PatternGroup parsed: weight=" + weight);
                }
                reader.ReadEndElement();
                if (!this.VERBOSE) continue;
                System.out.println("GoodPatternsIsOn=true");
                continue;
            }
            if (reader.Name.equalsIgnoreCase("MinShiftsPerWeek")) {
                int MinShiftsPerWeek2;
                boolean on = true;
                onStr = null;
                onStr = reader.GetAttribute("on");
                if (onStr != null) {
                    on = XmlConvert.ToBoolean(onStr);
                }
                int weight = -1;
                weightStr2 = reader.GetAttribute("weight");
                if (weightStr2 != null) {
                    weight = Integer.parseInt(weightStr2);
                }
                contract.MinShiftsPerWeekWeight = weight;
                contract.MinShiftsPerWeek = MinShiftsPerWeek2 = Integer.parseInt(reader.ReadString());
                contract.MinShiftsPerWeekIsOn = on;
                reader.ReadEndElement();
                if (!this.VERBOSE) continue;
                System.out.println("MinShiftsPerWeek=" + MinShiftsPerWeek2 + " weight=" + contract.MinShiftsPerWeekWeight + " contract.MinShiftsPerWeekIsOn=" + contract.MinShiftsPerWeekIsOn);
                continue;
            }
            if (reader.Name.equalsIgnoreCase("MaxShiftsPerWeek")) {
                int MaxShiftsPerWeek2;
                boolean on = true;
                onStr = null;
                onStr = reader.GetAttribute("on");
                if (onStr != null) {
                    on = XmlConvert.ToBoolean(onStr);
                }
                int weight = -1;
                weightStr2 = reader.GetAttribute("weight");
                if (weightStr2 != null) {
                    weight = Integer.parseInt(weightStr2);
                }
                contract.MaxShiftsPerWeekWeight = weight;
                contract.MaxShiftsPerWeek = MaxShiftsPerWeek2 = Integer.parseInt(reader.ReadString());
                contract.MaxShiftsPerWeekIsOn = on;
                reader.ReadEndElement();
                if (!this.VERBOSE) continue;
                System.out.println("MaxShiftsPerWeek=" + MaxShiftsPerWeek2 + " weight=" + contract.MaxShiftsPerWeekWeight + " contract.MaxShiftsPerWeekIsOn=" + contract.MaxShiftsPerWeekIsOn);
                continue;
            }
            if (reader.Name.equalsIgnoreCase("MinDaysBetweenShiftSeries")) {
                boolean on = true;
                onStr = reader.GetAttribute("on");
                if (onStr != null) {
                    on = XmlConvert.ToBoolean(onStr);
                }
                int weight = -1;
                weightStr2 = reader.GetAttribute("weight");
                if (weightStr2 != null) {
                    weight = Integer.parseInt(weightStr2);
                }
                contract.MinDaysBetweenShiftSeriesIsOn = on;
                contract.MinDaysBetweenShiftSeriesWeight = weight;
                reader.ReadStartElement("MinDaysBetweenShiftSeries");
                while (!reader.Name.equalsIgnoreCase("MinDaysBetweenShiftSeries")) {
                    reader.ReadStartElement("MinDaysBetweenShifts");
                    boolean shiftType = false;
                    boolean shiftGroup = false;
                    if (reader.Name.equalsIgnoreCase("ShiftType")) {
                        shiftType = true;
                    } else if (reader.Name.equalsIgnoreCase("ShiftGroup")) {
                        shiftGroup = true;
                    }
                    reader.ReadStartElement();
                    String ID = reader.ReadString();
                    reader.ReadEndElement();
                    reader.ReadStartElement("Value");
                    int val = Integer.parseInt(reader.ReadString());
                    reader.ReadEndElement();
                    if (this.VERBOSE) {
                        System.out.println("Min DaysBetweenShifts = " + ID + ", Value = " + val);
                    }
                    if (shiftType) {
                        st = this.schedulingPeriod.GetShiftType(ID);
                        if (st == null) {
                            System.out.println("Warning: Constraint MinDaysBetweenShiftSeries for ShiftType: " + ID + ", but no shifts of ShiftType: " + ID + " are known.");
                        } else {
                            contract.SetMinDaysBetweenShiftSeries(st, val);
                        }
                    } else if (shiftGroup) {
                        sg = this.schedulingPeriod.GetShiftGroup(ID);
                        if (sg == null) {
                            System.out.println("Warning: Constraint MinDaysBetweenShiftSeries for ShiftGroup: " + ID + ", but no shiftGroups of ID: " + ID + " are known.");
                        } else {
                            System.out.println("Warning : ShiftGroup for constraint MinDaysBetweenShiftSeries not yet implemented.");
                        }
                    }
                    reader.ReadEndElement();
                }
                reader.ReadEndElement();
                if (!this.VERBOSE) continue;
                System.out.println("MinDaysBetweenShiftSeriesIsOn=" + on);
                continue;
            }
            if (reader.Name.equalsIgnoreCase("MaxDaysBetweenShiftSeries")) {
                boolean on = true;
                onStr = reader.GetAttribute("on");
                if (onStr != null) {
                    on = XmlConvert.ToBoolean(onStr);
                }
                int weight = -1;
                weightStr2 = reader.GetAttribute("weight");
                if (weightStr2 != null) {
                    weight = Integer.parseInt(weightStr2);
                }
                contract.MaxDaysBetweenShiftSeriesIsOn = on;
                contract.MaxDaysBetweenShiftSeriesWeight = weight;
                reader.ReadStartElement("MaxDaysBetweenShiftSeries");
                while (!reader.Name.equalsIgnoreCase("MaxDaysBetweenShiftSeries")) {
                    reader.ReadStartElement("MaxDaysBetweenShifts");
                    boolean shiftType = false;
                    boolean shiftGroup = false;
                    if (reader.Name.equalsIgnoreCase("ShiftType")) {
                        shiftType = true;
                    } else if (reader.Name.equalsIgnoreCase("ShiftGroup")) {
                        shiftGroup = true;
                    }
                    reader.ReadStartElement();
                    String ID = reader.ReadString();
                    reader.ReadEndElement();
                    reader.ReadStartElement("Value");
                    int val = Integer.parseInt(reader.ReadString());
                    reader.ReadEndElement();
                    if (this.VERBOSE) {
                        System.out.println("Max DaysBetweenShifts = " + ID + ", Value = " + val);
                    }
                    if (shiftType) {
                        st = this.schedulingPeriod.GetShiftType(ID);
                        if (st == null) {
                            System.out.println("Warning: Constraint MaxDaysBetweenShiftSeries for ShiftType: " + ID + ", but no shifts of ShiftType: " + ID + " are known.");
                        } else {
                            contract.SetMaxDaysBetweenShiftSeries(st, val);
                        }
                    } else if (shiftGroup) {
                        sg = this.schedulingPeriod.GetShiftGroup(ID);
                        if (sg == null) {
                            System.out.println("Warning: Constraint MaxDaysBetweenShiftSeries for ShiftGroup: " + ID + ", but no shiftGroups of ID: " + ID + " are known.");
                        } else {
                            System.out.println("Warning : ShiftGroup for constraint MaxDaysBetweenShiftSeries not yet implemented.");
                        }
                    }
                    reader.ReadEndElement();
                }
                reader.ReadEndElement();
                if (!this.VERBOSE) continue;
                System.out.println("MaxDaysBetweenShiftSeriesIsOn=" + on);
                continue;
            }
            if (reader.Name.equalsIgnoreCase("MinConsecutiveShiftTypes")) {
                boolean on = true;
                onStr = reader.GetAttribute("on");
                if (onStr != null) {
                    on = XmlConvert.ToBoolean(onStr);
                }
                int weight = -1;
                weightStr2 = reader.GetAttribute("weight");
                if (weightStr2 != null) {
                    weight = Integer.parseInt(weightStr2);
                }
                contract.MinConsecutiveShiftTypesIsOn = on;
                contract.MinConsecutiveShiftTypesWeight = weight;
                reader.ReadStartElement("MinConsecutiveShiftTypes");
                while (!reader.Name.equalsIgnoreCase("MinConsecutiveShiftTypes")) {
                    reader.ReadStartElement("MinConsecutiveShiftType");
                    boolean shiftType = false;
                    boolean shiftGroup = false;
                    if (reader.Name.equalsIgnoreCase("ShiftType")) {
                        shiftType = true;
                    } else if (reader.Name.equalsIgnoreCase("ShiftGroup")) {
                        shiftGroup = true;
                    }
                    reader.ReadStartElement();
                    String ID = reader.ReadString();
                    reader.ReadEndElement();
                    reader.ReadStartElement("Value");
                    int val = Integer.parseInt(reader.ReadString());
                    reader.ReadEndElement();
                    if (this.VERBOSE) {
                        System.out.println("Min ConsecutiveShiftType = " + ID + ", Value = " + val);
                    }
                    if (shiftType) {
                        st = this.schedulingPeriod.GetShiftType(ID);
                        if (st == null) {
                            System.out.println("Warning: Constraint MinConsecutiveShiftType for ShiftType: " + ID + ", but no shifts of ShiftType: " + ID + " are known.");
                        } else {
                            contract.SetMinConsecutiveShiftType(st, val);
                        }
                    } else if (shiftGroup) {
                        sg = this.schedulingPeriod.GetShiftGroup(ID);
                        if (sg == null) {
                            System.out.println("Warning: Constraint MinConsecutiveShiftType for ShiftGroup: " + ID + ", but no shiftGroups of ID: " + ID + " are known.");
                        } else {
                            contract.SetMinConsecutiveShiftGroup(sg, val);
                        }
                    }
                    reader.ReadEndElement();
                }
                reader.ReadEndElement();
                if (!this.VERBOSE) continue;
                System.out.println("MinConsecutiveShiftTypesIsOn=" + on);
                continue;
            }
            if (reader.Name.equalsIgnoreCase("MaxConsecutiveShiftTypes")) {
                boolean on = true;
                onStr = reader.GetAttribute("on");
                if (onStr != null) {
                    on = XmlConvert.ToBoolean(onStr);
                }
                int weight = -1;
                weightStr2 = reader.GetAttribute("weight");
                if (weightStr2 != null) {
                    weight = Integer.parseInt(weightStr2);
                }
                contract.MaxConsecutiveShiftTypesIsOn = on;
                contract.MaxConsecutiveShiftTypesWeight = weight;
                reader.ReadStartElement("MaxConsecutiveShiftTypes");
                while (!reader.Name.equalsIgnoreCase("MaxConsecutiveShiftTypes")) {
                    reader.ReadStartElement("MaxConsecutiveShiftType");
                    boolean shiftType = false;
                    boolean shiftGroup = false;
                    if (reader.Name.equalsIgnoreCase("ShiftType")) {
                        shiftType = true;
                    } else if (reader.Name.equalsIgnoreCase("ShiftGroup")) {
                        shiftGroup = true;
                    }
                    reader.ReadStartElement();
                    String ID = reader.ReadString();
                    reader.ReadEndElement();
                    reader.ReadStartElement("Value");
                    int val = Integer.parseInt(reader.ReadString());
                    reader.ReadEndElement();
                    if (this.VERBOSE) {
                        System.out.println("Max ConsecutiveShiftType = " + ID + ", Value = " + val);
                    }
                    if (shiftType) {
                        st = this.schedulingPeriod.GetShiftType(ID);
                        if (st == null) {
                            System.out.println("Warning: Constraint MaxConsecutiveShiftType for ShiftType: " + ID + ", but no shifts of ShiftType: " + ID + " are known.");
                        } else {
                            contract.SetMaxConsecutiveShiftType(st, val);
                        }
                    } else if (shiftGroup) {
                        sg = this.schedulingPeriod.GetShiftGroup(ID);
                        if (sg == null) {
                            System.out.println("Warning: Constraint MaxConsecutiveShiftType for ShiftGroup: " + ID + ", but no ShiftGroup of ID: " + ID + " are known.");
                        } else {
                            contract.SetMaxConsecutiveShiftGroup(sg, val);
                        }
                    }
                    reader.ReadEndElement();
                }
                reader.ReadEndElement();
                if (!this.VERBOSE) continue;
                System.out.println("MaxConsecutiveShiftTypesIsOn=" + on);
                continue;
            }
            if (reader.Name.equalsIgnoreCase("MaxShiftTypeRatios")) {
                boolean on = true;
                onStr = reader.GetAttribute("on");
                if (onStr != null) {
                    on = XmlConvert.ToBoolean(onStr);
                }
                int weight = -1;
                weightStr2 = reader.GetAttribute("weight");
                if (weightStr2 != null) {
                    weight = Integer.parseInt(weightStr2);
                }
                contract.MaxShiftTypeRatiosIsOn = on;
                contract.MaxShiftTypeRatiosWeight = weight;
                reader.ReadStartElement("MaxShiftTypeRatios");
                while (!reader.Name.equalsIgnoreCase("MaxShiftTypeRatios")) {
                    reader.ReadStartElement("MaxShiftTypeRatio");
                    boolean shiftType = false;
                    boolean shiftGroup = false;
                    if (reader.Name.equalsIgnoreCase("ShiftType")) {
                        shiftType = true;
                    } else if (reader.Name.equalsIgnoreCase("ShiftGroup")) {
                        shiftGroup = true;
                    }
                    reader.ReadStartElement();
                    String ID = reader.ReadString();
                    reader.ReadEndElement();
                    reader.ReadStartElement("Ratio");
                    int val = Integer.parseInt(reader.ReadString());
                    reader.ReadEndElement();
                    if (this.VERBOSE) {
                        System.out.println("MaxShiftTypeRatio = " + ID + ", Value = " + val);
                    }
                    if (shiftType) {
                        st = this.schedulingPeriod.GetShiftType(ID);
                        if (st == null) {
                            System.out.println("Warning: Constraint MaxShiftTypeRatio for ShiftType: " + ID + ", but no shift types of ShiftType: " + ID + " are known.");
                        } else {
                            contract.SetMaxShiftTypeRatio(st, val);
                        }
                    } else if (shiftGroup) {
                        s = this.schedulingPeriod.GetShiftGroup(ID);
                        if (s == null) {
                            System.out.println("Warning: Constraint MaxShiftTypeRatio for ShiftGroup: " + ID + ", but no shift groups of ID: " + ID + " are known.");
                        } else {
                            contract.SetMaxShiftGroupRatio(s, val);
                        }
                    }
                    reader.ReadEndElement();
                }
                reader.ReadEndElement();
                if (!this.VERBOSE) continue;
                System.out.println("MaxShiftTypeRatioIsOn=" + on);
                continue;
            }
            if (reader.Name.equalsIgnoreCase("MinShiftTypeRatios")) {
                boolean on = true;
                onStr = reader.GetAttribute("on");
                if (onStr != null) {
                    on = XmlConvert.ToBoolean(onStr);
                }
                int weight = -1;
                weightStr2 = reader.GetAttribute("weight");
                if (weightStr2 != null) {
                    weight = Integer.parseInt(weightStr2);
                }
                contract.MinShiftTypeRatiosIsOn = on;
                contract.MinShiftTypeRatiosWeight = weight;
                reader.ReadStartElement("MinShiftTypeRatios");
                while (!reader.Name.equalsIgnoreCase("MinShiftTypeRatios")) {
                    reader.ReadStartElement("MinShiftTypeRatio");
                    boolean shiftType = false;
                    boolean shiftGroup = false;
                    if (reader.Name.equalsIgnoreCase("ShiftType")) {
                        shiftType = true;
                    } else if (reader.Name.equalsIgnoreCase("ShiftGroup")) {
                        shiftGroup = true;
                    }
                    reader.ReadStartElement();
                    String ID = reader.ReadString();
                    reader.ReadEndElement();
                    reader.ReadStartElement("Ratio");
                    int val = Integer.parseInt(reader.ReadString());
                    reader.ReadEndElement();
                    if (this.VERBOSE) {
                        System.out.println("MinShiftTypeRatio = " + ID + ", Value = " + val);
                    }
                    if (shiftType) {
                        st = this.schedulingPeriod.GetShiftType(ID);
                        if (st == null) {
                            System.out.println("Warning: Constraint MinShiftTypeRatio for ShiftType: " + ID + ", but no shift types of ShiftType: " + ID + " are known.");
                        } else {
                            contract.SetMinShiftTypeRatio(st, val);
                        }
                    } else if (shiftGroup) {
                        s = this.schedulingPeriod.GetShiftGroup(ID);
                        if (s == null) {
                            System.out.println("Warning: Constraint MinShiftTypeRatio for ShiftGroup: " + ID + ", but no shift Groups of : " + ID + " are known.");
                        } else {
                            contract.SetMinShiftGroupRatio(s, val);
                        }
                    }
                    reader.ReadEndElement();
                }
                reader.ReadEndElement();
                if (!this.VERBOSE) continue;
                System.out.println("MinShiftTypeRatioIsOn=" + on);
                continue;
            }
            if (reader.Name.equalsIgnoreCase("MaxShiftsPerDay")) {
                int MaxShiftsPerDay2;
                boolean on = true;
                onStr = null;
                onStr = reader.GetAttribute("on");
                if (onStr != null) {
                    on = XmlConvert.ToBoolean(onStr);
                }
                int weight = -1;
                weightStr2 = reader.GetAttribute("weight");
                if (weightStr2 != null) {
                    weight = Integer.parseInt(weightStr2);
                }
                contract.MaxShiftsPerDayWeight = weight;
                contract.MaxShiftsPerDay = MaxShiftsPerDay2 = Integer.parseInt(reader.ReadString());
                contract.MaxShiftsPerDayIsOn = on;
                reader.ReadEndElement();
                if (!this.VERBOSE) continue;
                System.out.println("MaxShiftsPerDay=" + MaxShiftsPerDay2 + " weight=" + contract.MaxShiftsPerDayWeight + " contract.MaxShiftsPerDayIsOn=" + contract.MaxShiftsPerDayIsOn);
                continue;
            }
            if (reader.Name.equalsIgnoreCase("MinHoursWorkedBetweenDates")) {
                boolean on = true;
                onStr = reader.GetAttribute("on");
                if (onStr != null) {
                    on = XmlConvert.ToBoolean(onStr);
                }
                int weight = -1;
                weightStr2 = reader.GetAttribute("weight");
                if (weightStr2 != null) {
                    weight = Integer.parseInt(weightStr2);
                }
                contract.MinHoursWorkedBetweenDatesIsOn = on;
                contract.MinHoursWorkedBetweenDatesWeight = weight;
                reader.ReadStartElement("MinHoursWorkedBetweenDates");
                while (!reader.Name.equalsIgnoreCase("MinHoursWorkedBetweenDates")) {
                    reader.ReadStartElement("MinHoursWorked");
                    reader.ReadStartElement("StartDate");
                    DateTime StartDate = DateTime.ParseDate(reader.ReadString());
                    reader.ReadEndElement();
                    reader.ReadStartElement("EndDate");
                    DateTime EndDate = DateTime.ParseDate(reader.ReadString());
                    reader.ReadEndElement();
                    reader.ReadStartElement("Value");
                    int val = Integer.parseInt(reader.ReadString());
                    reader.ReadEndElement();
                    reader.ReadEndElement();
                    contract.AddMinHoursWorkedBetweenDates(StartDate, EndDate, val);
                }
                reader.ReadEndElement();
                if (!this.VERBOSE) continue;
                System.out.println("MinHoursWorkedBetweenDatesIsOn=" + on);
                continue;
            }
            if (reader.Name.equalsIgnoreCase("MaxHoursWorkedBetweenDates")) {
                boolean on = true;
                onStr = reader.GetAttribute("on");
                if (onStr != null) {
                    on = XmlConvert.ToBoolean(onStr);
                }
                int weight = -1;
                weightStr2 = reader.GetAttribute("weight");
                if (weightStr2 != null) {
                    weight = Integer.parseInt(weightStr2);
                }
                contract.MaxHoursWorkedBetweenDatesIsOn = on;
                contract.MaxHoursWorkedBetweenDatesWeight = weight;
                reader.ReadStartElement("MaxHoursWorkedBetweenDates");
                while (!reader.Name.equalsIgnoreCase("MaxHoursWorkedBetweenDates")) {
                    reader.ReadStartElement("MaxHoursWorked");
                    reader.ReadStartElement("StartDate");
                    DateTime StartDate = DateTime.ParseDate(reader.ReadString());
                    reader.ReadEndElement();
                    reader.ReadStartElement("EndDate");
                    DateTime EndDate = DateTime.ParseDate(reader.ReadString());
                    reader.ReadEndElement();
                    reader.ReadStartElement("Value");
                    int val = Integer.parseInt(reader.ReadString());
                    reader.ReadEndElement();
                    reader.ReadEndElement();
                    contract.AddMaxHoursWorkedBetweenDates(StartDate, EndDate, val);
                }
                reader.ReadEndElement();
                if (!this.VERBOSE) continue;
                System.out.println("MaxHoursWorkedBetweenDatesIsOn=" + on);
                continue;
            }
            if (reader.Name.equalsIgnoreCase("MinConsecutiveWorkingWeekends")) {
                int MinConsecutiveWorkingWeekends2;
                boolean on = true;
                onStr = null;
                onStr = reader.GetAttribute("on");
                if (onStr != null) {
                    on = XmlConvert.ToBoolean(onStr);
                }
                int weight = -1;
                weightStr2 = reader.GetAttribute("weight");
                if (weightStr2 != null) {
                    weight = Integer.parseInt(weightStr2);
                }
                contract.MinConsecutiveWorkingWeekendsWeight = weight;
                contract.MinConsecutiveWorkingWeekends = MinConsecutiveWorkingWeekends2 = Integer.parseInt(reader.ReadString());
                contract.MinConsecutiveWorkingWeekendsIsOn = on;
                reader.ReadEndElement();
                if (!this.VERBOSE) continue;
                System.out.println("MinConsecutiveWorkingWeekends=" + MinConsecutiveWorkingWeekends2 + " weight=" + contract.MinConsecutiveWorkingWeekendsWeight);
                continue;
            }
            if (reader.Name.equalsIgnoreCase("MaxConsecutiveFreeWeekends")) {
                int MaxConsecutiveFreeWeekends2;
                boolean on = true;
                onStr = null;
                onStr = reader.GetAttribute("on");
                if (onStr != null) {
                    on = XmlConvert.ToBoolean(onStr);
                }
                int weight = -1;
                weightStr2 = reader.GetAttribute("weight");
                if (weightStr2 != null) {
                    weight = Integer.parseInt(weightStr2);
                }
                contract.MaxConsecutiveFreeWeekendsWeight = weight;
                contract.MaxConsecutiveFreeWeekends = MaxConsecutiveFreeWeekends2 = Integer.parseInt(reader.ReadString());
                contract.MaxConsecutiveFreeWeekendsIsOn = on;
                reader.ReadEndElement();
                if (!this.VERBOSE) continue;
                System.out.println("MaxConsecutiveFreeWeekends=" + MaxConsecutiveFreeWeekends2 + " weight=" + contract.MaxConsecutiveFreeWeekendsWeight);
                continue;
            }
            if (reader.Name.equalsIgnoreCase("MinConsecutiveFreeWeekends")) {
                int MinConsecutiveFreeWeekends2;
                boolean on = true;
                onStr = null;
                onStr = reader.GetAttribute("on");
                if (onStr != null) {
                    on = XmlConvert.ToBoolean(onStr);
                }
                int weight = -1;
                weightStr2 = reader.GetAttribute("weight");
                if (weightStr2 != null) {
                    weight = Integer.parseInt(weightStr2);
                }
                contract.MinConsecutiveFreeWeekendsWeight = weight;
                contract.MinConsecutiveFreeWeekends = MinConsecutiveFreeWeekends2 = Integer.parseInt(reader.ReadString());
                contract.MinConsecutiveFreeWeekendsIsOn = on;
                reader.ReadEndElement();
                if (!this.VERBOSE) continue;
                System.out.println("MinConsecutiveFreeWeekends=" + MinConsecutiveFreeWeekends2 + " weight=" + contract.MinConsecutiveFreeWeekendsWeight);
                continue;
            }
            System.out.println("Error :: Unknown Element : " + reader.Name);
            break;
        }
        reader.ReadEndElement();
        if (this.VERBOSE) {
            System.out.println("----------------------------------------------");
        }
        return contract;
    }

    private Cover ParseCover(XmlReader reader) {
        reader.ReadStartElement("Cover");
        String skillID = "";
        CoverRequirement.SkillTypes skillType = CoverRequirement.SkillTypes.AnySkill;
        if (reader.Name.equalsIgnoreCase("Skill")) {
            skillType = CoverRequirement.SkillTypes.SingleSkill;
            reader.ReadStartElement("Skill");
            skillID = reader.ReadString();
            reader.ReadEndElement();
        } else if (reader.Name.equalsIgnoreCase("SkillGroup")) {
            skillType = CoverRequirement.SkillTypes.SkillGroup;
            reader.ReadStartElement("SkillGroup");
            skillID = reader.ReadString();
            reader.ReadEndElement();
        }
        String ID = "";
        Cover.CoverType type = Cover.CoverType.Shift;
        Period period = null;
        if (reader.Name.equalsIgnoreCase("TimePeriod")) {
            type = Cover.CoverType.Period;
            period = this.ParseTimePeriod(reader);
        } else if (reader.Name.equalsIgnoreCase("Shift")) {
            type = Cover.CoverType.Shift;
            reader.ReadStartElement();
            ID = reader.ReadString();
            reader.ReadEndElement();
        } else if (reader.Name.equalsIgnoreCase("ShiftGroup")) {
            type = Cover.CoverType.ShiftGroup;
            reader.ReadStartElement();
            ID = reader.ReadString();
            reader.ReadEndElement();
        } else {
            System.out.println("Warning: Unknown cover type.");
        }
        int min = -1;
        int max = -1;
        int pref = -1;
        if (reader.Name.equalsIgnoreCase("Min")) {
            reader.ReadStartElement("Min");
            min = Integer.parseInt(reader.ReadString());
            reader.ReadEndElement();
        }
        if (reader.Name.equalsIgnoreCase("Max")) {
            reader.ReadStartElement("Max");
            max = Integer.parseInt(reader.ReadString());
            reader.ReadEndElement();
        }
        if (reader.Name.equalsIgnoreCase("Preferred")) {
            reader.ReadStartElement("Preferred");
            pref = Integer.parseInt(reader.ReadString());
            reader.ReadEndElement();
        }
        reader.ReadEndElement();
        if (this.VERBOSE) {
            System.out.println("ID = " + ID + ", Min = " + min + ", Max = " + max + ", Pref = " + pref + ", Type = " + (Object)((Object)type));
        }
        if (type == Cover.CoverType.Shift && this.schedulingPeriod.GetShiftType(ID) == null) {
            System.out.println("Warning: unknown shift: " + ID + ". Unable to add cover request for this shift.");
            return null;
        }
        if (type == Cover.CoverType.ShiftGroup && this.schedulingPeriod.GetShiftGroup(ID) == null) {
            System.out.println("Warning: unknown shift group: " + ID + ". Unable to add cover request for this shift group.");
            return null;
        }
        Cover cover = new Cover(ID, type, skillID, skillType, period);
        cover.Min = min;
        cover.Max = max;
        cover.Preferred = pref;
        return cover;
    }

    private boolean ParseCoverRequirements(XmlReader reader) {
        while (!reader.Name.equalsIgnoreCase("CoverRequirements")) {
            Cover cover;
            if (reader.Name.equalsIgnoreCase("DayOfWeekCover")) {
                reader.ReadStartElement("DayOfWeekCover");
                reader.ReadStartElement("Day");
                String Day = reader.ReadString();
                reader.ReadEndElement();
                DayCoverSpecification dayCoverSpec = new DayCoverSpecification(Day);
                if (this.VERBOSE) {
                    System.out.println("Day Requirement, " + Day);
                }
                while (!reader.Name.equalsIgnoreCase("DayOfWeekCover")) {
                    cover = this.ParseCover(reader);
                    if (cover == null) continue;
                    dayCoverSpec.AddCoverRequirement(cover);
                }
                this.schedulingPeriod.CoverRequirements.AddCoverSpecification(dayCoverSpec, false);
                reader.ReadEndElement();
                continue;
            }
            if (reader.Name.equalsIgnoreCase("DateSpecificCover")) {
                if (this.VERBOSE) {
                    System.out.println("DateSpecific Requirement:");
                }
                reader.ReadStartElement("DateSpecificCover");
                reader.ReadStartElement("Date");
                String DateString = reader.ReadString();
                DateTime Date2 = DateTime.ParseDate(DateString);
                reader.ReadEndElement();
                DateCoverSpecification dateCoverSpec = new DateCoverSpecification(Date2);
                if (this.VERBOSE) {
                    System.out.println("Date = " + Date2);
                }
                while (!reader.Name.equalsIgnoreCase("DateSpecificCover")) {
                    cover = this.ParseCover(reader);
                    if (cover == null) continue;
                    dateCoverSpec.AddCoverRequirement(cover);
                }
                this.schedulingPeriod.CoverRequirements.AddCoverSpecification(dateCoverSpec, false);
                reader.ReadEndElement();
                continue;
            }
            System.out.println("Error: Unknown element " + reader.Name);
        }
        if (this.VERBOSE) {
            System.out.println("CoverRequirements Parsed.");
            System.out.println("----------------------------------------------");
        }
        return true;
    }

    private MasterWeights ParseMasterWeights(XmlReader reader) {
        MasterWeights mws = new MasterWeights();
        while (!reader.Name.equalsIgnoreCase("MasterWeights")) {
            String name = reader.Name;
            reader.ReadStartElement();
            int weight = Integer.parseInt(reader.ReadString());
            if (name.equalsIgnoreCase("MinTimeBetweenShifts")) {
                mws.MinTimeBetweenShifts = weight;
            } else if (name.equalsIgnoreCase("MaxNumAssignments")) {
                mws.MaxNumAssignments = weight;
            } else if (name.equalsIgnoreCase("MinNumAssignments")) {
                mws.MinNumAssignments = weight;
            } else if (name.equalsIgnoreCase("MaxDaysOff")) {
                mws.MaxDaysOff = weight;
            } else if (name.equalsIgnoreCase("MinDaysOff")) {
                mws.MinDaysOff = weight;
            } else if (name.equalsIgnoreCase("MaxConsecutiveWorkingDays")) {
                mws.MaxConsecutiveWorkingDays = weight;
            } else if (name.equalsIgnoreCase("MinConsecutiveWorkingDays")) {
                mws.MinConsecutiveWorkingDays = weight;
            } else if (name.equalsIgnoreCase("MaxWorkingBankHolidays")) {
                mws.MaxWorkingBankHolidays = weight;
            } else if (name.equalsIgnoreCase("MaxConsecutiveFreeDays")) {
                mws.MaxConsecutiveFreeDays = weight;
            } else if (name.equalsIgnoreCase("MinConsecutiveFreeDays")) {
                mws.MinConsecutiveFreeDays = weight;
            } else if (name.equalsIgnoreCase("MaxConsecutiveWorkingWeekends")) {
                mws.MaxConsecutiveWorkingWeekends = weight;
            } else if (name.equalsIgnoreCase("MaxWorkingDaysPerWeek")) {
                mws.MaxWorkingDaysPerWeek = weight;
            } else if (name.equalsIgnoreCase("MaxWorkingWeekendsInFourWeeks")) {
                mws.MaxWorkingWeekendsInFourWeeks = weight;
            } else if (name.equalsIgnoreCase("MaxWorkingWeekendsIncFriNight")) {
                mws.MaxWorkingWeekendsIncFriNight = weight;
            } else if (name.equalsIgnoreCase("MaxShiftsPerWeekStartMon")) {
                mws.MaxShiftsPerWeekStartMon = weight;
            } else if (name.equalsIgnoreCase("MinShiftsPerWeekStartMon")) {
                mws.MinShiftsPerWeekStartMon = weight;
            } else if (name.equalsIgnoreCase("MaxWorkingWeekends")) {
                mws.MaxWorkingWeekends = weight;
            } else if (name.equalsIgnoreCase("MaxWeekendsOff")) {
                mws.MaxWeekendsOff = weight;
            } else if (name.equalsIgnoreCase("CompleteWeekends")) {
                mws.CompleteWeekends = weight;
            } else if (name.equalsIgnoreCase("IdenticalShiftTypesDuringWeekend")) {
                mws.IdenticalShiftTypesDuringWeekend = weight;
            } else if (name.equalsIgnoreCase("NoNightShiftBeforeFreeWeekend")) {
                mws.NoNightShiftBeforeFreeWeekend = weight;
            } else if (name.equalsIgnoreCase("TwoFreeDaysAfterNightShifts")) {
                mws.TwoFreeDaysAfterNightShifts = weight;
            } else if (name.equalsIgnoreCase("MaxAssignmentsForDayOfWeek")) {
                mws.MaxAssignmentsForDayOfWeek = weight;
            } else if (name.equalsIgnoreCase("ValidNumConsecutiveShiftTypes")) {
                mws.ValidNumConsecutiveShiftTypes = weight;
            } else if (name.equalsIgnoreCase("ValidNumConsecutiveShiftGroups")) {
                mws.ValidNumConsecutiveShiftGroups = weight;
            } else if (name.equalsIgnoreCase("MaxShiftTypes")) {
                mws.MaxShiftTypes = weight;
            } else if (name.equalsIgnoreCase("MinShiftTypes")) {
                mws.MinShiftTypes = weight;
            } else if (name.equalsIgnoreCase("MaxShiftTypesPerWeek")) {
                mws.MaxShiftTypesPerWeek = weight;
            } else if (name.equalsIgnoreCase("MaxHoursWorked")) {
                mws.MaxHoursWorked = weight;
            } else if (name.equalsIgnoreCase("MinHoursWorked")) {
                mws.MinHoursWorked = weight;
            } else if (name.equalsIgnoreCase("MaxHoursPerWeek")) {
                mws.MaxHoursPerWeek = weight;
            } else if (name.equalsIgnoreCase("MaxHoursPerFortnight")) {
                mws.MaxHoursPerFortnight = weight;
            } else if (name.equalsIgnoreCase("ValidShiftTypeSuccessions")) {
                mws.ValidShiftTypeSuccessions = weight;
            } else if (name.equalsIgnoreCase("AlternativeSkillCategory")) {
                mws.AlternativeSkillCategory = weight;
            } else if (name.equalsIgnoreCase("Tutorship")) {
                mws.Tutorship = weight;
            } else if (name.equalsIgnoreCase("WorkSeparately")) {
                mws.WorkSeparately = weight;
            } else if (name.equalsIgnoreCase("MinShiftsPerWeek")) {
                mws.MinShiftsPerWeek = weight;
            } else if (name.equalsIgnoreCase("MaxShiftsPerWeek")) {
                mws.MaxShiftsPerWeek = weight;
            } else if (name.equalsIgnoreCase("MinConsecutiveShiftTypes")) {
                mws.MinConsecutiveShiftTypes = weight;
            } else if (name.equalsIgnoreCase("MaxConsecutiveShiftTypes")) {
                mws.MaxConsecutiveShiftTypes = weight;
            } else if (name.equalsIgnoreCase("MaxDaysBetweenShiftSeries")) {
                mws.MaxDaysBetweenShiftSeries = weight;
            } else if (name.equalsIgnoreCase("MinDaysBetweenShiftSeries")) {
                mws.MinDaysBetweenShiftSeries = weight;
            } else if (name.equalsIgnoreCase("MaxShiftTypeRatios")) {
                mws.MaxShiftTypeRatios = weight;
            } else if (name.equalsIgnoreCase("MinShiftTypeRatios")) {
                mws.MinShiftTypeRatios = weight;
            } else if (name.equalsIgnoreCase("MaxShiftsPerDay")) {
                mws.MaxShiftsPerDay = weight;
            } else if (name.equalsIgnoreCase("MinHoursWorkedBetweenDates")) {
                mws.MinHoursWorkedBetweenDates = weight;
            } else if (name.equalsIgnoreCase("MaxHoursWorkedBetweenDates")) {
                mws.MaxHoursWorkedBetweenDates = weight;
            } else if (name.equalsIgnoreCase("MinConsecutiveWorkingWeekends")) {
                mws.MinConsecutiveWorkingWeekends = weight;
            } else if (name.equalsIgnoreCase("MaxConsecutiveFreeWeekends")) {
                mws.MaxConsecutiveFreeWeekends = weight;
            } else if (name.equalsIgnoreCase("MinConsecutiveFreeWeekends")) {
                mws.MinConsecutiveFreeWeekends = weight;
            } else if (name.equalsIgnoreCase("PrefOverStaffing")) {
                mws.PrefOverStaffing = weight;
            } else if (name.equalsIgnoreCase("PrefUnderStaffing")) {
                mws.PrefUnderStaffing = weight;
            } else if (name.equalsIgnoreCase("MaxOverStaffing")) {
                mws.MaxOverStaffing = weight;
            } else if (name.equalsIgnoreCase("MinUnderStaffing")) {
                mws.MinUnderStaffing = weight;
            } else if (name.equalsIgnoreCase("EmployeeAvailability")) {
                mws.EmployeeAvailability = weight;
            } else if (name.equalsIgnoreCase("SkilledShifts")) {
                mws.SkilledShifts = weight;
            } else if (name.equalsIgnoreCase("MaxWeekendDays")) {
                mws.MaxWeekendDays = weight;
            } else {
                System.out.println("Warning: Unknown element '" + name + "' in MasterWeights");
            }
            reader.ReadEndElement();
            if (!this.VERBOSE) continue;
            System.out.println("MasterWeight: " + name + "=" + weight);
        }
        if (this.VERBOSE) {
            System.out.println("MasterWeights Parsed.");
            System.out.println("----------------------------------------------");
        }
        return mws;
    }

    private EmployeeDescription ParseEmployee(XmlReader reader) {
        String EmployeeID = reader.GetAttribute("ID");
        if (this.VERBOSE) {
            System.out.println("Parsing Employee, EmployeeID = " + EmployeeID);
        }
        EmployeeDescription employee = new EmployeeDescription(EmployeeID, this.schedulingPeriod);
        employee.LastName = EmployeeID;
        reader.ReadStartElement("Employee");
        while (!reader.Name.equalsIgnoreCase("Employee")) {
            if (reader.Name.equalsIgnoreCase("Name")) {
                reader.ReadStartElement("Name");
                employee.LastName = reader.ReadString();
                reader.ReadEndElement();
                continue;
            }
            if (reader.Name.equalsIgnoreCase("FirstName")) {
                reader.ReadStartElement("FirstName");
                employee.FirstName = reader.ReadString();
                reader.ReadEndElement();
                continue;
            }
            if (reader.Name.equalsIgnoreCase("LastName")) {
                reader.ReadStartElement("LastName");
                employee.LastName = reader.ReadString();
                reader.ReadEndElement();
                continue;
            }
            if (reader.Name.equalsIgnoreCase("EmailAddress")) {
                reader.ReadStartElement("EmailAddress");
                employee.EmailAddress = reader.ReadString();
                reader.ReadEndElement();
                continue;
            }
            if (reader.Name.equalsIgnoreCase("PhoneNumber")) {
                reader.ReadStartElement("PhoneNumber");
                employee.PhoneNumber = reader.ReadString();
                reader.ReadEndElement();
                continue;
            }
            if (reader.Name.equalsIgnoreCase("InRoster")) {
                employee.InRoster = reader.ReadElementContentAsBoolean();
                continue;
            }
            if (reader.Name.equalsIgnoreCase("ContractID")) {
                reader.ReadStartElement("ContractID");
                String ContractID = reader.ReadString();
                Contract contract = this.GetContract(ContractID);
                if (contract == null) {
                    System.out.println("Error :: ContractID: '" + ContractID + "' (for employee " + EmployeeID + ") not defined.");
                } else {
                    ++contract.EmployeeCount;
                    employee.Contract = contract;
                }
                reader.ReadEndElement();
                continue;
            }
            if (reader.Name.equalsIgnoreCase("EmploymentStartDate")) {
                DateTime EmploymentStartDate = reader.ReadElementContentAsDateTime();
                employee.setEmploymentStartDate(EmploymentStartDate);
                continue;
            }
            if (reader.Name.equalsIgnoreCase("EmploymentEndDate")) {
                DateTime EmploymentEndDate = reader.ReadElementContentAsDateTime();
                employee.setEmploymentEndDate(EmploymentEndDate);
                continue;
            }
            if (reader.Name.equalsIgnoreCase("Skills")) {
                reader.ReadStartElement("Skills");
                while (!reader.Name.equalsIgnoreCase("Skills")) {
                    String Type2 = null;
                    Type2 = reader.GetAttribute("Type");
                    if (Type2 == null) {
                        Type2 = "Primary";
                    }
                    reader.ReadStartElement("Skill");
                    String SkillID = reader.ReadString();
                    reader.ReadEndElement();
                    employee.AddSkill(SkillID, Type2);
                    if (!this.VERBOSE) continue;
                    System.out.println("SkillID = " + SkillID + ", Type = " + Type2);
                }
                reader.ReadEndElement();
                continue;
            }
            System.out.println("Error :: Unknown Element : " + reader.Name);
            break;
        }
        reader.ReadEndElement();
        if (employee.Contract == null) {
            Random rand = new Random();
            employee.Contract = new Contract(Integer.toString(rand.nextInt(Integer.MAX_VALUE)), this.schedulingPeriod);
            employee.Contract.EmployeeCount = 1;
        }
        if (this.VERBOSE) {
            System.out.println("Name = " + employee.getName());
            System.out.println("ContractID = " + employee.Contract.ContractID);
            System.out.println("----------------------------------------------");
        }
        return employee;
    }

    private Period ParseTimePeriod(XmlReader reader) {
        if (this.VERBOSE) {
            System.out.println("Parsing Period");
        }
        DateTime startDateTime = new DateTime();
        DateTime endDateTime = new DateTime();
        reader.ReadStartElement("TimePeriod");
        while (!reader.Name.equalsIgnoreCase("TimePeriod")) {
            String name = reader.Name;
            reader.ReadStartElement();
            if (name.equalsIgnoreCase("Start")) {
                startDateTime = DateTime.ParseTime(reader.ReadString());
            } else if (name.equalsIgnoreCase("End")) {
                endDateTime = DateTime.ParseTime(reader.ReadString());
            } else {
                System.out.println("Warning: Unknown element '" + name + "' in TimePeriod");
            }
            reader.ReadEndElement();
        }
        reader.ReadEndElement();
        Period period = new Period(startDateTime, endDateTime);
        if (this.VERBOSE) {
            System.out.println("Start = " + period.getStartTime().ToShortTimeString());
            System.out.println("End   = " + period.getEndTime().ToShortTimeString());
            System.out.println("---------------------------------------------");
        }
        return period;
    }

    public ShiftType ParseShiftType(XmlReader reader) {
        String shiftTypeID = reader.GetAttribute("ID");
        if (this.VERBOSE) {
            System.out.println("Parsing Shift. ShiftID = " + shiftTypeID);
        }
        DateTime startDateTime = new DateTime();
        DateTime endDateTime = new DateTime();
        String colour = null;
        String label = null;
        String shiftName = null;
        String description = null;
        double hoursWorked = -1.0;
        double freeTimeBefore = -1.0;
        double freeTimeAfter = -1.0;
        ArrayList<String> skills = new ArrayList<String>();
        boolean autoAllocate = true;
        reader.ReadStartElement("Shift");
        while (!reader.Name.equalsIgnoreCase("Shift")) {
            String name = reader.Name;
            reader.ReadStartElement();
            if (name.equalsIgnoreCase("Label")) {
                label = reader.ReadString();
            } else if (name.equalsIgnoreCase("Name")) {
                shiftName = reader.ReadString();
            } else if (name.equalsIgnoreCase("Description")) {
                description = reader.ReadString();
            } else if (name.equalsIgnoreCase("Colour")) {
                colour = reader.ReadString();
            } else if (name.equalsIgnoreCase("StartTime")) {
                startDateTime = DateTime.ParseTime(reader.ReadString());
            } else if (name.equalsIgnoreCase("EndTime")) {
                endDateTime = DateTime.ParseTime(reader.ReadString());
            } else if (name.equalsIgnoreCase("HoursWorked")) {
                hoursWorked = Double.parseDouble(reader.ReadString());
            } else if (name.equalsIgnoreCase("FreeTimeBefore")) {
                freeTimeBefore = Double.parseDouble(reader.ReadString());
            } else if (name.equalsIgnoreCase("FreeTimeAfter")) {
                freeTimeAfter = Double.parseDouble(reader.ReadString());
            } else if (name.equalsIgnoreCase("AutoAllocate")) {
                autoAllocate = XmlConvert.ToBoolean(reader.ReadString());
            } else if (name.equalsIgnoreCase("Skills")) {
                while (!reader.Name.equalsIgnoreCase("Skills")) {
                    reader.ReadStartElement("Skill");
                    String SkillID = reader.ReadString();
                    reader.ReadEndElement();
                    skills.add(SkillID);
                }
            } else {
                System.out.println("Warning: Unknown element '" + name + "' in ShiftType");
            }
            reader.ReadEndElement();
        }
        reader.ReadEndElement();
        ShiftType shiftType = new ShiftType(shiftTypeID, startDateTime, endDateTime);
        if (colour != null) {
            shiftType.HtmlColor = colour;
        }
        if (description != null) {
            shiftType.Description = description;
        }
        if (label != null) {
            shiftType.Label = label;
        }
        if (shiftName != null) {
            shiftType.Name = shiftName;
        }
        if (hoursWorked >= 0.0) {
            shiftType.HoursWorked = hoursWorked;
        }
        if (freeTimeBefore >= 0.0) {
            shiftType.FreeTimeBefore = freeTimeBefore;
        }
        if (freeTimeAfter >= 0.0) {
            shiftType.FreeTimeAfter = freeTimeAfter;
        }
        shiftType.AutoAllocate = autoAllocate;
        if (this.VERBOSE) {
            System.out.println("Colour = " + shiftType.HtmlColor);
            System.out.println("Description = " + shiftType.Description);
            System.out.println("Label = " + shiftType.Label);
            System.out.println("HoursWorked = " + shiftType.HoursWorked);
            System.out.println("FreeTimeBefore = " + shiftType.FreeTimeBefore);
            System.out.println("FreeTimeAfter = " + shiftType.FreeTimeAfter);
        }
        for (String SkillID : skills) {
            shiftType.AddSkill(SkillID);
            if (!this.VERBOSE) continue;
            System.out.println("SkillID = " + SkillID);
        }
        if (this.VERBOSE) {
            System.out.println("---------------------------------------------");
        }
        return shiftType;
    }

    private ShiftGroup ParseShiftGroup(XmlReader reader) {
        String ID = reader.GetAttribute("ID");
        if (this.VERBOSE) {
            System.out.print("Shift Group: " + ID + " = ");
        }
        reader.ReadStartElement("ShiftGroup");
        ShiftGroup shiftGroup = new ShiftGroup(ID);
        while (!reader.Name.equalsIgnoreCase("ShiftGroup")) {
            ShiftType st;
            reader.ReadStartElement("Shift");
            String shiftTypeID = reader.ReadString();
            reader.ReadEndElement();
            if (this.VERBOSE) {
                System.out.print(String.valueOf(shiftTypeID) + ", ");
            }
            if ((st = this.schedulingPeriod.GetShiftType(shiftTypeID)) == null) {
                System.out.println("\nWarning: Unable to add ShiftType: '" + shiftTypeID + "' to ShiftGroup '" + ID + "' as ShiftType not defined");
                continue;
            }
            shiftGroup.AddShiftType(st, true);
        }
        reader.ReadEndElement();
        if (this.VERBOSE) {
            System.out.println("-----------------------------------------");
        }
        return shiftGroup;
    }

    private Skill ParseSkill(XmlReader reader) {
        String ID = reader.GetAttribute("ID");
        reader.ReadStartElement("Skill");
        if (this.VERBOSE) {
            System.out.println("SkillID : " + ID);
        }
        Skill skill = new Skill(ID, "");
        while (!reader.Name.equalsIgnoreCase("Skill")) {
            if (!reader.Name.equalsIgnoreCase("Label")) continue;
            reader.ReadStartElement("Label");
            skill.Label = reader.ReadString();
            reader.ReadEndElement();
        }
        reader.ReadEndElement();
        return skill;
    }

    private SkillGroup ParseSkillGroup(XmlReader reader) {
        String ID = reader.GetAttribute("ID");
        reader.ReadStartElement("SkillGroup");
        if (this.VERBOSE) {
            System.out.print("Skill Group: " + ID + " = ");
        }
        SkillGroup skillGroup = new SkillGroup(ID);
        while (!reader.Name.equalsIgnoreCase("SkillGroup")) {
            reader.ReadStartElement("Skill");
            String skillID = reader.ReadString();
            reader.ReadEndElement();
            Skill skill = this.schedulingPeriod.GetSkill(skillID);
            if (skill == null) {
                System.out.println("Warning: Unable to find skill " + skillID);
                continue;
            }
            skillGroup.AddSkill(skill);
            if (!this.VERBOSE) continue;
            System.out.print(String.valueOf(skillID) + ", ");
        }
        reader.ReadEndElement();
        if (this.VERBOSE) {
            System.out.println("-----------------------------------------");
        }
        return skillGroup;
    }

    private void ParseDayOffRequestBetweenDates(XmlReader reader) {
        if (this.VERBOSE) {
            System.out.println("Parsing day off request between dates...");
        }
        boolean holiday = true;
        String holStr = null;
        holStr = reader.GetAttribute("holiday");
        if (holStr != null) {
            holiday = XmlConvert.ToBoolean(holStr);
        }
        int weight = Integer.parseInt(reader.GetAttribute("weight"));
        reader.ReadStartElement("Request");
        reader.ReadStartElement("EmployeeID");
        String EmployeeID = reader.ReadString();
        reader.ReadEndElement();
        reader.ReadStartElement("StartDate");
        DateTime StartDate = DateTime.ParseDate(reader.ReadString());
        reader.ReadEndElement();
        reader.ReadStartElement("EndDate");
        DateTime EndDate = DateTime.ParseDate(reader.ReadString());
        reader.ReadEndElement();
        reader.ReadStartElement("MinimumDaysOff");
        int MinimumDaysOff = Integer.parseInt(reader.ReadString());
        reader.ReadEndElement();
        reader.ReadStartElement("MaximumDaysOff");
        int MaximumDaysOff = Integer.parseInt(reader.ReadString());
        reader.ReadEndElement();
        this.schedulingPeriod.RequestDaysOffBetweenDates(EmployeeID, weight, StartDate, EndDate, MinimumDaysOff, MaximumDaysOff, holiday);
        if (this.VERBOSE) {
            System.out.println("Weight = " + weight);
            System.out.println("EmployeeID = " + EmployeeID);
            System.out.println("StartDate = " + StartDate);
            System.out.println("EndDate = " + EndDate);
            System.out.println("MinimumDaysOff = " + MinimumDaysOff);
            System.out.println("MaximumDaysOff = " + MaximumDaysOff);
            System.out.println("Holiday = " + holiday);
            System.out.println(" ");
        }
        reader.ReadEndElement();
    }

    private Pattern ParsePattern(XmlReader reader) {
        int weight = Integer.parseInt(reader.GetAttribute("weight"));
        DateTime date = new DateTime();
        int weekdayIndex = 0;
        ArrayList<String> shiftsArr = new ArrayList<String>();
        ArrayList<Pattern.DayType> shiftOrGroup = new ArrayList<Pattern.DayType>();
        reader.ReadStartElement("Pattern");
        int start = 0;
        Pattern.StartType startType = Pattern.StartType.All;
        if (reader.Name.equalsIgnoreCase("StartDay")) {
            reader.ReadStartElement("StartDay");
            String StartDay = reader.ReadString();
            reader.ReadEndElement();
            startType = Pattern.StartType.Day;
            if (StartDay.equalsIgnoreCase("Monday")) {
                start = this.schedulingPeriod.MondayPatternIndex;
                weekdayIndex = 0;
            } else if (StartDay.equalsIgnoreCase("Tuesday")) {
                start = this.schedulingPeriod.TuesdayPatternIndex;
                weekdayIndex = 1;
            } else if (StartDay.equalsIgnoreCase("Wednesday")) {
                start = this.schedulingPeriod.WednesdayPatternIndex;
                weekdayIndex = 2;
            } else if (StartDay.equalsIgnoreCase("Thursday")) {
                start = this.schedulingPeriod.ThursdayPatternIndex;
                weekdayIndex = 3;
            } else if (StartDay.equalsIgnoreCase("Friday")) {
                start = this.schedulingPeriod.FridayPatternIndex;
                weekdayIndex = 4;
            } else if (StartDay.equalsIgnoreCase("Saturday")) {
                start = this.schedulingPeriod.SaturdayPatternIndex;
                weekdayIndex = 5;
            } else if (StartDay.equalsIgnoreCase("Sunday")) {
                start = this.schedulingPeriod.SundayPatternIndex;
                weekdayIndex = 6;
            } else {
                start = this.schedulingPeriod.MondayPatternIndex;
            }
        } else if (reader.Name.equalsIgnoreCase("StartDate")) {
            reader.ReadStartElement("StartDate");
            String StartDate = reader.ReadString();
            reader.ReadEndElement();
            startType = Pattern.StartType.Date;
            date = DateTime.ParseDate(StartDate);
            start = this.schedulingPeriod.ConvertDateToRosterDay(date);
        }
        while (!reader.Name.equalsIgnoreCase("Pattern")) {
            String name = reader.Name;
            reader.ReadStartElement();
            String val = reader.ReadString();
            reader.ReadEndElement();
            shiftsArr.add(val);
            if (val.equalsIgnoreCase("")) {
                shiftOrGroup.add(Pattern.DayType.Off);
                continue;
            }
            if (val.equalsIgnoreCase("*")) {
                shiftOrGroup.add(Pattern.DayType.Any);
                continue;
            }
            if (val.equalsIgnoreCase("+")) {
                shiftOrGroup.add(Pattern.DayType.OtherWork);
                continue;
            }
            if (val.equalsIgnoreCase("$")) {
                shiftOrGroup.add(Pattern.DayType.WorkingDay);
                continue;
            }
            if (name.equalsIgnoreCase("Shift")) {
                shiftOrGroup.add(Pattern.DayType.Shift);
                continue;
            }
            if (name.equalsIgnoreCase("NotShift")) {
                shiftOrGroup.add(Pattern.DayType.NotShift);
                continue;
            }
            if (name.equalsIgnoreCase("ShiftGroup")) {
                shiftOrGroup.add(Pattern.DayType.ShiftGroup);
                continue;
            }
            System.out.println("Unknown name:" + name);
        }
        reader.ReadEndElement();
        int[] pattern = new int[shiftsArr.size()];
        Pattern.DayType[] dayTypes = shiftOrGroup.toArray(new Pattern.DayType[0]);
        ShiftType[] Shifts = new ShiftType[dayTypes.length];
        ShiftGroup[] ShiftGroups = new ShiftGroup[dayTypes.length];
        int i = 0;
        while (i < shiftsArr.size()) {
            String str = (String)shiftsArr.get(i);
            if (dayTypes[i] == Pattern.DayType.Shift || dayTypes[i] == Pattern.DayType.NotShift) {
                ShiftType shiftType = this.schedulingPeriod.GetShiftType(str);
                if (shiftType == null) {
                    System.out.println("Warning: ShiftType '" + str + "', in constraint Patterns not defined.");
                    return null;
                }
                pattern[i] = shiftType.Index;
                Shifts[i] = shiftType;
            } else if (dayTypes[i] == Pattern.DayType.ShiftGroup) {
                ShiftGroup shiftGroup = this.schedulingPeriod.GetShiftGroup(str);
                if (shiftGroup == null) {
                    System.out.println("Warning: ShiftGroup '" + str + "', in constraint Patterns not defined.");
                    return null;
                }
                pattern[i] = shiftGroup.Index;
                ShiftGroups[i] = shiftGroup;
            } else {
                pattern[i] = -1;
            }
            ++i;
        }
        return new Pattern(start, startType, pattern, dayTypes, weight, weekdayIndex, date, Shifts, ShiftGroups);
    }

    private void ParseRequestedDayOff(XmlReader reader) {
        if (this.VERBOSE) {
            System.out.println("Parsing Day Off...");
        }
        boolean holiday = true;
        String holStr = null;
        holStr = reader.GetAttribute("holiday");
        if (holStr != null) {
            holiday = XmlConvert.ToBoolean(holStr);
        }
        boolean working = false;
        String workingStr = null;
        workingStr = reader.GetAttribute("working");
        if (workingStr != null) {
            working = XmlConvert.ToBoolean(workingStr);
        }
        int weight = Integer.parseInt(reader.GetAttribute("weight"));
        reader.ReadStartElement("DayOff");
        reader.ReadStartElement("EmployeeID");
        String EmployeeID = reader.ReadString();
        reader.ReadEndElement();
        boolean isDate = true;
        if (reader.Name.equalsIgnoreCase("Day")) {
            isDate = false;
        }
        reader.ReadStartElement();
        String dateString = reader.ReadString();
        reader.ReadEndElement();
        if (isDate) {
            DateTime date = DateTime.ParseDate(dateString);
            if (this.schedulingPeriod.IsDateWithinSchedulingPeriod(date)) {
                int day = this.schedulingPeriod.ConvertDateToRosterDay(date);
                this.schedulingPeriod.RequestDayOff(EmployeeID, day, date, weight, holiday, working);
            } else {
                System.out.println("Unable to request day off. Date : " + date + " out of scheduling range.");
            }
        } else {
            int day = Integer.parseInt(dateString);
            if (this.schedulingPeriod.IsDayWithinSchedulingPeriod(day)) {
                DateTime date = this.schedulingPeriod.ConvertRosterDayToDate(day);
                this.schedulingPeriod.RequestDayOff(EmployeeID, day, date, weight, holiday, working);
            } else {
                System.out.println("Unable to request day off. day : " + day + " out of scheduling range.");
            }
        }
        if (this.VERBOSE) {
            System.out.println("Weight = " + weight);
            System.out.println("EmployeeID = " + EmployeeID);
            System.out.println("Day/Date = " + dateString);
            System.out.println("Holiday = " + holiday);
            System.out.println("Working = " + working);
            System.out.println(" ");
        }
        reader.ReadEndElement();
    }

    private void ParseRequestedDayOn(XmlReader reader) {
        if (this.VERBOSE) {
            System.out.println("Parsing Day On...");
        }
        int weight = Integer.parseInt(reader.GetAttribute("weight"));
        reader.ReadStartElement("DayOn");
        reader.ReadStartElement("EmployeeID");
        String employeeID = reader.ReadString();
        reader.ReadEndElement();
        boolean isDate = true;
        if (reader.Name.equalsIgnoreCase("Day")) {
            isDate = false;
        }
        reader.ReadStartElement();
        String dateString = reader.ReadString();
        reader.ReadEndElement();
        if (isDate) {
            DateTime date = DateTime.ParseDate(dateString);
            if (this.schedulingPeriod.IsDateWithinSchedulingPeriod(date)) {
                int day = this.schedulingPeriod.ConvertDateToRosterDay(date);
                this.schedulingPeriod.RequestDayOn(employeeID, day, date, weight);
            } else {
                System.out.println("Unable to request day on. Date : " + date + " out of scheduling range.");
            }
        } else {
            int day = Integer.parseInt(dateString);
            if (this.schedulingPeriod.IsDayWithinSchedulingPeriod(day)) {
                DateTime date = this.schedulingPeriod.ConvertRosterDayToDate(day);
                this.schedulingPeriod.RequestDayOn(employeeID, day, date, weight);
            } else {
                System.out.println("Unable to request day on. day : " + day + " out of scheduling range.");
            }
        }
        if (this.VERBOSE) {
            System.out.println("Weight = " + weight);
            System.out.println("EmployeeID = " + employeeID);
            System.out.println("Day/Date = " + dateString);
        }
        reader.ReadEndElement();
    }

    private void ParseRequestedShiftOff(XmlReader reader) {
        if (this.VERBOSE) {
            System.out.println("Parsing Shift Off...");
        }
        int weight = Integer.parseInt(reader.GetAttribute("weight"));
        reader.ReadStartElement("ShiftOff");
        reader.ReadStartElement("ShiftTypeID");
        String ShiftTypeID = reader.ReadString();
        reader.ReadEndElement();
        reader.ReadStartElement("EmployeeID");
        String EmployeeID = reader.ReadString();
        reader.ReadEndElement();
        boolean isDate = true;
        if (reader.Name.equalsIgnoreCase("Day")) {
            isDate = false;
        }
        reader.ReadStartElement();
        String dateString = reader.ReadString();
        reader.ReadEndElement();
        if (isDate) {
            DateTime date = DateTime.ParseDate(dateString);
            if (this.schedulingPeriod.IsDateWithinSchedulingPeriod(date)) {
                int day = this.schedulingPeriod.ConvertDateToRosterDay(date);
                this.schedulingPeriod.RequestShiftOff(EmployeeID, ShiftTypeID, day, date, weight);
            } else {
                System.out.println("Unable to request shift off. Date : " + date + " out of scheduling range.");
            }
        } else {
            int day = Integer.parseInt(dateString);
            if (this.schedulingPeriod.IsDayWithinSchedulingPeriod(day)) {
                DateTime date = this.schedulingPeriod.ConvertRosterDayToDate(day);
                this.schedulingPeriod.RequestShiftOff(EmployeeID, ShiftTypeID, day, date, weight);
            } else {
                System.out.println("Unable to request shift off. Day : " + day + " out of scheduling range.");
            }
        }
        if (this.VERBOSE) {
            System.out.println("Weight = " + weight);
            System.out.println("ShiftTypeID = " + ShiftTypeID);
            System.out.println("EmployeeID = " + EmployeeID);
            System.out.println("Date/Day = " + dateString);
        }
        reader.ReadEndElement();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void ParseRequestedShiftOn(XmlReader reader) {
        if (this.VERBOSE) {
            System.out.println("Parsing Shift On...");
        }
        int weight = Integer.parseInt(reader.GetAttribute("weight"));
        reader.ReadStartElement("ShiftOn");
        String shiftGroupType = reader.Name;
        String ID = null;
        ArrayList<ShiftType> shifts = new ArrayList<ShiftType>();
        if (shiftGroupType.equalsIgnoreCase("ShiftGroupID") || shiftGroupType.equalsIgnoreCase("ShiftTypeID")) {
            reader.ReadStartElement();
            ID = reader.ReadString();
            reader.ReadEndElement();
        } else {
            reader.ReadStartElement("ShiftGroup");
            while (!reader.Name.equalsIgnoreCase("ShiftGroup")) {
                reader.ReadStartElement("Shift");
                String shiftTypeID = reader.ReadString();
                reader.ReadEndElement();
                ShiftType st = this.schedulingPeriod.GetShiftType(shiftTypeID);
                if (st == null) {
                    System.out.println("\nWarning: ShiftType: '" + shiftTypeID + " not defined");
                    continue;
                }
                shifts.add(st);
            }
            reader.ReadEndElement();
        }
        reader.ReadStartElement("EmployeeID");
        String EmployeeID = reader.ReadString();
        reader.ReadEndElement();
        boolean isDate = true;
        if (reader.Name.equalsIgnoreCase("Day")) {
            isDate = false;
        }
        reader.ReadStartElement();
        String dateString = reader.ReadString();
        reader.ReadEndElement();
        if (this.VERBOSE) {
            System.out.println("Weight = " + weight);
            System.out.println("EmployeeID = " + EmployeeID);
            System.out.println("Day/Date = " + dateString);
        }
        reader.ReadEndElement();
        if (isDate) {
            DateTime date = DateTime.ParseDate(dateString);
            if (!this.schedulingPeriod.IsDateWithinSchedulingPeriod(date)) {
                System.out.println("Unable to request shift on. Date : " + date + " out of scheduling range.");
                return;
            }
            int day = this.schedulingPeriod.ConvertDateToRosterDay(date);
            if (shiftGroupType.equalsIgnoreCase("ShiftTypeID")) {
                this.schedulingPeriod.RequestShiftOn(EmployeeID, ID, day, date, weight);
                return;
            }
            if (shiftGroupType.equalsIgnoreCase("ShiftGroupID")) {
                this.schedulingPeriod.RequestShiftGroupOn(EmployeeID, ID, day, date, weight);
                return;
            }
            this.schedulingPeriod.RequestShiftGroupOn(EmployeeID, shifts, day, date, weight);
            return;
        }
        int day = Integer.parseInt(dateString);
        if (!this.schedulingPeriod.IsDayWithinSchedulingPeriod(day)) {
            System.out.println("Unable to request shift on. Day : " + day + " out of scheduling range.");
            return;
        }
        DateTime date = this.schedulingPeriod.ConvertRosterDayToDate(day);
        if (shiftGroupType.equalsIgnoreCase("ShiftTypeID")) {
            this.schedulingPeriod.RequestShiftOn(EmployeeID, ID, day, date, weight);
            return;
        }
        if (shiftGroupType.equalsIgnoreCase("ShiftGroupID")) {
            this.schedulingPeriod.RequestShiftGroupOn(EmployeeID, ID, day, date, weight);
            return;
        }
        this.schedulingPeriod.RequestShiftGroupOn(EmployeeID, shifts, day, date, weight);
    }

    private void ParsePartnership(XmlReader reader) {
        if (this.VERBOSE) {
            System.out.println("Parsing Partnership...");
        }
        String Type2 = reader.GetAttribute("Type");
        reader.ReadStartElement("Partnership");
        reader.ReadStartElement("Employee1ID");
        String Employee1ID = reader.ReadString();
        reader.ReadEndElement();
        reader.ReadStartElement("Employee2ID");
        String Employee2ID = reader.ReadString();
        reader.ReadEndElement();
        if (Type2.equalsIgnoreCase("Tutorship")) {
            this.schedulingPeriod.RequestCollaboration(Employee1ID, Employee2ID);
        } else if (Type2.equalsIgnoreCase("Separation")) {
            this.schedulingPeriod.RequestSeparation(Employee1ID, Employee2ID);
        } else {
            System.out.println("Warning: Unknown Work Partnership type: " + Type2);
        }
        if (this.VERBOSE) {
            System.out.println("Type = " + Type2);
            System.out.println("Employee1ID = " + Employee1ID);
            System.out.println("Employee2ID = " + Employee2ID);
        }
        reader.ReadEndElement();
    }

    private void ParseSchedulingHistory(XmlReader reader) {
        if (this.VERBOSE) {
            System.out.println("Parsing SchedulingHistory");
        }
        while (!reader.Name.equalsIgnoreCase("SchedulingHistory")) {
            this.ParseEmployeeHistory(reader);
        }
        if (this.VERBOSE) {
            System.out.println("SchedulingHistory Parsed.");
            System.out.println("----------------------------------------------");
        }
    }

    private void ParseEmployeeHistory(XmlReader reader) {
        EmployeeDescription employee;
        String ID = reader.GetAttribute("EmployeeID");
        if (this.VERBOSE) {
            System.out.println("Parsing EmployeeHistory, EmployeeID = " + ID);
        }
        if ((employee = this.schedulingPeriod.GetEmployeeDescription(ID)) == null) {
            System.out.println("Error :: Employee ID: '" + ID + "' in scheduling history not defined in employees.");
        }
        this.schedulingPeriod.HistoryLoadedFromSchedulingPeriodFile = true;
        employee.SchedulingHistory.Exists = true;
        reader.ReadStartElement("EmployeeHistory");
        while (!reader.Name.equalsIgnoreCase("EmployeeHistory")) {
            ShiftType ShiftType2;
            String name = reader.Name;
            if (name.equalsIgnoreCase("PreviousAssignments")) {
                int day = 0;
                reader.ReadStartElement("PreviousAssignments");
                while (!reader.Name.equalsIgnoreCase("PreviousAssignments")) {
                    reader.ReadStartElement("Day");
                    if (this.VERBOSE) {
                        System.out.println("PreviousAssignments Day : " + day);
                    }
                    employee.SchedulingHistory.PreviousShiftAssignments = CSharpConversionHelper.ArrayResize(employee.SchedulingHistory.PreviousShiftAssignments, employee.SchedulingHistory.PreviousShiftAssignments.length + this.schedulingPeriod.ShiftTypesCount);
                    employee.SchedulingHistory.PreviousDayOffRequestWasWork = CSharpConversionHelper.ArrayResize(employee.SchedulingHistory.PreviousDayOffRequestWasWork, employee.SchedulingHistory.PreviousDayOffRequestWasWork.length + 1);
                    ++employee.SchedulingHistory.DaysOfHistoryProvided;
                    while (!reader.Name.equalsIgnoreCase("Day")) {
                        reader.ReadStartElement("Shift");
                        String shiftTypeID = reader.ReadString();
                        reader.ReadEndElement();
                        if (shiftTypeID.equalsIgnoreCase("+")) {
                            employee.SchedulingHistory.PreviousDayOffRequestWasWork[day] = true;
                        } else {
                            ShiftType shiftType = this.schedulingPeriod.GetShiftType(shiftTypeID);
                            if (shiftType == null) {
                                System.out.println("Error :: ShiftType ID: '" + shiftTypeID + "' in scheduling history not defined.");
                                continue;
                            }
                            int index = day * this.schedulingPeriod.ShiftTypesCount + shiftType.Index;
                            employee.SchedulingHistory.PreviousShiftAssignments[index] = true;
                        }
                        if (!this.VERBOSE) continue;
                        System.out.println("  Shift : " + shiftTypeID);
                    }
                    reader.ReadEndElement();
                    ++day;
                }
                reader.ReadEndElement();
                employee.SchedulingHistory.UpdatePreviousDayType(day, this.schedulingPeriod.ShiftTypesCount);
                continue;
            }
            if (name.equalsIgnoreCase("LastDayType")) {
                reader.ReadStartElement("LastDayType");
                String LastDayType = reader.ReadString();
                if (LastDayType.equalsIgnoreCase("WorkingDay")) {
                    employee.SchedulingHistory.LastDayType = 1;
                } else if (LastDayType.equalsIgnoreCase("NonWorkingDay")) {
                    employee.SchedulingHistory.LastDayType = 0;
                } else if (LastDayType.equalsIgnoreCase("HolidayNonWorkingDay")) {
                    employee.SchedulingHistory.LastDayType = 2;
                }
                reader.ReadEndElement();
                continue;
            }
            if (name.equalsIgnoreCase("LastDayShifts")) {
                reader.ReadStartElement("LastDayShifts");
                while (!reader.Name.equalsIgnoreCase("LastDayShifts")) {
                    reader.ReadStartElement("Shift");
                    String shiftTypeID = reader.ReadString();
                    reader.ReadEndElement();
                    ShiftType shiftType = this.schedulingPeriod.GetShiftType(shiftTypeID);
                    if (shiftType == null) {
                        System.out.println("Error :: ShiftType ID: '" + shiftTypeID + "' in scheduling history not defined.");
                    }
                    employee.SchedulingHistory.LastDayAssignments[shiftType.Index] = true;
                    if (!this.VERBOSE) continue;
                    System.out.println("LastDayShifts = " + shiftTypeID);
                }
                reader.ReadEndElement();
                continue;
            }
            if (name.equalsIgnoreCase("PreviousConsecutiveWorkingDays")) {
                reader.ReadStartElement("PreviousConsecutiveWorkingDays");
                employee.SchedulingHistory.PreviousConsecutiveWorkingDays = Integer.parseInt(reader.ReadString());
                reader.ReadEndElement();
                continue;
            }
            if (name.equalsIgnoreCase("PreviousConsecutiveWorkingDaysAndHoliday")) {
                reader.ReadStartElement("PreviousConsecutiveWorkingDaysAndHoliday");
                employee.SchedulingHistory.PreviousConsecutiveWorkingDaysAndHoliday = Integer.parseInt(reader.ReadString());
                reader.ReadEndElement();
                continue;
            }
            if (name.equalsIgnoreCase("PreviousConsecutiveFreeDays")) {
                reader.ReadStartElement("PreviousConsecutiveFreeDays");
                employee.SchedulingHistory.PreviousConsecutiveFreeDays = Integer.parseInt(reader.ReadString());
                reader.ReadEndElement();
                continue;
            }
            if (name.equalsIgnoreCase("PreviousConsecutiveFreeDaysAndHoliday")) {
                reader.ReadStartElement("PreviousConsecutiveFreeDaysAndHoliday");
                employee.SchedulingHistory.PreviousConsecutiveFreeDaysAndHoliday = Integer.parseInt(reader.ReadString());
                reader.ReadEndElement();
                continue;
            }
            if (name.equalsIgnoreCase("PreviousConsecutiveFreeDaysAndHolidayIncludesAtLeastOneNonWorkingDay")) {
                employee.SchedulingHistory.PreviousConsecutiveFreeDaysAndHolidayIncludesAtLeastOneNonWorkingDay = reader.ReadElementContentAsBoolean();
                continue;
            }
            if (name.equalsIgnoreCase("PreviousConsecutiveWorkingWeekends")) {
                reader.ReadStartElement("PreviousConsecutiveWorkingWeekends");
                employee.SchedulingHistory.PreviousConsecutiveWorkingWeekends = Integer.parseInt(reader.ReadString());
                reader.ReadEndElement();
                continue;
            }
            if (name.equalsIgnoreCase("PreviousWorkingBankHolidays")) {
                reader.ReadStartElement("PreviousWorkingBankHolidays");
                employee.SchedulingHistory.PreviousWorkingBankHolidays = Integer.parseInt(reader.ReadString());
                reader.ReadEndElement();
                continue;
            }
            if (name.equalsIgnoreCase("WeekendWorkedThreeWeeksAgo")) {
                employee.SchedulingHistory.WeekendWorkedThreeWeeksAgo = reader.ReadElementContentAsBoolean();
                continue;
            }
            if (name.equalsIgnoreCase("WeekendWorkedTwoWeeksAgo")) {
                employee.SchedulingHistory.WeekendWorkedTwoWeeksAgo = reader.ReadElementContentAsBoolean();
                continue;
            }
            if (name.equalsIgnoreCase("WeekendWorkedOneWeekAgo")) {
                employee.SchedulingHistory.WeekendWorkedOneWeekAgo = reader.ReadElementContentAsBoolean();
                continue;
            }
            if (name.equalsIgnoreCase("PreviousSaturdayWorked")) {
                employee.SchedulingHistory.PreviousSaturdayWorked = reader.ReadElementContentAsBoolean();
                continue;
            }
            if (name.equalsIgnoreCase("PreviousSundayWorked")) {
                employee.SchedulingHistory.PreviousSundayWorked = reader.ReadElementContentAsBoolean();
                continue;
            }
            if (name.equalsIgnoreCase("PreviousSaturdayRequestedHoliday")) {
                employee.SchedulingHistory.PreviousSaturdayRequestedHoliday = reader.ReadElementContentAsBoolean();
                continue;
            }
            if (name.equalsIgnoreCase("PreviousSundayRequestedHoliday")) {
                employee.SchedulingHistory.PreviousSundayRequestedHoliday = reader.ReadElementContentAsBoolean();
                continue;
            }
            if (name.equalsIgnoreCase("NightShiftThursday")) {
                employee.SchedulingHistory.NightShiftThursday = reader.ReadElementContentAsBoolean();
                continue;
            }
            if (name.equalsIgnoreCase("NightShiftFriday")) {
                employee.SchedulingHistory.NightShiftFriday = reader.ReadElementContentAsBoolean();
                continue;
            }
            if (name.equalsIgnoreCase("PreviousFridayWorked")) {
                employee.SchedulingHistory.PreviousFridayWorked = reader.ReadElementContentAsBoolean();
                continue;
            }
            if (name.equalsIgnoreCase("PreviousNightShift")) {
                employee.SchedulingHistory.PreviousNightShift = reader.ReadElementContentAsBoolean();
                continue;
            }
            if (name.equalsIgnoreCase("PreviousFreeDaysAfterNightShift")) {
                reader.ReadStartElement("PreviousFreeDaysAfterNightShift");
                employee.SchedulingHistory.PreviousFreeDaysAfterNightShift = Integer.parseInt(reader.ReadString());
                reader.ReadEndElement();
                continue;
            }
            if (name.equalsIgnoreCase("PreviousConsecutiveHolidayDaysOff")) {
                reader.ReadStartElement("PreviousConsecutiveHolidayDaysOff");
                employee.SchedulingHistory.PreviousConsecutiveHolidayDaysOff = Integer.parseInt(reader.ReadString());
                reader.ReadEndElement();
                continue;
            }
            if (name.equalsIgnoreCase("PreviousConsecutiveShifts")) {
                reader.ReadStartElement("PreviousConsecutiveShifts");
                while (!reader.Name.equalsIgnoreCase("PreviousConsecutiveShifts")) {
                    reader.ReadStartElement("PreviousConsecutiveShift");
                    reader.ReadStartElement("ShiftTypeID");
                    String shiftTypeID = reader.ReadString();
                    reader.ReadEndElement();
                    reader.ReadStartElement("Count");
                    int count = Integer.parseInt(reader.ReadString());
                    reader.ReadEndElement();
                    reader.ReadEndElement();
                    ShiftType2 = this.schedulingPeriod.GetShiftType(shiftTypeID);
                    if (ShiftType2 == null) {
                        System.out.println("Error :: ShiftType ID: '" + shiftTypeID + "' in scheduling history not defined.");
                    } else {
                        employee.SchedulingHistory.PreviousConsecutiveShifts[ShiftType2.Index] = count;
                    }
                    if (!this.VERBOSE) continue;
                    System.out.println("Previous '" + shiftTypeID + "' shifts = " + count);
                }
                reader.ReadEndElement();
                continue;
            }
            if (name.equalsIgnoreCase("PreviousConsecutiveShiftGroups")) {
                reader.ReadStartElement("PreviousConsecutiveShiftGroups");
                while (!reader.Name.equalsIgnoreCase("PreviousConsecutiveShiftGroups")) {
                    reader.ReadStartElement("PreviousConsecutiveShiftGroup");
                    reader.ReadStartElement("ShiftGroupID");
                    String shiftGroupID = reader.ReadString();
                    reader.ReadEndElement();
                    reader.ReadStartElement("Count");
                    int count = Integer.parseInt(reader.ReadString());
                    reader.ReadEndElement();
                    reader.ReadEndElement();
                    ShiftGroup ShiftGroup2 = this.schedulingPeriod.GetShiftGroup(shiftGroupID);
                    if (ShiftGroup2 == null) {
                        System.out.println("Error :: ShiftGroupID: '" + shiftGroupID + "' in scheduling history not defined.");
                    } else {
                        employee.SchedulingHistory.PreviousConsecutiveShiftGroups[ShiftGroup2.Index] = count;
                    }
                    if (!this.VERBOSE) continue;
                    System.out.println("Previous '" + shiftGroupID + "' shiftGroups = " + count);
                }
                reader.ReadEndElement();
                continue;
            }
            if (name.equalsIgnoreCase("DaysSinceShifts")) {
                reader.ReadStartElement("DaysSinceShifts");
                while (!reader.Name.equalsIgnoreCase("DaysSinceShifts")) {
                    reader.ReadStartElement("DaysSinceShift");
                    reader.ReadStartElement("ShiftTypeID");
                    String shiftTypeID = reader.ReadString();
                    reader.ReadEndElement();
                    reader.ReadStartElement("Count");
                    int count = Integer.parseInt(reader.ReadString());
                    reader.ReadEndElement();
                    reader.ReadEndElement();
                    ShiftType2 = this.schedulingPeriod.GetShiftType(shiftTypeID);
                    if (ShiftType2 == null) {
                        System.out.println("Error :: ShiftType ID: '" + shiftTypeID + "' in scheduling history not defined.");
                    } else {
                        employee.SchedulingHistory.DaysSinceShiftType[ShiftType2.Index] = count;
                    }
                    if (!this.VERBOSE) continue;
                    System.out.println("DaysSinceShift '" + shiftTypeID + "' shifts = " + count);
                }
                reader.ReadEndElement();
                continue;
            }
            if (name.equalsIgnoreCase("PreviousOvertime")) {
                reader.ReadStartElement("PreviousOvertime");
                employee.SchedulingHistory.PreviousOvertime = Double.parseDouble(reader.ReadString());
                reader.ReadEndElement();
                continue;
            }
            System.out.println("Warning: Unknown element: " + name);
            break;
        }
        reader.ReadEndElement();
        if (this.VERBOSE) {
            System.out.println("PreviousConsecutiveWorkingDays           : " + employee.SchedulingHistory.PreviousConsecutiveWorkingDays);
            System.out.println("PreviousConsecutiveWorkingDaysAndHoliday : " + employee.SchedulingHistory.PreviousConsecutiveWorkingDaysAndHoliday);
            System.out.println("PreviousConsecutiveFreeDays              : " + employee.SchedulingHistory.PreviousConsecutiveFreeDays);
            System.out.println("PreviousConsecutiveWorkingWeekends       : " + employee.SchedulingHistory.PreviousConsecutiveWorkingWeekends);
            System.out.println("PreviousWorkingBankHolidays              : " + employee.SchedulingHistory.PreviousWorkingBankHolidays);
            System.out.println("WeekendWorkedThreeWeeksAgo               : " + employee.SchedulingHistory.WeekendWorkedThreeWeeksAgo);
            System.out.println("WeekendWorkedTwoWeeksAgo                 : " + employee.SchedulingHistory.WeekendWorkedTwoWeeksAgo);
            System.out.println("WeekendWorkedOneWeekAgo                  : " + employee.SchedulingHistory.WeekendWorkedOneWeekAgo);
            System.out.println("PreviousSaturdayWorked                   : " + employee.SchedulingHistory.PreviousSaturdayWorked);
            System.out.println("PreviousSundayWorked                     : " + employee.SchedulingHistory.PreviousSundayWorked);
            System.out.println("PreviousSaturdayRequestedHoliday         : " + employee.SchedulingHistory.PreviousSaturdayRequestedHoliday);
            System.out.println("PreviousSundayRequestedHoliday           : " + employee.SchedulingHistory.PreviousSundayRequestedHoliday);
            System.out.println("NightShiftThursday                       : " + employee.SchedulingHistory.NightShiftThursday);
            System.out.println("NightShiftFriday                         : " + employee.SchedulingHistory.NightShiftFriday);
            System.out.println("PreviousFridayWorked                     : " + employee.SchedulingHistory.PreviousFridayWorked);
            System.out.println("PreviousNightShift                       : " + employee.SchedulingHistory.PreviousNightShift);
            System.out.println("PreviousFreeDaysAfterNightShift          : " + employee.SchedulingHistory.PreviousFreeDaysAfterNightShift);
            System.out.println("PreviousConsecutiveHolidayDaysOff        : " + employee.SchedulingHistory.PreviousConsecutiveHolidayDaysOff);
            System.out.println("PreviousOvertime                         : " + employee.SchedulingHistory.PreviousOvertime);
        }
    }

    private void ParseFrozenDays(XmlReader reader) {
        if (this.VERBOSE) {
            System.out.println("Parsing FrozenDays");
        }
        while (!reader.Name.equalsIgnoreCase("FrozenDays")) {
            this.ParseEmployeeFrozenDays(reader);
        }
        if (this.VERBOSE) {
            System.out.println("FrozenDays Parsed.");
            System.out.println("----------------------------------------------");
        }
    }

    private void ParseEmployeeFrozenDays(XmlReader reader) {
        if (this.VERBOSE) {
            System.out.println("Parsing EmployeeFrozenDays");
        }
        reader.ReadStartElement("EmployeeFrozenDays");
        reader.ReadStartElement("EmployeeID");
        String employeeID = reader.ReadString();
        reader.ReadEndElement();
        EmployeeDescription employee = this.schedulingPeriod.GetEmployeeDescription(employeeID);
        if (employee == null) {
            System.out.println("Error :: Employee ID: '" + employeeID + "' in EmployeeFrozenDays not defined in employees.");
        }
        while (!reader.Name.equalsIgnoreCase("EmployeeFrozenDays")) {
            reader.ReadStartElement("Date");
            String dateString = reader.ReadString();
            reader.ReadEndElement();
            if (employee == null) continue;
            DateTime date = DateTime.ParseDate(dateString);
            if (this.schedulingPeriod.IsDateWithinSchedulingPeriod(date)) {
                int day = this.schedulingPeriod.ConvertDateToRosterDay(date);
                employee.FrozenDay[day] = true;
                continue;
            }
            System.out.println("Unable to freeze day. Date : " + date + " out of scheduling range.");
        }
        reader.ReadEndElement();
    }

    private void ParsePreAssignments(XmlReader reader) {
        if (this.VERBOSE) {
            System.out.println("Parsing PreAssignments");
        }
        this.schedulingPeriod.ContainsInitialAssignments = true;
        while (!reader.Name.equalsIgnoreCase("PreAssignments")) {
            this.ParseEmployeePreAssignments(reader);
        }
        if (this.VERBOSE) {
            System.out.println("PreAssignments Parsed.");
            System.out.println("----------------------------------------------");
        }
    }

    private void ParseEmployeePreAssignments(XmlReader reader) {
        if (this.VERBOSE) {
            System.out.println("Parsing EmployeeAssignments");
        }
        reader.ReadStartElement("EmployeeAssignments");
        reader.ReadStartElement("EmployeeID");
        String employeeID = reader.ReadString();
        reader.ReadEndElement();
        EmployeeDescription employee = this.schedulingPeriod.GetEmployeeDescription(employeeID);
        if (employee == null) {
            System.out.println("Error :: Employee ID: '" + employeeID + "' in PreAssignments not defined in employees.");
        }
        reader.ReadStartElement("Assignments");
        while (!reader.Name.equalsIgnoreCase("Assignments")) {
            reader.ReadStartElement("Assignment");
            reader.ReadStartElement("ShiftTypeID");
            String shiftTypeID = reader.ReadString();
            ShiftType st = this.schedulingPeriod.GetShiftType(shiftTypeID);
            if (st == null) {
                System.out.println("Error :: ShiftType ID: '" + shiftTypeID + "' in PreAssignments not defined.");
            }
            reader.ReadEndElement();
            reader.ReadStartElement("Date");
            DateTime date = DateTime.ParseDate(reader.ReadString());
            reader.ReadEndElement();
            if (this.schedulingPeriod.IsDateWithinSchedulingPeriod(date)) {
                int day = this.schedulingPeriod.ConvertDateToRosterDay(date);
                if (employee != null && st != null) {
                    int index = day * this.schedulingPeriod.ShiftTypesCount + st.Index;
                    if (index >= 0 && index < employee.PreAssignments.length) {
                        employee.PreAssignments[index] = true;
                    } else {
                        System.out.println("Error :: Unable to set pre-assignment. Day=" + day + " ShiftTypeID=" + shiftTypeID + " (index out of range).");
                    }
                }
            } else {
                System.out.println("Unable to make pre-assignment. Date : " + date + " out of scheduling range.");
            }
            reader.ReadEndElement();
        }
        reader.ReadEndElement();
        reader.ReadEndElement();
    }

    private boolean AddContract(Contract contract) {
        String contractID = contract.ContractID;
        if (this.ContractsHash.containsKey(contractID)) {
            System.out.println("Unable to add Contract : " + contractID + " as contract with same ID already exists.");
            return false;
        }
        this.ContractsHash.put(contractID, contract);
        return true;
    }

    private Contract GetContract(String contractID) {
        return this.ContractsHash.get(contractID);
    }
}

