/*
 * Decompiled with CFR 0.152.
 */
package ASAP.NRP.Core.Tools;

import ASAP.NRP.Core.EmployeeDescription;
import ASAP.NRP.Core.Parsers.ParsedRoster;
import ASAP.NRP.Core.Parsers.ParsedShiftAssignment;
import ASAP.NRP.Core.Parsers.RosterParser;
import ASAP.NRP.Core.Parsers.SchedulingPeriodParser;
import ASAP.NRP.Core.Roster;
import ASAP.NRP.Core.SchedulingPeriod;
import ASAP.NRP.Core.ShiftType;
import java.io.InputStream;

public class RosterLoader {
    public boolean VERBOSE = true;

    public boolean CheckParsedRoster(ParsedRoster parsedRoster, SchedulingPeriod schedulingPeriod) {
        boolean error = false;
        if (schedulingPeriod == null) {
            System.out.println("Error: Null SchedulingPeriod.");
            return false;
        }
        for (ParsedShiftAssignment parsedShiftAssignment : parsedRoster.ParsedShiftAssignments) {
            ShiftType shiftType;
            EmployeeDescription employee = schedulingPeriod.GetEmployeeDescription(parsedShiftAssignment.EmployeeID);
            if (employee == null) {
                System.out.println("Error: Unable to find EmployeeID: " + parsedShiftAssignment.EmployeeID + " in SchedulingPeriod.");
                error = true;
            }
            if ((shiftType = schedulingPeriod.GetShiftType(parsedShiftAssignment.ShiftTypeID)) != null) continue;
            System.out.println("Error: Unable to find ShiftID: " + parsedShiftAssignment.ShiftTypeID + " in SchedulingPeriod.");
            error = true;
        }
        return !error;
    }

    public Roster CreateEmptyRoster(String schedulingPeriodFile) {
        SchedulingPeriod schedulingPeriod;
        Roster roster;
        block3: {
            roster = null;
            SchedulingPeriodParser spp = new SchedulingPeriodParser();
            spp.VERBOSE = this.VERBOSE;
            spp.ValidateFirst = true;
            schedulingPeriod = spp.Parse(schedulingPeriodFile);
            if (schedulingPeriod != null) break block3;
            System.out.println("Error : Problem parsing : " + schedulingPeriodFile);
            System.out.println("Unable to create roster.");
            return null;
        }
        try {
            roster = new Roster(schedulingPeriod);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return roster;
    }

    public Roster CreateEmptyRoster(InputStream is) {
        SchedulingPeriod schedulingPeriod;
        Roster roster;
        block3: {
            roster = null;
            SchedulingPeriodParser spp = new SchedulingPeriodParser();
            spp.VERBOSE = this.VERBOSE;
            spp.ValidateFirst = true;
            schedulingPeriod = spp.Parse(is);
            if (schedulingPeriod != null) break block3;
            System.out.println("Error : Problem parsing ");
            System.out.println("Unable to create roster.");
            return null;
        }
        try {
            roster = new Roster(schedulingPeriod);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return roster;
    }

    public ParsedRoster LoadRoster(InputStream is, String rosterFile) {
        SchedulingPeriod schedulingPeriod;
        ParsedRoster parsedRoster;
        block5: {
            block4: {
                parsedRoster = null;
                SchedulingPeriodParser spp = new SchedulingPeriodParser();
                spp.VERBOSE = this.VERBOSE;
                spp.ValidateFirst = true;
                schedulingPeriod = spp.Parse(is);
                if (schedulingPeriod != null) break block4;
                System.out.println("Unable to load roster.");
                return null;
            }
            RosterParser sp = new RosterParser();
            sp.VERBOSE = this.VERBOSE;
            sp.ValidateFirst = true;
            parsedRoster = sp.Parse(rosterFile);
            if (parsedRoster != null) break block5;
            System.out.println("Error: Problem parsing : " + rosterFile);
            System.out.println("Unable to load roster");
            return null;
        }
        try {
            parsedRoster.CreateRoster(schedulingPeriod);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return parsedRoster;
    }

    public ParsedRoster LoadRoster(String schedulingPeriodFile, String rosterFile) {
        SchedulingPeriod schedulingPeriod;
        ParsedRoster parsedRoster;
        block5: {
            block4: {
                parsedRoster = null;
                SchedulingPeriodParser spp = new SchedulingPeriodParser();
                spp.VERBOSE = this.VERBOSE;
                spp.ValidateFirst = true;
                schedulingPeriod = spp.Parse(schedulingPeriodFile);
                if (schedulingPeriod != null) break block4;
                System.out.println("Error: Problem parsing : " + schedulingPeriodFile);
                System.out.println("Unable to load roster.");
                return null;
            }
            RosterParser sp = new RosterParser();
            sp.VERBOSE = this.VERBOSE;
            sp.ValidateFirst = true;
            parsedRoster = sp.Parse(rosterFile);
            if (parsedRoster != null) break block5;
            System.out.println("Error: Problem parsing : " + rosterFile);
            System.out.println("Unable to load roster");
            return null;
        }
        try {
            parsedRoster.CreateRoster(schedulingPeriod);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return parsedRoster;
    }
}

