/*
 * Decompiled with CFR 0.152.
 */
package ASAP.NRP.Solvers.VariableDepthSearch;

import ASAP.NRP.Core.DateTime;
import ASAP.NRP.Core.Employee;
import ASAP.NRP.Core.Roster;
import ASAP.NRP.Core.Shift;
import ASAP.NRP.Solvers.VariableDepthSearch.TestShiftDB;
import java.util.Random;

public class Hrz1Emp1Swp_M {
    public boolean Stopped = true;
    public String Author = "T";
    public String Title = "Horiz_1E_1SwapMax ";
    public long TotalEvaluations = 0L;
    public int RandomSeed = 1;
    Random rand;
    boolean finished;
    DateTime FinishTime;
    TestShiftDB shiftsDB;
    int iterationCount = 0;
    int[] employeeLastChanged;
    int[] dayLastChanged;
    int lastImprovementEmployee1;
    int lastImprovementDay2;
    int lastImprovementDay;
    int lastImprovementBlockSize;
    public int[] BlockSizeMovesCount;
    public int cachePosition = 0;
    public boolean VERBOSE = true;
    public boolean SKIP_ZERO_PEN = false;
    public boolean CALCULATE_COVER_PENALTY = true;
    public int MAX_BLOCK_SIZE = 2;
    public boolean TIME_LIMIT = false;
    public double MAX_RUN_TIME = 10.0;
    public boolean[] TRY_BLOCK_SIZE;
    public int VIOLATION_HEURISTIC_THRESHOLD = 0;
    boolean cacheViolationPens = false;
    boolean randSet = false;

    public Hrz1Emp1Swp_M(TestShiftDB shiftsDB) {
        this.shiftsDB = shiftsDB;
        this.TRY_BLOCK_SIZE = new boolean[this.MAX_BLOCK_SIZE];
        int i = 0;
        while (i < this.TRY_BLOCK_SIZE.length) {
            this.TRY_BLOCK_SIZE[i] = true;
            ++i;
        }
    }

    public void setRNG(Random rand) {
        this.rand = rand;
        this.randSet = true;
    }

    public void Solve(Roster roster) {
        this.FinishTime = DateTime.getNow().AddSeconds(this.MAX_RUN_TIME);
        if (!this.randSet) {
            this.rand = new Random(this.RandomSeed);
        }
        this.ShuffleEmployees(roster);
        this.Search(roster);
        if (this.VERBOSE) {
            System.out.println("Search finished. Total moves tested=" + this.TotalEvaluations);
        }
    }

    private void Search(Roster roster) {
        int i;
        if (this.MAX_BLOCK_SIZE > roster.SchedulingPeriod.NumDaysInPeriod) {
            this.MAX_BLOCK_SIZE = roster.SchedulingPeriod.NumDaysInPeriod;
        }
        this.cacheViolationPens = this.VIOLATION_HEURISTIC_THRESHOLD > 0;
        int totalImprovingMoves = 0;
        int noImprovement = 0;
        boolean repeat = true;
        this.Stopped = false;
        this.finished = false;
        this.iterationCount = 0;
        this.employeeLastChanged = new int[roster.Employees.length];
        this.dayLastChanged = new int[roster.SchedulingPeriod.NumDaysInPeriod];
        this.lastImprovementEmployee1 = -1;
        this.lastImprovementDay2 = -1;
        this.lastImprovementDay = -1;
        this.lastImprovementBlockSize = -1;
        this.BlockSizeMovesCount = new int[this.MAX_BLOCK_SIZE];
        boolean DO_REPEAT = true;
        if (this.MAX_BLOCK_SIZE > this.TRY_BLOCK_SIZE.length) {
            boolean[] tempArr = new boolean[this.MAX_BLOCK_SIZE];
            i = 0;
            while (i < this.TRY_BLOCK_SIZE.length) {
                tempArr[i] = this.TRY_BLOCK_SIZE[i];
                ++i;
            }
            i = this.TRY_BLOCK_SIZE.length;
            while (i < this.MAX_BLOCK_SIZE) {
                tempArr[i] = true;
                ++i;
            }
            this.TRY_BLOCK_SIZE = tempArr;
        }
        int blockSizesToTry = 0;
        i = 0;
        while (i < this.TRY_BLOCK_SIZE.length) {
            if (this.TRY_BLOCK_SIZE[i]) {
                ++blockSizesToTry;
            }
            ++i;
        }
        while (blockSizesToTry > 0 && repeat) {
            int movesCount = 0;
            if (this.TIME_LIMIT && DateTime.getNow().isGreaterThan(this.FinishTime)) break;
            int i2 = 1;
            while (i2 <= this.MAX_BLOCK_SIZE) {
                ++this.iterationCount;
                if (this.TRY_BLOCK_SIZE[i2 - 1]) {
                    int j = 0;
                    while (j < roster.Employees.length) {
                        movesCount += this.SwapShiftsDepthOne(roster, roster.Employees[j], i2);
                        ++j;
                    }
                    totalImprovingMoves += movesCount;
                    if (this.VERBOSE) {
                        System.out.println("After SwapShiftsDepthOne (blockSize=" + i2 + ") (" + movesCount + " moves), roster.Penalty = " + roster.getTotalPenalty());
                    }
                    noImprovement = movesCount == 0 ? ++noImprovement : 0;
                    if (this.finished || noImprovement == blockSizesToTry) {
                        repeat = false;
                        break;
                    }
                }
                ++i2;
            }
            if (this.VERBOSE) {
                System.out.println("Total moves tested=" + this.TotalEvaluations + ", totalImprovingMoves=" + totalImprovingMoves);
            }
            if (!DO_REPEAT) break;
        }
        if (this.VERBOSE) {
            System.out.println("Swaps finished. Total moves tested=" + this.TotalEvaluations + ", totalImprovingMoves=" + totalImprovingMoves);
        }
        if (!this.CALCULATE_COVER_PENALTY) {
            roster.RecalculateAllPenalties();
        }
    }

    public void SearchSingleEmployee(Employee employee) {
        int i;
        Roster roster = employee.Roster;
        if (this.TIME_LIMIT) {
            this.FinishTime = DateTime.getNow().AddSeconds(this.MAX_RUN_TIME);
        }
        if (this.MAX_BLOCK_SIZE > roster.SchedulingPeriod.NumDaysInPeriod) {
            this.MAX_BLOCK_SIZE = roster.SchedulingPeriod.NumDaysInPeriod;
        }
        this.cacheViolationPens = this.VIOLATION_HEURISTIC_THRESHOLD > 0;
        int totalImprovingMoves = 0;
        int noImprovement = 0;
        boolean repeat = true;
        this.Stopped = false;
        this.finished = false;
        this.iterationCount = 0;
        this.employeeLastChanged = new int[roster.Employees.length];
        this.dayLastChanged = new int[roster.SchedulingPeriod.NumDaysInPeriod];
        this.lastImprovementEmployee1 = -1;
        this.lastImprovementDay2 = -1;
        this.lastImprovementDay = -1;
        this.lastImprovementBlockSize = -1;
        this.BlockSizeMovesCount = new int[this.MAX_BLOCK_SIZE];
        boolean DO_REPEAT = true;
        if (this.MAX_BLOCK_SIZE > this.TRY_BLOCK_SIZE.length) {
            boolean[] tempArr = new boolean[this.MAX_BLOCK_SIZE];
            i = 0;
            while (i < this.TRY_BLOCK_SIZE.length) {
                tempArr[i] = this.TRY_BLOCK_SIZE[i];
                ++i;
            }
            i = this.TRY_BLOCK_SIZE.length;
            while (i < this.MAX_BLOCK_SIZE) {
                tempArr[i] = true;
                ++i;
            }
            this.TRY_BLOCK_SIZE = tempArr;
        }
        int blockSizesToTry = 0;
        i = 0;
        while (i < this.TRY_BLOCK_SIZE.length) {
            if (this.TRY_BLOCK_SIZE[i]) {
                ++blockSizesToTry;
            }
            ++i;
        }
        while (blockSizesToTry > 0 && repeat) {
            int movesCount = 0;
            if (this.TIME_LIMIT && DateTime.getNow().isGreaterThan(this.FinishTime)) break;
            int i2 = 1;
            while (i2 <= this.MAX_BLOCK_SIZE) {
                ++this.iterationCount;
                if (this.TRY_BLOCK_SIZE[i2 - 1]) {
                    movesCount = this.SwapShiftsDepthOne(roster, employee, i2);
                    totalImprovingMoves += movesCount;
                    if (this.VERBOSE) {
                        System.out.println("After SwapShiftsDepthOne (blockSize=" + i2 + ") (" + movesCount + " moves), roster.Penalty = " + roster.getTotalPenalty());
                    }
                    noImprovement = movesCount == 0 ? ++noImprovement : 0;
                    if (this.finished || noImprovement == blockSizesToTry) {
                        repeat = false;
                        break;
                    }
                }
                ++i2;
            }
            if (this.VERBOSE) {
                System.out.println("Total moves tested=" + this.TotalEvaluations + ", totalImprovingMoves=" + totalImprovingMoves);
            }
            if (!DO_REPEAT) break;
        }
        if (this.VERBOSE) {
            System.out.println("Swaps finished. Total moves tested=" + this.TotalEvaluations + ", totalImprovingMoves=" + totalImprovingMoves);
        }
    }

    private int SwapShiftsDepthOne(Roster roster, Employee employee1, int blockSize) {
        int movesCount = 0;
        if (this.SKIP_ZERO_PEN && employee1.Penalty == 0) {
            return 0;
        }
        int day = 0;
        while (day < roster.SchedulingPeriod.NumDaysInPeriod - blockSize + 1) {
            block66: {
                block65: {
                    if (this.VERBOSE) {
                        System.out.println("H/1E/1S: Swap..D1: BlockSize=" + blockSize + " E1=" + employee1.EmployeeDescription.getName() + " Day=" + day + " Evals=" + this.TotalEvaluations + " Pen=" + roster.getTotalPenalty());
                    }
                    if (!this.shiftsDB.getEmployeeDescriptionHasFrozenDays()[employee1.EmployeeDescription.IndexID]) break block65;
                    boolean frozen = false;
                    int x = 0;
                    while (x < blockSize) {
                        if (employee1.EmployeeDescription.FrozenDay[day + x]) {
                            frozen = true;
                            break;
                        }
                        ++x;
                    }
                    if (frozen) break block66;
                }
                boolean moveMade = false;
                boolean employee1Violations = false;
                if (this.VIOLATION_HEURISTIC_THRESHOLD > 0) {
                    int x = 0;
                    while (x < blockSize) {
                        if (employee1.ConstraintViolationPenalties[day + x] >= this.VIOLATION_HEURISTIC_THRESHOLD) {
                            employee1Violations = true;
                        }
                        ++x;
                    }
                }
                int originalPenalty = roster.getTotalPenalty();
                Shift[] shifts1 = new Shift[blockSize];
                roster.CacheEmployeePenalties(this.cachePosition, this.cacheViolationPens);
                boolean fixedShift = false;
                boolean dayChanged = false;
                int x = 0;
                while (x < blockSize) {
                    shifts1[x] = employee1.GetShift(day + x);
                    if (shifts1[x] != null && shifts1[x].isFixed()) {
                        fixedShift = true;
                        break;
                    }
                    if (this.iterationCount - this.dayLastChanged[day + x] <= this.MAX_BLOCK_SIZE) {
                        dayChanged = true;
                    }
                    ++x;
                }
                if (fixedShift) break block66;
                x = 0;
                while (x < blockSize) {
                    roster.UnAssignShift(shifts1[x]);
                    ++x;
                }
                if (this.CALCULATE_COVER_PENALTY) {
                    roster.CoverPenalty += roster.UpdateCoverPens(shifts1);
                }
                int day2 = day + blockSize;
                while (day2 < roster.SchedulingPeriod.NumDaysInPeriod - blockSize + 1) {
                    block68: {
                        block69: {
                            int x2;
                            block67: {
                                if (!this.shiftsDB.getEmployeeDescriptionHasFrozenDays()[employee1.EmployeeDescription.IndexID]) break block67;
                                boolean frozen = false;
                                x2 = 0;
                                while (x2 < blockSize) {
                                    if (employee1.EmployeeDescription.FrozenDay[day2 + x2]) {
                                        frozen = true;
                                        break;
                                    }
                                    ++x2;
                                }
                                if (frozen) break block68;
                            }
                            if (this.VIOLATION_HEURISTIC_THRESHOLD <= 0 || employee1Violations) break block69;
                            boolean employee1Violations2 = false;
                            x2 = 0;
                            while (x2 < blockSize) {
                                if (employee1.ConstraintViolationPenalties[day2 + x2] >= this.VIOLATION_HEURISTIC_THRESHOLD) {
                                    employee1Violations2 = true;
                                }
                                ++x2;
                            }
                            if (!employee1Violations2) break block68;
                        }
                        Shift[] shifts2 = new Shift[blockSize];
                        fixedShift = false;
                        boolean day2Changed = false;
                        int x3 = 0;
                        while (x3 < blockSize) {
                            shifts2[x3] = employee1.GetShift(day2 + x3);
                            if (shifts2[x3] != null && shifts2[x3].isFixed()) {
                                fixedShift = true;
                                break;
                            }
                            if (this.iterationCount - this.dayLastChanged[day2 + x3] <= this.MAX_BLOCK_SIZE) {
                                day2Changed = true;
                            }
                            ++x3;
                        }
                        if (!(fixedShift || !dayChanged && !day2Changed && this.iterationCount - this.employeeLastChanged[employee1.Index] > this.MAX_BLOCK_SIZE || shifts1[0] == null && shifts2[0] == null || shifts1[blockSize - 1] == null && shifts2[blockSize - 1] == null)) {
                            boolean different = false;
                            int x4 = 0;
                            while (x4 < blockSize) {
                                if (shifts1[x4] != null && shifts2[x4] != null) {
                                    if (shifts1[x4].ShiftType != shifts2[x4].ShiftType) {
                                        different = true;
                                        break;
                                    }
                                } else if (shifts1[x4] != null || shifts2[x4] != null) {
                                    different = true;
                                    break;
                                }
                                ++x4;
                            }
                            if (different) {
                                x4 = 0;
                                while (x4 < blockSize) {
                                    roster.UnAssignShift(shifts2[x4]);
                                    ++x4;
                                }
                                if (this.CALCULATE_COVER_PENALTY) {
                                    roster.CoverPenalty += roster.UpdateCoverPens(shifts2);
                                }
                                boolean valid = true;
                                Shift[] shifts1Real = new Shift[blockSize];
                                Shift[] shifts2Real = new Shift[blockSize];
                                int x5 = 0;
                                while (x5 < blockSize) {
                                    Shift tShift1 = null;
                                    if (shifts2[x5] != null) {
                                        tShift1 = this.shiftsDB.GetTestShift(shifts2[x5].ShiftType.Index, day + x5);
                                    }
                                    shifts2Real[x5] = tShift1;
                                    if (tShift1 != null && employee1.ViolationsForAssigningShift(tShift1) == -1) {
                                        valid = false;
                                        break;
                                    }
                                    Shift tShift2 = null;
                                    if (shifts1[x5] != null) {
                                        tShift2 = this.shiftsDB.GetTestShift(shifts1[x5].ShiftType.Index, day2 + x5);
                                    }
                                    shifts1Real[x5] = tShift2;
                                    if (tShift2 != null && employee1.ViolationsForAssigningShift(tShift2) == -1) {
                                        valid = false;
                                        break;
                                    }
                                    ++x5;
                                }
                                if (valid) {
                                    roster.CacheEmployeePenalties(this.cachePosition + 1, this.cacheViolationPens);
                                    x5 = 0;
                                    while (x5 < blockSize) {
                                        roster.AssignShift(employee1, shifts1Real[x5]);
                                        roster.AssignShift(employee1, shifts2Real[x5]);
                                        ++x5;
                                    }
                                    Shift[] allShifts = new Shift[blockSize * 2];
                                    int x6 = 0;
                                    while (x6 < blockSize) {
                                        allShifts[x6] = shifts1Real[x6];
                                        allShifts[x6 + blockSize] = shifts2Real[x6];
                                        ++x6;
                                    }
                                    if (this.CALCULATE_COVER_PENALTY) {
                                        employee1.Roster.CoverPenalty += employee1.Roster.UpdateCoverPens(allShifts);
                                        employee1.RecalculatePenalty(originalPenalty);
                                    } else {
                                        employee1.RecalculatePenalty();
                                    }
                                    ++this.TotalEvaluations;
                                    moveMade = roster.getTotalPenalty() < originalPenalty;
                                    if (moveMade) {
                                        int n = blockSize - 1;
                                        this.BlockSizeMovesCount[n] = this.BlockSizeMovesCount[n] + 1;
                                        x6 = 0;
                                        while (x6 < blockSize) {
                                            roster.UnAssignShift(shifts1Real[x6]);
                                            roster.UnAssignShift(shifts2Real[x6]);
                                            if (shifts1Real[x6] != null) {
                                                roster.AssignShift(employee1, (Shift)shifts1Real[x6].Clone());
                                            }
                                            if (shifts2Real[x6] != null) {
                                                roster.AssignShift(employee1, (Shift)shifts2Real[x6].Clone());
                                            }
                                            if (shifts1Real[x6] != null && shifts2[x6] != null) {
                                                if (shifts1Real[x6].ShiftType != shifts2[x6].ShiftType) {
                                                    this.dayLastChanged[day2 + x6] = this.iterationCount;
                                                }
                                            } else if (shifts1Real[x6] != null || shifts2[x6] != null) {
                                                this.dayLastChanged[day2 + x6] = this.iterationCount;
                                            }
                                            if (shifts1[x6] != null && shifts2Real[x6] != null) {
                                                if (shifts1[x6].ShiftType != shifts2Real[x6].ShiftType) {
                                                    this.dayLastChanged[day + x6] = this.iterationCount;
                                                }
                                            } else if (shifts1[x6] != null || shifts2Real[x6] != null) {
                                                this.dayLastChanged[day + x6] = this.iterationCount;
                                            }
                                            ++x6;
                                        }
                                        this.employeeLastChanged[employee1.Index] = this.iterationCount;
                                        this.lastImprovementEmployee1 = employee1.Index;
                                        this.lastImprovementBlockSize = blockSize;
                                        this.lastImprovementDay = day;
                                        this.lastImprovementDay2 = day2;
                                        break;
                                    }
                                    x6 = 0;
                                    while (x6 < blockSize) {
                                        roster.UnAssignShift(shifts1Real[x6]);
                                        roster.UnAssignShift(shifts2Real[x6]);
                                        ++x6;
                                    }
                                    roster.RestoreEmployeePenalties(this.cachePosition + 1, this.cacheViolationPens);
                                    if (this.CALCULATE_COVER_PENALTY) {
                                        roster.CoverPenalty += roster.UpdateCoverPens(allShifts);
                                    }
                                }
                                x = 0;
                                while (x < blockSize) {
                                    roster.AssignShift(employee1, shifts2[x]);
                                    ++x;
                                }
                                if (this.CALCULATE_COVER_PENALTY) {
                                    roster.CoverPenalty += roster.UpdateCoverPens(shifts2);
                                }
                                if (this.lastImprovementDay == day && this.lastImprovementDay2 == day2 && this.lastImprovementEmployee1 == employee1.Index && this.lastImprovementBlockSize == blockSize) {
                                    this.finished = true;
                                    break;
                                }
                            }
                        }
                    }
                    ++day2;
                }
                if (moveMade) {
                    ++movesCount;
                } else {
                    x = 0;
                    while (x < blockSize) {
                        roster.AssignShift(employee1, shifts1[x]);
                        ++x;
                    }
                    roster.RestoreEmployeePenalties(this.cachePosition, this.cacheViolationPens);
                    if (this.CALCULATE_COVER_PENALTY) {
                        roster.CoverPenalty += roster.UpdateCoverPens(shifts1);
                    }
                }
                if (this.Stopped || this.finished || this.TIME_LIMIT && DateTime.getNow().isGreaterThan(this.FinishTime)) {
                    return movesCount;
                }
            }
            ++day;
        }
        return movesCount;
    }

    private void ShuffleEmployees(Roster roster) {
        int i = 0;
        while (i < roster.Employees.length * 3) {
            int index1 = this.rand.nextInt(roster.Employees.length);
            int index2 = this.rand.nextInt(roster.Employees.length);
            Employee temp = roster.Employees[index1];
            roster.Employees[index1] = roster.Employees[index2];
            roster.Employees[index2].Index = index1;
            roster.Employees[index2] = temp;
            temp.Index = index2;
            ++i;
        }
    }
}

