/*
 * Decompiled with CFR 0.152.
 */
package ASAP.NRP.Solvers.VariableDepthSearch;

import ASAP.NRP.Core.DateTime;
import ASAP.NRP.Core.Employee;
import ASAP.NRP.Core.Roster;
import ASAP.NRP.Core.Shift;
import ASAP.NRP.Solvers.VariableDepthSearch.TestShiftDB;
import java.util.Random;

public class New1Emp1Swp_M {
    public boolean Stopped = true;
    public String Author = "T";
    public String Title = "NewBlock_1E_1SwapMax ";
    public long TotalEvaluations = 0L;
    public int RandomSeed = 1;
    Random rand;
    boolean finished;
    TestShiftDB shiftsDB;
    DateTime FinishTime;
    int iterationCount = 0;
    int[] employeeLastChanged;
    int[] dayLastChanged;
    int lastImprovementEmployee1;
    int lastImprovementBlockSize;
    int lastImprovementDay;
    int lastImprovementShiftType;
    public int[] BlockSizeMovesCount;
    public int cachePosition = 0;
    public boolean VERBOSE = true;
    public boolean SKIP_ZERO_PENS = false;
    public boolean CALCULATE_COVER_PENALTY = true;
    public int MAX_BLOCK_SIZE = 2;
    public boolean TIME_LIMIT = false;
    public double MAX_RUN_TIME = 10.0;
    public boolean[] TRY_BLOCK_SIZE;
    public int VIOLATION_HEURISTIC_THRESHOLD = 0;
    boolean cacheViolationPens = false;
    boolean randSet = false;

    public New1Emp1Swp_M(TestShiftDB shiftsDB) {
        this.shiftsDB = shiftsDB;
        this.TRY_BLOCK_SIZE = new boolean[this.MAX_BLOCK_SIZE];
        int i = 0;
        while (i < this.TRY_BLOCK_SIZE.length) {
            this.TRY_BLOCK_SIZE[i] = true;
            ++i;
        }
    }

    public void setRNG(Random rand) {
        this.rand = rand;
        this.randSet = true;
    }

    public void Solve(Roster roster) {
        this.FinishTime = DateTime.getNow().AddSeconds(this.MAX_RUN_TIME);
        if (!this.randSet) {
            this.rand = new Random(this.RandomSeed);
        }
        this.ShuffleEmployees(roster);
        this.Search(roster);
        if (this.VERBOSE) {
            System.out.println("Search finished. Total moves tested=" + this.TotalEvaluations);
        }
    }

    private void Search(Roster roster) {
        int i;
        if (this.MAX_BLOCK_SIZE > roster.SchedulingPeriod.NumDaysInPeriod) {
            this.MAX_BLOCK_SIZE = roster.SchedulingPeriod.NumDaysInPeriod;
        }
        this.cacheViolationPens = this.VIOLATION_HEURISTIC_THRESHOLD > 0;
        int totalImprovingMoves = 0;
        int noImprovement = 0;
        boolean repeat = true;
        this.Stopped = false;
        this.finished = false;
        this.iterationCount = 0;
        this.employeeLastChanged = new int[roster.Employees.length];
        this.dayLastChanged = new int[roster.SchedulingPeriod.NumDaysInPeriod];
        this.lastImprovementEmployee1 = -1;
        this.lastImprovementBlockSize = -1;
        this.lastImprovementDay = -1;
        this.lastImprovementShiftType = -2;
        this.BlockSizeMovesCount = new int[this.MAX_BLOCK_SIZE];
        boolean DO_REPEAT = true;
        if (this.MAX_BLOCK_SIZE > this.TRY_BLOCK_SIZE.length) {
            boolean[] tempArr = new boolean[this.MAX_BLOCK_SIZE];
            i = 0;
            while (i < this.TRY_BLOCK_SIZE.length) {
                tempArr[i] = this.TRY_BLOCK_SIZE[i];
                ++i;
            }
            i = this.TRY_BLOCK_SIZE.length;
            while (i < this.MAX_BLOCK_SIZE) {
                tempArr[i] = true;
                ++i;
            }
            this.TRY_BLOCK_SIZE = tempArr;
        }
        int blockSizesToTry = 0;
        i = 0;
        while (i < this.TRY_BLOCK_SIZE.length) {
            if (this.TRY_BLOCK_SIZE[i]) {
                ++blockSizesToTry;
            }
            ++i;
        }
        while (blockSizesToTry > 0 && repeat) {
            int movesCount = 0;
            if (this.TIME_LIMIT && DateTime.getNow().isGreaterThan(this.FinishTime)) break;
            int i2 = 1;
            while (i2 <= this.MAX_BLOCK_SIZE) {
                ++this.iterationCount;
                if (this.TRY_BLOCK_SIZE[i2 - 1]) {
                    int j = 0;
                    while (j < roster.Employees.length) {
                        movesCount += this.SwapShiftsDepthOne(roster, roster.Employees[j], i2);
                        ++j;
                    }
                    totalImprovingMoves += movesCount;
                    if (this.VERBOSE) {
                        System.out.println("After SwapShiftsDepthOne (blockSize=" + i2 + ") (" + movesCount + " moves), roster.Penalty = " + roster.getTotalPenalty());
                    }
                    noImprovement = movesCount == 0 ? ++noImprovement : 0;
                    if (this.finished || noImprovement == blockSizesToTry) {
                        repeat = false;
                        break;
                    }
                }
                ++i2;
            }
            if (this.VERBOSE) {
                System.out.println("Total moves tested=" + this.TotalEvaluations + ", totalImprovingMoves=" + totalImprovingMoves);
            }
            if (!DO_REPEAT) break;
        }
        if (this.VERBOSE) {
            System.out.println("Swaps finished. Total moves tested=" + this.TotalEvaluations + ", totalImprovingMoves=" + totalImprovingMoves);
        }
        if (!this.CALCULATE_COVER_PENALTY) {
            roster.RecalculateAllPenalties();
        }
    }

    public void SearchSingleEmployee(Employee employee) {
        int i;
        Roster roster = employee.Roster;
        if (this.MAX_BLOCK_SIZE > roster.SchedulingPeriod.NumDaysInPeriod) {
            this.MAX_BLOCK_SIZE = roster.SchedulingPeriod.NumDaysInPeriod;
        }
        this.cacheViolationPens = this.VIOLATION_HEURISTIC_THRESHOLD > 0;
        int totalImprovingMoves = 0;
        int noImprovement = 0;
        boolean repeat = true;
        this.Stopped = false;
        this.finished = false;
        this.iterationCount = 0;
        this.employeeLastChanged = new int[roster.Employees.length];
        this.dayLastChanged = new int[roster.SchedulingPeriod.NumDaysInPeriod];
        this.lastImprovementEmployee1 = -1;
        this.lastImprovementBlockSize = -1;
        this.lastImprovementDay = -1;
        this.lastImprovementShiftType = -2;
        this.BlockSizeMovesCount = new int[this.MAX_BLOCK_SIZE];
        boolean DO_REPEAT = true;
        if (this.MAX_BLOCK_SIZE > this.TRY_BLOCK_SIZE.length) {
            boolean[] tempArr = new boolean[this.MAX_BLOCK_SIZE];
            i = 0;
            while (i < this.TRY_BLOCK_SIZE.length) {
                tempArr[i] = this.TRY_BLOCK_SIZE[i];
                ++i;
            }
            i = this.TRY_BLOCK_SIZE.length;
            while (i < this.MAX_BLOCK_SIZE) {
                tempArr[i] = true;
                ++i;
            }
            this.TRY_BLOCK_SIZE = tempArr;
        }
        int blockSizesToTry = 0;
        i = 0;
        while (i < this.TRY_BLOCK_SIZE.length) {
            if (this.TRY_BLOCK_SIZE[i]) {
                ++blockSizesToTry;
            }
            ++i;
        }
        while (blockSizesToTry > 0 && repeat) {
            int movesCount = 0;
            if (this.TIME_LIMIT && DateTime.getNow().isGreaterThan(this.FinishTime)) break;
            int i2 = 1;
            while (i2 <= this.MAX_BLOCK_SIZE) {
                ++this.iterationCount;
                if (this.TRY_BLOCK_SIZE[i2 - 1]) {
                    movesCount = this.SwapShiftsDepthOne(roster, employee, i2);
                    totalImprovingMoves += movesCount;
                    if (this.VERBOSE) {
                        System.out.println("After SwapShiftsDepthOne (blockSize=" + i2 + ") (" + movesCount + " moves), roster.Penalty = " + roster.getTotalPenalty());
                    }
                    noImprovement = movesCount == 0 ? ++noImprovement : 0;
                    if (this.finished || noImprovement == blockSizesToTry) {
                        repeat = false;
                        break;
                    }
                }
                ++i2;
            }
            if (this.VERBOSE) {
                System.out.println("Total moves tested=" + this.TotalEvaluations + ", totalImprovingMoves=" + totalImprovingMoves);
            }
            if (!DO_REPEAT) break;
        }
        if (this.VERBOSE) {
            System.out.println("Swaps finished. Total moves tested=" + this.TotalEvaluations + ", totalImprovingMoves=" + totalImprovingMoves);
        }
    }

    private int SwapShiftsDepthOne(Roster roster, Employee employee1, int blockSize) {
        int movesCount = 0;
        if (this.SKIP_ZERO_PENS && employee1.Penalty == 0) {
            return 0;
        }
        int day = 0;
        while (day < roster.SchedulingPeriod.NumDaysInPeriod - blockSize + 1) {
            block49: {
                Shift[] shifts1;
                int originalPenalty;
                boolean moveMade;
                block50: {
                    block48: {
                        if (!this.shiftsDB.getEmployeeDescriptionHasFrozenDays()[employee1.EmployeeDescription.IndexID]) break block48;
                        boolean frozen = false;
                        int x = 0;
                        while (x < blockSize) {
                            if (employee1.EmployeeDescription.FrozenDay[day + x]) {
                                frozen = true;
                                break;
                            }
                            ++x;
                        }
                        if (frozen) break block49;
                    }
                    if (this.VERBOSE) {
                        System.out.println("N/1E/1S: Swap..D1: BlockSize=" + blockSize + " E1=" + employee1.EmployeeDescription.getName() + " Day=" + day + " Evals=" + this.TotalEvaluations + " Pen=" + roster.getTotalPenalty());
                    }
                    moveMade = false;
                    originalPenalty = roster.getTotalPenalty();
                    shifts1 = new Shift[blockSize];
                    roster.CacheEmployeePenalties(this.cachePosition, this.cacheViolationPens);
                    if (this.VIOLATION_HEURISTIC_THRESHOLD <= 0) break block50;
                    boolean employee1Violations = false;
                    int x = 0;
                    while (x < blockSize) {
                        if (employee1.ConstraintViolationPenalties[day + x] >= this.VIOLATION_HEURISTIC_THRESHOLD) {
                            employee1Violations = true;
                        }
                        ++x;
                    }
                    if (!employee1Violations) break block49;
                }
                boolean dayChanged = false;
                boolean fixedShift = false;
                int x = 0;
                while (x < blockSize) {
                    shifts1[x] = employee1.GetShift(day + x);
                    if (shifts1[x] != null && shifts1[x].isFixed()) {
                        fixedShift = true;
                        break;
                    }
                    if (this.iterationCount - this.dayLastChanged[day + x] <= this.MAX_BLOCK_SIZE) {
                        dayChanged = true;
                    }
                    ++x;
                }
                if (!fixedShift && (dayChanged || this.iterationCount - this.employeeLastChanged[employee1.Index] <= this.MAX_BLOCK_SIZE)) {
                    x = 0;
                    while (x < blockSize) {
                        roster.UnAssignShift(shifts1[x]);
                        ++x;
                    }
                    if (this.CALCULATE_COVER_PENALTY) {
                        roster.CoverPenalty += roster.UpdateCoverPens(shifts1);
                    }
                    int k = -1;
                    while (k < roster.SchedulingPeriod.ShiftTypesCount) {
                        if (!this.shiftsDB.getSchedulingPeriodContainsNonAutoAssignShifts() || k < 0 || roster.SchedulingPeriod.GetShiftType((int)k).AutoAllocate) {
                            Shift[] shifts2 = new Shift[blockSize];
                            boolean different = false;
                            int x2 = 0;
                            while (x2 < blockSize) {
                                if (k < 0) {
                                    shifts2[x2] = null;
                                    if (shifts1[x2] != null) {
                                        different = true;
                                    }
                                } else {
                                    shifts2[x2] = this.shiftsDB.GetTestShift(k, day + x2);
                                    if (shifts1[x2] == null || shifts1[x2].ShiftType.Index != k) {
                                        different = true;
                                    }
                                }
                                ++x2;
                            }
                            if (!(!different || shifts1[0] == null && shifts2[0] == null || shifts1[blockSize - 1] == null && shifts2[blockSize - 1] == null)) {
                                boolean valid = true;
                                int x3 = 0;
                                while (x3 < blockSize) {
                                    if (employee1.ViolationsForAssigningShift(shifts2[x3]) == -1) {
                                        valid = false;
                                        break;
                                    }
                                    ++x3;
                                }
                                if (valid) {
                                    roster.CacheEmployeePenalties(this.cachePosition + 1, this.cacheViolationPens);
                                    x3 = 0;
                                    while (x3 < blockSize) {
                                        roster.AssignShift(employee1, shifts2[x3]);
                                        ++x3;
                                    }
                                    if (this.CALCULATE_COVER_PENALTY) {
                                        employee1.Roster.CoverPenalty += employee1.Roster.UpdateCoverPens(shifts2);
                                        employee1.RecalculatePenalty(originalPenalty, day, day + blockSize - 1, true);
                                    } else {
                                        employee1.RecalculatePenalty(day, day + blockSize - 1, true);
                                    }
                                    ++this.TotalEvaluations;
                                    if (roster.getTotalPenalty() < originalPenalty) {
                                        moveMade = true;
                                        ++movesCount;
                                        int n = blockSize - 1;
                                        this.BlockSizeMovesCount[n] = this.BlockSizeMovesCount[n] + 1;
                                        if (shifts2[0] != null) {
                                            x3 = 0;
                                            while (x3 < blockSize) {
                                                roster.UnAssignShift(shifts2[x3]);
                                                if (shifts2[x3] != null) {
                                                    roster.AssignShift(employee1, (Shift)shifts2[x3].Clone());
                                                }
                                                ++x3;
                                            }
                                        }
                                        if (this.cacheViolationPens && employee1.EmployeeDescription.Contract != null && employee1.EmployeeDescription.Contract.BadPatternsIsOn) {
                                            employee1.RecalculatePenalty();
                                        }
                                        this.employeeLastChanged[employee1.Index] = this.iterationCount;
                                        x3 = 0;
                                        while (x3 < blockSize) {
                                            if (shifts1[x3] != null && shifts2[x3] != null) {
                                                if (shifts1[x3].ShiftType != shifts2[x3].ShiftType) {
                                                    this.dayLastChanged[day + x3] = this.iterationCount;
                                                }
                                            } else if (shifts1[x3] != null || shifts2[x3] != null) {
                                                this.dayLastChanged[day + x3] = this.iterationCount;
                                            }
                                            ++x3;
                                        }
                                        this.lastImprovementEmployee1 = employee1.Index;
                                        this.lastImprovementBlockSize = blockSize;
                                        this.lastImprovementDay = day;
                                        this.lastImprovementShiftType = k;
                                        break;
                                    }
                                    x3 = 0;
                                    while (x3 < blockSize) {
                                        roster.UnAssignShift(shifts2[x3]);
                                        ++x3;
                                    }
                                    roster.RestoreEmployeePenalties(this.cachePosition + 1, this.cacheViolationPens);
                                    if (this.CALCULATE_COVER_PENALTY) {
                                        roster.CoverPenalty += roster.UpdateCoverPens(shifts2);
                                    }
                                }
                                if (this.lastImprovementDay == day && this.lastImprovementEmployee1 == employee1.Index && this.lastImprovementShiftType == k && this.lastImprovementBlockSize == blockSize) {
                                    this.finished = true;
                                    break;
                                }
                            }
                        }
                        ++k;
                    }
                    if (!moveMade) {
                        x = 0;
                        while (x < blockSize) {
                            roster.AssignShift(employee1, shifts1[x]);
                            ++x;
                        }
                        roster.RestoreEmployeePenalties(this.cachePosition, this.cacheViolationPens);
                        if (this.CALCULATE_COVER_PENALTY) {
                            roster.CoverPenalty += roster.UpdateCoverPens(shifts1);
                        }
                        if (employee1.EmployeeDescription.Contract != null && employee1.EmployeeDescription.Contract.BadPatternsIsOn && employee1.EmployeeDescription.BadPatternConstraint != null) {
                            employee1.EmployeeDescription.BadPatternConstraint.Calculate(employee1);
                        }
                    }
                    if (this.Stopped || this.finished || this.TIME_LIMIT && DateTime.getNow().isGreaterThan(this.FinishTime)) {
                        return movesCount;
                    }
                }
            }
            ++day;
        }
        return movesCount;
    }

    private void ShuffleEmployees(Roster roster) {
        int i = 0;
        while (i < roster.Employees.length * 3) {
            int index1 = this.rand.nextInt(roster.Employees.length);
            int index2 = this.rand.nextInt(roster.Employees.length);
            Employee temp = roster.Employees[index1];
            roster.Employees[index1] = roster.Employees[index2];
            roster.Employees[index2].Index = index1;
            roster.Employees[index2] = temp;
            temp.Index = index2;
            ++i;
        }
    }
}

