/*
 * Decompiled with CFR 0.152.
 */
package ASAP.NRP.Solvers.VariableDepthSearch;

import ASAP.NRP.Core.Employee;
import ASAP.NRP.Core.Roster;
import ASAP.NRP.Core.Shift;

public class SingleMoves {
    public static void VerticalSwap(Roster roster, int day, int blockSize, int employee1Index, int employee2Index) {
        boolean cacheViolationPens = true;
        if (employee1Index == employee2Index) {
            return;
        }
        Employee employee1 = roster.Employees[employee1Index];
        while (day + blockSize >= roster.SchedulingPeriod.NumDaysInPeriod) {
            --blockSize;
        }
        if (blockSize <= 0) {
            return;
        }
        Shift[] shifts1 = new Shift[blockSize];
        roster.CacheEmployeePenalties(0, cacheViolationPens);
        int x = 0;
        while (x < blockSize) {
            shifts1[x] = employee1.GetShift(day + x);
            roster.UnAssignShift(shifts1[x]);
            ++x;
        }
        roster.CoverPenalty += roster.UpdateCoverPens(shifts1);
        Employee employee2 = roster.Employees[employee2Index];
        Shift[] shifts2 = new Shift[blockSize];
        int x2 = 0;
        while (x2 < blockSize) {
            shifts2[x2] = employee2.GetShift(day + x2);
            ++x2;
        }
        x2 = 0;
        while (x2 < blockSize) {
            roster.UnAssignShift(shifts2[x2]);
            ++x2;
        }
        roster.CoverPenalty += roster.UpdateCoverPens(shifts2);
        boolean valid = true;
        int x3 = 0;
        while (x3 < blockSize) {
            if (employee2.ViolationsForAssigningShift(shifts1[x3]) == -1 || employee1.ViolationsForAssigningShift(shifts2[x3]) == -1) {
                valid = false;
                break;
            }
            ++x3;
        }
        if (valid) {
            roster.CacheEmployeePenalties(1, cacheViolationPens);
            x3 = 0;
            while (x3 < blockSize) {
                roster.AssignShift(employee2, shifts1[x3]);
                roster.AssignShift(employee1, shifts2[x3]);
                ++x3;
            }
            employee1.Roster.CoverPenalty += employee1.Roster.UpdateCoverPens(shifts2);
            employee2.Roster.CoverPenalty += employee2.Roster.UpdateCoverPens(shifts1);
            employee1.RecalculatePenalty();
            employee2.RecalculatePenalty();
        } else {
            x3 = 0;
            while (x3 < blockSize) {
                roster.UnAssignShift(shifts1[x3]);
                ++x3;
            }
            roster.CoverPenalty += roster.UpdateCoverPens(shifts1);
            x3 = 0;
            while (x3 < blockSize) {
                roster.AssignShift(employee2, shifts2[x3]);
                ++x3;
            }
            roster.CoverPenalty += roster.UpdateCoverPens(shifts2);
            if (employee2.EmployeeDescription.Contract != null && employee2.EmployeeDescription.Contract.BadPatternsIsOn && employee2.EmployeeDescription.BadPatternConstraint != null) {
                employee2.EmployeeDescription.BadPatternConstraint.Calculate(employee2);
            }
            x3 = 0;
            while (x3 < blockSize) {
                roster.AssignShift(employee1, shifts1[x3]);
                ++x3;
            }
            roster.CoverPenalty += roster.UpdateCoverPens(shifts1);
            roster.RestoreEmployeePenalties(0, cacheViolationPens);
            if (employee1.EmployeeDescription.Contract != null && employee1.EmployeeDescription.Contract.BadPatternsIsOn && employee1.EmployeeDescription.BadPatternConstraint != null) {
                employee1.EmployeeDescription.BadPatternConstraint.Calculate(employee1);
            }
        }
    }
}

