/*
 * Decompiled with CFR 0.152.
 */
package BinPacking;

import AbstractClasses.ProblemDomain;
import BinPacking.Bin;
import BinPacking.Piece;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Vector;

public class BinPacking
extends ProblemDomain {
    private static final boolean HIGHEST_FIRST = true;
    private static final boolean LOWEST_FIRST = false;
    private static int defaultmemorysize = 2;
    private final int[] mutations;
    private final int[] ruinRecreates;
    private final int[] localSearches;
    private final int[] crossovers;
    private Solution[] solutionMemory;
    private Vector<Bin> bestEverSolution;
    private double bestEverObjectiveFunction;
    private double bestEverNumberOfBins;
    private double capacity;
    private double totalpiecesize;
    private int numberOfPieces;
    private Piece[] pieces;
    private int lrepeats;
    private int mrepeats;

    public BinPacking(long seed) {
        super(seed);
        int[] nArray = new int[3];
        nArray[1] = 3;
        nArray[2] = 5;
        this.mutations = nArray;
        this.ruinRecreates = new int[]{1, 2};
        this.localSearches = new int[]{4, 6};
        this.crossovers = new int[]{7};
        this.bestEverObjectiveFunction = Double.POSITIVE_INFINITY;
        this.bestEverNumberOfBins = Double.POSITIVE_INFINITY;
    }

    @Override
    public void setDepthOfSearch(double depthOfSearch) {
        super.setDepthOfSearch(depthOfSearch);
        this.lrepeats = depthOfSearch <= 0.2 ? 10 : (depthOfSearch <= 0.4 ? 12 : (depthOfSearch <= 0.6 ? 14 : (depthOfSearch <= 0.8 ? 17 : 20)));
    }

    @Override
    public void setIntensityOfMutation(double intensityOfMutation) {
        super.setIntensityOfMutation(intensityOfMutation);
        this.mrepeats = intensityOfMutation <= 0.2 ? 1 : (intensityOfMutation <= 0.4 ? 2 : (intensityOfMutation <= 0.6 ? 3 : (intensityOfMutation <= 0.8 ? 4 : 5)));
    }

    @Override
    public int[] getHeuristicsThatUseDepthOfSearch() {
        return this.localSearches;
    }

    @Override
    public int[] getHeuristicsThatUseIntensityOfMutation() {
        int[] newint = new int[this.mutations.length + this.ruinRecreates.length];
        int count = 0;
        int x = 0;
        while (x < this.mutations.length) {
            newint[count] = this.mutations[x];
            ++count;
            ++x;
        }
        x = 0;
        while (x < this.ruinRecreates.length) {
            newint[count] = this.ruinRecreates[x];
            ++count;
            ++x;
        }
        return newint;
    }

    private void loadInstance(String filename) {
        try {
            FileReader read = new FileReader(filename);
            BufferedReader buffread = new BufferedReader(read);
            this.readInInstance(buffread);
        }
        catch (FileNotFoundException a) {
            try {
                InputStream fis = this.getClass().getClassLoader().getResourceAsStream(filename);
                BufferedReader buffread = new BufferedReader(new InputStreamReader(fis));
                this.readInInstance(buffread);
            }
            catch (NullPointerException n) {
                System.err.println("cannot find file " + filename);
                System.exit(-1);
            }
        }
    }

    private void readInInstance(BufferedReader buffread) {
        try {
            buffread.readLine();
            buffread.readLine();
            String l = buffread.readLine();
            this.capacity = Double.parseDouble(l.split(" ")[1]) * 10.0;
            this.numberOfPieces = Integer.parseInt(l.split(" ")[2]);
            this.pieces = new Piece[this.numberOfPieces];
            int piece = 0;
            while (piece < this.numberOfPieces) {
                double piecesize = Double.parseDouble(buffread.readLine()) * 10.0;
                this.totalpiecesize += piecesize;
                this.pieces[piece] = new Piece(piecesize, piece);
                ++piece;
            }
        }
        catch (IOException a) {
            System.err.println(a.getMessage());
            System.exit(0);
        }
    }

    @Override
    public void loadInstance(int instanceID) {
        String ins = "instance doesn't exist: " + instanceID;
        if (instanceID < 2) {
            ins = "data/binpacking/falkenauer/falk1000-" + (instanceID + 1) + ".txt";
        } else if (instanceID < 4) {
            ins = "data/binpacking/schoenfield/schoenfieldhard" + (instanceID - 1) + ".txt";
        } else if (instanceID < 5) {
            ins = "data/binpacking/2000/10-30/instance1.txt";
        } else if (instanceID < 6) {
            ins = "data/binpacking/2000/10-30/instance2.txt";
        } else if (instanceID < 7) {
            ins = "data/binpacking/trip1002/instance1.txt";
        } else if (instanceID < 8) {
            ins = "data/binpacking/trip2004/instance1.txt";
        } else if (instanceID < 9) {
            ins = "data/binpacking/testdual4/binpack0.txt";
        } else if (instanceID < 10) {
            ins = "data/binpacking/testdual7/binpack0.txt";
        } else if (instanceID < 11) {
            ins = "data/binpacking/2000/50-90/instance1.txt";
        } else if (instanceID < 12) {
            ins = "data/binpacking/testdual10/binpack0.txt";
        } else {
            System.err.println("instance " + ins + "does not exist");
            System.exit(-1);
        }
        this.loadInstance(ins);
        this.solutionMemory = new Solution[defaultmemorysize];
    }

    @Override
    public void initialiseSolution(int index) {
        this.solutionMemory[index] = new Solution();
        this.solutionMemory[index].addBin(new Bin());
        LinkedList<Piece> piecerandomiser = new LinkedList<Piece>();
        int piece = 0;
        while (piece < this.numberOfPieces) {
            piecerandomiser.add(this.pieces[piece]);
            ++piece;
        }
        Collections.shuffle(piecerandomiser, this.rng);
        piece = 0;
        while (piece < this.numberOfPieces) {
            this.pieces[piece] = (Piece)piecerandomiser.removeLast();
            ++piece;
        }
        int i = 0;
        while (i < this.numberOfPieces) {
            Piece currentPiece = this.pieces[i];
            int numberOfBins = this.solutionMemory[index].size();
            int binNumber = 0;
            while (binNumber < numberOfBins) {
                Bin bin = this.solutionMemory[index].get(binNumber);
                if (currentPiece.getSize() <= this.capacity - bin.getFullness()) {
                    bin.addPiece(currentPiece);
                    this.solutionMemory[index].set(binNumber, bin);
                    if (binNumber != numberOfBins - 1) break;
                    this.solutionMemory[index].addBin(new Bin());
                    break;
                }
                ++binNumber;
            }
            ++i;
        }
        this.sortbins(this.solutionMemory[index].solution, true);
        double i2 = this.getFunctionValue(index);
        if (i2 < this.bestEverObjectiveFunction) {
            this.bestEverObjectiveFunction = i2;
        }
    }

    private double evaluateObjectiveFunction(Vector<Bin> bins) {
        double objectiveFunctionValue = 0.0;
        double utilisation = 0.0;
        double binsused = 0.0;
        int u = 0;
        while (u < bins.size()) {
            Bin bin = bins.get(u);
            if (bin.getFullness() != 0.0) {
                utilisation += Math.pow(bin.getFullness() / this.capacity, 2.0);
                binsused += 1.0;
            }
            ++u;
        }
        objectiveFunctionValue = 1.0 - utilisation / binsused;
        return objectiveFunctionValue;
    }

    private void applyBestFit(Bin[] array, Vector<Bin> v) {
        Vector<Piece> pieceVector = new Vector<Piece>();
        int pieces = 0;
        int i = 0;
        while (i < array.length) {
            Bin b = array[i];
            int binpieces = b.numberOfPiecesInThisBin();
            int x = 0;
            while (x < binpieces) {
                pieceVector.add(b.removePiece(0));
                ++pieces;
                ++x;
            }
            ++i;
        }
        Collections.sort(pieceVector);
        int y = 0;
        while (y < pieces) {
            Piece currentPiece = (Piece)pieceVector.remove(0);
            int numberOfBins = v.size();
            double bestgapsofar = Double.POSITIVE_INFINITY;
            int bestbinsofar = -1;
            int binNumber = 0;
            while (binNumber < numberOfBins) {
                Bin bin = v.get(binNumber);
                double gap = this.capacity - currentPiece.getSize() - bin.getFullness();
                if (gap < bestgapsofar && gap >= 0.0) {
                    bestgapsofar = gap;
                    bestbinsofar = binNumber;
                }
                ++binNumber;
            }
            Bin bin = v.get(bestbinsofar);
            bin.addPiece(currentPiece);
            if (bestbinsofar == numberOfBins - 1) {
                v.add(new Bin());
            }
            ++y;
        }
    }

    private void applyHeuristic0(Vector<Bin> temporaryBinVector) {
        int r = 0;
        while (r < this.mrepeats) {
            int numberofbins;
            Piece piece1 = this.pieces[this.rng.nextInt(this.numberOfPieces)];
            Piece piece2 = this.pieces[this.rng.nextInt(this.numberOfPieces)];
            while (piece1.getSize() == piece2.getSize()) {
                piece2 = this.pieces[this.rng.nextInt(this.numberOfPieces)];
            }
            int bin1index = -1;
            int bin2index = -1;
            int x = 0;
            while (x < temporaryBinVector.size()) {
                Bin currentbin = temporaryBinVector.get(x);
                if (currentbin.contains(piece1) != -1) {
                    bin1index = x;
                }
                if (currentbin.contains(piece2) != -1) {
                    bin2index = x;
                }
                if (bin1index != -1 && bin2index != -1) break;
                ++x;
            }
            Bin bin1 = temporaryBinVector.get(bin1index);
            Bin bin2 = temporaryBinVector.get(bin2index);
            bin2.removePiece(piece2);
            if (bin2.getFullness() + piece1.getSize() <= this.capacity) {
                bin2.addPiece(piece1);
            } else {
                numberofbins = temporaryBinVector.size();
                bin2 = temporaryBinVector.get(numberofbins - 1);
                bin2.addPiece(piece1);
                temporaryBinVector.add(new Bin());
            }
            bin1.removePiece(piece1);
            if (bin1.getFullness() + piece2.getSize() <= this.capacity) {
                bin1.addPiece(piece2);
            } else {
                numberofbins = temporaryBinVector.size();
                bin1 = temporaryBinVector.get(numberofbins - 1);
                bin1.addPiece(piece2);
                temporaryBinVector.add(new Bin());
            }
            this.sortbins(temporaryBinVector, true);
            ++r;
        }
    }

    private void ruinAndRecreate(int numberOfBinsToRemove, Vector<Bin> temporaryBinVector, boolean highestOrLowest) {
        Bin[] tempBinArray = new Bin[numberOfBinsToRemove];
        if (!highestOrLowest) {
            this.sortbins(temporaryBinVector, false);
        }
        int x = 0;
        while (x < numberOfBinsToRemove) {
            tempBinArray[x] = temporaryBinVector.remove(0);
            ++x;
        }
        if (!highestOrLowest) {
            this.sortbins(temporaryBinVector, true);
        }
        this.applyBestFit(tempBinArray, temporaryBinVector);
    }

    private void applyHeuristic1(Vector<Bin> temporaryBinVector) {
        if (this.intensityOfMutation <= 0.2) {
            this.ruinAndRecreate(3, temporaryBinVector, true);
        } else if (this.intensityOfMutation <= 0.4) {
            this.ruinAndRecreate(6, temporaryBinVector, true);
        } else if (this.intensityOfMutation <= 0.6) {
            this.ruinAndRecreate(9, temporaryBinVector, true);
        } else if (this.intensityOfMutation <= 0.8) {
            this.ruinAndRecreate(12, temporaryBinVector, true);
        } else {
            this.ruinAndRecreate(15, temporaryBinVector, true);
        }
    }

    private void applyHeuristic2(Vector<Bin> temporaryBinVector) {
        if (this.intensityOfMutation <= 0.2) {
            this.ruinAndRecreate(3, temporaryBinVector, false);
        } else if (this.intensityOfMutation <= 0.4) {
            this.ruinAndRecreate(6, temporaryBinVector, false);
        } else if (this.intensityOfMutation <= 0.6) {
            this.ruinAndRecreate(9, temporaryBinVector, false);
        } else if (this.intensityOfMutation <= 0.8) {
            this.ruinAndRecreate(12, temporaryBinVector, false);
        } else {
            this.ruinAndRecreate(15, temporaryBinVector, false);
        }
    }

    private void applyHeuristic3(Vector<Bin> temporaryBinVector) {
        int r = 0;
        while (r < this.mrepeats) {
            this.ruinAndRecreate(1, temporaryBinVector, false);
            this.sortbins(temporaryBinVector, true);
            ++r;
        }
    }

    private void applyHeuristic4(Vector<Bin> temporaryBinVector) {
        int r = 0;
        while (r < this.lrepeats) {
            this.sortbins(temporaryBinVector, false);
            Bin lowestbin = temporaryBinVector.get(0);
            double largestpieceinthisbin = 0.0;
            int largestpieceindex = -1;
            int x = 0;
            while (x < lowestbin.numberOfPiecesInThisBin()) {
                if (lowestbin.getPieceSize(x) > largestpieceinthisbin) {
                    largestpieceinthisbin = lowestbin.getPieceSize(x);
                    largestpieceindex = x;
                }
                ++x;
            }
            Piece p1 = lowestbin.removePiece(largestpieceindex);
            int bin2 = -1;
            boolean continuelooping = true;
            while (continuelooping) {
                bin2 = this.rng.nextInt(temporaryBinVector.size());
                if (bin2 != 0) break;
            }
            Bin randomBin = temporaryBinVector.get(bin2);
            double largestsmallerpiece = 0.0;
            int largestsmallerpieceindex = -1;
            int x2 = 0;
            while (x2 < randomBin.numberOfPiecesInThisBin()) {
                double piecesize = randomBin.getPieceSize(x2);
                if (piecesize < largestpieceinthisbin && randomBin.getFullness() - piecesize + largestpieceinthisbin <= this.capacity && piecesize > largestsmallerpiece) {
                    largestsmallerpiece = piecesize;
                    largestsmallerpieceindex = x2;
                }
                ++x2;
            }
            if (largestsmallerpieceindex != -1) {
                Piece p2 = randomBin.removePiece(largestsmallerpieceindex);
                lowestbin.addPiece(p2);
                randomBin.addPiece(p1);
            } else {
                int piece1index = -1;
                int piece2index = -1;
                int x3 = 0;
                while (x3 < randomBin.numberOfPiecesInThisBin()) {
                    double piece1size = randomBin.getPieceSize(x3);
                    int y = 0;
                    while (y < randomBin.numberOfPiecesInThisBin()) {
                        double piece2size = randomBin.getPieceSize(y);
                        if (y != x3 && piece1size + piece2size < largestpieceinthisbin && randomBin.getFullness() - piece1size - piece2size + largestpieceinthisbin <= this.capacity) {
                            piece1index = x3;
                            piece2index = y;
                        }
                        ++y;
                    }
                    ++x3;
                }
                if (piece1index != -1) {
                    Piece[] tworemovedpieces = randomBin.removeTwoPieces(piece1index, piece2index);
                    randomBin.addPiece(p1);
                    lowestbin.addPiece(tworemovedpieces[0]);
                    lowestbin.addPiece(tworemovedpieces[1]);
                } else {
                    lowestbin.addPiece(p1);
                }
            }
            ++r;
        }
    }

    private void applyHeuristic5(Vector<Bin> temporaryBinVector) {
        int r = 0;
        while (r < this.mrepeats) {
            double averagenumberofpieces = 0.0;
            int x = 0;
            while (x < temporaryBinVector.size() - 1) {
                averagenumberofpieces += (double)temporaryBinVector.get(x).numberOfPiecesInThisBin();
                ++x;
            }
            if ((averagenumberofpieces /= (double)(temporaryBinVector.size() - 1)) != 1.0) {
                Vector<Integer> v = new Vector<Integer>();
                int x2 = 0;
                while (x2 < temporaryBinVector.size() - 1) {
                    int numberofpiecesinthisbin = temporaryBinVector.get(x2).numberOfPiecesInThisBin();
                    if ((double)numberofpiecesinthisbin >= averagenumberofpieces) {
                        v.add(new Integer(x2));
                    }
                    ++x2;
                }
                double[] emptinesses = new double[v.size()];
                double totalemptiness = 0.0;
                int x3 = 0;
                while (x3 < v.size()) {
                    emptinesses[x3] = totalemptiness += this.capacity - temporaryBinVector.get((Integer)v.get(x3)).getFullness();
                    ++x3;
                }
                double roulettenumber = this.rng.nextDouble() * totalemptiness;
                int x4 = 0;
                while (x4 < emptinesses.length) {
                    if (roulettenumber <= emptinesses[x4]) {
                        Bin binToHalf = temporaryBinVector.get((Integer)v.get(x4));
                        int numberofpiecesinthisbin = binToHalf.numberOfPiecesInThisBin();
                        int numberofpiecestotakeout = (int)Math.floor((double)numberofpiecesinthisbin / 2.0);
                        Bin emptybin = new Bin();
                        int y = 0;
                        while (y < numberofpiecestotakeout) {
                            emptybin.addPiece(binToHalf.removePiece(this.rng.nextInt(numberofpiecesinthisbin - y)));
                            ++y;
                        }
                        temporaryBinVector.add(emptybin);
                        break;
                    }
                    ++x4;
                }
                this.sortbins(temporaryBinVector, true);
            }
            ++r;
        }
    }

    private void applyHeuristic6(Vector<Bin> temporaryBinVector) {
        int r = 0;
        while (r < this.lrepeats) {
            Piece piece1 = this.pieces[this.rng.nextInt(this.numberOfPieces)];
            Piece piece2 = this.pieces[this.rng.nextInt(this.numberOfPieces)];
            while (piece1.getSize() == piece2.getSize()) {
                piece2 = this.pieces[this.rng.nextInt(this.numberOfPieces)];
            }
            int bin1index = -1;
            int bin2index = -1;
            int x = 0;
            while (x < temporaryBinVector.size()) {
                Bin currentbin = temporaryBinVector.get(x);
                if (currentbin.contains(piece1) != -1) {
                    bin1index = x;
                }
                if (currentbin.contains(piece2) != -1) {
                    bin2index = x;
                }
                if (bin1index != -1 && bin2index != -1) break;
                ++x;
            }
            Bin bin1 = temporaryBinVector.get(bin1index);
            Bin bin2 = temporaryBinVector.get(bin2index);
            boolean possible = true;
            boolean beneficial = false;
            if (bin1.getFullness() - piece1.getSize() + piece2.getSize() > this.capacity) {
                possible = false;
            }
            if (bin2.getFullness() - piece2.getSize() + piece1.getSize() > this.capacity) {
                possible = false;
            }
            if (possible) {
                if (bin1.getFullness() > bin2.getFullness()) {
                    if (piece1.getSize() < piece2.getSize()) {
                        beneficial = true;
                    }
                } else if (bin2.getFullness() > bin1.getFullness()) {
                    if (piece2.getSize() < piece1.getSize()) {
                        beneficial = true;
                    }
                } else {
                    beneficial = true;
                }
            }
            if (beneficial) {
                bin2.removePiece(piece2);
                bin1.removePiece(piece1);
                bin2.addPiece(piece1);
                bin1.addPiece(piece2);
            }
            this.sortbins(temporaryBinVector, true);
            ++r;
        }
    }

    private void applyHeuristic7(Vector<Bin> temporaryBinVector1, Vector<Bin> temporaryBinVector2) {
        Vector<Bin> binlist = new Vector<Bin>();
        binlist.addAll(temporaryBinVector1);
        binlist.addAll(temporaryBinVector2);
        Collections.sort(binlist);
        binlist.remove(binlist.size() - 1);
        temporaryBinVector1.removeAllElements();
        Vector<Integer> numberspacked = new Vector<Integer>();
        ListIterator i = binlist.listIterator();
        while (i.hasNext()) {
            Bin b = (Bin)i.next();
            boolean newbin = true;
            ListIterator np = numberspacked.listIterator();
            while (np.hasNext()) {
                int p = (Integer)np.next();
                if (!b.contains(p)) continue;
                newbin = false;
                break;
            }
            if (!newbin) continue;
            temporaryBinVector1.add(b);
            b.copypiecenumbers(numberspacked);
            i.remove();
        }
        ListIterator np1 = binlist.listIterator();
        while (np1.hasNext()) {
            Bin b = (Bin)np1.next();
            ListIterator<Piece> piecesinbin = b.piecesInThisBin.listIterator();
            while (piecesinbin.hasNext()) {
                Piece p = piecesinbin.next();
                if (numberspacked.contains(new Integer((int)p.getNumber()))) {
                    piecesinbin.remove();
                    continue;
                }
                numberspacked.add(new Integer((int)p.getNumber()));
            }
            if (b.numberOfPiecesInThisBin() != 0) continue;
            np1.remove();
        }
        Bin[] array = new Bin[binlist.size()];
        this.applyBestFit(binlist.toArray(array), temporaryBinVector1);
        this.sanitycheck(temporaryBinVector1);
    }

    private Vector<Bin> deepCopyBins(Vector<Bin> vectorToCopy) {
        Vector<Bin> copy = new Vector<Bin>();
        int x = 0;
        while (x < vectorToCopy.size()) {
            Bin b = vectorToCopy.get(x).clone();
            copy.add(b.clone());
            ++x;
        }
        return copy;
    }

    private void sortbins(Vector<Bin> bins, boolean highestOrLowest) {
        Collections.sort(bins);
        Bin endbin = bins.get(bins.size() - 1);
        Bin endbin2 = bins.get(bins.size() - 2);
        if (endbin.getFullness() != 0.0) {
            System.err.println("The last bin is not empty, so there are no empty bins");
            System.exit(0);
        } else if (endbin2.getFullness() == 0.0) {
            System.err.println("Error solution: \n");
            this.printtempbins(bins);
            System.err.println("There is more than one empty bin");
            System.exit(0);
        }
        if (!highestOrLowest) {
            int countleft = 0;
            int countright = bins.size() - 2;
            int x = 0;
            while (x < bins.size()) {
                Bin temp = bins.remove(countleft);
                bins.add(countleft, bins.remove(countright - 1));
                bins.add(countright, temp);
                if (++countleft >= --countright) break;
                ++x;
            }
        }
    }

    private void printtempbins(Vector<Bin> v) {
        int binNumber = 0;
        while (binNumber < v.size()) {
            Bin b = v.get(binNumber);
            System.out.print(String.valueOf(binNumber) + " ");
            System.out.print(b.addToString(""));
            ++binNumber;
        }
    }

    @Override
    public int getNumberOfHeuristics() {
        return 8;
    }

    @Override
    public double applyHeuristic(int heuristicID, int source, int destination) {
        long startTime = System.currentTimeMillis();
        Vector<Bin> temporaryBinVector = this.deepCopyBins(this.solutionMemory[source].solution);
        boolean isCrossover = false;
        int[] crossovers = this.getHeuristicsOfType(ProblemDomain.HeuristicType.CROSSOVER);
        if (crossovers != null) {
            int x = 0;
            while (x < crossovers.length) {
                if (crossovers[x] == heuristicID) {
                    isCrossover = true;
                    break;
                }
                ++x;
            }
        }
        if (isCrossover) {
            if (this.solutionMemory[destination] == null) {
                this.solutionMemory[destination] = new Solution();
            }
            this.solutionMemory[destination].solution = this.deepCopyBins(this.solutionMemory[source].solution);
        } else {
            if (heuristicID == 0) {
                this.applyHeuristic0(temporaryBinVector);
            } else if (heuristicID == 1) {
                this.applyHeuristic1(temporaryBinVector);
            } else if (heuristicID == 2) {
                this.applyHeuristic2(temporaryBinVector);
            } else if (heuristicID == 3) {
                this.applyHeuristic3(temporaryBinVector);
            } else if (heuristicID == 4) {
                this.applyHeuristic4(temporaryBinVector);
            } else if (heuristicID == 5) {
                this.applyHeuristic5(temporaryBinVector);
            } else if (heuristicID == 6) {
                this.applyHeuristic6(temporaryBinVector);
            } else {
                System.err.println("Heuristic " + heuristicID + " does not exist");
                System.exit(0);
            }
            int n = heuristicID;
            this.heuristicCallRecord[n] = this.heuristicCallRecord[n] + 1;
            int n2 = heuristicID;
            this.heuristicCallTimeRecord[n2] = this.heuristicCallTimeRecord[n2] + (int)(System.currentTimeMillis() - startTime);
        }
        this.sortbins(temporaryBinVector, true);
        this.sanitycheck(temporaryBinVector);
        double newobjectiveFunctionValue = this.evaluateObjectiveFunction(temporaryBinVector);
        if (newobjectiveFunctionValue < this.bestEverObjectiveFunction) {
            this.bestEverObjectiveFunction = newobjectiveFunctionValue;
            this.bestEverNumberOfBins = temporaryBinVector.size() - 1;
            this.bestEverSolution = this.deepCopyBins(temporaryBinVector);
        }
        if (this.solutionMemory[destination] == null) {
            this.solutionMemory[destination] = new Solution();
        }
        this.solutionMemory[destination].solution = this.deepCopyBins(temporaryBinVector);
        return newobjectiveFunctionValue;
    }

    private boolean sanitycheck(Vector<Bin> v) {
        int totalnumberofpieces = 0;
        double totalfullness = 0.0;
        Boolean[] allnumbers = new Boolean[this.numberOfPieces];
        int x = 0;
        while (x < v.size()) {
            Bin b = v.get(x);
            totalnumberofpieces += b.numberOfPiecesInThisBin();
            totalfullness += b.getFullness();
            ListIterator<Piece> i = b.piecesInThisBin.listIterator();
            while (i.hasNext()) {
                allnumbers[(int)i.next().getNumber()] = true;
            }
            if (b.getFullness() > this.capacity) {
                System.err.println("bin " + x + " is overfilled");
                System.exit(0);
            }
            ++x;
        }
        x = 0;
        while (x < this.numberOfPieces) {
            if (!allnumbers[x].booleanValue()) {
                System.err.println("piece number " + x + " is not present in the solution");
                System.exit(0);
            }
            ++x;
        }
        if (totalnumberofpieces != this.numberOfPieces) {
            System.err.println("there are not the correct number of pieces");
            System.exit(0);
        }
        if (totalfullness != this.totalpiecesize) {
            System.err.println("the pieces do not add up to the correct size");
            System.exit(0);
        }
        return true;
    }

    @Override
    public double applyHeuristic(int heuristicID, int source1, int source2, int destination) {
        long startTime = System.currentTimeMillis();
        Vector<Bin> temporaryBinVector = this.deepCopyBins(this.solutionMemory[source1].solution);
        Vector<Bin> temporaryBinVector2 = this.deepCopyBins(this.solutionMemory[source2].solution);
        boolean isCrossover = false;
        int[] crossovers = this.getHeuristicsOfType(ProblemDomain.HeuristicType.CROSSOVER);
        if (crossovers != null) {
            int x = 0;
            while (x < crossovers.length) {
                if (crossovers[x] == heuristicID) {
                    isCrossover = true;
                    break;
                }
                ++x;
            }
        }
        if (isCrossover) {
            if (heuristicID == 7) {
                this.applyHeuristic7(temporaryBinVector, temporaryBinVector2);
            } else {
                System.err.println("Heuristic " + heuristicID + " is not a crossover operator");
                System.exit(0);
            }
        } else {
            if (heuristicID == 0) {
                this.applyHeuristic0(temporaryBinVector);
            } else if (heuristicID == 1) {
                this.applyHeuristic1(temporaryBinVector);
            } else if (heuristicID == 2) {
                this.applyHeuristic2(temporaryBinVector);
            } else if (heuristicID == 3) {
                this.applyHeuristic3(temporaryBinVector);
            } else if (heuristicID == 4) {
                this.applyHeuristic4(temporaryBinVector);
            } else if (heuristicID == 5) {
                this.applyHeuristic5(temporaryBinVector);
            } else if (heuristicID == 6) {
                this.applyHeuristic6(temporaryBinVector);
            } else {
                System.err.println("Heuristic " + heuristicID + "does not exist");
                System.exit(0);
            }
            int n = heuristicID;
            this.heuristicCallRecord[n] = this.heuristicCallRecord[n] + 1;
            int n2 = heuristicID;
            this.heuristicCallTimeRecord[n2] = this.heuristicCallTimeRecord[n2] + (int)(System.currentTimeMillis() - startTime);
        }
        this.sortbins(temporaryBinVector, true);
        this.sanitycheck(temporaryBinVector);
        double newobjectiveFunctionValue = this.evaluateObjectiveFunction(temporaryBinVector);
        if (newobjectiveFunctionValue < this.bestEverObjectiveFunction) {
            this.bestEverObjectiveFunction = newobjectiveFunctionValue;
            this.bestEverNumberOfBins = temporaryBinVector.size() - 1;
            this.bestEverSolution = this.deepCopyBins(temporaryBinVector);
        }
        if (this.solutionMemory[destination] == null) {
            this.solutionMemory[destination] = new Solution();
        }
        this.solutionMemory[destination].solution = this.deepCopyBins(temporaryBinVector);
        return newobjectiveFunctionValue;
    }

    @Override
    public void copySolution(int source, int destination) {
        Vector<Bin> temporaryBinVector = this.deepCopyBins(this.solutionMemory[source].solution);
        if (this.solutionMemory[destination] == null) {
            this.solutionMemory[destination] = new Solution();
        }
        this.solutionMemory[destination].solution = temporaryBinVector;
    }

    @Override
    public String solutionToString(int index) {
        String s = "";
        int binNumber = 0;
        while (binNumber < this.solutionMemory[0].size()) {
            Bin b = this.solutionMemory[0].get(binNumber);
            s = String.valueOf(s) + binNumber + " ";
            s = b.addToString(s);
            ++binNumber;
        }
        return s;
    }

    @Override
    public String bestSolutionToString() {
        String s = "";
        s = String.valueOf(s) + "Best Solution Found:\n";
        int binNumber = 0;
        while (binNumber < this.bestEverSolution.size()) {
            Bin b = this.bestEverSolution.get(binNumber);
            s = b.addToString(s);
            ++binNumber;
        }
        s = String.valueOf(s) + "Objective Function Value: " + this.bestEverNumberOfBins + "\n";
        return s;
    }

    @Override
    public double getFunctionValue(int index) {
        return this.evaluateObjectiveFunction(this.solutionMemory[index].solution);
    }

    @Override
    public double getBestSolutionValue() {
        return this.bestEverObjectiveFunction;
    }

    @Override
    public void setMemorySize(int size) {
        Solution[] newSolutionMemory = new Solution[size];
        if (this.solutionMemory != null) {
            int x = 0;
            while (x < this.solutionMemory.length) {
                if (x < size) {
                    newSolutionMemory[x] = this.solutionMemory[x];
                }
                ++x;
            }
        }
        this.solutionMemory = newSolutionMemory;
    }

    @Override
    public int getNumberOfInstances() {
        return 12;
    }

    @Override
    public String toString() {
        return "BinPacking";
    }

    @Override
    public boolean compareSolutions(int solutionIndex1, int solutionIndex2) {
        Solution s1 = this.solutionMemory[solutionIndex1];
        Solution s2 = this.solutionMemory[solutionIndex2];
        if (s1.size() != s2.size()) {
            return false;
        }
        int i = 0;
        while (i < s1.size()) {
            Bin b1 = s1.get(i);
            Bin b2 = s2.get(i);
            int piecesinb1 = b1.numberOfPiecesInThisBin();
            int piecesinb2 = b2.numberOfPiecesInThisBin();
            if (b1.compareTo(b2) != 0 || piecesinb1 != piecesinb2) {
                return false;
            }
            int x = 0;
            while (x < piecesinb1) {
                if (b1.getPieceSize(x) != b2.getPieceSize(x)) {
                    return false;
                }
                ++x;
            }
            ++i;
        }
        return true;
    }

    @Override
    public int[] getHeuristicsOfType(ProblemDomain.HeuristicType hType) {
        switch (hType) {
            case LOCAL_SEARCH: {
                return this.localSearches;
            }
            case RUIN_RECREATE: {
                return this.ruinRecreates;
            }
            case MUTATION: {
                return this.mutations;
            }
            case CROSSOVER: {
                return this.crossovers;
            }
        }
        return null;
    }

    class Solution {
        public Vector<Bin> solution = new Vector();

        public void addBin(Bin b) {
            this.solution.add(b);
        }

        public int size() {
            return this.solution.size();
        }

        public Bin get(int index) {
            return this.solution.get(index);
        }

        public void set(int index, Bin b) {
            this.solution.set(index, b);
        }
    }

    class returnSolution {
        public double value;
        public Vector<Piece> solution;

        public returnSolution(Vector<Piece> s, double v) {
            this.solution = s;
            this.value = v;
        }
    }
}

