/*
 * Decompiled with CFR 0.152.
 */
package Examples;

import AbstractClasses.HyperHeuristic;
import AbstractClasses.ProblemDomain;

public class ExampleHyperHeuristic2
extends HyperHeuristic {
    public ExampleHyperHeuristic2(long seed) {
        super(seed);
    }

    @Override
    public void solve(ProblemDomain problem) {
        int solutionmemorysize = 10;
        problem.setMemorySize(solutionmemorysize);
        int hs = problem.getNumberOfHeuristics();
        double[] current_obj_function_values = new double[solutionmemorysize];
        int best_solution_index = 0;
        double best_solution_value = Double.POSITIVE_INFINITY;
        int x = 0;
        while (x < solutionmemorysize) {
            problem.initialiseSolution(x);
            current_obj_function_values[x] = problem.getFunctionValue(x);
            if (current_obj_function_values[x] < best_solution_value) {
                best_solution_value = current_obj_function_values[x];
                best_solution_index = x;
            }
            ++x;
        }
        while (!this.hasTimeExpired()) {
            int heuristic_to_apply = this.rng.nextInt(hs);
            current_obj_function_values[best_solution_index] = problem.applyHeuristic(heuristic_to_apply, best_solution_index, best_solution_index);
            if (!(current_obj_function_values[best_solution_index] > best_solution_value)) continue;
            best_solution_value = Double.POSITIVE_INFINITY;
            int x2 = 0;
            while (x2 < solutionmemorysize) {
                if (current_obj_function_values[x2] < best_solution_value) {
                    best_solution_value = current_obj_function_values[x2];
                    best_solution_index = x2;
                }
                ++x2;
            }
        }
    }

    @Override
    public String toString() {
        return "Example Hyper Heuristic Two";
    }
}

