/*
 * Decompiled with CFR 0.152.
 */
package Examples;

import AbstractClasses.HyperHeuristic;
import AbstractClasses.ProblemDomain;

public class ExampleHyperHeuristic3
extends HyperHeuristic {
    public ExampleHyperHeuristic3(long seed) {
        super(seed);
    }

    @Override
    public void solve(ProblemDomain problem) {
        int[] local_search_heuristics = problem.getHeuristicsOfType(ProblemDomain.HeuristicType.LOCAL_SEARCH);
        int[] mutation_heuristics = problem.getHeuristicsOfType(ProblemDomain.HeuristicType.MUTATION);
        int[] crossover_heuristics = problem.getHeuristicsOfType(ProblemDomain.HeuristicType.CROSSOVER);
        int solutionmemorysize = 10;
        problem.setMemorySize(solutionmemorysize);
        double[] current_obj_function_values = new double[solutionmemorysize];
        int best_solution_index = 0;
        double best_solution_value = Double.POSITIVE_INFINITY;
        int x = 0;
        while (x < solutionmemorysize) {
            problem.initialiseSolution(x);
            current_obj_function_values[x] = problem.getFunctionValue(x);
            if (current_obj_function_values[x] < best_solution_value) {
                best_solution_value = current_obj_function_values[x];
                best_solution_index = x;
            }
            ++x;
        }
        while (!this.hasTimeExpired()) {
            int heuristic_to_apply = 0;
            heuristic_to_apply = mutation_heuristics != null ? mutation_heuristics[this.rng.nextInt(mutation_heuristics.length)] : this.rng.nextInt(problem.getNumberOfHeuristics());
            problem.applyHeuristic(heuristic_to_apply, best_solution_index, best_solution_index);
            heuristic_to_apply = 0;
            heuristic_to_apply = local_search_heuristics != null ? local_search_heuristics[this.rng.nextInt(local_search_heuristics.length)] : this.rng.nextInt(problem.getNumberOfHeuristics());
            current_obj_function_values[best_solution_index] = problem.applyHeuristic(heuristic_to_apply, best_solution_index, best_solution_index);
            if (current_obj_function_values[best_solution_index] > best_solution_value) {
                best_solution_value = Double.POSITIVE_INFINITY;
                int x2 = 0;
                while (x2 < solutionmemorysize) {
                    if (current_obj_function_values[x2] < best_solution_value) {
                        best_solution_value = current_obj_function_values[x2];
                        best_solution_index = x2;
                    }
                    ++x2;
                }
            }
            if (crossover_heuristics == null) continue;
            int solution_index_1 = this.rng.nextInt(solutionmemorysize);
            int solution_index_2 = this.rng.nextInt(solutionmemorysize);
            while (solution_index_1 == solution_index_2) {
                solution_index_2 = this.rng.nextInt(solutionmemorysize);
            }
            heuristic_to_apply = crossover_heuristics[this.rng.nextInt(crossover_heuristics.length)];
            current_obj_function_values[solution_index_1] = problem.applyHeuristic(heuristic_to_apply, solution_index_1, solution_index_2, solution_index_1);
            if (solution_index_1 == best_solution_index) {
                if (!(current_obj_function_values[solution_index_1] > best_solution_value)) continue;
                best_solution_value = Double.POSITIVE_INFINITY;
                int x3 = 0;
                while (x3 < solutionmemorysize) {
                    if (current_obj_function_values[x3] < best_solution_value) {
                        best_solution_value = current_obj_function_values[x3];
                        best_solution_index = x3;
                    }
                    ++x3;
                }
                continue;
            }
            if (!(current_obj_function_values[solution_index_1] < best_solution_value)) continue;
            best_solution_value = current_obj_function_values[solution_index_1];
            best_solution_index = solution_index_1;
        }
    }

    @Override
    public String toString() {
        return "Example Hyper Heuristic Three";
    }
}

