/*
 * Decompiled with CFR 0.152.
 */
package FlowShop;

import FlowShop.Instance;
import FlowShop.Solution;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;

class BasicAlgorithms {
    private int Cmax;

    BasicAlgorithms() {
    }

    Solution neh(Instance instance) {
        int[] initialPermutation = this.generateLPTSequence(instance);
        int[] partialSchedule = new int[]{initialPermutation[0]};
        int j = 1;
        while (j < instance.n) {
            partialSchedule = this.insert(partialSchedule, initialPermutation[j], instance);
            ++j;
        }
        return new Solution(partialSchedule, this.Cmax);
    }

    Solution neh(Instance instance, int[] ordering) {
        int[] partialSchedule = new int[]{ordering[0]};
        int j = 1;
        while (j < instance.n) {
            partialSchedule = this.insert(partialSchedule, ordering[j], instance);
            ++j;
        }
        return new Solution(partialSchedule, this.Cmax);
    }

    int nehReturnCmax(Instance instance) {
        this.neh(instance);
        return this.Cmax;
    }

    Solution nehBT(Instance instance, int backTrackLevel) {
        int[] initialPermutation = this.generateLPTSequence(instance);
        int[] partialSchedule = new int[]{initialPermutation[0]};
        int j = 1;
        while (j < backTrackLevel) {
            partialSchedule = this.insert(partialSchedule, initialPermutation[j], instance);
            ++j;
        }
        int[] jobsToInsert = new int[instance.n - backTrackLevel];
        int i = backTrackLevel;
        while (i < initialPermutation.length) {
            jobsToInsert[i - backTrackLevel] = initialPermutation[i];
            ++i;
        }
        int[] schedule = this.nehPartScheduleBT(instance, partialSchedule, jobsToInsert, 3);
        return new Solution(schedule, this.Cmax);
    }

    int[] nehPartialSchedule(Instance instance, int[] partialSchedule, int[] jobsToInsert) {
        int[] newSchedule = partialSchedule;
        int i = 0;
        while (i < jobsToInsert.length) {
            newSchedule = this.insert(newSchedule, jobsToInsert[i], instance);
            ++i;
        }
        return newSchedule;
    }

    int[] nehPartScheduleBT(Instance problem, int[] partialSchedule, int[] jobsToInsert, int depthOfSearch) {
        ArrayList<PartialSchedule> initialPartialSchedules = this.insert(partialSchedule, jobsToInsert[0], problem, depthOfSearch);
        int i = 1;
        while (i < jobsToInsert.length) {
            ArrayList<PartialSchedule> newPartialSchedules = new ArrayList<PartialSchedule>(depthOfSearch * depthOfSearch);
            for (PartialSchedule schedule : initialPartialSchedules) {
                schedule.insertJob();
            }
            int jobToInsert = jobsToInsert[i];
            int j = 0;
            while (j < depthOfSearch) {
                newPartialSchedules.addAll(this.insert(initialPartialSchedules.get((int)j).partialSchedule, jobToInsert, problem, depthOfSearch));
                ++j;
            }
            Collections.sort(newPartialSchedules);
            initialPartialSchedules.clear();
            int k = 0;
            while (k < depthOfSearch) {
                initialPartialSchedules.add((PartialSchedule)newPartialSchedules.get(k));
                ++k;
            }
            ++i;
        }
        initialPartialSchedules.get(0).insertJob();
        return initialPartialSchedules.get((int)0).partialSchedule;
    }

    int[] fImpLocalSearch(Instance problem, int[] initialSchedule, int initialCmax) {
        int bestCmax = initialCmax;
        int newCmax = initialCmax;
        boolean improvement = true;
        int[] newSchedule = initialSchedule;
        int[] bestSchedule = initialSchedule;
        block0: while (improvement) {
            improvement = false;
            int i = 0;
            while (i < initialSchedule.length) {
                newSchedule = this.fImpLocalSearchPass(problem, bestSchedule, i, bestCmax);
                newCmax = this.evaluatePermutation(newSchedule, problem);
                if (newCmax < bestCmax) {
                    bestSchedule = newSchedule;
                    bestCmax = newCmax;
                    improvement = true;
                    continue block0;
                }
                ++i;
            }
        }
        return bestSchedule;
    }

    int[] fImpLocalSearchPass(Instance problem, int[] initialSchedule, int indexToReinsert, int initialCmax) {
        int jobToInsert = initialSchedule[indexToReinsert];
        int[] partialSchedule = this.removeIndex(initialSchedule, indexToReinsert);
        int partialScheduleLength = partialSchedule.length;
        int[][] e = this.calculate_e(partialScheduleLength, problem.m, partialSchedule, problem.processingTimes);
        int[][] q = this.calculate_q(partialScheduleLength, problem.m, partialSchedule, problem.processingTimes);
        int[][] f = this.calculate_f(jobToInsert, partialScheduleLength, partialSchedule, e, problem.m, problem.processingTimes);
        int newCmax = initialCmax;
        int i = 0;
        while (i <= partialScheduleLength) {
            newCmax = i == partialSchedule.length ? this.calculatePartialCmax(i, problem.m, q, f, partialScheduleLength) : this.calculatePartialCmax(i, problem.m, q, f, partialScheduleLength);
            if (newCmax < initialCmax) {
                return this.insertJob(partialSchedule, jobToInsert, i);
            }
            ++i;
        }
        return initialSchedule;
    }

    int[] localSearch(Instance problem, int[] initialSchedule, int initialCmax) {
        int bestCmax = initialCmax;
        int newCmax = initialCmax;
        boolean improvement = true;
        int[] newSchedule = initialSchedule;
        int[] bestSchedule = initialSchedule;
        block0: while (improvement) {
            improvement = false;
            int i = 0;
            while (i < initialSchedule.length) {
                newSchedule = this.localSearchPass(problem, bestSchedule, i, bestCmax);
                newCmax = this.evaluatePermutation(newSchedule, problem);
                if (newCmax < bestCmax) {
                    bestSchedule = newSchedule;
                    bestCmax = newCmax;
                    improvement = true;
                    continue block0;
                }
                ++i;
            }
        }
        return bestSchedule;
    }

    int[] localSearchPass(Instance problem, int[] initialSchedule, int indexToReinsert, int initialCmax) {
        boolean foundImprovement = false;
        int jobToInsert = initialSchedule[indexToReinsert];
        int[] partialSchedule = this.removeIndex(initialSchedule, indexToReinsert);
        int partialScheduleLength = partialSchedule.length;
        int[][] e = this.calculate_e(partialScheduleLength, problem.m, partialSchedule, problem.processingTimes);
        int[][] q = this.calculate_q(partialScheduleLength, problem.m, partialSchedule, problem.processingTimes);
        int[][] f = this.calculate_f(jobToInsert, partialScheduleLength, partialSchedule, e, problem.m, problem.processingTimes);
        int minCmax = initialCmax;
        int newCmax = initialCmax;
        int position = 0;
        int i = 0;
        while (i <= partialScheduleLength) {
            newCmax = i == partialSchedule.length ? this.calculatePartialCmax(i, problem.m, q, f, partialScheduleLength) : this.calculatePartialCmax(i, problem.m, q, f, partialScheduleLength);
            if (newCmax < minCmax) {
                minCmax = newCmax;
                position = i;
                foundImprovement = true;
            }
            ++i;
        }
        if (foundImprovement) {
            return this.insertJob(partialSchedule, jobToInsert, position);
        }
        return initialSchedule;
    }

    int[] randomFImpLocalSearch(Instance problem, int[] initialSchedule, int initialCmax, int[] jobIndices) {
        int bestCmax = initialCmax;
        int newCmax = initialCmax;
        int[] newSchedule = initialSchedule;
        int[] bestSchedule = initialSchedule;
        int i = 0;
        while (i < jobIndices.length) {
            newSchedule = this.fImpLocalSearchPass(problem, bestSchedule, jobIndices[i], bestCmax);
            newCmax = this.evaluatePermutation(newSchedule, problem);
            if (newCmax <= bestCmax) {
                bestSchedule = newSchedule;
                bestCmax = newCmax;
            }
            ++i;
        }
        return bestSchedule;
    }

    int[] randomLocalSearch(Instance problem, int[] initialSchedule, int initialCmax, int[] jobIndices) {
        int bestCmax = initialCmax;
        int newCmax = initialCmax;
        int[] newSchedule = initialSchedule;
        int[] bestSchedule = initialSchedule;
        int i = 0;
        while (i < jobIndices.length) {
            newSchedule = this.localSearchPass(problem, bestSchedule, jobIndices[i], bestCmax);
            newCmax = this.evaluatePermutation(newSchedule, problem);
            if (newCmax <= bestCmax) {
                bestSchedule = newSchedule;
                bestCmax = newCmax;
            }
            ++i;
        }
        return bestSchedule;
    }

    private int evaluatePermutation(int[] permutation, Instance instance) {
        int jobIndex;
        int[][] processingTimes = instance.processingTimes;
        int n = instance.n;
        int m = instance.m;
        int[] releaseTimes = new int[n];
        int time = 0;
        int j = 0;
        while (j < n) {
            jobIndex = permutation[j];
            releaseTimes[jobIndex] = time += processingTimes[jobIndex][0];
            ++j;
        }
        int i = 1;
        while (i < m) {
            time = 0;
            int j2 = 0;
            while (j2 < n) {
                jobIndex = permutation[j2];
                int releaseTime = releaseTimes[jobIndex];
                int n2 = releaseTime >= time ? releaseTime : time;
                releaseTimes[jobIndex] = time = n2 + processingTimes[jobIndex][i];
                ++j2;
            }
            ++i;
        }
        return time;
    }

    private int[][] calculate_e(int partialScheduleLength, int m, int[] partialSchedule, int[][] processingTimes) {
        int[][] e = new int[partialSchedule.length][m];
        int j = 0;
        while (j < partialScheduleLength) {
            int jobIndex = partialSchedule[j];
            int k = 0;
            while (k < m) {
                e[j][k] = j == 0 && k == 0 ? processingTimes[jobIndex][k] : (j == 0 ? e[j][k - 1] + processingTimes[jobIndex][k] : (k == 0 ? e[j - 1][k] + processingTimes[jobIndex][k] : Math.max(e[j][k - 1], e[j - 1][k]) + processingTimes[jobIndex][k]));
                ++k;
            }
            ++j;
        }
        return e;
    }

    private int[][] calculate_f(int jobIndex, int partialScheduleLength, int[] partialSchedule, int[][] e, int m, int[][] processingTimes) {
        int[][] f = new int[partialSchedule.length + 1][m];
        int j = 0;
        while (j <= partialScheduleLength) {
            int k = 0;
            while (k < m) {
                f[j][k] = j == 0 && k == 0 ? processingTimes[jobIndex][k] : (j == 0 ? f[j][k - 1] + processingTimes[jobIndex][k] : (k == 0 ? e[j - 1][k] + processingTimes[jobIndex][k] : Math.max(f[j][k - 1], e[j - 1][k]) + processingTimes[jobIndex][k]));
                ++k;
            }
            ++j;
        }
        return f;
    }

    private int[][] calculate_q(int partialScheduleLength, int m, int[] partialSchedule, int[][] processingTimes) {
        int[][] q = new int[partialScheduleLength][m];
        int j = partialScheduleLength - 1;
        while (j >= 0) {
            int jobIndex = partialSchedule[j];
            int k = m - 1;
            while (k >= 0) {
                q[j][k] = j == partialScheduleLength - 1 && k == m - 1 ? processingTimes[jobIndex][k] : (j == partialScheduleLength - 1 ? q[j][k + 1] + processingTimes[jobIndex][k] : (k == m - 1 ? q[j + 1][k] + processingTimes[jobIndex][k] : Math.max(q[j + 1][k], q[j][k + 1]) + processingTimes[jobIndex][k]));
                --k;
            }
            --j;
        }
        return q;
    }

    private int calculatePartialCmax(int position, int m, int[][] q, int[][] f, int partialScheduleLength) {
        int M = 0;
        if (position == partialScheduleLength) {
            M = f[position][m - 1];
        } else {
            int k = 0;
            while (k < m) {
                M = Math.max(M, f[position][k] + q[position][k]);
                ++k;
            }
        }
        return M;
    }

    private int[] generateLPTSequence(Instance instance) {
        int m = instance.m;
        int n = instance.n;
        int[][] processingTimes = instance.processingTimes;
        int[] sumProcTimes = new int[n];
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < m) {
                sumProcTimes[i] = sumProcTimes[i] + processingTimes[i][j];
                ++j;
            }
            ++i;
        }
        Object[] jobs = new Job[n];
        int i2 = 0;
        while (i2 < n) {
            jobs[i2] = new Job(i2, sumProcTimes[i2]);
            ++i2;
        }
        Arrays.sort(jobs);
        int[] permutation = new int[n];
        int i3 = 0;
        while (i3 < n) {
            permutation[i3] = ((Job)jobs[i3]).index;
            ++i3;
        }
        return permutation;
    }

    private int[] insert(int[] partialSchedule, int jobToInsert, Instance instance) {
        int m = instance.m;
        int[][] processingTimes = instance.processingTimes;
        int partialScheduleLength = partialSchedule.length;
        int[][] e = this.calculate_e(partialScheduleLength, m, partialSchedule, processingTimes);
        int[][] q = this.calculate_q(partialScheduleLength, m, partialSchedule, processingTimes);
        int[][] f = this.calculate_f(jobToInsert, partialScheduleLength, partialSchedule, e, m, processingTimes);
        int minCmax = this.calculatePartialCmax(0, m, q, f, partialScheduleLength);
        int position = 0;
        int i = 1;
        while (i <= partialSchedule.length) {
            int newCmax = i == partialSchedule.length ? this.calculatePartialCmax(i, m, q, f, partialScheduleLength) : this.calculatePartialCmax(i, m, q, f, partialScheduleLength);
            if (newCmax < minCmax) {
                minCmax = newCmax;
                position = i;
            }
            ++i;
        }
        this.Cmax = minCmax;
        int[] newPermutation = new int[partialSchedule.length + 1];
        int counter = 0;
        newPermutation[position] = jobToInsert;
        int i2 = 0;
        while (i2 < newPermutation.length) {
            if (i2 == position) {
                --counter;
            } else {
                newPermutation[i2] = partialSchedule[counter];
            }
            ++i2;
            ++counter;
        }
        return newPermutation;
    }

    private ArrayList<PartialSchedule> insert(int[] partialSchedule, int jobToInsert, Instance problem, int depthOfSearch) {
        ArrayList<PartialSchedule> partialSchedules = new ArrayList<PartialSchedule>(partialSchedule.length + 1);
        int partialScheduleLength = partialSchedule.length;
        int[][] e = this.calculate_e(partialScheduleLength, problem.m, partialSchedule, problem.processingTimes);
        int[][] q = this.calculate_q(partialScheduleLength, problem.m, partialSchedule, problem.processingTimes);
        int[][] f = this.calculate_f(jobToInsert, partialScheduleLength, partialSchedule, e, problem.m, problem.processingTimes);
        int i = 0;
        while (i <= partialScheduleLength) {
            int newCmax = i == partialSchedule.length ? this.calculatePartialCmax(i, problem.m, q, f, partialScheduleLength) : this.calculatePartialCmax(i, problem.m, q, f, partialScheduleLength);
            partialSchedules.add(new PartialSchedule(partialSchedule, jobToInsert, i, newCmax));
            ++i;
        }
        Collections.sort(partialSchedules);
        ArrayList<PartialSchedule> schedulesToReturn = new ArrayList<PartialSchedule>(depthOfSearch);
        Iterator iterator = partialSchedules.iterator();
        int i2 = 0;
        while (i2 < depthOfSearch) {
            schedulesToReturn.add((PartialSchedule)iterator.next());
            ++i2;
        }
        return schedulesToReturn;
    }

    private int[] insertJob(int[] initialSequence, int jobToInsert, int placeToInsert) {
        int[] newSequence = new int[initialSequence.length + 1];
        int counter = 0;
        newSequence[placeToInsert] = jobToInsert;
        int i = 0;
        while (i < newSequence.length) {
            if (i == placeToInsert) {
                --counter;
            } else {
                newSequence[i] = initialSequence[counter];
            }
            ++i;
            ++counter;
        }
        return newSequence;
    }

    private int[] removeIndex(int[] initialSequence, int indexToRemove) {
        int[] newSequence = new int[initialSequence.length - 1];
        int counter = 0;
        int i = 0;
        while (i < initialSequence.length) {
            if (i != indexToRemove) {
                newSequence[counter] = initialSequence[i];
                ++counter;
            }
            ++i;
        }
        return newSequence;
    }

    private class Job
    implements Comparable<Job> {
        int index;
        int sumproctimes;

        Job(int index, int sumproctimes) {
            this.index = index;
            this.sumproctimes = sumproctimes;
        }

        @Override
        public int compareTo(Job o) {
            return -this.sumproctimes + o.sumproctimes;
        }
    }

    private class PartialSchedule
    implements Comparable<PartialSchedule> {
        int[] partialSchedule;
        int jobToInsert;
        int placeToInsert;
        int Cmax;

        PartialSchedule(int[] partialSchedule, int jobToInsert, int placeToInsert, int Cmax) {
            this.partialSchedule = partialSchedule;
            this.jobToInsert = jobToInsert;
            this.placeToInsert = placeToInsert;
            this.Cmax = Cmax;
        }

        @Override
        public int compareTo(PartialSchedule ps2) {
            return this.Cmax - ps2.Cmax;
        }

        void insertJob() {
            int[] newSchedule = new int[this.partialSchedule.length + 1];
            int counter = 0;
            newSchedule[this.placeToInsert] = this.jobToInsert;
            int i = 0;
            while (i < newSchedule.length) {
                if (i == this.placeToInsert) {
                    --counter;
                } else {
                    newSchedule[i] = this.partialSchedule[counter];
                }
                ++i;
                ++counter;
            }
            this.partialSchedule = newSchedule;
        }
    }
}

